/* LE PROGRAMME D'EXEMPLE: Un synth  "autant-que-tu-veux" voies!! */

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include "tss.h"
#include "types.h"

/* Constantes */
#define NBRCHANNELS	8	/* Nombre de voies du synth */
#define MIXFREQ		16000	/* Frquence de mixage des canaux */
#define	DEFAULT_VOL	63	/* Volume par dfaut du sample */
#define DEFAULT_FREQ	22000	/* Frquence par dfaut du sample */

/* Scan codes et frquences atribues aux touches */
#define NBRNOTES	13	/* Nombre de notes diffrentes */
#define MIDDLEFREQ	262	/* Frquence de rfrence */
BYTE	key_code[NBRNOTES]	= {44,31,45,32,46,47,34,48,35,49,36,50,51};
WORD	key_freq[NBRNOTES]	= {262,277,294,311,330,349,370,392,415,440,466,494,523};

/* Variables globales */
SAMPLE		*smp;			/* Sample de dmonstration */
WORD		keychn[128];		/* Canaux utiliss en fonction des touches */
int		getout;			/* Flag de sortie */
void interrupt	(*oldkbhandler)();	/* Ancien handler de clavier */

/* Charge un sample
 * 
 *	Entre: filename = nom du fichier  charger
 *	Sortie: renvoie un pointeur sur un descripteur de sample
 *		ou NULL si erreur
 */
SAMPLE *loadsample (char *filename)
{
	FILE	*in;	/* Descripteur de fichier */
	SAMPLE	*smp;	/* Descripteur de sample */
	WORD	size;	/* Taille du fichier */

	/* Ouvre le fichier */
	if ((in = fopen(filename,"rb")) == NULL)
		return NULL;

	/* Lit la taille du fichier */
	fseek(in,0,SEEK_END);
	size = (WORD)ftell(in);
	fseek(in,0,SEEK_SET);

	/* Alloue de la mmoire pour le sample et son descripteur */
	if ((smp = malloc(sizeof(*smp))) == NULL)
		return NULL;
	if ((smp->sample = malloc(size)) == NULL)
		return NULL;

	/* Initialise le descripteur de sample */
	strcpy(smp->name,filename);
	smp->flags	= TSS_LOOPON;
	smp->vol	= DEFAULT_VOL;
	smp->freq	= DEFAULT_FREQ;
	smp->length	= size;
	smp->loopstart	= 0;
	smp->loopend	= size;

	/* Lit le sample proprement dit */
	fread(smp->sample,sizeof(BYTE),size,in);

	fclose(in);
	return smp;
}

/* Libre la mmoire prise par un sample
 * 
 *	Entre: smp = pointeur sur un descripteur de sample
 *	Sortie: rien
 */
void freesample (SAMPLE *smp)
{
	/* Libre mmoire du sample */
	free(smp->sample);
	/* Libre mmoire du descripteur */
	free(smp);
}

/* Nouveau handler de clavier
 * 
 *	Entre: rien
 *	Sortie: rien
 */
void interrupt kbhandler ()
{
	BYTE	key = inportb(0x60);	/* Scan code de la touche appyue */
	WORD	chn;		/* Compteur de canal */
	WORD	note;		/* Compteur de notes */
	CHANNEL	*pchn;		/* Pointeur sur le canal courant */

	/* Envoie un ACK au PIC */
	outportb(0x20,0x20);

	/* Si la touche est [ESC], sort */
	if (key == 1)
	{
		getout = 1;
		return;
	}

	/* Si la touche est appuye */
	if ((key & 0x80) == 0)
	{
		/* Si la touche n'est pas dj appuye */
		if (keychn[key] == 0xffff)
		{
			/* Cherche un canal libre */
			for (chn=0,pchn=tss_channels; chn<tss_nbrchannels; chn++,pchn++)
				if ((pchn->flags & TSS_ACTIVE) == 0)
				{
					/* Cherche la frquence de la note */
					for (note=0; note<NBRNOTES; note++)
						if (key_code[note] == key)
						{
							/* Envoie le sample  la frquence donne */
							tss_playsample(chn,smp);
							tss_setchnfreq(chn,(DWORD)smp->freq * key_freq[note] / MIDDLEFREQ);
							keychn[key] = chn;
							return;
						}
				}
		}
	}
	/* Sinon la touche est relche */
	else
	{
		/* Si la touche a t appuye */
		if ((chn = keychn[key &= 0x7f]) != 0xffff)
		{
			/* Stoppe le canal */
			tss_stopsample(chn);
			keychn[key] = 0xffff;
                }
	}
}

/* MAIN routine */
int main ()
{
	/* Initialise le TSS */
	if (!tss_init(NBRCHANNELS,MIXFREQ))
	{
		printf("ErRoR: Unable to init the TrIaX's SoundSystem!!\n");
		return 0xff;
	}
	/* Charge le sample */
	if ((smp = loadsample("sample.raw")) == NULL)
	{
		printf("ErRoR: Unable to load the wonderful sample!!\n");
		return 0xff;
	}

	/* Mode d'emploi du bazar */
	printf("\n\
\t      SYNTHE - (c)TrIaX'95\n\n\
\tĿ\n\
\t              \n\
\t              \n\
\t  S D    G H J     \n\
\t              \n\
\t                        \n\
\t W  X  C  V  B  N  ,  ; \n\
\t\n\n\
\t    [ESC] exits  Have fun!!\n");

	/* Installe le nouveau handler clavier */
	oldkbhandler = getvect(0x9);
	setvect(0x9,kbhandler);
	memset(keychn,0xff,sizeof(keychn));
	getout = 0;

	while (!getout);	/* Attend la fin... */

	/* Rinstalle l'ancien handler clavier */
	setvect(0x9,oldkbhandler);

	freesample(smp);
	tss_done();
	return 0;
}