/* Fichier include du module SB */

#ifndef SB_H
#define SB_H

#include "types.h"

/* Variables globales */
extern  WORD    sb_port;	/* Port de base de la SB */
extern  WORD    sb_irq;		/* Ligne d'irq de la SB */
extern  WORD    sb_dma;		/* Canal dma de la SB */
extern  int     sb_dmadone;	/* Transfert dma termin oui/non */
extern  int     sb_dmahold;	/* Transfert dma en pause oui/non */
extern  int     sb_quiet;	/* Haut-parleur teint oui/non */

/* Fonctions */
int     sb_init ();			/* Initialise la SB */
void    sb_done ();			/* Uninitialise la SB */
int     sb_detect ();			/* Auto-dtecte la SB */
int     sb_reset ();			/* Reset la SB */
void    sb_hpon ();			/* Allume le HP */
void    sb_hpoff ();			/* Eteint le HP */
BYTE    sb_directin ();			/* Entre directe de sample */
void    sb_directout (BYTE data);	/* Sortie directe de sample */
void    sb_setfreq (WORD freq);		/* Rgle freq de sampling */
void    sb_dmain (WORD size, void *ptr);	/* Entre de sample via DMA */
void    sb_dmaout (WORD size, void *ptr);	/* Sortie de sample via DMA */
void    sb_dmastop ();			/* Stoppe un transfert DMA */
void    sb_dmacontinue ();		/* Continue un transfert DMA */
void	sb_setuserhandler (void (*handler)());	/* Dfinit handler d'irq utilisateur */

#endif