/* Fichier include du module DMA */

#ifndef DMA_H
#define DMA_H

#include "types.h"

/* Constantes pour le mode de transfert */
#define DMA_VERIFY	0x00
#define DMA_READ	0x04
#define DMA_WRITE       0x08
#define DMA_AUTOINIT    0x10
#define DMA_INCREMENT   0x00
#define DMA_DECREMENT   0x20
#define DMA_DEMAND      0x00
#define DMA_SINGLE      0x40
#define DMA_BLOCK       0x80
#define DMA_CASCADE     0xc0

/* Fonctions */
void	dma_start (BYTE chn, BYTE mode, WORD size, void *ptr);
void	dma_stop (BYTE chn);
void	dma_continue (BYTE chn);

#endif