/*  Gestion du DMA  */

#include <dos.h>
#include "dma.h"
#include "types.h"

WORD	dma_mask[8]	= {0x0a,0x0a,0x0a,0x0a,0xd4,0xd4,0xd4,0xd4};
WORD    dma_mode[8]     = {0x0b,0x0b,0x0b,0x0b,0xd6,0xd6,0xd6,0xd6};
WORD    dma_flipflop[8] = {0x0c,0x0c,0x0c,0x0c,0xd8,0xd8,0xd8,0xd8};
WORD    dma_address[8]  = {0x00,0x02,0x04,0x06,0xc0,0xc4,0xc8,0xcc};
WORD    dma_count[8]    = {0x01,0x03,0x05,0x07,0xc2,0xc6,0xca,0xce};
WORD    dma_page[8]     = {0x87,0x83,0x81,0x82,0x8f,0x8b,0x89,0x8a};

/************************************************************************
 *   Initialise le contrleur DMA:                                     *
 *  - Masque le canal                                                   *
 *  - Envoie le mode de transfert                                       *
 *  - Remet le flip-flop  zro                                         *
 *  - Envoie la taille du transfert (octet LO, puis HI)                 *
 *  - Envoie l'adresse du bloc (16 bits faibles de l'adr physique)      *
 *  - Envoie la page du bloc (4 bits forts de l'adr physique)           *
 *      - Dmasque le canal                                             *
 ************************************************************************/
void dma_start (BYTE chn, BYTE mode, WORD size, void *ptr)
{
	DWORD   address = ((DWORD)FP_SEG(ptr) << 4) + FP_OFF(ptr);

	outportb(dma_mask[chn],chn | 4);
	outportb(dma_mode[chn],mode | (chn & 3));
	outportb(dma_flipflop[chn],0);
	outportb(dma_count[chn],(BYTE)(size));
	outportb(dma_count[chn],(BYTE)(size >> 8));
	outportb(dma_address[chn],(BYTE)(address));
	outportb(dma_address[chn],(BYTE)(address >> 8));
	outportb(dma_page[chn],(BYTE)(address >> 16));
	outportb(dma_mask[chn],chn & 3);
}

/************************************************************************
 *   Stoppe un transfert DMA:                                          *
 *  - Masque le canal DMA                                               *
 ************************************************************************/
void dma_stop (BYTE chn)
{
	outportb(dma_mask[chn],chn | 4);
}

/************************************************************************
 *   Continue un transfert DMA:                                        *
 *  - Dmasque le canal DMA                                             *
 ************************************************************************/
void dma_continue (BYTE chn)
{
	outportb(dma_mask[chn],chn & 3);
}
