{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P+,Q-,R-,S-,T-,V-,X+,Y+}
Unit VMem;

{
 
  Mmoire virtuelle                              
 
 }

INTERFACE

{======================= Mmoire Virtuelle =================================

  Contrairement au driver XMS, le nombre de handle est illimit, puisque
  ils sont stocks dans une double liste chaine. Cela dit, un driver XMS
  c'est fait en ASM, et a ne dispose pas de "tas", je ne critique donc pas.

  Le fichier d'change est dynamique, cd qu'il n'occupe que la place dont
  il a besoin.

  La procdure de copie de bloc n'intgre que les dplacements
  mmoire centrale <-> mmoire virtuelle, et aucun dplacements directs,
  mais ce n'est pas bien dur  faire, suffit de passer par un buffer
  pour vmem<->vmem et de passer par Xchg (prsent dans Funcs) pour
  mem<->mem. Penser aussi  utiliser ReducePtr pour faire du "override
  segment" arf'.

  J'ai test cette unit  la va vite. Si vous remarquez des bugs,
  communiquez les moi et je vous enverrai une version dbugue ou des
  explications..
}

Type  vmbptr = ^vmb;
      vmb = record  { Virtual memory block }
        next     : vmbptr;    { Prochain bloc }
        pred     : vmbptr;    { Prcdent bloc, cela facilite les choses }
        id       : word;      { Identificateur du bloc }
        Bsize    : word;      { Taille du bloc }
        position : longint;   { Position dans le fichier }
        flags    : set of (
                    fl_unused,    { Libre ou non }
                    fl_locked     { Lecture seulement }
                   );
      end;

      Embrec = record    { si un handle = 0 alors mmoire conventionelle }
        Esize      : longint;   { Taille  dplacer }
        src_handle : word;      { Handle Source }
        src_offset : longint;   { Offset de dbut du bloc source }
        cib_handle : word;      { Handle Cible }
        cib_offset : longint;   { Offset de dbut du bloc cible }
      end;

      TFileRec = record
        Handle: Word;
        Mode: Word;
        RecSize: Word;
        Private: array[1..26] of Byte;
        UserData: array[1..16] of Byte;
        Name: array[0..79] of Char;
      end;

Const MemBloc             = 1024; { 1024 octets = 1 bloc de mmoire }
      mr_ok               = 0;    { Rien  signaler }
      mr_vm_initFail      = 1;    { Echec lors de l'ouverture du swapfile }
      mr_vm_noMoreMemory  = 2;    { Plus de mmoire pour un handle }
      mr_vm_doneFail      = 3;    { Echec lors de la supression de swapfile }
      mr_unknowHandle     = 4;    { Handle non allou }
      mr_IncorrectSize    = 5;    { Taille  dplacer trop grande }
      mr_vm_diskfull      = 6;    { Disque plein }

Const memres  : byte      = 0;    { Erreurs  signaler }
      fvmb    : vmbptr    = NIL;  { Premier bloc de la liste chaine }

Var   vm_file : file;             { Fichier d'change }


{Ŀ
 Ŀ  
  Services gnraux                                                     
   
 }

{ Initialisation du fichier d'change. Doit tre appel avant tout chose }
Procedure vm_Init;

{ Fermeture du fichier d'change. Execute automatiquement  la fin du prog }
Procedure vm_Done; far;

{ Allocation d'une zone mmoire (ou encore bloc/handle/vmb) }
Procedure vm_Alloc (var handle : word; Asize : word);

{ Dsallocation d'une zone mmoire }
Procedure vm_UnAlloc (var handle : word);

{ Copier une zone vers la mmoire et vice versa }
Procedure vm_trans (var emb : embRec);

{ Sauver quelque chose dans une zone mmoire }
Procedure vm_save(var source; const handle : word; offset : longint; Asize : longint);

{ Restaurer le contenu d'une zone mmoire }
Procedure vm_load (const handle : word; var dest; offset : longint; Asize : longint);

{Ŀ
 Ŀ  
  Services d'information                                                
   
 }

{ Renvoie la taille du fichier. Assez lent }
Function vm_size : longint;

{ Renvoie la place perdue dans un fichier en % }
function vm_frag : byte;

{ Renvoie le nombre de handles dfinis }
Function vm_NbHandles : word;

{ Renvoie le nombre de handles allous et utiles }
Function vm_NbUsedHandles : word;

{ Mmoire libre TOTALE dans le fichier }
Function vm_MemAvail : longint;

{ Mmoire libre MAXIMALE (plus grand bloc) dans le fichier }
Function vm_MaxAvail : longint;

{ Mmoire virtuelle disponible libre TOTALE  disposition }
Function vm_MemFree : longint;

{ Mmoire virtuelle MAXIMALE  disposition }
Function vm_MaxFree : longint;

{ 0 = tout va bien. Fonctionne comme IOresult }
Function vm_memresult : byte;


{Ŀ
 Ŀ  
  Procdures internes                                                   
   
 }

{ Trouver un identificateur dans la liste chaine }
Function vm_FindVmb (askID : word) : vmbptr;

{ Trouver un nouvel identificateur encore inutilis }
Function vm_FindID : word;


{
 
  IMPLEMENTATION                                 
 
 }

IMPLEMENTATION

Uses  Funcs, dos;

{ Adresse de l'ancien exitproc }
Const vm_oldexit : pointer = NIL;

{ Size est souvent utilis :

  Var    Description                                                Unit
  
  Bsize  taille d'un Bloc sur disque dur                            membloc
  Asize  taille  Allouer demande                                  membloc
  Fsize  meilleure taille trouve (Find) pour un bloc  insrer     membloc
  Esize  taille d'un dplacement Emb de la mmoire au swapfile      octets
  Usize  taille relement inUtilise dans le fichier                membloc
  Tsize  taille Totale du fichier                                   membloc
}
{ͻ
  Virtual Mem  Ouvre un fichier pour la mmoire virtuelle                
 Ķ
  Ouvre un fichier possdant un nom intelligible, de prfrence dans le   
  rpertoire TEMP, puis TMP, courant, ou sur chacuns des root autre que   
  A: et B:. Rinitialise la table des handlers.                           
 ͼ}
Procedure vm_Init;
var   path    : string;
      fichier : string;
      attr    : word;
      i       : word;
Const consonnes : array[0..19] of char = 'BCDFGHJKLMNPQRSTVWXZ';
      voyelles  : array[0..5] of char = 'AEIOUY';
begin
  {******** TROUVER LE REPERTOIRE OU METTRE LE FICHIER D'ECHANGE ********}
  For i := 1 to 27 do begin
    Case i of
      1  : path := GetEnv ('TEMP');
      2  : path := GetEnv ('TMP');
      3  : GetDir (0, path);
      else path := chr(i+63)+':\';
    end;
    if not (path[1] in ['A','B']) and Exist(path) then break;
  end;
  AddSlash (path);

  {******************* TROUVER UN NOM DE FICHIER ***************************}
  { faire un systme de gnration alatoire de fichiers, permettant un
    nombre de combinaisons illimites et la possibilit  l'utilisateur
    de les supprimer facilement grce  un nom intelligible }
  fichier := '00000000.SWP';
  Randomize;

  Repeat
    for i := 1 to 4 do begin
      fichier[i SHL 1 - 1] := consonnes[random(20)];
      fichier[i SHL 1]     := voyelles[random(6)];
    end;
    Assign (vm_file, path + fichier);
    doserror := 0;
    GetFattr (vm_file, attr);
  until doserror > 0;

  {******************* OUVRIR LE FICHIER ***********************************}
  inoutres := 0;
  Rewrite (vm_file, 1);              { unit de base : un bloc mmoire }

  fvmb := NIL;
  if ioresult > 0
    then begin
      { Ca ne marche pas. Causes possibles :
          - Ecriture sur CD-ROM ou support amovible
          - Root rempli
          - Plus de buffers
          - plus un octet de libre }
      memres  := mr_vm_initfail;
      Assign (vm_file, '');
    end
    else begin
      memres     := mr_ok;           { Reinitialiser erreurs courantes }
      vm_oldexit := exitproc;
      exitproc   := @vm_done;
      { Pour avoir un fichier cach :
      Close (vm_file);
      SetFattr (vm_file, hidden+sysfile);
      filemode   := 128+16+2;                // Pour ne pas le partager
      Reset (vm_file, 1);            { Rouvrir avec attributs cachs }
    end;
end;

{ͻ
  Virtual Mem  Ferme le fichier virtuel                                  
 Ķ
  Retire tous les handles, supprime le fichier du disque.                 
 ͼ}
Procedure vm_Done;
var avmb : vmbptr;
begin
  if vm_oldexit = NIL then exit;

  exitproc   := vm_oldexit;
  vm_oldexit := NIL;

  inoutres := 0;
  close (vm_file);       { Fermer }
  Erase (vm_file);       { Supprimer }
  if ioresult > 0 then memres := mr_vm_donefail;

  { Librer les VMB }
  while fvmb <> NIL do begin
    avmb := fvmb^.next;
    Dispose (fvmb);
    fvmb := avmb;
  end;
end;

{ͻ
  Virtual Mem  Trouve le vmb de la liste chain qui a l'ID demand       
 Ķ
  Renvoie 0 si introuv.                                                  
 ͼ}
Function vm_FindVmb (askID : word) : vmbptr;
assembler; asm
  mov  ax, askID
  les  di, fvmb          { Parcourir la liste }

  @loop:                 { Trouver l'ID demand }
  mov  bx, es
  cmp  bx, 0
  je   @fin              { erreur --> renvoyer NIL }
  cmp  es:[di].vmb.id, ax
  je   @fin              { ID trouv }
  les  di, es:[di].vmb.next
  jmp  @loop

  @fin:
  mov  dx, es
  mov  ax, di
end;

{ Traduction en Pascal :

Function vm_FindVmb (askID : word) : vmbptr;
var avmb : vmbptr;
Begin
  avmb := fvmb;
  while avmb <> NIL do with avmb^ do
    if id = askID then break else avmb := next;
  vm_findVmb := avmb;
end;
}

{ͻ
  Virtual Mem  Trouve un identificateur encore inutilis                 
 Ķ
  Pour aller plus rapidement, il est possible de passer par une table     
  de recoupements binaire. La taille ncessaire pour tout traiter en      
  une seule passe sera cependant de 8192 octets.                          
                                                                          
  Cette procdure est souvent utilise, donc optimise en asm             
 ͼ}
Function vm_FindID : word; assembler;
Const LastID : word = 0;
asm
  mov  ax, lastID        { Commencer par 0 }

  @start:
  inc  ax
  les  di, fvmb          { Recommencer  parcourir la liste }

  or   ax, ax
  jnz  @loop
  inc  ax                { Interdire le handle #0 }

  @loop:                 { Vrifier que l'ID choisi n'est pas dj pris }
  mov  bx, es
  cmp  bx, 0
  je   @fin
  cmp  es:[di].vmb.id, ax
  je   @start
  les  di, es:[di].vmb.next
  jmp  @loop

  @fin:
  mov  LastID, ax        { sauver l'ID trouv pour la recherche suivante }
end;

{ Traduction Pascal :

Function vm_FindID : word;
Const LastID : word = 0;
Var   aID : word;
      avmb : vmbptr;
Begin
  aID := LastID;

  Repeat
    inc(aID);
    avmb := fvmb;
    While avmb <> NIL do with avmb^ do begin
      if id = aID then break;
      avmb := next;
    end;
    if avmb = NIL then break;
  Until false;

  LastId := aID;
  vm_FindId := aID;
end;
}

{ͻ
  Virtual Mem  Alloue un bloc de mmoire virtuelle                       
 Ķ
  La taille est  indiquer en KO.                                         
 ͼ}
Procedure vm_Alloc (var handle : word; Asize : word);
Var avmb, lvmb : vmbptr;
    Fhandle    : vmbptr;   { Handle correspondant trouv }
    Fsize      : word;     { Meilleure taille trouve }
    newpos     : longint;  { Vrification nlle pos dans le fichier }
Begin
  avmb    := fvmb;
  lvmb    := NIL;       { dernier }
  Fsize   := 0;
  Fhandle := NIL;
  while avmb <> NIL do with avmb^ do begin
    if fl_unused in flags then
      if (Bsize >= Asize) and (Bsize > Fsize) then begin
        Fhandle := avmb;
        Fsize   := Fhandle^.Bsize;
      end;
    lvmb  := avmb;
    avmb  := avmb^.next;
  end;

  { Fhandle contient le vmb ayant la meilleure taille
    Fsize   = Fhandle^.Bsize soit la meilleure taille trouve
    avmb    contient NIL
    lvmb    contient le dernier VMB de la liste }

  If Fsize > 0 then begin
    If Fsize < Asize then begin
      { Dans ce cas le handle trouv est un peu plus gros que celui
        desir, il suffit donc de faire un autre handle indiquant qu'il
        reste de l'espace libre entre la fin du handle nouvellement
        allou et la taille du handle prcdement prsent }

      New (lvmb^.next);           { Allouer un handle pour combler la <> }
      if heapresult then begin    { Renvoyer false & byebye }
        memres := mr_vm_noMoreMemory;
        exit;
      end;
      avmb := lvmb^.next;
      with avmb^ do begin
        next     := NIL;                       { En dernire place }
        pred     := lvmb;                      { li dans les deux sens }
        id       := vm_FindID;                 { Nouvel identificateur }
        Bsize    := Asize-Fsize;               { Diffrence de taille }
        position := Fhandle^.position + Asize; { Position du bloc restant }
        flags    := [fl_unused];               { inutilis }
      end;
    end;
  end else begin
    { Dans ce cas aucun handle plus grand ou gal  la taille demande
      n'a pu tre trouv, on alloue alors un nouvel handle et on lui
      attribue la dernire position du fichier }
    New(Fhandle);                 { Allouer un nouvel handle }
    if heapresult then begin
      memres := mr_vm_noMoreMemory;
      exit;                       { Renvoyer false & byebye }
    end;
    if fvmb = NIL
      then fvmb := Fhandle
      else lvmb^.next := fhandle;
    With Fhandle^ do begin
      next     := NIL;
      pred     := lvmb;
      id       := vm_FindID;
      position := filesize(vm_file) div MemBloc;
      newpos   := (position + Asize) * MemBloc;
      seek (vm_file, newpos);
      truncate (vm_file);    { etendre la taille du fichier }

      { Plus de place sur disque }
      if filesize(vm_file) <> newpos then begin
        newpos := position * MemBloc;
        if pred = NIL then fvmb := NIL else pred^.next := NIL;
        dispose (fhandle);
        seek (vm_file, newpos);
        truncate (vm_file);
        memres := mr_vm_diskfull;
        exit;
      end;

    end;
  end;

  With Fhandle^ do begin
    Bsize  := Asize;
    flags  := [];
    handle := id;      { Renvoyer }
  end;
end;

{ͻ
  Virtual Mem  Dsalloue un bloc de mmoire virtuelle                    
 Ķ
  Doit avoir t prcdement allou.                                      
  Mini dfragmentation intgre.                                          
 ͼ}
Procedure vm_UnAlloc (var handle : word);
var avmb : vmbptr;        { actuel        | utiliss pour    }
    tvmb : vmbptr;        { temporaire    | la gestion       }
Begin
  avmb := vm_FindVmb (handle);
  if avmb = NIL then begin
    memres := mr_UnknowHandle
  end else with avmb^ do begin
    flags := flags + [fl_unused];

    {******************* REDUCTION DE LA FRAGMENTATION *********************}

    { Vrifier si le prcdent bloc est inutilis,
      si oui, joindre les deux blocs pour rduire la fragmentation }
    if (pred <> NIL) and (fl_unused in pred^.flags) then begin
      position := pred^.position;
      Bsize    := Bsize + pred^.Bsize;
      { joindre l'avant prcdent  celui en cours ! }
      if (pred^.pred <> NIL) then pred^.pred^.next := avmb else fvmb := avmb;
      { garder l'adresse du prcdent. }
      tvmb     := pred;
      { joindre celui en cours  l'avant prcdent ! }
      pred     := pred^.pred;

      { Retirer le handle de la mmoire. }
      Dispose (tvmb);
    end;

    { Vrifier si le bloc suivant est inutilis,
      si oui joindre le bloc courant au suivant pour les mme raisons
      que plus haut }
    if (next <> NIL) and (fl_unused in next^.flags) then begin
      Bsize    := Bsize + next^.Bsize;
      { joindre le suivant-suivant au bloc courant }
      if (next^.next <> NIL) then next^.next^.pred := avmb;
      { sauver }
      tvmb     := next;
      { joindre le bloc courant au suivant-suivant }
      next     := next^.next;
      { Retirer de la mmoire }
      Dispose (tvmb);
    end;

    {***********************************************************************}
    { Les deux blocs ci dessus peuvent tre retirs mais le fichier aura    }
    { alors un espace plus fragment.                                       }
    {***********************************************************************}

    if position + Bsize >= filesize(vm_file) then begin
      { Le bloc  dsallouer est le dernier du fichier }
      Seek (vm_file, position * MemBloc);
      Truncate (vm_file);          { Diminuer la taille du fichier }
      if avmb^.pred <> NIL then avmb^.pred^.next := NIL else fvmb := NIL;
      dispose (avmb);              { Retirer le bloc }
      handle := 0;
    end;
  end;
end;

{ͻ
  Virtual Mem  Opre un transfre entre la mmoire centrale et une zone. 
 Ķ
  Attention ! Cette procdure n'autorise pas les dplacements             
  fichier d'change <-> fichier d'change ni                              
  mmoire centrale  <-> mmoire centrale.                                 
  A vous de les rajouter... pour une fois que vous bosserez !             
 ͼ}
{ Transfre un bloc mmoire avec les informations contenues dans un EMB
  standard pour la XMS. }
Procedure vm_trans (var emb : embRec);
var avmb   : vmbptr;         { Bloc disque  tranfrer }
    handle : word;           { Handle du bloc disque  transfrer }
    data   : pointer;        { adresse du bloc mmoire }
    offset : longint;        { Offset  partir du bloc disque  transfrer }
    count  : word;           { Taille du morceau  transfrer }
Begin
  With emb do begin
    if src_handle = 0
      then begin
        handle := cib_handle;
        offset := cib_offset;
        data   := ReducePtr (pointer(src_offset));
      end else begin
        handle := src_handle;
        offset := src_offset;
        data   := ReducePtr (pointer(cib_offset));
      end;

    avmb := vm_FindVmb (handle);
    if avmb = NIL then begin
      memres := mr_UnknowHandle
    end else with avmb^ do begin

      { Il y a dbordement sur un autre bloc }
      If Esize > offset + longint(Bsize) * MemBloc then begin
        memres := mr_IncorrectSize;
        exit;
      end;

      { Positionner au bon endroit du fichier }
      Seek (vm_file, position * MemBloc + offset);

      { Comme la taille  crire peut tre suprieure  65535 et que
        BlockWrite/read ne fonctionnent qu'avec des word, il faut ruser...  }
      While ESize > 0 do begin
        If ESize >= 65520 then begin             { 65520 est multiple de 16 }
          dec(ESize, 65520);
          count := 65520;
        end else begin
          count := Esize;
          Esize := 0;
        end;
        if emb.src_handle = 0
          then BlockWrite (vm_file, Data^, count)       { crire un morceau }
          else BlockRead  (vm_file, Data^, count);      { lire }

        { Incrmente l'adresse de 65520 octets }
        if count = 65520 then inc(word(data), $FFF);     { Seg = Seg + 4095 }
      end;
    end;

  end; { with emb }
end;

{ͻ
  Virtual Mem  Sauve une zone mmoire vers un handle du fichier d'change
 Ķ
  Les transferts peuvent excder 64ko sans dpassements de segment.       
                                                                          
  Source = Adresse  copier dans un bloc                                  
  Handle = Bloc destination                                               
  offset = adresse destination dans le bloc en octets                     
  Asize  = taille du bloc  dplacer en octets                            
 ͼ}
Procedure vm_save(var source; const handle : word; offset : longint; Asize : longint);
var emb : embrec;
Begin
  With emb do begin
    Esize      := Asize;
    src_handle := 0;                  { mmoire }
    src_offset := longint(@source);   { adresse }
    cib_handle := handle;
    cib_offset := offset;             { destination }
  end;
  vm_trans (emb);
end;

{ͻ
  Virtual Mem  Restaure une zone du fichier d'change vers la mmoire    
 Ķ
  Handle = Bloc source                                                    
  Dest   = Adresse destine  recevoir les donnes                        
  offset = adresse source dans le bloc en octets                          
  Asize  = taille du bloc  dplacer en octets                            
 ͼ}
Procedure vm_load (const handle : word; var dest; offset : longint; Asize : longint);
var emb : embrec;
Begin
  With emb do begin
    Esize      := Asize;
    cib_handle := 0;                  { mmoire }
    cib_offset := longint(@dest);     { adresse }
    src_handle := handle;
    src_offset := offset;             { source }
  end;
  vm_trans (emb);
end;

{ͻ
  Virtual Mem  Renvoie la taille en KO du fichier d'change              
 Ķ
  Attention ! cette procdure est grosse conssomatrice de ressources.     
 ͼ}
Function vm_size : longint;
Begin
  vm_size := filesize (vm_file) Div MemBloc;
end;

{ͻ
  Virtual Mem  Renvoie la place perdue dans le fichier en %              
 Ķ
  La place perdue est constitue de tous les handles dsalloues mais non 
  dfragments.                                                           
 ͼ}
function vm_frag : byte;
var avmb  : vmbptr;        { Bloc courant }
    Usize : longint;       { taille inUtilise dans le fichier }
    Tsize : longint;       { taille Totale du fichier }
Begin
  avmb  := fvmb;
  Usize := 0;
  While avmb <> NIL do with avmb^ do begin
    if (fl_unused in flags) then inc(Usize, Bsize);
    avmb := next;
  end;
  Tsize := Filesize(vm_file) div MemBloc;
  If Tsize > 0
    then vm_frag := Usize * 100 div Tsize
    else vm_frag := 0;
end;

{ͻ
  Virtual Mem  Renvoie le nombre de handles total.                       
 Ķ
  Handles allous et inutiliss inclus.                                   
 ͼ}
Function vm_NbHandles : word;
assembler; asm
  xor  ax, ax
  les  di, fvmb

  @loop:
  mov  bx, es
  or   bx, bx
  jz   @fin
  inc  ax
  les  di, es:[di].vmb.next
  jmp  @loop

  @fin:
end;

{ͻ
  Virtual Mem  Renvoie le nombre de handles UTILISES                     
 Ķ
  Uniquement ceux que vous n'avez pas dsallouer.                         
  Vous pouvez obtenir le nombre de handles existant mais inutiliss par   
  la formule vm_NbHandles - Vm_NbUsedHandles                              
 ͼ}
Function vm_NbUsedHandles : word;
assembler; asm
  xor  ax, ax
  les  di, fvmb

  @loop:
  mov  bx, es
  or   bx, bx
  jz   @fin
  test es:[di].vmb.flags, 1 {fl_unused}
  jnz  @hop
  inc  ax
  @hop:
  les  di, es:[di].vmb.next
  jmp  @loop

  @fin:
end;

{ͻ
  Virtual Mem  Renvoie la place TOTALE encore dispo dans le FICHIER      
 Ķ
  Cd le total des parcelles dsalloues mais encore actives              
  Unit : KO                                                              
 ͼ}
Function vm_MemAvail : longint;
assembler; asm
  xor  ax, ax
  xor  dx, dx
  les  di, fvmb

  @loop:
  mov  bx, es
  or   bx, bx
  jz   @fin
  test es:[di].vmb.flags, 1  {fl_unused}
  jz   @hop
  add  ax, es:[di].vmb.Bsize

  @hop:
  les  di, es:[di].vmb.next
  jmp  @loop

  @fin:
end;

{ͻ
  Virtual Mem  Renvoie la taille MAXIMALE disponible dans le FICHIER     
 Ķ
  cd le plus gros bloc dsallou mais encore disponible                  
  unit : KO                                                              
 ͼ}
Function vm_MaxAvail : longint;
assembler; asm
  xor  ax, ax
  xor  dx, dx
  les  di, fvmb

  @loop:
  mov  bx, es
  or   bx, bx
  jz   @fin
  test es:[di].vmb.flags, 1    {fl_unused}
  jz   @hop

  mov  cx, es:[di].vmb.Bsize   { vrifier si c plus grand }
  cmp  cx, ax
  jbe  @hop
  mov  ax, cx

  @hop:
  les  di, es:[di].vmb.next    { suivant }
  jmp  @loop

  @fin:
end;

{ͻ
  Virtual Mem  Renvoie la taille TOTALE disponible sur le DISQUE         
 Ķ
  Renvoie la place totale encore allouable cd la place disponible sur    
  disque + la place disponible dans l'enceinte du fichier                 
  unit : KO.                                                             
 ͼ}
{ Espace encore disponible pour les allocations en KO }
Function vm_MemFree : longint;
Begin
  Close (vm_file);
  vm_MemFree := DiskFree( ord(Tfilerec(vm_file).name[0]) - 64 ) Div MemBloc +
                 vm_MemAvail;
  Reset (vm_file);
end;

{ͻ
  Virtual Mem  Renvoie la taille MAXIMALE disponible sur le DISQUE       
 Ķ
  Renvoie la place encore allouable en un seul bloc sur tout le disque    
  ou directement dans le fichier si la taille du plus gros bloc dans le   
  fichier est plus grande que la taille disponible sur disque             
  Unit : KO                                                              
 ͼ}
{ Plus grand bloc encore allouable en KO }
Function vm_MaxFree : longint;
var Dsize : longint;       { Taille restant sur disque }
    Msize : longint;       { Taille maxi dispo dans le fichier }
Begin
  Close (vm_file);
  Dsize := DiskFree( ord(Tfilerec(vm_file).name[0]) - 64 ) Div MemBloc;
  Msize := vm_MaxAvail;
  If Dsize > Msize
    then vm_MaxFree := Dsize
    else vm_MaxFree := Msize;
  Reset (vm_file, 1);
end;

{ͻ
  Virtual Mem  Renvoie l'tat du gestionnaire                            
 Ķ
  Renvoie 0 si tout va bien. Fonctionne comme IORESULT.                   
 ͼ}
Function vm_memresult : byte;
assembler; asm
  xor   al, al
  xchg  al, memres
end;

END.