{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P+,Q-,R-,S-,T-,V-,X+,Y+}
Program Vdefrag;
Uses    funcs, crt, Vmem;

{ 
               Exemple de dfragmenteur de mmoire virtuelle.
  

  MakeMemory        : fait un fichier bidon & fouilli alatoire
  DrawBlocs         : donne un apercu de la fragmentation
  AffBlocs          : dboguage uniquement
  Vm_defrag         : Dfragementeur tous types de fichier d'change.

  Amusez vous avec les 4 constantes ci dessous.
}


Const CntByKO   : boolean = true; { Compter les blocs par KO et non par handles }
      MaxBloc   = 100;            { mini = 20 }
      MaxSize   = 30;             { mini = 10 }
      UnAlloc   = 10;             { fraction des blocs dsallous. ici = 1/10 }



Const VidSeg    : word = $B800;   { Dtection Auto }

{ͻ
  Vmem Defrag  Remplit la mmoire virtuelle n'importe comment !          
 Ķ
  Alloue entre 100 et 1000 blocs, puis en dsalloue 10% au hasard.        
 ͼ}
Procedure MakeMemory;
Var   blocs  : array[1..MaxBloc] of word;
      max, i : word;
      sz, tz : longint;
Begin
  Randomize;
  max := MaxBloc - 20 + Random(21);
  tz  := 0;
  for i := 1 to Max do begin
    sz := random(11)+MaxSize-10;
    vm_Alloc (blocs[i], sz);

    while keypressed do if readkey = #27
      then memres := $FF;   { pas trs propre mais efficace }

    if Vm_memresult > 0 then begin
      max := i-1;
      break;
    end;
    inc(tz, sz);
    Write (i, ' blocs allous sur ', max, '. Taille du fichier = ',tz:7, 'ko'#13);
  end;
  Writeln;
  tz := 0;
  For i := 1 to Max do begin
    if random(UnAlloc) = 0 then begin
      inc(tz);
      vm_Unalloc(blocs[i]);
    end;
    Write (i, ' blocs traits dont ', tz, ' dsallous'#13);
  end;
end;

{ͻ
  Vmem Defrag  Dessine les blocs virtuels  l'cran.                     
 Ķ
  Utilise un caractre par KO, si cela ne peux entrer, augment le nombre  
  de KO par caractre.                                                    
 ͼ}
Procedure DrawBlocs;
const nbLig     = 2;          { Nombre de lignes en haut }
      BlocInChar : word = 0;  { Nombre de blocs par caractre }
      fsize      : longint= 0;{ Taille du fichier }
      ocbk       : boolean=false;{ old count by ko }
var   avmb       : vmbptr;    { Bloc en cours de traitement }
      Chr_free   : word;      { Nombre de blocs libres dans le caractre }
      Chr_count  : word;      { Nombre de blocs compts dans le caractre }
      Chr_fact   : word;      { Caractre en cours de traitement }
      i          : word;      { Compteur de blocs dans le caractre }
      z          : word;
      okfirst    : boolean;
      ff         : byte;      { First free, premier trouv ? }
      apos       : longint;   { Position en cours de traitement }

    Procedure DrawChar;
    var c : byte;
        a : char;
    Begin
      if chr_free = Chr_count
        then begin
          c := 2;                { autre bloc libre }
          if ff = 0 then begin
            ff := 1;             { indiqu que le premier bloc libre trouv }
            apos := avmb^.position;
          end
        end
        else if chr_free = 0 then begin
          if ff = 1 then inc(ff);{ ragir : fin du premier bloc libre }
          c := 4;         { n bloc libre }
        end else c := 6;

        if ff < 2 then c := c OR 8;
      MemW[VidSeg:(nblig*80+Chr_fact) SHL 1] := c SHL 8 + 10;
    end;

Begin
  If (BlocInChar = 0) or (ocbk <> cntByKo) then begin
    if cntByKo then begin
      BlocInChar := vm_size div 1599;
      inc(BlocInChar);
    end else begin
      BlocInChar := vm_nbhandles div 1599;
      inc(BlocInChar);
    end;
    ocbk := cntbyko;
  end;

  avmb := fvmb;
  ff   := 0;
  Chr_fact := 0;
  chr_count := 0;
  chr_free := 0;
  While avmb <> NIL do with avmb^ do begin
    if cntByKO
      then z := Bsize
      else z := 1;
    okfirst := chr_count = 0;
    For i := 1 to z do begin
      inc(Chr_count);
      if (fl_unused in flags) then inc(Chr_free);
      if chr_count = BlocInChar then begin
        DrawChar;
        okfirst := true;
        Chr_Count := 0;
        chr_free  := 0;
        inc(chr_fact);
      end;
    end;
    avmb := next;
  end;
  If chr_count > 0 then DrawChar;
  for i := chr_fact to 1599 do
    Memw[VidSeg:(nbLig*80+i) SHL 1] := 15 SHL 8 + 32;

  { informations }
  TextAttr := 30;
  GotoXy (1, 24);
  Write (' Espace perdu : ', vm_frag:5, '%  Fragmentation : ',
         100 -(vm_NBusedhandles * 100 div vm_nbhandles):3, '%',
         '   = ', BlocInChar:3);
  if CntByKo
    then write ('ko      ')
    else write (' bloc(s)');

  { obtenir la taille, une seule fois sinon l'instruction prend 4% du
    temps machine de ce dfragmenteur !! }
  if fsize = 0 then fsize := vm_size;

  if apos > fsize then apos := fsize;
  Write ('  ', apos * 100 div fsize:3,'% achevs  ');

end;

{ͻ
  Vmem Defrag  Etablit la liste des handles prsents.                    
 Ķ
  Aide au dboguage.                                                      
 ͼ}
Procedure Affblocs;
var a : vmbptr;
    n : word;
    ok : boolean;
begin
  textattr := 15;
  ClrScr;
  a := fvmb;
  n := 0;
  ok := (a <> NIL) and (fl_unused in a^.flags);
  while a <> NIL do with a^ do begin
    if (a^.next <> NIL) and (fl_unused in a^.next^.flags) then ok := true;
    if ok then begin
      Writeln ('ID: ',ID:3, '  Taille: ', Bsize:2, '  Position: ', position:4,
               '  Libre: ', fl_unused in flags);
      inc(n);
      if n = 23 then begin
        writeln ('--- Appuyez sur une touche. ESC = fin ---');
        if readkey = #27 then break;
        n := 0;
      end;
    end;
    a := next;
  end;
  if a = NIL then begin
    writeln ('--- Fin, appuyez sur une touche ---');
    readkey;
  end;
  while keypressed do readkey;
end;

{ͻ
  Vmem Defrag  Procdure dfragmentant l'espace.                         
 Ķ
  Passe par un buffer de 64ko. Gre les superpositions.                   
  Mthode brute sans aucune analyse : ramne les blocs un par un vers le  
  haut du fichier.                                                        
                                                                          
  N'utilise absolument aucune des constantes dfinies dans ce programme.  
  Travaille donc uniquement avec les services de l'unit Vmem.            
  Seul appel externe : DrawBlocs pour donner un apercu de la situation.   
 ͼ}
Var buf : pointer;
Procedure Vm_Defrag;
Var avmb       : vmbptr;      { Bloc en cours de traitement }
    totaloct   : longint;     { Total des octets d'un bloc  transferer }
    swapOct    : word;        { Octets transfrs en une passe }
    oldposi    : longint;     { Ancienne position d'un bloc dans le fichier }
    newposi    : longint;     { Nlle position }
    maxoct     : word;        { Nombre d'octets maxi transfrs }
    ovmb       : vmbptr;      { ANcien bloc }
begin
  DrawBlocs;
  avmb := fvmb;
  While avmb <> NIL do with avmb^ do begin
    If (fl_unused in flags) then
    If (next <> NIL) then
    If not (fl_unused in next^.flags) then begin
      { Dans ce cas c'est un bloc rempli qui suit le bloc vide.
        On les interchange. }
      totaloct := next^.Bsize * MemBloc;
      newposi := position * MemBloc;
      oldposi := next^.position * MemBloc;
      if abs(newposi-oldposi) >= 65520
        then maxoct := 65520
        else maxoct := abs(newposi-oldposi);
      Repeat
        If TotalOct > maxoct then begin
          swapOct := maxoct;
          dec(TotalOct, maxoct);
        end else begin
          SwapOct := TotalOct;
          TotalOct := 0;
        end;
        Seek (vm_file, oldposi);
        BlockRead (vm_file, buf^, swapOct);
        oldposi := filepos(vm_file);

        Seek (vm_file, newposi);
        BlockWrite (vm_file, buf^, swapOct);
        newposi := filepos(vm_file);
      Until totalOct = 0;
      Xchg (ID, next^.ID, sizeof(ID));
      Xchg (Bsize, next^.Bsize, sizeof(Bsize));
      Xchg (flags, next^.flags, sizeof(flags));
      next^.position := position + Bsize;

      DrawBlocs;
    end else begin
      { Dans ce cas c'est un bloc logique qui en suit un autre.
        On vire le bloc courant et on passe au suivant }
      next^.position := position;
      inc (next^.Bsize, Bsize);
      next^.pred := pred;
      if pred <> NIL then pred^.next := next else fvmb := next;
      ovmb := avmb;
      avmb := next;
      Dispose (ovmb);
      DrawBlocs;
      continue;        { reboucler sans passer par le next }

    end else begin
      { Dans ce cas c'est le dernier bloc du fichier, vide. On le
        supprime }
      Seek (vm_file, position);
      Truncate (vm_file);
      if pred <> NIL then pred^.next := NIL else fvmb := NIL;
      Dispose (avmb);
      DrawBlocs;
      break;             { avmb = NIL, on arrete tout }
    end;

    if keypressed then
    case readkey of
      #32 : CntByKo := not CntByKo;
      #27 : exit;
      #0  : readkey;
    end;

    avmb := avmb^.next;
  end;
  readkey;
end;

var timer  : longint absolute $40:$6C;
    t1, t2 : longint;
Begin
  if Mem[0:$463] = $3B then dec(VidSeg, $800);

  vm_init;
  if vm_memresult = 0 then begin
    textattr := 7*16;
    ClrScr;
    MakeMemory;
    GetMem(buf, 65520);
    t1 := timer;
    Vm_Defrag;
    t1 := timer-t1;
    FreeMem(buf, 65520);
    textattr := 15;
    ClrScr;
    Writeln ('Temps : ', t1 / 18.2:3:2, ' secondes');
  end;

end.

