{$B-,X+}
Unit HeapUmb;

{ Trs simple, il suffit de rajouter HeapUmb dans "uses" de votre
  programme, et Turbo Pascal se servira aussi des UMBs pour allouer
  la mmoire ! }

INTERFACE

CONST NbUMB   : word = 0;          { Nombre d'UMBs intgrs }
      UMBsize : longint = 0;       { Taille de tous les UMBs runis }

Type  BlocPtr = ^Bloc;
      Bloc = record
        next : BlocPtr;   { Prochain bloc }
        size : word;      { Taille en paragraphes }
        segm : word;      { Segment d'adresse }
      end;

      FreePtr = ^FreeRec;
      FreeRec = record
        next  : FreePtr;
        sizeO : word;
        sizeS : word;
      end;

Var   fBloc   : BlocPtr;

IMPLEMENTATION

Const xm_ok          = 0;
      xm_mcb_failure = 7;
      xm_no_more_mem = 8;
      xm_not_mcb     = 9;

      MinBloc        = 2;        { Taille minimale d'un bloc en paragraphes }

var   oldexit : pointer;

{ͻ
  Unit memory  Renvoie la taille de la mmoire externe disponible        
 Ķ
  Le nombre renvoy indique la taille DU PLUS GRAND                       
  BLOC disponible en paragraphes                                          
 ͼ}
Function  xp_MaxAvail : word;
assembler; asm
  mov  ah, 48h              { Allouer }
  mov  bx, $FFFF            { toute la mmoire }
  int  21h                  { Impossible, d'o erreur }
  mov  ax, bx
end;

{ͻ
  Unit memory  Alloue un bloc mmoire externe                            
 Ķ
  Le maximum adressable est fonction de la taille maximum disponible      
  Renvoie le segment de la zone adresse                                  
 ͼ}
Function  xp_GetMem (Size: word) : word;
assembler; asm
  mov  ah, 48h              { Crer un block }
  mov  bx, size             { taille }
  int  21h                  { Maintenant, au dos de jouer ! }
  jnc  @fin                 { erreur, al = 7, 8 ou 9 }
  xor  ax, ax               { ax = 0 : erreur }
  @fin:
end;

{ͻ
  Unit memory  Dsaloue une zone mmoire externe dos                     
 Ķ
  P identifie un MCB qui contient les informations ncessaires (taille,   
  voisins...) au dchargement du bloc.                                    
 ͼ}
Procedure xp_FreeMem (P: word);
assembler; asm
  mov  ah, 49h              { Retirer un block de la mmoire }
  mov  es, p
  int  21h                  { Maintenant, au dos de jouer ! }
end;

{  Renvoie TRUE si DOS version 5 ou plus prsent }
Function DOS5 : boolean;
Assembler; asm
  mov  ah, 30h
  int  21h
  cmp  al, 5
  mov  al, false
  jb   @fin
  inc  al
@fin:
end;

{  Configure le DOS pour utiliser les UMBs.
     FALSE --> DOS=UMB non prcis dans config.sys
     TRUE  --> c'est bon, DOS est prt  allouer dans les UMBs. }
Function SetUMB : boolean;
Assembler; asm
  mov  ax, 5803h
  mov  bx, 1
  int  21h
  mov  al, false
  jc   @error
  mov  ax, 5801h
  mov  bx, 81h
  int  21h
  mov  al, false
  jc   @error
  inc  al
  @error:
end;

{  Dsalloue tous les UMBs allous pour retrouver une configuration de
     base. Le tas devient totalement inutilisable aprs cet appel,
     normalement automatique,  la fin du programme. }
Procedure UnAllocBlocks; far;
Var Bloc1, Bloc2 : BlocPtr;
Begin
  ExitProc := oldexit;

  Bloc1 := fBloc;
  While Bloc1 <> NIL do with Bloc1^ do begin
    xp_FreeMem (segm);               { Refiler au DOS l'UMB }
    Bloc1 := next;
  end;
  FreeList := HeapPtr;               { Faire semblant que tout va bien }
end;

{  Alloue tous les blocs disponibles, UMB ou non, ayant au moins la
     taille indique dans MinBloc. }
Procedure AllocAllBlocks;
Var Bloc1, Bloc2 : BlocPtr;
    MaxSize      : word;               { Taille  allouer }
Begin

  { Allocation de TOUS les blocs }
  fBloc := NIL;
  Repeat
    MaxSize := xp_MaxAvail;            { Taille du plus grand bloc dispo }
    if MaxSize < MinBloc then break;   { Trop petite }
    New (Bloc1);                       { Allouer un descripteur }
    If fBloc = NIL
      then fBloc := Bloc1              { Premire entre de la liste }
      else Bloc2^.next := Bloc1;       { lie la liste }
    Bloc2 := Bloc1;                    { Garder trace du prcedent }
    With Bloc1^ do begin
      segm := xp_GetMem (MaxSize);     { Allouer le bloc mmoire }
      size := MaxSize;                 { indiquer sa taille }
      next := NIL;                     { pour indiquer la fin de la liste }
    end;
  Until false;                         { c'est le break qui en sortira }

  { Dsallocation des non - UMBs }
  Bloc1 := fBloc;
  Bloc2 := NIL;
  While Bloc1 <> NIL do with Bloc1^ do begin

    { Ce n'est pas un UMB : dsallouer }
    If segm < $A000 then begin
      xp_FreeMem (segm);               { Rendre au DOS ce qui est au DOS }
      If Bloc2 = NIL
        then fBloc := next             { Faire pointer le prcdent sur }
        else Bloc2^.next := next;      { le suivant }
      Dispose (Bloc1);
      If Bloc2 = NIL                   { Continuer sur le suivant }
        then Bloc1 := fBloc
        else Bloc1 := Bloc2^.next;
      continue;                        { Revenir au while }
    end;

    Bloc2 := Bloc1;                    { Bloc2 garde trace du prcdent }
    Bloc1 := next;                     { Passer au suivant }

  end;
end;

{  Enchaine les UMBs avec le systme d'allocation de TP }
Procedure ChainBlocks;
Var Bloc1, Bloc2 : BlocPtr;
Begin
  { Chainage dans la mmoire }
  Bloc1 := fBloc;
  While Bloc1 <> NIL do with Bloc1^ do begin
    If next = NIL
      then FreePtr(Ptr(segm, 0))^.next := FreeList
      else FreePtr(Ptr(segm, 0))^.next := Ptr(next^.segm, 0);

    FreePtr(Ptr(segm, 0))^.sizeO := 0;
    FreePtr(Ptr(segm, 0))^.sizeS := size;

    inc(NbUmb);
    inc(UmbSize, longint(size)*16);
    Bloc1 := next;
  end;

  { Organiser la dsallocation }
  if nbUmb > 0 then begin
    { Repositionner FreeList sur le premier UMB }
    FreeList := Ptr(fBloc^.segm, 0);
    oldexit  := exitproc;
    exitproc := @UnAllocBlocks; { Nouvelle sortie }
  end;
end;

BEGIN
  If DOS5 and SetUMB Then AllocAllBlocks;
  ChainBlocks;
END.