{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P+,Q-,R-,S-,T-,V-,X+,Y+}

Unit
{ Cette unit } Funcs { propose quelques fonctions utilises par Vmem, Xms
  et Memory, rutilisables dans d'autres unites };

(* ͻ
   *********************************************************************
   ****************************) INTERFACE (****************************
   *********************************************************************
   ͼ *)

CONST Heap_err : boolean = FALSE;

Function HeapResult : boolean;
Function Exist (fic : string) : boolean;
Function AddSlash (var s : string) : boolean;  { true si added }
Procedure Xchg (Var Source, Dest; Count : Word);
Function ReducePtr (p : pointer) : pointer;

(* ͻ
   *********************************************************************
   *************************) IMPLEMENTATION (**************************
   *********************************************************************
   ͼ *)

{ͻ
  Unit  Funcs  Gestion des dbordements de tas                           
 Ķ
  Les fonctions suivantes servent  avertir d'une erreur d'allocation     
  ou d'un dbordement de tas                                              
 ͼ}
VAR   Heap_old : pointer;
      Exit_old : pointer;

{ͻ
  Unit  Funcs  Appele  chaque new/dispose/get/freemem   ***INTERNAL*** 
 ͼ}
FUNCTION heap_man(Size : Word): Integer; far;
assembler; asm
  cmp  size, 0
  je   @ok
  mov  heap_err, 1
  @ok:
  mov  ax, 1
end;

{ͻ
  Unit  Funcs  Dsactive l'avertisseur d'erreurs de tas   ***INTERNAL*** 
 ͼ}
PROCEDURE DoneHeap; far;
assembler; asm
  push ds
  pop  es
  cld
  mov  si, offset exit_old
  mov  di, offset exitproc
  movsw
  movsw
  mov  si, offset heap_old
  mov  di, offset heaperror
  movsw
  movsw
end;

{ͻ
  Unit  Funcs  Renvoie TRUE si une erreur de tas s'est produite          
 ͼ}
FUNCTION HeapResult : BOOLEAN;
assembler; asm
  xor   al, al
  xchg  al, Heap_err
end;

{ͻ
  Unit  Funcs  Dsactive l'avertisseur d'erreurs de tas   ***INTERNAL*** 
 ͼ}
PROCEDURE InitHeap; far;
assembler; asm
  push ds
  pop  es
  cld
  mov  si, offset heaperror
  mov  di, offset heap_old
  movsw
  movsw
  mov  ds:[si]-2, cs
  mov  ax, offset heap_man
  mov  ds:[si]-4, ax
  mov  si, offset exitproc
  mov  di, offset exit_old
  movsw
  movsw
  mov  ds:[si]-2, cs
  mov  ax, offset DoneHeap
  mov  ds:[si]-4, ax
end;

{ͻ
  Unit  Funcs  Informe de l'existance d'un fichier ou d'un rpertoire    
 Ķ
  le rpertoire peut tre indifframent termin par un anti-Slash ou non  
 ͼ}
Function Exist (fic : string) : boolean;
assembler; asm
  push ds
  cld
  lds  si, fic
  lodsb
  mov  dx, si
  xor  bh, bh
  mov  bl, al
  cmp  byte ptr ds:[si+bx-1], '\'
  jne  @met0
  cmp  byte ptr ds:[si+bx-2], ':'
  je   @met0
  dec  bx
  @met0:
  mov  byte ptr ds:[si+bx], 0
  mov  ax, 4300h
  int  21h
  mov  al, 0
  jc   @fin
  inc  al
  @fin:
  pop  ds
end;

{ͻ
  Unit  Funcs  Ajoute un contre slash s'il n'est pas dj prsent        
 Ķ
  Renvoie true si il y a eu modification                                  
 ͼ}
Function AddSlash (var s : string) : boolean;  { true si added }
assembler; asm
  mov  al, false
  les  di, s
  mov  bx, di
  add  bl, es:[bx]
  adc  bh, 0
  cmp  byte ptr es:[bx], '\'
  je   @bye
  inc  byte ptr es:[di]
  mov  byte ptr es:[bx+1], '\'
  inc  al

  @bye:
end;

{ͻ
  Unit  Funcs  Echange deux parties de mmoires                          
 Ķ
  A la difference de Move, Xchg intervertit les donnes sources et cible. 
 ͼ}
Procedure Xchg     (Var Source, Dest;    Count : Word);
assembler; asm     { Pas de 32 bits ici, gain de temps insignifiant }
  cld
  push ds
  mov  cx, count
  les  di, Dest
  lds  si, Source
  or   cx, cx
  jz   @fin

  shr  cx, 1
  jz   @one
  @:mov  ax, es:[di]   { cible  --> buffer }
    movsw              { source --> cible  }
    mov  ds:[si-2], ax { cible  --> source }
  loop @
  jnc  @fin

  @one:
  mov  al, es:[di]
  movsb
  mov  ds:[si-1], al

  @fin:
  pop  ds
end;

{ͻ
  Unit  Funcs  Renvoie un pointeur sous sa forme la plus simple          
 Ķ
  B000:8000h --> B800:0000h                                               
  5000:123Ch --> 5123:000Ch                                               
 ͼ}
Function ReducePtr (p : pointer) : pointer;
assembler; asm
  mov  ax, word ptr p
  mov  dx, word ptr p+2
  mov  bx, ax
  mov  cl, 4
  shr  bx, cl
  add  dx, bx
  and  ax, 15
end;

BEGIN
  InitHeap;
END.