.386P	
LOCALS	
b	EQU <byte ptr>
w	EQU <word ptr>
d	EQU <dword ptr>
o	EQU <offset>
setalc	EQU <db 0d6h>
Meg	EQU 1048576
	
RTCEMU = 1
	
INCLUDE PMSTRUC.ASI
	
; ====================================
	
CodeOS SEGMENT USE32
ASSUME cs:CodeOS	
	
StartOS:        ; On arrive en mode protg, f initialiser les interruptions.
	
	xor eax,eax	; Init les reg de seg
	mov ds,eax
	mov es,eax
	mov fs,eax
	mov gs,eax
	mov eax,Sel_PileOS
	mov ss,eax
	mov esp,TaillePileOS-4
	
PAUSE	MACRO
	JMP $+2
	JMP $+2
	ENDM
	
	; *************************
	; ** Reinitialise le PIC **
	; *************************
	
        mov al,11h      ; 11h pour PC (Edge trigered) / 19h pour PS
                        ; (Level trigered)
	out 0a0h,al
	PAUSE
	out 20h,al
	
	mov al,40
	out 0a1h,al
	PAUSE
	mov al,32
	out 21h,al
	PAUSE
	
	mov al,2
	out 0a1h,al
	PAUSE
	mov al,4
	out 021h,al
	PAUSE
	
	mov al,00001110b	; ICW4
	out 021h,al
	PAUSE
	mov al,00001010b
	out 0a1h,al
	PAUSE
	
	mov al,0	; enables toutes les IRQs
	out 21h,al
	PAUSE
	out 0a1h,al
	PAUSE
	mov al,20h	; et okazou on envoit des EOIs
	out 20h,al
	PAUSE
	out 0a0h,al
	
	; programme la frequence du PIT
	
	Count = 5966	;(approx 5ms - duree*1.19318M)
	
	mov al,110110b
	out 43h,al
	PAUSE
	mov al, low Count
	out 40h,al
	PAUSE
	mov al, high Count
	out 40h,al
	
	
        ; ***************************
        ; ** Lance l'irq Verticale **
        ; ***************************
	
IFE RTCEMU	
	mov eax,Sel_@CodeOS
	mov ds,eax
ASSUME ds:CodeOS	
	mov dx,3d4h
	mov al,11h
	out dx,al
	inc dx
	in al,dx
	mov VGA_OldVRE,al
	or al,00010000b
	out dx,al
ELSE	
	mov al,8bh
	out 70h,al
	PAUSE
	in al,71h
	PAUSE
	or al,01001000b
	out 71h,al
	PAUSE
	
	mov al,8ah
	out 70h,al
	PAUSE
        mov al,1010b+(010b*16) ; Frquence d'int = 64Hz
	out 71h,al
	PAUSE
ENDIF	
	
	; **************
	; ** Init VGA **
	; **************
	
	mov dx,3ceh
	mov ax,01h	; ALL CPU
	out dx,ax
	mov al,03h	; REMPLACER
	out dx,ax
	mov al,05h	; W0R0
	out dx,ax
	mov ax,0ff08h	; ALL BITS
	out dx,ax
	
	
	; *****************
	; ** Init la Map **
	; *****************
	
	mov eax,Sel_Map
	mov es,eax
ASSUME ds:NOTHING	
	mov eax,Sel_DataOS
	mov ds,eax
ASSUME ds:DataOS	
	mov eax,Sel_MapDesc
	mov fs,eax
	
	xor edi,edi	; CLS
	mov ecx,(2*Meg) shr 2
	xor eax,eax
	rep stosd
	
	xor edi,edi
	mov ecx,NbMapMurs
	
@@TraceMur:	; Tracer un bloc
	
	movzx esi,w fs:[edi+2]	; Y
	shl esi,10
	movzx eax,w fs:[edi]
	add esi,eax	; esi = addy du premier coin
	
	mov bx,fs:[edi+6]	; bx = delta Y
	sub bx,fs:[edi+2]
@@1:	
	mov dx,fs:[edi+4]	; dx = Delta X
	sub dx,fs:[edi]
	
	push esi
@@0:	
	mov b es:[esi],1	; met un mur
	inc esi
	dec dx
	jnz @@0
	
	pop esi
	add esi,1024
	dec bx
	jnz @@1
	
	add edi,8
	dec ecx
	jnz @@TraceMur
	
	
	; Afficher la Map
	
	xor esi,esi
	mov edi,esi
	mov ecx,1023
	mov edx,2047
	call Map2VRAM_C0
	
	; *************************
        ; ** Lance le multitche **
	; *************************
	
	mov eax,Sel_DataOs
	mov ds,eax
ASSUME ds:DataOS	
	in al,40h
	mov Rand,al
	
	mov ax,Sel_TSSPoubelle	; charge le TSS bidon
	ltr ax
	
	int 32	; Go !!
	
	
ASSUME ds:NOTHING	
	
INCLUDE INTERFAC.ASI
INCLUDE INTERRUP.ASI
	
FinCodeOS = $
CodeOS ENDS

; ====================================

PileOS SEGMENT STACK 'STACK'
TaillePileOS = 2048
	DB TaillePileOS dup(0)
PileOS ENDS

; ====================================
	
PileDro1N0 SEGMENT
TaillePileDroN0 = 1024
	DB TaillePileDroN0 dup(0)
PileDro1N0 ENDS	
	
PileDro2N0 SEGMENT
	DB TaillePileDroN0 dup(0)
PileDro2N0 ENDS	
	
PileDro3N0 SEGMENT
	DB TaillePileDroN0 dup(0)
PileDro3N0 ENDS	
	
; ====================================
	
PileIRQ SEGMENT	
	DB 1024 dup(0)
PileIRQ ENDS	
	
PileDeadDroid SEGMENT
	DB 1024 dup(0)
PileDeadDroid ENDS
	
; =====================================
	
MapDesc SEGMENT	
DebMapDesc = $
	DW 0,0,1023,39	; cadre
	DW 0,40,39,2047
	DW 40,2008,1023,2047
	DW 984,40,1023,2008
	
        DW 40,600,984,639       ; dcoupe l'espace en deux

	DW 800,250,810,600	; Des petits murs
	DW 300,300,720,310
	DW 130,450,300,455
	DW 295,455,300,600
FinMapDesc = $	
MapDesc ENDS	
	
; =====================================
	
DataOS SEGMENT USE32
	
NbMapMurs	DD (o FinMapDesc - o DebMapDesc) SHR 3 ;9
	
GDTLoader	DTPtr_s <o FinGDT - o GDT,>
GDT	LABEL GDT_Desc_s
;	              Limite 0_15   |Base 0_15|Base 16_23|        Acces        |     Taille     |Base 24_31|
GDT_Nul	GDT_Desc_s <       0        ,    0    ,    0     ,        0            ,       0        ,    0     >
GDT_Radio	GDT_Desc_s <     0ffffh     ,    0    , 110000b  , 11100000b+TypeData  ,     1111b      ,    0     >	; ComSeg
GDT_Radar	GDT_Desc_s <  Module_Radar  ,Sel_CodeOS,   0     ,11100000b+TypeCallGate,     0         ,    0     >
GDT_Tir	GDT_Desc_s <  Module_Tir    ,Sel_CodeOS,   0     ,11100000b+TypeCallGate,     0         ,    0     >
GDT_CodeOS	GDT_Desc_s <   o FinCodeOS  ,         ,          , MASK AccesP+TypeCode, MASK TailleD_B ,          >
GDT_@CodeOS	GDT_Desc_s <   o FinCodeOS  ,         ,          , MASK AccesP+TypeData,       0        ,          >
GDT_DataOS	GDT_Desc_s <   o FinDataOS  ,         ,          , MASK AccesP+TypeData,       0        ,          >
GDT_Map	GDT_Desc_s <      512       ,    0    ,   10h    , MASK AccesP+TypeData,  MASK TailleG  ,    0     >
GDT_VRAM	GDT_Desc_s <     0FFFFh     ,   0000h ,   0ah    , MASK AccesP+TypeData,       1        ,    0     >
GDT_MapDesc	GDT_Desc_s <     0ffffh     ,         ,          , MASK AccesP+TypeData,       0        ,          >	; taille bidon de 64Ko
GDT_PileOS	GDT_Desc_s <       0        ,         ,          ,MASK AccesP+TypeStack, MASK TailleD_B ,          >
GDT_PileIRQ	GDT_Desc_s <       0        ,         ,          ,MASK AccesP+TypeStack, MASK TailleD_B ,          >
GDT_PileDeadDroid	GDT_Desc_s <       0        ,         ,          ,MASK AccesP+TypeStack, MASK TailleD_B ,          >
GDT_TSSIRQ0	GDT_DESC_s <FinTSSIRQ0-TSSIRQ0,       ,          ,      10001001b      ,       0        ,          >
GDT_TSSPoubelle	GDT_DESC_s <FinTSSPoub-TSSPoubelle,   ,          ,      10001001b      ,       0        ,          >
; Les infos des Droids
GDT_LDTDro1	GDT_DESC_s <FinLDTDro1-LDTDro1,       ,          ,  11100000b+TypeLDT  ,       0        ,          >	; A qoui sert le DPL d'un descripteur de LDT ??
GDT_CodeDro1	GDT_DESC_s < o FinCodeDro1  ,         ,          , 11100000b+TypeCode  , MASK TailleD_B ,          >	; pourquoi un DPL de 3 deja ??
GDT_PileDro1	GDT_DESC_s <       0        ,         ,          , 11100000b+TypeStack , MASK TailleD_B ,          >
; ---
GDT_LDTDro2	GDT_DESC_s <FinLDTDro2-LDTDro2,       ,          ,  11100000b+TypeLDT  ,       0        ,          >
GDT_CodeDro2	GDT_DESC_s < o FinCodeDro2  ,         ,          , 11100000b+TypeCode  , MASK TailleD_B ,          >
GDT_PileDro2	GDT_DESC_s <       0        ,         ,          , 11100000b+TypeStack , MASK TailleD_B ,          >
; ---
GDT_LDTDro3	GDT_DESC_s <FinLDTDro3-LDTDro3,       ,          ,  11100000b+TypeLDT  ,       0        ,          >
GDT_CodeDro3	GDT_DESC_s < o FinCodeDro3  ,         ,          , 11100000b+TypeCode  , MASK TailleD_B ,          >
GDT_PileDro3	GDT_DESC_s <       0        ,         ,          , 11100000b+TypeStack , MASK TailleD_B ,          >
; Les DatasSeg des droids
GDT_DataDro1	GDT_Desc_s <    0ffffh      ,         ,          , 10000000b+TypeData  ,       0        ,    0     >
GDT_DataDro2	GDT_Desc_s <    0ffffh      ,         ,          , 10000000b+TypeData  ,       0        ,    0     >
GDT_DataDro3	GDT_Desc_s <    0ffffh      ,         ,          , 10000000b+TypeData  ,       0        ,    0     >
; Les pilesOS des taches
GDT_PileDro1N0	GDT_Desc_s <       0        ,         ,          ,MASK AccesP+TypeStack, MASK TailleD_B ,          >
; ---
GDT_PileDro2N0	GDT_Desc_s <       0        ,         ,          ,MASK AccesP+TypeStack, MASK TailleD_B ,          >
; ---
GDT_PileDro3N0	GDT_Desc_s <       0        ,         ,          ,MASK AccesP+TypeStack, MASK TailleD_B ,          >
; A partir d'ici, on a les taches qui commutent
GDT_TSSDep	GDT_DESC_s <FinTSSDep-TSSDep,         ,          ,      10001011b      ,       0        ,          >
GDT_TSSDro1	GDT_DESC_s <FinTSSDro1-TSSDro1,       ,          ,      10001011b      ,       0        ,          >
GDT_TSSDro2	GDT_DESC_s <FinTSSDro2-TSSDro2,       ,          ,      10001011b      ,       0        ,          >
GDT_TSSDro3	GDT_DESC_s <FinTSSDro3-TSSDro3,       ,          ,      10001011b      ,       0        ,          >
FinGDT = $	
;	Les selecteurs associes
Sel_Nul	= 0
Sel_Radio	= GDT_Radio-GDT	; 1er
Sel_Radar	= GDT_Radar-GDT	; 2eme
Sel_Tir	= GDT_Tir-GDT	; 3eme
Sel_CodeOS	= GDT_CodeOS-GDT
Sel_@CodeOS	= GDT_@CodeOS-GDT
Sel_DataOS	= GDT_DataOS-GDT
Sel_Map	= GDT_Map-GDT
Sel_Radio	= GDT_Radio-GDT
Sel_VRAM	= GDT_VRAM-GDT
Sel_MapDesc	= GDT_MapDesc-GDT
Sel_PileOS	= GDT_PileOS-GDT
Sel_PileIRQ	= GDT_PileIRQ-GDT
Sel_PileDeadDroid	= GDT_PileDeadDroid-GDT
Sel_TSSIRQ0	= GDT_TSSIRQ0-GDT
Sel_TSSPoubelle	= GDT_TSSPoubelle-GDT
Sel_TSSDep	= GDT_TSSDep-GDT
; ---	
Sel_TSSDro1	= GDT_TSSDro1-GDT
Sel_CodeDro1	= GDT_CodeDro1-GDT
Sel_PileDro1	= GDT_Piledro1-GDT
Sel_PileDro1N0	= GDT_PileDro1N0-GDT
Sel_DataDro1	= GDT_DataDro1-GDT
Sel_LDTDro1	= GDT_LDTDro1-GDT
; ---	
Sel_LDTDro2	= GDT_LDTDro2-GDT
Sel_TSSDro2	= GDT_TSSDro2-GDT
Sel_CodeDro2	= GDT_CodeDro2-GDT
Sel_PileDro2	= GDT_Piledro2-GDT
Sel_PileDro2N0	= GDT_PileDro2N0-GDT
Sel_DataDro2	= GDT_DataDro2-GDT
; ---	
Sel_LDTDro3	= GDT_LDTDro3-GDT
Sel_TSSDro3	= GDT_TSSDro3-GDT
Sel_CodeDro3	= GDT_CodeDro3-GDT
Sel_PileDro3	= GDT_Piledro3-GDT
Sel_PileDro3N0	= GDT_PileDro3N0-GDT
Sel_DataDro3	= GDT_DataDro3-GDT
	
ALIGN 4	
	
Sel_FrstTache	DD Sel_TSSDep
Sel_TacheActu	DD Sel_TSSDep
Sel_LastTache	DD Sel_TSSDro3
	
Sel_TSSTable	DD o TSSDep, o TSSDro1, o TSSDro2, o TSSDro3	; ne plus utiliser cette table par la suite !
NbDroids	DD 3
ViewSelection	DD 0
ParamDroTable	DD o ParamDro1, Sel_DataDro1, o ParamDro2, Sel_DataDro2, o ParamDro3, Sel_DataDro3
	
IDTLoader	DTPtr_s <o FinIDT - o IDT,>
IDT	LABEL
;	
IDT_Division	IDT_Desc_s <o Int_Division,Sel_CodeOS, , >	; ** EXCEPTIONS & INTEL RESERVED **
IDT_Debug	IDT_Desc_s <o Int_Debug,Sel_CodeOS, , >
IDT_NMI	IDT_Desc_s <o Int_NMI,Sel_CodeOS, , >
IDT_PointArret	IDT_Desc_s <o Int_PointArret,Sel_CodeOS, , >
IDT_Overflow	IDT_Desc_s <o Int_OverFlow,Sel_CodeOS, , >
IDT_Bound	IDT_Desc_s <o Int_Bound,Sel_CodeOS, , >
IDT_OpCodeInvld	IDT_Desc_s <o Int_OpCodeInvld,Sel_CodeOS, , >
IDT_EmuCopro	IDT_Desc_s <o Int_EmuCopro,Sel_CodeOS, , >
IDT_DoubleFaute	IDT_Desc_s <o Int_DoubleFaute,Sel_CodeOS, , >
IDT_DepassCopro	IDT_Desc_s <o Int_DepassCopro,Sel_CodeOS, , >
IDT_TSSInvld	IDT_Desc_s <o Int_TSSInvld,Sel_CodeOS, , >
IDT_SegAbsent	IDT_Desc_s <o Int_SegAbsent,Sel_CodeOS, , >
IDT_FautePile	IDT_Desc_s <o Int_FautePile,Sel_CodeOS, , >
IDT_Protection	IDT_Desc_s <o Int_Protection,Sel_CodeOS, , >
IDT_FautePage	IDT_Desc_s <o Int_FautePage,Sel_CodeOS, , >
IDT_Reserv	IDT_Desc_s <o Int_Reserv,Sel_CodeOS, , >
IDT_FauteMaths	IDT_Desc_s <o Int_FauteMaths,Sel_CodeOS, , >
IDT_IntelResered	IDT_Desc_s 15 dup (<o Int_IntelReserved,Sel_CodeOS, , >)
IDT_IRQ0	IDT_Desc_s <,Sel_TSSIRQ0,,10000101b,>	; ** IRQ DU 8259 **
IDT_IRQ1	IDT_Desc_s <o Int_IRQ1,Sel_CodeOS,,,>
IDT_IRQ2	IDT_Desc_s <o Int_IRQ2,Sel_CodeOS,,,>
IDT_IRQ3	IDT_Desc_s <o Int_IRQ3,Sel_CodeOS,,,>
IDT_IRQ4	IDT_Desc_s <o Int_IRQ4,Sel_CodeOS,,,>
IDT_IRQ5	IDT_Desc_s <o Int_IRQ5,Sel_CodeOS,,,>
IDT_IRQ6	IDT_Desc_s <o Int_IRQ6,Sel_CodeOS,,,>
IDT_IRQ7	IDT_Desc_s <o Int_IRQ7,Sel_CodeOS,,,>
IDT_IRQ8	IDT_Desc_s <o Int_IRQ8,Sel_CodeOS,,,>
IDT_IRQ9	IDT_Desc_s <o Int_IRQ9,Sel_CodeOS,,,>
IDT_IRQ10	IDT_Desc_s <o Int_IRQ10,Sel_CodeOS,,,>
IDT_IRQ11	IDT_Desc_s <o Int_IRQ11,Sel_CodeOS,,,>
IDT_IRQ12	IDT_Desc_s <o Int_IRQ12,Sel_CodeOS,,,>
IDT_IRQ13	IDT_Desc_s <o Int_IRQ13,Sel_CodeOS,,,>
IDT_IRQ14	IDT_Desc_s <o Int_IRQ14,Sel_CodeOS,,,>
IDT_IRQ15	IDT_Desc_s <o Int_IRQ15,Sel_CodeOS,,,> 
FinIDT = $	
	
	
;	**************
;	** Les LDTs **
;	**************
	
LDTDro1_Loader	DTPtr_s <o FinLDTDro1 - o LDTDro1,>
LDTDro1	LABEL GDT_Desc_s
;               Limite 0_15     |  Base 0_15  |  Base 16_23  |          Acces          |       Taille       |  Base 24_31  |
GDT_Desc_s <       0ffffh       ,             ,              ,   11100000b+TypeData    ,         0          ,      0       >	; Datas Locales
FinLDTDro1 = $	
	
LDTDro2_Loader	DTPtr_s <o FinLDTDro2 - o LDTDro2,>
LDTDro2	LABEL GDT_Desc_s
;               Limite 0_15     |  Base 0_15  |  Base 16_23  |          Acces          |       Taille       |  Base 24_31  |
GDT_Desc_s <       0ffffh       ,             ,              ,   11100000b+TypeData    ,         0          ,      0       >	; Datas Locales
FinLDTDro2 = $	
	
LDTDro3_Loader	DTPtr_s <o FinLDTDro3 - o LDTDro3,>
LDTDro3	LABEL GDT_Desc_s
;               Limite 0_15     |  Base 0_15  |  Base 16_23  |          Acces          |       Taille       |  Base 24_31  |
GDT_Desc_s <       0ffffh       ,             ,              ,   11100000b+TypeData    ,         0          ,      0       >	; Datas Locales
FinLDTDro3 = $	
	
	
; =========================================
TSSPoubelle	TSSHeader_s <,,,,,,,,,,,,,,,,,,,,,,,,,,IOMApPoub-TSSPoubelle>
ParamPoub	LABEL
IOMapPoub	LABEL
FinTSSPoub = $	
; =========================================
TSSIRQ0	TSSHeader_s <,1020,Sel_PileIRQ,,,,,,o Int_IRQ0,100000000000000b,,,,,1020,,,,,Sel_CodeOS,Sel_PileIRQ,,,,,,IOMapIRQ0-TSSIRQ0>
ParamIRQ0	LABEL
IOMapIRQ0	LABEL
FinTSSIRQ0 = $	
; =========================================
TSSDep	TSSHeader_s <,TaillePileOS-4,Sel_PileOS,,,,,,o Task_Dep,111000000000000b,,,,,TaillePileOS-4,,,,,Sel_CodeOS,Sel_PileOS,Sel_DataOS,,,,,IOMapDep-TSSDep>
ParamDep	LABEL
IOMapDep	LABEL
FinTSSDep = $	
; =========================================
DroParam	STRUC
Dro_Number	DD ?	; juste pour simplifier
Dro_PosX	DD 512*65536
Dro_PosY	DD 1024*65536
Dro_Orient	DD 0
Dro_Flag	DD 0
Dro_TirTempo	DD 0
	ENDS
; =========================================
TSSDro1	TSSHeader_s <,TaillePileDroN0-4,Sel_PileDro1N0,,,,,,o StartDroid1,100001000000000b,,,,,1020,,,,Sel_Radio,Sel_CodeDro1+3,Sel_PileDro1+3,100b,,,Sel_LDTDro1,,IOMApDro1-TSSDro1>
ParamDro1	DroParam <0,500*65536,80*65536>
IOMapDro1	LABEL
FinTSSDro1 = $	
; =========================================
TSSDro2	TSSHeader_s <,TaillePileDroN0-4,Sel_PileDro2N0,,,,,,o StartDroid2,100001000000000b,,,,,1020,,,,Sel_Radio,Sel_CodeDro2+3,Sel_PileDro2+3,100b,,,Sel_LDTDro2,,IOMApDro2-TSSDro2>
ParamDro2	DroParam <1,450*65536,100*65536,400>
IOMapDro2	LABEL
FinTSSDro2 = $	
; =========================================
TSSDro3	TSSHeader_s <,TaillePileDroN0-4,Sel_PileDro3N0,,,,,,o StartDroid3,100001000000000b,,,,,1020,,,,Sel_Radio,Sel_CodeDro3+3,Sel_PileDro3+3,100b,,,Sel_LDTDro3,,IOMApDro3-TSSDro3>
ParamDro3	DroParam <2,800*65536,120*65536>
IOMapDro3	LABEL
FinTSSDro3 = $	
; =========================================
	
KeyField	DD 0,0,0,0	; 128 bits pour les 102 touches du clavier
	
VGA_CRTC	DW 0
HPP	DB 0,0
	
ALIGN 4	
INCLUDE sinus.512
	
Y1	DW ?
X1	DW ?
Y2	DW ?
X2	DW ?
Y3	DW ?
X3	DW ?
	
DeltaX1	DW ?
DeltaX1Hi	DW ?,0
DeltaX2	DW ?
DeltaX2Hi	DW ?,0
DeltaX3	DW ?
DeltaX3Hi	DW ?,0
	
XMap	DD ?,0
YMap	DD ?,0
	
RadioDumpAddy	DD 0
DroidDumpAddy	DD 0
ViewSequence	DD 0
	
LignesATracer	DD 4*50 DUP(0)	; X1,Y1,X2,Y2
NbLignesATracer	DD o LignesATracer
LignesAEffacer	DD 4*50 DUP(0)
NbLignesAEffacer	DD o LignesAEffacer
	
TaillePlotMask1	DD 8,7,6,5,4,3,2,1
PlotMask1	DB 11111111b,01111111b,00111111b,00011111b,00001111b,00000111b,00000011b,00000001b
PlotMask2	DB 00000000b,10000000b,11000000b,11100000b,11110000b,11111000b,11111100b,11111110b
PlotAnd	DB 11111111b,11111110b,11111100b,11111000b,11110000b,11100000b,11000000b,10000000b,00000000b
PlotMask0	DB 10000000b,01000000b,00100000b,00010000b,00001000b,00000100b,00000010b,00000001b
	
Quotient	DD ?,0
	
Rand	DB ?,?,?,?
	
INCLUDE	FONT.ASI
	
FinDataOS = $	
DataOS ENDS	
	
; ===================================
	
Code16 SEGMENT USE16
ASSUME cs:Code16	
	
Start:	
	; ***************
	; ** Init. DOS **
	; ***************
	
	mov bx,1000h
	mov ah,4ah
	int 21h
	
	; **************************
	; ** Activer la ligne A20 **
	; **************************
	
	mov ax,4300h
	int 2fh
	mov ax,4310h
	int 2fh
	mov XMMOff,bx
	mov XMMSeg,es
	mov ah,3
	jmp $+2
	db 9ah
XMMOff	DW 1234h
XMMSeg	DW 1234h
	
	
	; *******************************
	; ** S'approcher du mode video **
	; *******************************
	
	mov ax,12h	; 640*480 - 16 couls
	int 10h
	
	mov dx,3d4h	; offset = 512
	mov ax,2013h
	out dx,ax
	
	; **********************
	; ** Completer la GDT **
	; **********************
	
BaseGDT	MACRO @@Desc , @@Seg , @@Lab
	
	mov eax,@@Seg
	shl eax,4
IFDEF @@Lab	
	add eax,o @@Lab
ENDIF	
	mov @@Desc.GDesc_Base_0_15,ax
	shr eax,16
	mov @@Desc.GDesc_Base_16_23,al
	mov @@Desc.GDesc_Base_24_31,ah
	ENDM
	
	mov ax,DataOS
	mov ds,ax
ASSUME ds:DataOS	
	BaseGDT GDT_CodeOS , CodeOS
	BaseGDT GDT_@CodeOS , CodeOS
	BaseGDT GDT_DataOS, DataOS
	BaseGDT GDT_MapDesc, MapDesc
	BaseGDT GDT_PileOS , PileOS
	BaseGDT GDT_PileIRQ , PileIRQ
	BaseGDT GDT_PileDeadDroid , PileDeadDroid
	BaseGDT GDT_TSSIRQ0 , DataOS , TSSIRQ0
	BaseGDT GDT_TSSPoubelle , DataOS , TSSPoubelle
	BaseGDT GDT_TSSDep , DataOS , TSSDep
	; ---
	BaseGDT GDT_TSSDro1 , DataOS , TSSDro1
	BaseGDT GDT_CodeDro1 , CodeDroid1
	BaseGDT GDT_PileDro1 , PileDroid1
	BaseGDT GDT_PileDro1N0 , PileDro1N0
	BaseGDT GDT_LDTDro1 , DataOS , LDTDro1
	; ---
	BaseGDT GDT_TSSDro2 , DataOS , TSSDro2
	BaseGDT GDT_CodeDro2 , CodeDroid2
	BaseGDT GDT_PileDro2 , PileDroid2
	BaseGDT GDT_PileDro2N0 , PileDro2N0
	BaseGDT GDT_LDTDro2 , DataOS , LDTDro2
	; ---
	BaseGDT GDT_TSSDro3 , DataOS , TSSDro3
	BaseGDT GDT_CodeDro3 , CodeDroid3
	BaseGDT GDT_PileDro3 , PileDroid3
	BaseGDT GDT_PileDro3N0 , PileDro3N0
	BaseGDT GDT_LDTDro3 , DataOS , LDTDro3
	
	; *******************************
	; ** Completer avec les droids **
	; *******************************
	
        mov bx,1000h    ; alloc un segment en conventionnelle pour les datas
                        ; locales a droid1
	mov ah,48h
	int 21h
	call ClearSeg
	movzx eax,ax
	shl eax,4
	mov LDTDro1.GDesc_Base_0_15,ax
	mov GDT_DataDro1.GDesc_Base_0_15,ax
	shr eax,16
	mov LDTDro1.GDesc_Base_16_23,al
	mov GDT_DataDro1.GDesc_Base_16_23,al
	
	; ---
	
	mov bx,1000h	; droid 2
	mov ah,48h
	int 21h
	call ClearSeg
	movzx eax,ax
	shl eax,4
	mov LDTDro2.GDesc_Base_0_15,ax
	mov GDT_DataDro2.GDesc_Base_0_15,ax
	shr eax,16
	mov LDTDro2.GDesc_Base_16_23,al
	mov GDT_DataDro2.GDesc_Base_16_23,al
	
	; ---
	
	mov bx,1000h	; droid 3
	mov ah,48h
	int 21h
	jc $
	call ClearSeg
	movzx eax,ax
	shl eax,4
	mov LDTDro3.GDesc_Base_0_15,ax
	mov GDT_DataDro3.GDesc_Base_0_15,ax
	shr eax,16
	mov LDTDro3.GDesc_Base_16_23,al
	mov GDT_DataDro3.GDesc_Base_16_23,al
	
	; ***********************
	; ** Charger GDT & IDT **
	; ***********************
	
	cli
	mov al,00h
	out 70h,al
	in al,71h
	
	mov eax,DataOS
	shl eax,4
	mov ebx,eax
	add eax,o GDT
	mov GDTLoader.DTPtr_BaseGDT,eax
	lgdt GDTLoader
	
	add ebx,o IDT
	mov IDTLoader.DTPtr_BaseGDT,ebx
	lidt IDTLoader
	
	; ****************************
	; ** Passer en mode protege **
	; ****************************
	
	push 11000000000010b
	popfd
	
	mov eax,cr0
	or eax,MASK CR0PE
	mov cr0,eax
	
	db 66h		; JMP FAR Sel_CodeOS:StartOS
	db 0eah
	dd o StartOS
	dw Sel_CodeOS
	
ClearSeg:	; IN : ax = Segment dont il faut clearer les 32 premiers octets
	push es
	pusha
	mov es,ax
	xor di,di
	mov cx,32
	xor al,al
	cld
	rep stosb
	popa
	pop es
	retn
	
Code16 ENDS	
	
; =====================================
	
INCLUDE DROID1.ASM
INCLUDE DROID2.ASM
INCLUDE DROID3.ASM

END	Start
