/*************************************************************\
** (c) Jrme Stolfo 1995                                    **
**                                                           **
** Donne la taille reelle d'un repertoire                    **
** Syntaxe : RS [dir] [/sub] [/nnnn]                          **
**          /sub : scanne aussi les sours-repertoires        **
**          /nnnn : simule des clusters de 'nnnn' octets     **
\*************************************************************/

#include <iostream.h>
#include <stdlib.h>
#include <dir.h>
#include <fcntl.h>
#include <dos.h>
#include <string.h>
#include <process.h>
#include <conio.h>

extern unsigned _stklen = 40000U;

unsigned int ClusterSize;
unsigned int SimulClusterSize;
char Dir[256];
char OldDir[256];
int Sub=0;
int Simul= 0;
unsigned long TotalBytes;
unsigned long SimulTotalBytes;
unsigned long FalseBytes;
unsigned long SubDirBytes;
int Deep;

inline void PrintTitle();
void ParseCommandLine( int argc, char **argv);
inline void PrintSyntax();
void ReadFiles();
void MoveTo();
void MoveFrom();
void ReadSub( char *Name);

void main( int argc, char **argv)
{
	/* Affiche le titre */
	PrintTitle();
	/* Traite la ligne de commande */
	ParseCommandLine( argc, argv);

	/* Se deplace vers le repertoire indique */
	MoveTo();
	/* Lit la taille de tous les fichiers */
	ReadFiles();
	/* Revient au repertoire de depart */
	MoveFrom();
}

inline void PrintTitle()
{
	cout << "Clusters 1.00 - (c) J. Stolfo 1995 - Freeware.\n\n";
}

inline void PrintSyntax()
{
	cout << "Syntaxe : RS Repertoire [/sub][/nnnn]\n"
		  << "             /sub : Scanne les sous-repertoires\n"
		  << "             /nnnn : Simule des clusters de nnnn octets.\n\n";
	exit( 1);
}

void ParseCommandLine( int argc, char **argv)
{
	/* Verifie le nombre d'arguments */
	if( ( argc > 4)) PrintSyntax();
	int DirPresent=1;
	if( argc>=2 && argv[1][0]=='/') {
		DirPresent--;
		_fullpath( Dir, "", 255);
	} else {
		_fullpath( Dir, argv[1], 255);
	}

	for( int i= 1+DirPresent; i<argc; ++i)
	{
		if( argv[i][0] != '/') {
			cout << "Argument incorrect...\n";
			PrintSyntax();
			exit( 1);
		}

		switch( argv[i][1]) {
			case 's' :
			case 'S' : Sub++;
						  break;

			case '0' :
			case '1' :
			case '2' :
			case '3' :
			case '4' :
			case '5' :
			case '6' :
			case '7' :
			case '8' :
			case '9' :
				Simul++;
				SimulClusterSize= atoi( argv[i]+1);
				if( !SimulClusterSize)
				{
					cout << "Taille de clusters invalide...\n";
					PrintSyntax();
					exit( 1);
				}
				break;

			default : cout << "Argument inconnu...\n";
						 PrintSyntax();
						 exit (1);
						 break;
		}
	}

	_fullpath( OldDir, "", 255);

	_DX= Dir[0]-'A'+1;
	unsigned int SectorsPerCluster;
	unsigned int BytesPerSector;

	/* Obtient la taille des clusters */
	asm {
		mov ah, 36h
		int 21h
		mov SectorsPerCluster, ax
		mov BytesPerSector, cx
	}

	ClusterSize= SectorsPerCluster* BytesPerSector;

	cout << "Taille des clusters : " << ClusterSize << " octets.\n\n";
}

void MoveTo()
{
	setdisk( Dir[0]-'A');
	if( chdir( Dir+2)== -1) {
		cout << "Chemin non trouve !!\n";
		setdisk( OldDir[0]-'A');
		exit( 1);
	}
}

void MoveFrom()
{
	setdisk( OldDir[0]-'A');
   chdir( OldDir+2);
}

void ReadFiles()
{
	cout << "Travail en cours...\n";
	if( Sub) cout << "Scanne les sous-repertoires...\n";

	struct ffblk ffb;
	ldiv_t size;
   int done= findfirst( "*.*", &ffb, 0x7F);
   while( !done )
   {
      if( (ffb.ff_attrib & FA_DIREC) && (ffb.ff_name[0] != '.')) {
         if( Sub) ReadSub( ffb.ff_name);
         TotalBytes += ClusterSize;
         if( Simul) SimulTotalBytes += SimulClusterSize;

      } else {
         size= ldiv( ffb.ff_fsize, ClusterSize);
         if( size.rem) TotalBytes+=(size.quot+1)*ClusterSize;
         else TotalBytes+=ffb.ff_fsize;

         if( Simul) {
            size= ldiv( ffb.ff_fsize, SimulClusterSize);
				if( size.rem) SimulTotalBytes+=(size.quot+1)*SimulClusterSize;
				else SimulTotalBytes+=ffb.ff_fsize;
			}

			FalseBytes+= ffb.ff_fsize;
		}

		done= findnext( &ffb);
	}
	cout << "\n\nTotal indique par le DOS : " << FalseBytes
		  << " (" << (FalseBytes>>10) << " Ko)."
		  << "\nTotal trouve par Clusters : " << TotalBytes
		  << " (" << (TotalBytes>>10) << " Ko).\n";

	if( Simul) {
		cout << "\nResultats de la simulation (clusters de " << SimulClusterSize <<
				  " octets) :\n";
		cout << "   Avec les clusters fictifs : " << SimulTotalBytes <<
				  " octets (" << (SimulTotalBytes>>10) << " Ko).\n" <<
				  "   Et avec les clusters reels : " <<
				  TotalBytes << " octets (" << (TotalBytes>>10) << " Ko).\n" <<
				  "   Difference : " << (TotalBytes - SimulTotalBytes) <<
				  " octets (" << (TotalBytes - SimulTotalBytes)*100/TotalBytes <<
				  "%).\n";
	}
}

void ReadSub( char *Name)
{
   Deep++;
   chdir( Name);

   cout << '\n';
   for( int i=0; i< Deep; ++i)
      cout << "    ";

	cout << "Sous-repertoire : " << Name << " : ";

	SubDirBytes= 0;
	struct ffblk ffb;
	ldiv_t size;
   int done= findfirst( "*.*", &ffb, 0x7F);
   while( !done)
   {
      if( (ffb.ff_attrib & FA_DIREC) && (ffb.ff_name[0] != '.')) {
         if( Sub) ReadSub( ffb.ff_name);
         TotalBytes += ClusterSize;
         SubDirBytes += ClusterSize;

         if( Simul) SimulTotalBytes += SimulClusterSize;

      } else {
         size= ldiv( ffb.ff_fsize, ClusterSize);
         if( size.rem) TotalBytes+=(size.quot+1)*ClusterSize;
			else TotalBytes+=ffb.ff_fsize;
         if( size.rem) SubDirBytes+=(size.quot+1)*ClusterSize;
         else SubDirBytes+=ffb.ff_fsize;

         if( Simul) {
				size= ldiv( ffb.ff_fsize, SimulClusterSize);
            if( size.rem) SimulTotalBytes+=(size.quot+1)*SimulClusterSize;
            else SimulTotalBytes+=ffb.ff_fsize;
         }

         FalseBytes+= ffb.ff_fsize;
      }

      done= findnext( &ffb);
   }

   cout << '\n';
   for( i=0; i< Deep; ++i)
		cout << "    ";
	cout << "> Total " << Name << " : " << SubDirBytes << " octets.\n";

   chdir( "..");
   Deep--;
}
