unit jeu;
(**************************************************************************
    Le 'coeur' de CRESUS, dcrit et comment pour le reporter.
    Contient en fait diffrents algorithmes de recherche de coup
    optimal dans un arbre de jeu, afin de les comparer.

             (C)  Mars 1995,  Luc Rivire

***************************************************************************)
{---------------------------------INTERFACE--------------------------------}
interface

type tJeu=array[1..111] of byte;

const
    {type de pions particuliers}
    bord=9; pionV=0; vide=8;
    {valeur des pions en dizaines de centimes}
    valeur:array[0..9] of integer=(1,2,5,10,20,50,100,200,0,0);
    {les 8 directions possibles de dplacement}
    NE=-11; N=-10; NO=-9; O=-1; E=1; SE=9; S=10; SO=11;
    dir:array[1..8] of shortint=(NE,N,NO,O,E,SE,S,SO);
    {premire et dernire case qui ne soit pas un bord}
    premier=12; dernier=100;
    {tableau de jeu initial}
    JeuInit:tJeu=(
    bord,bord,bord,bord,bord,bord,bord,bord,bord,bord,
    bord,pionV,pionV,pionV,pionV,pionV,pionV,pionV,pionV,pionV,
    bord,pionV,pionV,pionV,pionV,pionV,pionV,pionV,pionV,pionV,
    bord,pionV,pionV,pionV,pionV,pionV,pionV,pionV,pionV,pionV,
    bord,pionV,pionV,pionV,pionV,pionV,pionV,pionV,pionV,pionV,
    bord,pionV,pionV,pionV,pionV,vide,pionV,pionV,pionV,pionV,
    bord,pionV,pionV,pionV,pionV,pionV,pionV,pionV,pionV,pionV,
    bord,pionV,pionV,pionV,pionV,pionV,pionV,pionV,pionV,pionV,
    bord,pionV,pionV,pionV,pionV,pionV,pionV,pionV,pionV,pionV,
    bord,pionV,pionV,pionV,pionV,pionV,pionV,pionV,pionV,pionV,
    bord,bord,bord,bord,bord,bord,bord,bord,bord,bord,bord);
    {l'adversaire est l'oppose du joueur}
    oppose:array [0..1] of byte=(1,0);

var xCurs,yCurs:byte;  {position du curseur}
    jeuEnCour:tJeu;    {le jeu en lui mme}
    joueur:byte;       {celui qui a le trait}
    score:array[0..1] of integer;
    resultatEval:integer;
    nbNoeud,nbBranche,nbfeuille:longint;
    estOrdi:array[0..1] of boolean;
    methode:array[0..1] of char;
    { methode contient un caractre, pour chaque joueur, qui indique,
      si c'est un ordi, quelle methode de recherche il doit utiliser.
      valeurs permises:     'M' pour le MiniMax
                            'A' pour l'AlphaBeta
                            'S' pour Scout
                            'P' pour Principal Variation Search (PVS)
                            'I' pour une suite AlphaBeta-PVS
    }

procedure initJeu; {a appeler au debut du jeu}
procedure choisisCase(x,y:byte);
procedure coupOrdi(var x,y:byte; prof:byte);
function fini:boolean;
procedure retour(var x,y:byte);
procedure sauvegarde(nomPartie:string);
procedure recupere(nomPartie:string;var x,y:byte);

{------------------------------IMPLEMENTATION------------------------------}
implementation


type listeCoups=record
                  nombre:byte; position,pion:array[1..8] of byte;
                end;

     pBranche=^Branche;
     Branche=record    {pour version avec stockage arbre}
        position,pion:byte;
        frere,fils:pBranche;
        result:integer;
     end;

var curseur:byte;
    provScore:integer;
    jeuDebut:tJeu;
    suiteJouee:array[1..81] of byte;
    nbCoups:byte;
    f:file of byte;
    profStocke:byte;
    tete:pBranche;

{----------------------------------FINI------------------------------------}

function fini:boolean;
{teste si jeu est fini}
var i:byte;
begin
  fini:=true;
  for i:=1 to 8 do if jeuEnCour[curseur+dir[i]]<vide then fini:=false;
end;

{--------------------------------INITJEU-----------------------------------}

procedure initJeu;
{initialise une nouvelle partie au debut}
const seuil:array[1..7] of real=(0.08,0.22,0.38,0.56,0.72,0.84,0.94);
var i:byte; x:real;
begin
  jeuEnCour:=jeuInit;
  curseur:=56;
  xCurs:=(curseur-1) mod 10; yCurs:=(curseur-1) div 10;
  score[0]:=0; score[1]:=0;
  joueur:=0;
  resultatEval:=0;
  nbNoeud:=0; nbBranche:=0; nbFeuille:=0;
  for i:=premier to dernier do
    if jeuEnCour[i]=pionV then begin
      x:=random;
      if x>seuil[7] then jeuEnCour[i]:=7
      else if x>seuil[6] then jeuEnCour[i]:=6
      else if x>seuil[5] then jeuEnCour[i]:=5
      else if x>seuil[4] then jeuEnCour[i]:=4
      else if x>seuil[3] then jeuEnCour[i]:=3
      else if x>seuil[2] then jeuEnCour[i]:=2
      else if x>seuil[1] then jeuEnCour[i]:=1
      else jeuEnCour[i]:=0;
     {dfavorise les pices extrmes, ce qui est voulu}
    end;
  jeuDebut:=jeuEnCour; {recopie jeu du debut, pour permettre retour arrire}
  nbCoups:=0;
end;

{------------------------------CHOISISCASE---------------------------------}

procedure choisisCase(x,y:byte);
{procedure  appeler lorsque un joueur a choisi une case donne}
var posit:byte;
begin
  posit:=10*x+y+1;
  if abs(curseur-posit) in [1,9,10,11] then begin
    {sur l'une des cases voisines}
    if jeuEnCour[posit]<vide then begin
      {pion prenable}
      inc(score[joueur],valeur[jeuEnCour[posit]]);
      jeuEnCour[posit]:=vide;
      joueur:=oppose[joueur];
      curseur:=posit;
      xCurs:=x; yCurs:=y;
      inc(nbCoups); suiteJouee[nbCoups]:=posit;
    end;
  end;
end;

{----------------------------------RETOUR----------------------------------}

procedure rejoueJusque(n:byte);
{rejoue depuis le dbut de la partie jusqu' un coup donn}
var i,posit:integer;
begin
  jeuEnCour:=jeuDebut;
  score[0]:=0; score[1]:=0; joueur:=0;
  posit:=56;
  for i:=1 to n do begin
    posit:=suiteJouee[i];
    inc(score[joueur],valeur[jeuEnCour[posit]]);
    jeuEnCour[posit]:=vide;
    joueur:=oppose[joueur];
  end;
  curseur:=posit;
  xCurs:=(curseur-1) div 10; yCurs:=(curseur-1) mod 10;
end;

procedure retour(var x,y:byte);
var n:integer;
begin
  if estOrdi[oppose[joueur]] then nbCoups:=nbCoups-2 else nbCoups:=nbCoups-1;
  if nbCoups>128 then nbCoups:=0;    {byte ngatif!}
  rejoueJusque(nbCoups);
  x:=xCurs; y:=yCurs;
end;

{---------------------------------RECUPERE---------------------------------}

procedure recupere(nomPartie:string;var x,y:byte);
{recupere une partie sur disque}
var i:byte;
begin
  assign(f,nomPartie+'.PRT');
  reset(f);
  for i:=1 to 111 do read(f,jeuDebut[i]);
  read(f,nBCoups);  {nombre de coups joues}
  for i:=1 to nbCoups do read(f,suiteJouee[i]);
  close(f);
  rejoueJusque(nbCoups);
  x:=xCurs; y:=yCurs;
end;

{---------------------------------SAUVEGARDE-------------------------------}

procedure sauvegarde(nomPartie:string);
{sauvegarde une partie sur disque}
var i:byte;
begin
  assign(f,nomPartie+'.PRT');
  rewrite(f);
  for i:=1 to 111 do write(f,jeuDebut[i]);
  write(f,nBCoups);  {nombre de coups joues}
  for i:=1 to nbCoups do write(f,suiteJouee[i]);
  close(f);
end;

{---------------------------------EVALUATION-------------------------------}

function ScoreFinal:integer;
begin
  if provScore>0 then ScoreFinal:=16500+provScore
  else if provScore<0 then ScoreFinal:=-16500+provScore
  else ScoreFinal:=0;
end;

function evalue(cur:byte):integer;
{bien que ce soit du ressort de la 'tactique' on continue ici
  choisir le meilleur coup possible du joueur parmi tous ceux
 dont il dispose.. On creuse en fait d'une profondeur de plus
 mais sans coupure}
var i,max,valVois:byte;
begin
  inc(nbFeuille);
  max:=0;
  for i:=1 to 8 do begin
    valVois:=valeur[jeuEnCour[cur+dir[i]]];
    if (valVois>max) then max:=valVois;
    {car valeur d'une case vide et du bord mis  zro}
  end;
  {provScore est vu du cot adversaire car on ne l'a pas fait jouer
  en ralit! De plus,il a pris le pion sur la position en 'cur'}
  evalue:=-provScore-valeur[jeuEnCour[cur]]+max;
end;

{------------------------------CHERCHE et CLASSE---------------------------}

procedure chercheEtClasse(cur:byte;var liste:listeCoups);
var i,j,provPion,provPos:byte;
begin
  with liste do begin
    nombre:=0;
    for i:=1 to 8 do if jeuEnCour[cur+dir[i]]<vide then begin
      inc(nombre);
      position[nombre]:=cur+dir[i];
      pion[nombre]:=jeuEnCour[cur+dir[i]];
      j:=nombre-1;
      while (j>0) and (pion[j]<pion[j+1]) do begin
        provPion:=pion[j]; provPos:=position[j];
        pion[j]:=pion[j+1]; position[j]:=position[j+1];
        pion[j+1]:=provPion; position[j+1]:=provPos;
        dec(j);
      end; {while}
    end; {for}
  end; {with}
end;

{-----------------------------------MINIMAX--------------------------------}

function minimax(prof,cur:byte; var best:byte):integer;
var liste:listeCoups;  max,resultat:integer; meilleur,j:byte;
begin
  inc(nbNoeud);
  chercheEtClasse(cur,liste);
  {en fait classer est inutile dans le minimax..}
  if (liste.nombre=0) then minimax:=scoreFinal
               {plus de cases jouables}
  else begin {pour les cases jouables}
    max:=-32000;
    with liste do for j:=1 to nombre do begin
      inc(NbBranche);
      if (prof=1) then resultat:=-evalue(position[j])
      else begin
        jeuEnCour[position[j]]:=vide; {joue la case}
        provScore:=-provScore-valeur[pion[j]];
        resultat:=-minimax(prof-1,position[j],meilleur);
        jeuEnCour[position[j]]:=pion[j]; {remet en place}
        provScore:=-provScore-valeur[pion[j]];
      end;
      if resultat>max then begin
        max:=resultat; best:=position[j];
      end;
    end; {with.. for..}
    minimax:=max;
  end; {cases jouables}
end;

{---------------------------------ALPHA-BETA-------------------------------}

function AlphaBeta(alpha,beta:integer; prof,cur:byte; var best:byte):integer;
var liste:listeCoups;  max,resultat:integer; meilleur,j:byte;
begin
  inc(nbNoeud);
  chercheEtClasse(cur,liste);
  if (liste.nombre=0) then AlphaBeta:=scoreFinal
     {plus de cases jouables}
  else begin {pour les cases jouables}
    max:=-32000;
    with liste do begin
      j:=0;
      repeat
        inc(NbBranche);
        inc(j);
        if (prof=1) then resultat:=-evalue(position[j])
        else begin
          jeuEnCour[position[j]]:=vide; {joue la case}
          provScore:=-provScore-valeur[pion[j]];
          resultat:=-AlphaBeta(-beta,-alpha,prof-1,position[j],meilleur);
          jeuEnCour[position[j]]:=pion[j]; {remet en place}
          provScore:=-provScore-valeur[pion[j]];
        end;
        if resultat>max then begin
          max:=resultat; best:=position[j];
        end;
        if resultat>alpha then alpha:=resultat;
      until (j=nombre) or (alpha>=beta);
    end; {with}
    AlphaBeta:=max;
  end; {cases jouables}
end;

{---------------------------------ZEROWINDOW-------------------------------}

function zeroWindow(alpha:integer; prof,cur:byte):integer;
{comme un AlphaBeta avec beta=alpha+1}
var liste:listeCoups;  max,resultat:integer; j:byte;
begin
  inc(nbNoeud);
  chercheEtClasse(cur,liste);
  if (liste.nombre=0) then zeroWindow:=scoreFinal
    {plus de cases jouables}
  else begin {pour les cases jouables}
    max:=-32000;
    with liste do begin
      j:=0;
      repeat
        inc(NbBranche);
        inc(j);
        if (prof=1) then resultat:=-evalue(position[j])
        else begin
          jeuEnCour[position[j]]:=vide; {joue la case}
          provScore:=-provScore-valeur[pion[j]];
          resultat:=-zeroWindow(-succ(alpha),prof-1,position[j]);
          jeuEnCour[position[j]]:=pion[j]; {remet en place}
          provScore:=-provScore-valeur[pion[j]];
        end;
        if resultat>max then max:=resultat;
      until (j=nombre) or (max>alpha);
    end; {with}
    zeroWindow:=max;
  end; {cases jouables}
end;

{------------------------------------SCOUT---------------------------------}

function Scout (prof,cur:byte; var best:byte):integer;
    {Scout de base: espionner avant d'valuer}
var liste:listeCoups;  max,resultat:integer; meilleur,j:byte;
    first:boolean;
begin
  inc(nbNoeud);
  chercheEtClasse(cur,liste);
  if (liste.nombre=0) then Scout:=scoreFinal
     {plus de cases jouables}
  else begin {pour les cases jouables}
    max:=-32000;
    first:=true;
    with liste do begin
      for j:=1 to nombre do begin
        inc(NbBranche);
        if (prof=1) then resultat:=-evalue(position[j])
        else begin
          jeuEnCour[position[j]]:=vide; {joue la case}
          provScore:=-provScore-valeur[pion[j]];
          if first then begin
            resultat:=-Scout(prof-1,position[j],meilleur);
            first:=false;
          end else begin {coups suivants}
            resultat:=-zeroWindow(-succ(max),prof-1,position[j]);
            {on espionne}
            if (max<resultat) then begin
              {si ncessaire, on value}
              inc(NbBranche);
              resultat:=-Scout(prof-1,position[j],meilleur);
            end;
          end;
          jeuEnCour[position[j]]:=pion[j]; {remet en place}
          provScore:=-provScore-valeur[pion[j]];
        end;
        if resultat>max then begin
          max:=resultat; best:=position[j];
        end;
      end; {for j}
    end; {with}
    Scout:=max;
  end; {cases jouables}
end;

{-----------------------PRINCIPAL VARIATION SEARCH-------------------------}

function PVSearch(alpha,beta:integer; prof,cur:byte; var best:byte):integer;
var liste:listeCoups;  max,resultat:integer; meilleur,j:byte; first:boolean;
   {combinaison AlphaBeta et Scout: Principal Variation Search}
begin
  inc(nbNoeud);
  chercheEtClasse(cur,liste);
  if (liste.nombre=0) then PVSearch:=scoreFinal
     {plus de cases jouables}
  else begin {pour les cases jouables}
    max:=-32000;
    first:=true;
    with liste do begin
      j:=0;
      repeat
        inc(NbBranche);
        inc(j);
        if (prof=1) then resultat:=-evalue(position[j])
        else begin
          jeuEnCour[position[j]]:=vide; {joue la case}
          provScore:=-provScore-valeur[pion[j]];
          if first then begin
            resultat:=-PVSearch(-beta,-alpha,prof-1,position[j],meilleur);
            first:=false;
          end else begin {coups suivants}
            resultat:=-zeroWindow(-succ(alpha),prof-1,position[j]);
            if (alpha<resultat) and (resultat<beta) and (prof>2) then begin
              inc(NbBranche);
              resultat:=-PVSearch(-beta,-resultat,prof-1,position[j],meilleur);
            end;
          end;
          jeuEnCour[position[j]]:=pion[j]; {remet en place}
          provScore:=-provScore-valeur[pion[j]];
        end;
        if resultat>max then begin
          max:=resultat; best:=position[j];
        end;
        if resultat>alpha then alpha:=resultat;
      until (j=nombre) or (alpha>=beta);
    end; {with}
    PVSearch:=max;
  end; {cases jouables}
end;

{---------------------------------RECLASSEMENT-----------------------------}

procedure reclasse(var precedent,courant,premier:pBranche);
{rordonne l'arbre de jeu en fonction du nouveau rsultat}
var provis:pBranche;
begin
  if (precedent=nil) or (courant^.result<=precedent^.result) then begin
  {premier coup ou dj bien pla: pas de reclassement}
    precedent:=courant;
    courant:=courant^.frere;
  end else begin {il faut reclasser courant..}
    precedent^.frere:=courant^.frere;
    {prcdent reli au suivant de courant}
    if (premier^.result<courant^.result) then begin
        {la nouvelle branche devient la premire}
      courant^.frere:=premier; premier:=courant;
    end else begin {voyons les autres}
      provis:=premier;
      while (provis^.frere^.result>courant^.result)
        {tant qu'il existe un frre mieux class, on passe au suivant}
      do provis:=provis^.frere;
      {insrer courant entre provis et son frere}
      courant^.frere:=provis^.frere;
      provis^.frere:=courant;
    end;
    courant:=precedent^.frere; {coup suivant}
  end;
end;

{---------------------------ALPHA BETA avec STOCKAGE-----------------------}

function ABStocke(alpha,beta:integer; prof,cur:byte;
                  var best:byte; var papa:pBranche)   :integer;
  {AlphaBeta avec stockage des coups de l'arbre}
var max,resultat:integer; meilleur:byte;
    premier,courant,precedent:pBranche;

procedure initialiseBranche(cur:byte);
var i:byte;
begin
  premier:=nil;
  for i:=1 to 8 do if jeuEnCour[cur+dir[i]]<vide then begin
    new(courant);    {nouvelle branche}
    with courant^ do begin
      position:=cur+dir[i];
      pion:=jeuEnCour[cur+dir[i]];
      result:=-32000;
      frere:=nil; fils:=nil;
    end;
    if (premier=nil) then premier:=courant
    {tenir trace de la premire branche}
    else begin
      if (premier^.pion<courant^.pion) then begin
        {la nouvelle branche devient la premire}
        courant^.frere:=premier; premier:=courant;
      end else begin
        precedent:=premier;
        while (precedent^.frere<>nil) and (precedent^.frere^.pion>=courant^.pion)
        {tant qu'il existe un frre mieux class, on passe au suivant}
          do precedent:=precedent^.frere;
        if precedent^.frere=nil then precedent^.frere:=courant
        else begin
          courant^.frere:=precedent^.frere; precedent^.frere:=courant;
        end;
      end;
    end;
  end; {for}
end; {initialiseBranche}

begin
  inc(nbNoeud);
  initialiseBranche(cur);
  if (premier=nil) then ABStocke:=scoreFinal
     {plus de cases jouables}
  else begin {pour les cases jouables}
    max:=-32000;
    courant:=premier;
    precedent:=nil; {le prcdent de courant}
    repeat
      inc(NbBranche);
      if (prof=1) then resultat:=-evalue(courant^.position)
      else begin
        jeuEnCour[courant^.position]:=vide; {joue la case}
        provScore:=-provScore-valeur[courant^.pion];
        if prof<profStocke then
          resultat:=-AlphaBeta(-beta,-alpha,prof-1,courant^.position,meilleur)
        else
          resultat:=-ABStocke(-beta,-alpha,prof-1,courant^.position,meilleur,courant);
        jeuEnCour[courant^.position]:=courant^.pion; {remet en place}
        provScore:=-provScore-valeur[courant^.pion];
      end;
      courant^.result:=resultat;
      if resultat>max then begin
          max:=resultat; best:=courant^.position;
      end;
      if resultat>alpha then alpha:=resultat;
      reclasse(precedent,courant,premier); {rordonne et passe au suivant}
    until (courant=nil) or (alpha>=beta);
    ABStocke:=max;
    papa^.fils:=premier;
  end; {cases jouables}
end;

{-------------------------ZEROWINDOW sur ARBRE-----------------------------}

function ZWarbre(alpha:integer; prof,cur:byte;var papa:pBranche):integer;
{ZeroWindow avec rcupration arbre, sans reclassement}
var max,resultat:integer; courant:PBranche;
begin
  inc(nbNoeud);
  max:=-32000;
  courant:=papa^.fils;
  repeat
    inc(NbBranche);
    if (prof=1) then resultat:=-evalue(courant^.position)
    else begin
      jeuEnCour[courant^.position]:=vide; {joue la case}
      provScore:=-provScore-valeur[courant^.pion];
      if (courant^.fils=nil) then
        resultat:=-zeroWindow(-succ(alpha),prof-1,courant^.position)
      else
        resultat:=-ZWarbre(-succ(alpha),prof-1,courant^.position,courant);
      jeuEnCour[courant^.position]:=courant^.pion; {remet en place}
      provScore:=-provScore-valeur[courant^.pion];
    end;
    courant^.result:=resultat;
    if resultat>max then max:=resultat;
    courant:=courant^.frere;
  until (courant=nil) or (resultat>alpha);
  ZWArbre:=max;
end;

{------------------------------PVS sur ARBRE-------------------------------}

function PVSArbre(alpha,beta:integer; prof,cur:byte;
                  var best:byte; var papa:pBranche)   :integer;
{PVS avec rcupration des coups de l'arbre, sans reclassement}
var max,resultat:integer; meilleur:byte;
    courant:pBranche;

begin
  inc(nbNoeud);
  max:=-32000;
  courant:=papa^.fils;
  repeat
    inc(NbBranche);
    if (prof=1) then resultat:=-evalue(courant^.position)
    else begin
      jeuEnCour[courant^.position]:=vide; {joue la case}
      provScore:=-provScore-valeur[courant^.pion];
      if (courant=papa^.fils) then begin
        if (courant^.fils=nil) then
          resultat:=-AlphaBeta(-beta,-alpha,prof-1,courant^.position,meilleur)
        else
          resultat:=-PVSArbre(-beta,-alpha,prof-1,courant^.position,meilleur,courant);
      end else begin {coups suivants}
        if (courant^.fils=nil) then
          resultat:=-zeroWindow(-succ(alpha),prof-1,courant^.position)
        else
          resultat:=-ZWarbre(-succ(alpha),prof-1,courant^.position,courant);
        if (resultat>alpha) and (resultat<beta) then begin
          inc(NbBranche);
          if (courant^.fils=nil) then
            resultat:=-AlphaBeta(-beta,-resultat,prof-1,courant^.position,meilleur)
          else
            resultat:=-PVSArbre(-beta,-resultat,prof-1,courant^.position,meilleur,courant);
        end;
      end;
      jeuEnCour[courant^.position]:=courant^.pion; {remet en place}
      provScore:=-provScore-valeur[courant^.pion];
    end;
    courant^.result:=resultat;
    if resultat>max then begin
        max:=resultat; best:=courant^.position;
    end;
    if resultat>alpha then alpha:=resultat;
    courant:=courant^.frere;
  until (courant=nil) or (alpha>=beta);
  PVSArbre:=max;
end;

{-------------------------PVS avec RECLASSEMENT----------------------------}

function PVSreclasse(prof,cur:byte; var best:byte):integer;
var p:pointer; resultat:integer;   profcur:byte;
const seuil=100;
begin
  profStocke:=2;  {dfinit la profondeur de stockage,
                    savoir 2 de moins que ABStocke}
  mark(p);
  new(tete);    {nouvelle tte de l'arbre}
  with tete^ do begin
      position:=0; pion:=0; result:=-32000; frere:=nil; fils:=nil;
  end;
  resultat:=ABStocke(-32000,32000,6,curseur,best,tete);
  {calcul  profondeur plus faible avec stockage arbre}
  if (tete^.fils<>nil) then begin
      resultat:=PVSArbre(-32000,32000,prof,curseur,best,tete);
  end;
  PVSreclasse:=resultat;
  release(p);
end;

{---------------------------------COUPORDI---------------------------------}

procedure coupOrdi(var x,y:byte; prof:byte);
var posit:byte;
begin
  nbNoeud:=0; nbBranche:=0; nbFeuille:=0;
  provScore:=score[joueur]-score[oppose[joueur]];
  if (prof<8) and (methode[joueur]='I') then methode[joueur]:='A';
  {mthode  reclassement inutile pour faible profondeur}
  case methode[joueur] of
    'M':resultatEval:=minimax(prof,curseur,posit);
    'A':resultatEval:=AlphaBeta(-32000,32000,prof,curseur,posit);
    'S':resultatEval:=Scout(prof,curseur,posit);
    'P':resultatEval:=PVSearch(-32000,32000,prof,curseur,posit);
    'I':resultatEval:=PVSreclasse(prof,curseur,posit);
  end;
  inc(score[joueur],valeur[jeuEnCour[posit]]);
  jeuEnCour[posit]:=vide;
  joueur:=oppose[joueur];
  curseur:=posit;
  x:=(curseur-1) div 10; y:=(curseur-1) mod 10;
  xCurs:=x; yCurs:=y;
  inc(nbCoups); suiteJouee[nbCoups]:=posit;
end;

begin randomize; end.