program CresusDos;
(*
    mini interface utilisateur sous DOS pour Crsus...
    Sans aucune prtention, si ce n'est d'tudier les algorithmes
    de recherche de coup optimal dans un arbre de jeu (unite jeu.pas)

            (C) Luc Rivire  Mars 1995, pour le Reporter 6
*)
uses crt,dos,jeu;
type str3=string[3];
const Xinit=-2 {+6}; Yinit=0 {+2};
      data:array[0..8] of str3=
        ('10c','20c','50c','1 F','2 F','5 F','10F','20F','   ');

var niveau:array[0..1] of byte;

procedure cursOn;
var reg:registers;
begin
  with reg do begin ah:=1; ch:=6; cl:=7; end;
  intr($10,reg);
end;

procedure cursOff;
var reg:registers;
begin
  with reg do begin ah:=1; ch:=32; cl:=32; end;
  intr($10,reg);
end;


procedure affichePion(num:byte);
var x,y,typ:byte;
begin
  x:=(num-1) div 10; y:=(num-1) mod 10;
  typ:=jeuEnCour[num];
  if typ<bord then begin
    textcolor(white);
    gotoxy(Xinit+6*x,Yinit+2*y);
    write('');
    gotoxy(Xinit+6*x,Yinit+2*y+1);
    write(' ');
    if typ<3 then textColor(lightgreen)
    else if typ<6 then textcolor(lightred)
    else textColor(yellow);
    write(data[typ]);
    textcolor(white);
    write(' ');
    gotoxy(Xinit+6*x,Yinit+2*y+2);
    write('');
  end;
end;

procedure afficheCurseur(x,y:byte);
var typ:integer;
begin
  gotoxy(Xinit+6*x+2,Yinit+2*y+1);
  textBackground(cyan);
  typ:=jeuEnCour[10*x+y+1];
  if typ<3 then textColor(lightgreen+blink)
  else if typ<6 then textcolor(lightred+blink)
  else if typ< vide then textColor(yellow+blink)
  else textColor(blue+blink);
  if typ<vide then write(data[typ]) else write('');
  textColor(white);
end;

procedure afficheJeu;
var i:byte;
begin
  textBackGround(blue);
  for i:=premier to dernier do affichePion(i);
  textColor(lightGray);
end;

procedure afficheEcran;
var i:integer;
begin
  cursOff;
  textColor(white);
  textBackground(black);
  clrScr;
  gotoxy(Xinit+9,Yinit+1);
  writeln('A     B     C     D     E     F     G     H     I');
  for i:=1 to 9 do begin
    gotoxy(xinit+3,yinit+2*i+1);
    write(i:2);
  end;
  textBackground(lightGray);
  textcolor(blue);
  gotoxy(3,24);  write(' (S)auve ');
  gotoxy(15,24); write(' (C)harge ');
  gotoxy(28,24); write(' (R)etour ');
  gotoxy(41,24); write(' (N)ouveau ');
  gotoxy(55,24); write(' (O)ptions ');
  gotoxy(69,24); write(' (F)in ');
end;

procedure deplace(c:char;var x,y:byte);
var nx,ny:integer;
begin
  nx:=x; ny:=y;
  case c of
     '1':if (x>=xCurs) and (y<=yCurs) then begin dec(nx); inc(ny); end;
     '2':if (y<=yCurs) then inc(ny);
     '3':if (x<=xCurs) and (y<=yCurs) then begin inc(nx); inc(ny); end;
     '4':if (x>=xCurs) then dec(nx);
     '6':if (x<=xCurs) then inc(nx);
     '7':if (x>=xCurs) and (y>=yCurs) then begin dec(nx); dec(ny); end;
     '8':if (y>=yCurs) then dec(ny);
     '9':if (x<=xCurs) and (y>=yCurs) then begin inc(nx); dec(ny); end;
  end;
  if (nx>0) and (nx<10) and (ny>0) and (ny<10) then begin
    x:=nx; y:=ny;
  end;
end;

procedure affichejoueur(i:byte);
var sc:real;
begin
  textBackGround(black);
  gotoxy(61+10*i,2);
  if joueur=i then textColor(green) else textcolor(white);
  if estOrdi[i] then write(' ORDI ') else write('JOUEUR');
  textcolor(yellow);
  gotoxy(60+10*i,4);
  sc:=score[i]/10;
  write(sc:6:1);
  textcolor(white);
  gotoxy(60+10*i,6);
  if not(estOrdi[i]) then write('         ') else
  case methode[i] of
      'M': write('Minimax  ');
      'A': write('AlphaBeta');
      'S': write('Scout    ');
      'P': write('PVSearch ');
      'I': write('IterPVS  ');
  end;
  gotoxy(60+10*i,7);
  if not(estOrdi[i]) then write('        ') else  if (joueur<>i) then
    write('Prof:',niveau[i],' ');
  gotoxy(62+10*i,9);
  if not(estOrdi[i]) then write('        ') else  if (joueur<>i) then
    write('Eval');
  gotoxy(60+10*i,10);
  if not(estOrdi[i]) then write('        ') else  if (joueur<>i) then
    if resultatEval>=16500 then write('  Vict')
    else if resultatEval<=-16500 then write('  Df.')
    else begin sc:=resultatEval/10; write(sc:6:1); end;
  gotoxy(62+10*i,12);
  if not(estOrdi[i]) then write('        ') else  if (joueur<>i) then
    write('Noeuds');
  gotoxy(61+10*i,13);
  if not(estOrdi[i]) then write('        ') else  if (joueur<>i) then
    write(NbNoeud:6,'   ');
  gotoxy(61+10*i,15);
  if not(estOrdi[i]) then write('        ') else  if (joueur<>i) then
    write('Branches');
  gotoxy(61+10*i,16);
  if not(estOrdi[i]) then write('        ') else  if (joueur<>i) then
    write(nbBranche:6,'   ');
  gotoxy(61+10*i,18);
  if not(estOrdi[i]) then write('        ') else  if (joueur<>i) then
    write('Feuilles');
  gotoxy(61+10*i,19);
  if not(estOrdi[i]) then write('        ') else  if (joueur<>i) then
    write(NbFeuille:6,'   ');
end;

procedure afficheScore;
begin
  afficheJoueur(0); afficheJoueur(1);
end;

procedure nouveauJeu(var x,y:byte);
begin
  initJeu;
  x:=xCurs; y:=yCurs;
end;

procedure optionPour(j:byte);
var c:char;
begin
  repeat
    gotoxy(10,22);
    write('Joueur ',j+1,': (H)umain ou (O)rdinateur ?');
    c:=upcase(readkey);
  until c in ['H','O'];
  if c='H' then estOrdi[j]:=false else begin
    estOrdi[j]:=true;
    repeat
      gotoxy(10,22);
      write('(M)inimax  (A)lphaBeta  (S)cout  (P)VSearch  (I)terPVS');
      c:=upcase(readkey);
    until c in ['A','M','S','P','I'];
    methode[j]:=c;
    gotoxy(10,22);
    write('                                                        ');
    gotoxy(10,22);
    write('Profondeur: '); readln(niveau[j]);
  end;
  gotoxy(10,22);
  write('                                                        ');
end;

procedure options;
begin
  {pour chacun des joueurs}
  optionPour(0);
  optionPour(1);
end;

procedure sauve;
var fichier:string;
begin
  gotoxy(10,22);
  write('Nom du fichier (8 caractres sans extension) : ');
  readln(fichier);
  sauvegarde(fichier);
  gotoxy(10,22);
  write('                                                        ');
end;

procedure charge(var x,y:byte);
var fichier:string;
begin
  gotoxy(10,22);
  write('Nom du fichier (8 caractres sans extension) : ');
  readln(fichier);
  recupere(fichier,x,y);
  gotoxy(10,22);
  write('                                                        ');
end;

procedure afficheGagnant(var c:char);
begin
  gotoxy(10,22);
  if (estOrdi[0] or estOrdi[1]) then  begin
   if (estOrdi[0] and (score[0]>score[1])) or
      (estOrdi[1] and (score[1]>score[0]))
   then write('J''ai gagn...  < Appuyez sur une touche... >')
   else write('J''ai perdu...  < Appuyez sur une touche... >')
  end else write('Le jeu est fini !    < Appuyez sur une touche... >');
  c:=upcase(readkey);
  gotoxy(10,22);
  write('                                                  ');
end;

procedure principale;
var c:char;  x,y:byte;
begin
  afficheEcran;
  nouveauJeu(x,y);
  repeat
    afficheJeu;
    afficheCurseur(x,y);
    afficheScore;
    if fini then begin afficheGagnant(c); nouveauJeu(x,y);
    end else begin
      if estOrdi[joueur] then begin
        coupOrdi(x,y,niveau[joueur]);
      end else begin  {joueur humain}
        c:=upcase(readKey);
        if c=#0 then c:=upcase(readKey);
        case c of  {cas des fleches du clavier tendu}
         'H':c:='8'; 'P':c:='2'; 'K':c:='4'; 'M':c:='6';
        end;
        if c in['1','2','3','4','6','7','8','9'] then deplace(c,x,y);
        if c=#13 {RC} then choisisCase(x,y);
        if c='R' then begin
          retour(x,y);
          if (estOrdi[joueur]) then retour(x,y);
        end;
        if c='O' then options;
        if c='S' then sauve;
        if c='C' then charge(x,y);
      end;
    end;
    if c='N' then begin nouveauJeu(x,y); c:=' '; end;
  until c ='F';
  cursOn;
end;

begin
  estOrdi[0]:=false; methode[0]:='A';
  estOrdi[1]:=true; methode[1]:='I';
  niveau[0]:=10;
  niveau[1]:=10;
  principale;
end.