;
;	FONCTION DE LA LIBRAIRIE REPLIB :
;
;	VGA_Reso
;
;	Regle le CRTC pour obtenir la resolution souhaitee
;	Cf. VGA IV dans Rep4 pour le sens de ces divers paramettres
;
;	IN : Les donnees publiques

.386P
locals

b	equ <byte ptr>
w	equ <word ptr>
d	equ <dword ptr>
o	equ <offset>
setalc	equ <db 0d6h>
	
code	segment public use16

	assume cs:code

	include extrns.asi

public VGA_Reso

VGA_Reso:	
	mov dx,3c2h	; Misc. OutPut.
	mov al,0	; Reglage du mode 16 ou 256 couleur.
	bt w VideoFlag,1
	adc al,0
	shl al,2
	mov ah,VideoFlag	; Reglage de la frequence de point.
	and ah,11000000b
	or al,ah
	or al,11b	; Autorise l'acces CPU a la VRAM
	out dx,al	; et met les adr port a D.
	
	mov dl,0d4h	; CRTC.
	
	mov ax,0011h	; Deprotege les 1ers reg du crtc.
	out dx,ax
	
	; Horizontalement
	
	mov ah,HTotal	; Horizontal-Total.
	sub ah,5
	mov al,0
	out dx,ax
	
	add ah,4	; Fin du Blanking.
	sub ah,HBorder
	mov cl,ah	; (preserve le bit 6 dans cl)
	shl cl,2
	and cl,80h
	and ah,11111b
	or ah,80h
	mov al,3
	out dx,ax
	
	mov ah,HDisplay	; Nbr de caracteres affiches.
	dec ah
	mov al,1
	out dx,ax
	
	add ah,HBorder		; Debut du Blanking.
	mov al,2
	out dx,ax
	
	mov ah,HSPS	; Debut de Retour horizontal.
	mov al,4
	out dx,ax
	
	mov ah,HSPE	; Fin de retours et bit 6 de la Fin du Blanking.
	and ah,11111b
	or ah,cl
	mov al,5
	out dx,ax
	
	; Vertical
	
	sub VTotal,2
	mov ah,b VTotal	; Vertical-Total, 8 1ers bits...
	mov al,6
	out dx,ax
	
	mov al,b VTotal+1	; ...9eme et 10eme bits.
	and al,1
	or @@Overflow,al
	mov al,b VTotal+1
	and al,10b
	shl al,4
	or @@Overflow,al
	add VTotal,2
	
	dec VDisplay	; Nbr de lignes affiches, 8 1ers bits...
	mov ah,b VDisplay
	mov al,12h
	out dx,ax
	
	mov al,b VDisplay+1	; ...9eme et 10eme bits.
	and al,1
	shl al,1
	or @@Overflow,al
	mov al,b VDisplay+1
	and al,10b
	shl al,5
	or @@Overflow,al
	inc VDisplay
	
	mov ah,b VSPS	; Debut de Retour, 8 1ers bits...
	mov al,10h
	out dx,ax
	
	mov al,b VSPS+1	; ... 9eme et 10eme bits.
	and al,1
	shl al,2
	or @@Overflow,al
	mov al,b VSPS+1
	and al,10b
	shl al,6
	or @@Overflow,al
	
	mov bx,VDisplay	; Debut de Blanking, 8 1ers bits...
	add bx,VBorder
	inc bx
	mov ah,bl
	mov al,15h
	out dx,ax
	
	mov al,bh	; ... Debut de blanking, 9eme bit...
	and al,1
	shl al,3
	or @@Overflow,al
	
	mov ah,bh	; ... Debut de blanking, 10eme bit.
	and ah,10b
	shl ah,4
	mov al,9
	out dx,ax
	
	mov ax,VTotal	; Fin de Blanking.
	sub ax,VBorder
	mov ah,al
	mov al,16h
	out dx,ax
	
	jmp $+2	; Vide le prefetch car on a modifie @@Overflow.
	
@@Overflow	= this byte +1	
	mov ah,0	; Charge l'overflow.
	mov al,7
	out dx,ax
	
	mov ah,b VSPE	; Fin de Retour.
	and ah,1111b
	or ah,10000000b	; (au passage : on reprotege les registres)
	mov al,11h
	out dx,ax
	
	mov dl,0c4h	; Sequenceur.
	mov ax,101h	; 8 pts par caracteres
	out dx,ax	; et pas de division de frequence.
	xor ax,ax	; Reset.
	out dx,ax
	mov ah,11b
	out dx,ax
	
	retn
	
code	ends
end
