;
;	FONCTION DE LA LIBRAIRIE REPLIB :
;
;	Init_Flat
;
;	Regle la taille des registres de segment sur 4Go
;

.386P
locals

b	equ <byte ptr>
w	equ <word ptr>
d	equ <dword ptr>
o	equ <offset>
setalc	equ <db 0d6h>


code	segment public use16

	include extrns.asi	; declaration des symboles externes

	assume cs:code

	public Init_Flat

Init_Flat:
	pushf	; Sauvegarde les flags.
	cli	; Stoppe les interruptions externes (sauf NMIs).
	push ds es gs fs	; Sauvegarde les registres de segment saus FS.
	
	mov eax,cs	; Calcule l'adresse physique de la GDT :
	shl eax,4	; (CS SHL 4) + Offset @@GDT
	mov ebx,offset @@gdt
	add eax,ebx
	mov @@gdt_adr,eax
	mov bx,offset @@gdt_ptr	; Charge l'adresse et la taille de
	lgdt fword ptr [bx]	; la GDT dans GDTR.
	
	mov eax,cr0	; Passe en mode protege en mettant a 1 le bit 0
	or al,1	; de CR0
	mov cr0,eax
	
	jmp short $+2	; JMP pour effectuer le changement de fonction
		; des registres de segment (???)
	mov bx,8	; 8=100b : Le descripteur No1 dans la GDT.
	mov ds,bx	; Charge les registres de segment avec ce
	mov es,bx	; descripteur.
	mov fs,bx
	mov gs,bx
	
	and al,0FEh	; Revient en mode reel en remettant le bit 0
	mov cr0,eax	; de CR0 a 0.
	
	pop fs gs es ds	; Recupere les bases des registres de segment.
	
	popf	; Recupere les flags.
	retn	; Et retours a l'envoyeur.
	

;	Donnees locales

@@gdt	LABEL WORD	; Deux selecteurs :
	DW 0,0,0,0	; Le selecteur zro
	DW 0FFFFh,0,9200h,8Fh	; et un selecteur de limite 4 Go

@@gdt_ptr	dw 16	; Taille de la GDT
@@gdt_adr	dd ?	; Adresse physique de la GDT

code	ends

end
