;
;	FONCTION DE LA LIBRAIRIE REPLIB :
;
;	VGA_256Point
;
;	Met le point de coordonnees (X,Y) a la couleur c
;	(Les coordonnees sont comptees a partir de ADR0)
;
;	IN : ADR0 est une variable publique et peut etre modifiee
;	     n'importe quand.
;	     FS = 0 / Taille = 4 Go
;	     ES -> Video
;	     BX = X>0 / EBP = Y>0 / VGA256_Point_Coul est un octet publique
;
;	OUT : Le controleur graphique et le MapMask sont reprogrammes
;


.386P
locals

b	equ <byte ptr>
w	equ <word ptr>
d	equ <dword ptr>
o	equ <offset>
setalc	equ <db 0d6h>


code	segment public use16

	include extrns.asi	; declaration des symboles externes

	assume cs:code

public VGA256_Point
public VGA256_Point_Coul	; Ne peut pas etre utiliser dans d'autres
		; routines a moins d'etre rajoute en extrns:Byte

VGA256_Point:

	; On commence par regler le controleur graphique
	
	mov dx,003CEh	; Controleur graphique !  T'es la ?
	
	mov ax,00003h	; Je t'interdit de jouer avec mes bits !
	out dx,ax	; Ni rotation, ni operation logique...
	
	mov ax,04005h	; Mode d'ecriture No 0
	out dx,ax
	
	mov cl,bl	; cl <- X MOD 8
	and cl,11b
	mov ax,00102h	; ah <- 01h
	shl ah,cl	; ah <- 01h SHL (X MOD 4)
	mov dl,0C4h
	out dx,ax	; A bon banania pour MapMask !
	
	mov edi,Adr32OfsTbl	; fs:edi -> la table d'adresse
	mov di,fs:[edi+ebp*2]	; di <- l'adresse du debut de ligne
	shr bx,2
	add di,bx	; di <- l'adresse du point, ouf !
	add di,ADR0
	
VGA256_Point_Coul = this byte +3
	mov b es:[di],12h	; Envoyez la couleur !
	
	retn

code	ends

end