;
;	FONCTION DE LA LIBRAIRIE REPLIB :
;
;	VGA16_Point
;
;	Met le point de coordonnees (X,Y) a la couleur c
;	(Les coordonnees sont comptees a partir de ADR0)
;
;	IN : ADR0 est une variable publique et peut etre modifiee
;	     n'importe quand.
;	     FS = 0 / Taille = 4 Go
;	     ES -> Video
;	     BX = X>0 / EBP = Y>0 / VGA16_Point_Coul est un octet publique
;
;	OUT : Le controleur graphique est reprogramme
;
;	Note : On ne touche pas au MapMask

.386P
locals

b	equ <byte ptr>
w	equ <word ptr>
d	equ <dword ptr>
o	equ <offset>
setalc	equ <db 0d6h>
	
code	segment public use16
	
	assume cs:code
	
	include extrns.asi
	
public VGA16_Point

public VGA16_Point_Coul	; Ne peut pas etre utiliser dans d'autres
		; routines a moins d'etre rajoute en extrns:Byte

VGA16_Point:	
	; On commence par regler le controleur graphique
	
	mov dx,003CEh	; Controleur graphique !  T'es la ?
	
	mov ax,00003h	; Je t'interdit de jouer avec mes bits !
	out dx,ax	; Ni rotation, ni operation logique...
	
	mov ax,00205h	; Mode d'ecriture No 2
	out dx,ax
	
	mov cl,bl	; cl <- X MOD 8
	and cl,111b
	mov ax,08008h	; ah <- 80h
	shr ah,cl	; al <- 80h SHR (X MOD 8)
	out dx,ax	; A bon banania pour BitMask !
	
	mov edi,Adr32OfsTbl	; fs:edi -> la table d'adresse
	mov di,fs:[edi+ebp*2]	; di <- l'adresse du debut de ligne
	shr bx,3
	add di,bx	; di <- l'adresse du point, ouf !
	add di,ADR0
	
	mov al,es:[di]	; Latches : Chaaaaaargez !
VGA16_Point_Coul = this byte +3
	mov b es:[di],12h	; Envoyez la couleur !
	
	retn
	
code	ends
end