***********************************************
*           Filtre d'import GEDCOM
***********************************************
*
*              Programme GEDIMP
*
*                    V1.0
*
* Importation d'un fichier GEDCOM dans la base INDI/FAM
*     (En Foxpro Win, langage "compatible dBase")
*
*      (c) Franois CLAUSTRES 1994/1995
*
*               *** FREEWARE ***
*
***********************************************
*
*               CHAMPS IMPORTES
*
* 1) HEADer
* ---------
* - CHAR (tables: ANSI, IBMPC; ASCII trait comme IBMPC)
*
* 2) SUBMiter
* -----------
* Aucun champ!
*
* 3) INDIvidus:
* -------------
* - Index GEDCOM
* - NAME (y compris les alias, mais sans DATE)
* - SEX (masculin par dfaut)
* - BIRT (avec DATE et PLAC)
* - DEAT (avec DATE et PLAC)
* - BURI (avec DATE et PLAC)
* - OCCU (sur une ligne)
* - NOTE (avec suite en utilisant CONT ou NOTE; champ de type "Mmo")
*  
* - Index FAMS et FAMC (en mode "IndiFam=.T." uniquement)
* - REFN supprim
*
* 4) FAMilles:
* ------------
* - Index GEDCOM
* - Index HUSB
* - Index WIFE
* - Index CHIL (et conservation de l'ordre en mode "IndiFam=.F.")
* - MARR (avec DATE et PLAC)
* - DIV (DIV Y pour divorc; dfaut DIV N)
* - NOTE (avec suite en utilisant CONT ou NOTE; champ de type "Mmo")
*
* - REFN supprim
*********************************************** 
CLEAR
***********************************************
* 1) Ouverture des bases
***********************************************
CLOSE ALL
SELECT 1
USE INDI
SELECT 2
USE FAM
* RAZ des bases!
SELECT INDI
DELETE ALL
PACK
SELECT FAM
DELETE ALL
PACK
***********************************************
* Gestion du mode Familles dcrite dans INDI
*               (FAMS /FAMC)
***********************************************
*
* IndiFam=.F.: gedimp utilise UNIQUEMENT les
*              donnes FAM pour crer les liens
*              familiaux; cela doit suffire
*              dans 99,99% des cas!
*              Mthode qui plus est (relativement)
*              plus rapide...
*
* IndiFam=.T.: gedimp utilise aussi bien les
*              donnes FAMS et FAMC de chaque
*              INDIvidu, que celles de FAM pour
*              crer les liens familiaux. Utile
*              dans 0,01% des cas... Quand le
*              fichier GEDCOM est abim, par
*              exemple!
*              ATTENTION: dans ce cas, l'ordre
*              des naissances n'est pas gr!!!
*              CETTE OPTION EST DONC A EVITER,
*              SAUF EN CAS DE PERTES DE DONNEES
*              SUR LES LIENS FAMILIAUX!
***********************************************
IndiFam=.F.
***********************************************
* Ouverture du fichier GEDCOM
***********************************************
*ACCEPT 'Nom du fichier gedcom (sans .GED) -->' TO NomFic
NomFic=GETFILE('GED','Choix du fichier GEDCOM','OK')
?
NomFic=ALLTRIM(NomFic)
*IF LEN(NomFic)>8
*  ? '*** Nom de fichier trop long!'
*  CLOSE ALL
*  RETURN
*ENDIF
*NomFic=NomFic+'.GED'
NumFic=FOPEN(NomFic)
IF NumFic=-1 OR EOF(NumFic)
  ? '*** Echec ouverture fichier GEDCOM!'
  CLOSE ALL
  RETURN
ENDIF
***********************************************
* Est-ce un fichier GEDCOM?
***********************************************
*Ligne=FGET(NumFic)
Police='INCONNUE'
LireLigne=.T.
Ligne='RIEN'
DO LireFic
IF LEN(Ligne)<6
  ? '*** Pas un fichier GEDCOM!'
  RETURN
ENDIF
IF LEFT(Ligne,6)<>"0 HEAD"
  ? '*** Pas un en-tte GEDCOM!'
  RETURN
ENDIF
***********************************************
* Lecture du "HEADER"
***********************************************
* Ligne suivante
Ligne="1"
* Lecture des champs du HEADER
DO WHILE (NOT EOF(NumFic)) AND (LEFT(Ligne,1)<>"0")
  DO LireFic
  IF LEN(Ligne)>7
    Champ=UPPER(TRIM(SUBSTR(Ligne,3,4)))
    * Action!
    DO CASE
      CASE Champ='CHAR'
      Police=UPPER(ALLTRIM(SUBSTR(ligne,8)))
      ? 'Police '+Police
      
    OTHERWISE
      DO SuppNiv2
    ENDCASE
  ENDIF
ENDDO
***********************************************
* Recherche des INDIvidus ou des FAMilles
* Pour cela, il faut scanner les lignes commenant par "0"
***********************************************
DO WHILE (NOT EOF(NumFic)) AND (Ligne<>"0 TRLR")
  *IF LireLigne
  *  Ligne=TRIM(FGET(NumFic))
  *ELSE
  *  LireLigne=.T.
  *ENDIF
  DO LireFic
  IF (LEFT(Ligne,1)="0") AND (LEN(Ligne)>6)
    * Est-ce un INDI/FAM ou autre?
    DO CASE
      * Dfinition d'un individu!
      CASE RIGHT(Ligne,4)="INDI"
      DO ExtraitIndi
      
      * Dfinition d'une famille!
      CASE RIGHT(Ligne,3)="FAM"
      DO ExtraitFam
      
    OTHERWISE
      * Autres cas: on autorise la lecture de la ligne suivante
      LireLigne=.T.
    ENDCASE
  * Fin de la boucle: une entre de type "0"!
  ENDIF
* Fin de la boucle principale INDI/FAM
ENDDO
***********************************************
* The End!
***********************************************
CLOSE ALL
?'*** GEDIMP termin avec succs!'
RETURN
***********************************************
* Extraction d'un individu
***********************************************
PROCEDURE ExtraitIndi
  * 1) Extraction de l'index de l'individu
  * L'index se situe OBLIGATOIREMENT entre deux "@"
  IF OCCURS('@',Ligne)<>2
    ? '*** Erreur! Index introuvable!'
    RETURN
  ENDIF
  * Recherche la position des "@", puis extraction de l'index
  Debut=AT('@',Ligne,1)
  Fin=AT('@',Ligne,2)
  IF (Debut+1)=Fin
    ? '*** Erreur! Index non valide!'
    RETURN
  ENDIF
  VIndi=SUBSTR(Ligne,Debut+1,Fin-Debut-1)
  
  * 2) RAZ des champs, avant compltion
  VName="<INCONNU>"
  VName_Alias=""
  VSex=.T.
  VBirt_Date=""
  VBirt_Plac=""
  VDeat_Date=""
  VDeat_Plac=""
  VBuri_Date=""
  VBuri_Plac=""
  VOccu=""
  VNote=""
  
  VFam=""
  VFamc=""
  VFams=""

    
  * 3) Remplissage des champs disponibles...
  DO WHILE (NOT EOF(NumFic))
    * Lecture de la ligne...
    DO LireFic

    * Est-ce une ligne valide?
    IF LEN(Ligne)>5
      Cmd=LEFT(Ligne,1)
      * De quel type de ligne s'agit-il?
      DO CASE
        * Un nouvel enregistrement: on sort!
        CASE Cmd="0"
          Exit
        * Un nouveau champ!
        CASE Cmd="1"
          Champ=UPPER(TRIM(SUBSTR(Ligne,3,4)))

          * Aiguillage Champs de niveau "1"
          DO CASE
            * No de rfrence
            CASE Champ="REFN"
              * Pas utiliss!
              DO SuppNiv2
          
            * Nom & surnom
            CASE Champ="NAME"
              *     Le champ NAME permet de rajouter des alias!
              *
              * MAIS: Seul le DERNIER des noms dclar sera le PRINCIPAL!
              *
              * ATTN: de plus, on peut mettre un champ de niveau "2 DATE" pour
              *       prciser le changement de nom!
              *
              * Un nom existe dj? On le met en ALIAS!
              IF VName<>"<INCONNU>"
                IF EMPTY(VName_Alias)
                  VName_Alias=VName
                ELSE
                  * Cas de plusieurs ALIAS: on les sparera par ';'
                  VName_Alias=VName_Alias+' ; '+VName
                ENDIF
              ENDIF
              * Extraction du Nom suivant, qui est mis d'office en principal!
              VName=ALLTRIM(SUBSTR(ligne,8))
              * Et on fait le mnage! (pour viter qu'une DATE baladeuse
              *  nous fiche le boxon!
              DO SuppNiv2

            * Sexe
            CASE Champ="SEX"
              IF UPPER(RIGHT(Ligne,1))="F"
                VSex=.F.
              ENDIF
              DO SuppNiv2
              
            * La Naissance
            CASE Champ="BIRT"
              Ligne="2"
              * Est-ce une ligne de niveau "2"?
              DO WHILE LEFT(Ligne,1)="2"
                * On lit la ligne suivante
                DO LireFic
                * Extraction du champ de niveau "2"
                Champ=UPPER(TRIM(SUBSTR(Ligne,3,4)))
                * Ce peut tre soit DATE, soit PLAC!
                DO CASE
                  CASE Champ="DATE" AND LEN(Ligne)>6
                    VBirt_Date=UPPER(ALLTRIM(SUBSTR(ligne,8)))

                  CASE Champ="PLAC" AND LEN(Ligne)>6
                    VBirt_Plac=SUBSTR(ligne,8)
                    
                OTHERWISE
                IF LEFT(LIGNE,1)='2'
                  ? '*** Erreur individu '+Vindi+': Champ '+Champ+' inconnu dans BIRT'
                  ? Ligne
                ENDIF
                ENDCASE
              ENDDO
              LireLigne=.F.
              *DO SuppNiv2
              
            * Le Dcs...
            CASE Champ="DEAT"
              Ligne="2"
              * Est-ce une ligne de niveau "2"?
              DO WHILE LEFT(Ligne,1)="2"
                * On lit la ligne suivante
                DO lireFic
                * Extraction du champ de niveau "2"
                Champ=UPPER(TRIM(SUBSTR(Ligne,3,4)))
                * Ce peut tre soit DATE, soit PLAC!
                DO CASE
                  CASE Champ="DATE" AND LEN(Ligne)>6
                    VDeat_Date=UPPER(ALLTRIM(SUBSTR(ligne,8)))

                  CASE Champ="PLAC" AND LEN(Ligne)>6
                    VDeat_Plac=SUBSTR(ligne,8)
                    
                OTHERWISE
                IF LEFT(Ligne,1)='2'
                  ? '*** Erreur individu '+Vindi+': Champ '+Champ+' inconnu dans DEAT'
                  ? Ligne
                ENDIF
                ENDCASE
              ENDDO
              *DO SuppNiv2
              LireLigne=.F.
            
            * L'enterrement...
            CASE Champ="BURI"
              Ligne="2"
              * Est-ce une ligne de niveau "2"?
              DO WHILE LEFT(Ligne,1)="2"
                * On lit la ligne suivante
                DO LireFic
                * Extraction du champ de niveau "2"
                Champ=UPPER(TRIM(SUBSTR(Ligne,3,4)))
                * Ce peut tre soit DATE, soit PLAC!
                DO CASE
                  CASE Champ="DATE" AND LEN(Ligne)>6
                    VBuri_Date=UPPER(ALLTRIM(SUBSTR(ligne,8)))

                  CASE Champ="PLAC" AND LEN(Ligne)>6
                    VBuri_Plac=SUBSTR(ligne,8)

                OTHERWISE
                IF LEFT(Ligne,1)='2'
                  ? '*** Erreur individu '+Vindi+': Champ '+Champ+' inconnu dans BURI'
                  ? Ligne
                ENDIF
                ENDCASE
              ENDDO
              *DO SuppNiv2
              LireLigne=.F.
             
            * Famille d'o est n l'individu
            CASE Champ="FAMC"
              IF IndiFam
                * Extraction de la Famille
                VFam=ALLTRIM(SUBSTR(ligne,8))
                VFam=SUBSTR(VFam,2,LEN(VFam)-2)
                * La Famille dont l'individu est l'enfant existe-t-elle?
                SELECT FAM
                GO TOP
                LOCATE FOR VFam==ALLTRIM(Fam.Fam)
                IF NOT EOF('FAM')
                  * Elle existe: l'enfant est-il dj dclar?
                  IF NOT((VIndi+'I') $ Fam.Chil) AND NOT((Vindi+'@') $ Fam.Chil)
                    * L'enfant n'est pas dclar: on l'ajoute!
                    IF EMPTY(Fam.Chil)
                      * Pas d'enfants dclars auparavant...
                      REPLACE Fam.Chil WITH VIndi+'@'
                    ELSE
                      * Des enfants dj dclars...
                      VTemp=ALLTRIM(Fam.Chil)
                      VTemp=LEFT(VTemp,LEN(VTemp)-1)+VIndi+'@'
                      REPLACE Fam.Chil WITH VTemp
                    ENDIF
                  ENDIF
                ELSE
                  * Elle n'existe pas: on la cre, et on y met l'enfant!
                  INSERT INTO FAM (Fam,Chil) VALUES (VFam,VIndi+'@')
                ENDIF
                * Retour  INDI!
                SELECT INDI
                
                DO SuppNiv2
              ENDIF
            
            * Familles dont l'individu est le conjoint
            CASE Champ="FAMS"
              IF IndiFam
                * Extraction de la Famille
                VFam=ALLTRIM(SUBSTR(ligne,8))
                VFam=SUBSTR(VFam,2,LEN(VFam)-2)
                * La Famille dont l'individu est le conjoint existe-t-elle?
                SELECT FAM
                GO TOP
                LOCATE FOR VFam==ALLTRIM(Fam.Fam)
                IF NOT EOF('FAM')
                  * Elle existe: l'individu est-il dj dclar?
                  DO CASE
                  
                    * Cas d'un Mari
                    CASE VSex=.T.
                      IF EMPTY(ALLTRIM(Fam.Husb))
                        * Mari  dclarer!
                        REPLACE Fam.Husb WITH VIndi
                      ENDIF
                    
                    * Cas d'une Femme
                    CASE VSex=.F.
                      IF EMPTY(ALLTRIM(Fam.Wife))
                        * Epouse  dclarer!
                        REPLACE Fam.Wife WITH VIndi
                      ENDIF
                   
                  ENDCASE
                  
                ELSE
                  * Elle n'existe pas: on la cre, et on y met le conjoint
                  DO CASE
                    * Mari...
                    CASE VSex=.T.
                      INSERT INTO FAM (Fam,Husb) VALUES (VFam,VIndi)
                    * Epouse...
                    CASE VSex=.F.
                      INSERT INTO FAM (Fam,Wife) VALUES (VFam,VIndi)
                  ENDCASE
                ENDIF
                
                * Retour  INDI!
                SELECT INDI
                
                DO SuppNiv2
              ENDIF

            * Champ d'Occupation
            CASE Champ="OCCU"
              VOccu=SUBSTR(ligne,8)
              DO SuppNiv2

            * Champ de notes
            CASE Champ="NOTE"
              * Extraction de la premire ligne...
              VNote=VNote+SUBSTR(ligne,8)+CHR(13)
              * On lit la ligne suivante
              DO LireFic
              * A-t-on un champ de niveau "2" aprs?
              DO WHILE LEFT(Ligne,1)="2"
                * Extraction du champ de niveau "2"
                Champ=UPPER(TRIM(SUBSTR(Ligne,3,4)))
                * Ce ne peut tre qu'un CONT!
                IF Champ="CONT"
                  IF LEN(ALLTRIM(Ligne))>6
                    VNote=VNote+SUBSTR(ligne,8)+CHR(13)
                  ELSE
                    VNote=VNote+CHR(13)
                  ENDIF
                ENDIF
                DO LireFic
              ENDDO
              *DO SuppNiv2
              LireLigne=.F.
              
            * Autres cas!
            OTHERWISE
              * Champ inconnu!
              ? '*** Erreur Individus '+VIndi+': Champ '+Champ+' inconnu!'
              ? Ligne
              * On "purge" les ventuels niveaux qui en dpendent
              DO SuppNiv2
        * Fin de l'aiguillage!
        ENDCASE

        OTHERWISE
          Exit
      * Fin d'une ligne de commande
      ENDCASE
    * Fin d'une ligne de taille >5
    ENDIF
  * Fin de la boucle de remplissage!
  ENDDO

  * 4) Cration d'un nouvel enregistrement dans INDI
  SELECT INDI
  INSERT INTO INDI (Indi,Name,Name_Alias,Sex,Birt_Date,Birt_Plac,Deat_Date,Deat_Plac,Buri_Date,Buri_Plac,Occu,Note) VALUES (VIndi,VName,VName_Alias,VSex,VBirt_Date,VBirt_Plac,VDeat_Date,VDeat_Plac,VBuri_Date,VBuri_Plac,VOccu,Vnote)
  * ? Vindi+" "+Name
  
  * Pour ne pas sauteur une dfinition!
  LireLigne=.F.
RETURN
***********************************************
* Extraction d'une famille
***********************************************
PROCEDURE ExtraitFam
  * 1) Extraction de l'index de la famille
  * L'index se situe OBLIGATOIREMENT entre deux "@"
  IF OCCURS('@',Ligne)<>2
    ? '*** Erreur! Index introuvable!'
    RETURN
  ENDIF
  * Recherche la position des "@", puis extraction de l'index
  Debut=AT('@',Ligne,1)
  Fin=AT('@',Ligne,2)
  IF (Debut+1)=Fin
    ? '*** Erreur! Index non valide!'
    RETURN
  ENDIF
  VFam=SUBSTR(Ligne,Debut+1,Fin-Debut-1)
  
  * 2) RAZ des champs, avant compltion
  VHusb=""
  VWife=""
  VChil=""
  VMarr_Date=""
  VMarr_Plac=""
  VDiv=.F.
  VNote=""
  
  NouvelFam=.T.
  
  * 2bis) Si on est en mode FAM dans INDI, on regarde si
  * la famille existe... Et si c'est le cas, on met  jour
  * ces variables par les valeurs dj disponibles!
  IF IndiFam
    SELECT FAM
    GO TOP
    LOCATE FOR VFam==ALLTRIM(Fam.Fam)
    IF NOT EOF('FAM')
      * Elle existe dj: on met  jour les variables!
      NouvelFam=.F.
      VHusb=ALLTRIM(Fam.Husb)
      VWife=ALLTRIM(Fam.Wife)
      VChil=ALLTRIM(Fam.Chil)
    ENDIF
  ENDIF
  
    
  * 3) Remplissage des champs disponibles...
  DO WHILE (NOT EOF(NumFic))
    * On lit la ligne... Si c'est ncessaire!
    *IF LireLigne
    *  Ligne=TRIM(FGET(NumFic))
    *ELSE
    *  LireLigne=.T.
    *ENDIF
    DO LireFic

    * Est-ce une ligne valide?
    IF LEN(Ligne)>5
      Cmd=LEFT(Ligne,1)

      * De quel type de ligne s'agit-il?
      DO CASE

        * Un nouvel enregistrement: on sort!
        CASE Cmd="0"
          Exit
        * Un nouveau champ!
        CASE Cmd="1"
          Champ=UPPER(TRIM(SUBSTR(Ligne,3,4)))

          * Aiguillage...
          DO CASE

            * No de rfrence
            CASE Champ="REFN"
              * Pas utiliss!
              DO SuppNiv2

            * Index du mari
            CASE Champ="HUSB"
              VHusb=ALLTRIM(SUBSTR(ligne,8))
              VHusb=SUBSTR(VHusb,2,LEN(VHusb)-2)
              DO SuppNiv2

            * Index de la femme
            CASE Champ="WIFE"
              VWife=ALLTRIM(SUBSTR(ligne,8))
              VWife=SUBSTR(VWife,2,LEN(VWife)-2)
              DO SuppNiv2

            * Index des enfants...
            * ATTN: il y a apparemment un ORDRE dans la dclinaison des index
            *   d'enfant: on va du plus vieux (ain) au plus jeune (cadet)
            CASE Champ="CHIL"
              * Extraction de l'index du gosse
              VTemp=ALLTRIM(SUBSTR(ligne,8))
              VTemp=SUBSTR(VTemp,2,LEN(Vtemp)-2)
              
              IF EMPTY(VChil)
                * Y'a rien: cas le plus simple!
                VChil=VTemp+'@'
              ELSE
                * Ca se complique!
                IF IndiFam
                  * Ae! Il faut d'abord tester si le gosse n'a
                  *  pas dj t dclar!
                  IF NOT ((VTemp+'I') $ VChil) AND NOT ((VTemp+'@') $ VChil)
                    * Ok! Yapa! On peut l'ajouter!
                    VChil=LEFT(VChil,LEN(VChil)-1)+VTemp+'@'
                  ENDIF
                ELSE
                  * Ouf! Il suffit de mettre le champ  jour!
                  VChil=LEFT(VChil,LEN(VChil)-1)+VTemp+'@'
                ENDIF
              ENDIF
              DO SuppNiv2

            * Mariage...
            CASE Champ="MARR"
              Ligne='2222222222222222222'
              * Est-ce une ligne de niveau "2"?
              DO WHILE LEFT(Ligne,1)="2" AND LEN(Ligne)>7
                * On lit la ligne suivante
                DO LireFic
                * Extraction du champ de niveau "2"
                Champ=UPPER(TRIM(SUBSTR(Ligne,3,4)))
                * Ce peut tre soit DATE, soit PLAC!
                DO CASE
                  CASE Champ="DATE" AND LEN(Ligne)>6
                    VMarr_Date=UPPER(ALLTRIM(SUBSTR(Ligne,8)))

                  CASE Champ="PLAC" AND LEN(Ligne)>6
                    VMarr_Plac=SUBSTR(Ligne,8)
                    
                  OTHERWISE
                  IF LEFT(Ligne,1)='2'
                    ? '*** Erreur Famille '+VFam+': Champ '+Champ+' inconnu dans MARR'
                    ? Ligne
                  ENDIF
                  ENDCASE

                ENDDO
                LireLigne=.F.
                
            * Divorc (dfaut: N)
            CASE Champ="DIV"
              IF UPPER(RIGHT(Ligne,1))="Y"
                VDiv=.T.
              ENDIF
              DO SuppNiv2

            * Champ de notes
            * - Reconnu par Kith&Kin 
            * - Non reconnu par WinFamily
            CASE Champ="NOTE"
              * Extraction de la premire ligne...
              VNote=VNote+SUBSTR(ligne,8)+CHR(13)
              * On lit la ligne suivante
              *Ligne=TRIM(FGET(NumFic))
              DO LireFic
              * A-t-on un champ de niveau "2" aprs?
              DO WHILE LEFT(Ligne,1)="2"
                * Extraction du champ de niveau "2"
                Champ=UPPER(TRIM(SUBSTR(Ligne,3,4)))
                * Ce ne peut tre qu'un CONT!
                IF Champ="CONT"
                  IF LEN(ALLTRIM(Ligne))>6
                    VNote=VNote+SUBSTR(ligne,8)+CHR(13)
                  ELSE
                    VNote=VNote+CHR(13)
                  ENDIF
                ENDIF
                *Ligne=TRIM(FGET(NumFic))
                DO LireFic
              ENDDO
              LireLigne=.F.

          OTHERWISE
              * Champ Inconnu!
              ? '*** Erreur Familles '+VFam+':Champ '+Champ+' inconnu!'
              ? Ligne
              * On "purge" les ventuels niveaux qui en dpendent
              DO SuppNiv2

          * Fin de l'aiguillage!
          ENDCASE

        OTHERWISE
          Exit
      * Fin d'une ligne de commande
      ENDCASE
    * Fin d'une ligne de taille >5
    ENDIF
  * Fin de la boucle de remplissage!
  ENDDO
  
  * 4) Cration d'un nouvel enregistrement dans INDI
  IF NouvelFam
    * La famille n'existe pas... Il faut en crer une nouvelle!
    SELECT FAM
    INSERT INTO FAM (Fam,Husb,Wife,Chil,Marr_Date,Marr_Plac,Div,Note) VALUES (VFam,VHusb,VWife,VChil,VMarr_Date,VMarr_Plac,VDiv,VNote)
  ELSE
    * Elle existe! Simple Mise  jour dans ces conditions!
    REPLACE Fam.Husb WITH VHusb, Fam.Wife WITH VWife, Fam.Chil WITH VChil, Fam.Marr_Date WITH VMarr_Date, Fam.Marr_Plac WITH VMarr_Plac, Fam.Div WITH VDiv, Fam.Note WITH VNote
  ENDIF
  *? VFam+" "+VHusb+" "+VWife

  * Pour ne pas sauter une dfinition!
  LireLigne=.F.
RETURN
************************************************
* Extraction d'une nouvelle ligne du fichier import
************************************************
PROCEDURE LireFic
  IF LireLigne
    Ligne=TRIM(FGET(NumFic))
    * Traduction ventuelle ASCII -> ANSI
    IF Police='IBMPC' OR Police='ASCII'
      Ligne=OEMTOANSI(Ligne)
    ENDIF
  ELSE
    LireLigne=.T.
  ENDIF
RETURN
************************************************
* "Vidange" des niveaux annexes ("2 XXX")
************************************************
Procedure SuppNiv2
  Ligne="2"
  DO WHILE LEFT(Ligne,1)>="2"
    DO LireFic
  ENDDO
  LireLigne=.F.
RETURN
************************************************
