***********************************************
*
*              Programme GEDEXP
*
*                    V1.0
*
* Exportation de la base INDI/FAM dans un fichier GEDCOM
*     (En Foxpro Win, langage "compatible dBase")
*
*      (c) Franois CLAUSTRES 1994/1995
*
*               *** FREEWARE ***
* 
***********************************************
*
* NOTE: pour une plus grande compatibilit, les
*       INDIvidus sont dcrits en premier, PUIS
*       les FAMilles suivent!
*
***********************************************
*
* CHAMPS EXPORTES: voir gedimp.prg sur les champs
*                  imports!
*
* LIMITATIONS: dans cette version, les ALIAS
*              ne sont pas exports!
*
***********************************************
* 1) Initialisations & ouverture des bases
***********************************************
CLOSE ALL
SELECT 1
USE INDI
SELECT 2
USE FAM
* Longueur de ligne des mmos (maxi = 256)
* ceci pour calculer  peu prs correctement MLINE!
SET MEMOWIDTH TO 256
***********************************************
* Gestion du mode Familles dcrite dans INDI
*               (FAMS /FAMC)
***********************************************
*
* IndiFam=.F.: gedexp ne cre pas les liens
*              FAMS/FAMC pour chaque INDIvidu.
*              En thorie, ces derniers ne sont
*              pas ncessaires, car ils sont dcrits
*              en FAM: WINGAO n'en a pas besoin par
*              exemple, MAIS pour une plus grande
*              compatibilit avec d'autres softs,
*              il est FORTEMENT recommand de ne pas
*              utilise ce mode!
*
* IndiFam=.T.: gedexp dcrit les liens familiaux aussi
*              bien en INDI (FAMS/FAMC) qu'en FAM.
*              MODE QUI ASSURE UNE COMPATIBILITE A 99,99%!!!
*              (pour ne pas dire 100%...) AVEC LES FILTRES
*              D'IMPORT GEDCOM!
*              Le fichier obtenu - ainsi que le traitement -
*              est un peu plus long, mais a en vaut la peine!
*
************************************************
IndiFam=.T.
***********************************************
*
* Jeu de caractres du fichier d'export:
*  ANS2ASC=.F.   Jeu ANSI
*  ANS2ASC=.T.   Jeu ASCII 
*
***********************************************
ANS2ASC=.T.
***********************************************
* 2) Cration du fichier GEDCOM
***********************************************
NomFic="export.ged"
NumFic=FCREATE(NomFic)
IF NumFic=-1
  ? '*** Echec cration fichier GEDCOM!'
  RETURN
ENDIF
***********************************************
* 3) Cration de l'en-tte GEDCOM
* RQ: FPUT met un "CR" en fin, FWRITE non
***********************************************
=FPUT(NumFic,"0 HEAD")
=FPUT(NumFic,"1 SOUR MICROGED")
=FPUT(NumFic,"2 VERS 1.0")
=FPUT(NumFic,"1 DATE 13 Nov 1994")
=FPUT(NumFic,"1 DEST PAF")
IF ANS2ASC
  =FPUT(NumFic,"1 CHAR IBMPC")
ELSE
  =FPUT(NumFic,"1 CHAR ANSI")
ENDIF
=FPUT(NumFic,"1 FILE EXPORT.GED")
***********************************************
* 4) Ajout des individus
***********************************************
SELECT INDI
GO TOP
DO WHILE NOT EOF('INDI')

  * En-tte de l'individu
  Ligne='0 @'+ALLTRIM(Indi.Indi)+'@ INDI'
  DO EcrireFic
  
  * Nom
  IF NOT EMPTY(ALLTRIM(Indi.Name))
    Ligne='1 NAME '+ALLTRIM(Indi.Name)
    DO EcrireFic
  ENDIF
  
  * Sexe
  DO CASE
    CASE SEX=.T.
      Ligne="1 SEX M"
    CASE SEX=.F.
      Ligne="1 SEX F"
  ENDCASE
  DO EcrireFic
  
  * La naissance
  IF NOT EMPTY(ALLTRIM(Indi.Birt_Date)) OR NOT EMPTY(ALLTRIM(Indi.Birt_Plac))
    Ligne='1 BIRT'
    DO EcrireFic
    IF NOT EMPTY(ALLTRIM(Indi.Birt_Date))
      Ligne='2 DATE '+ALLTRIM(Indi.Birt_date)
      DO EcrireFic
    ENDIF
    IF NOT EMPTY(ALLTRIM(Indi.Birt_Plac))
      Ligne='2 PLAC '+ALLTRIM(Indi.Birt_Plac)
      DO EcrireFic
    ENDIF
  ENDIF
  
  * Le dcs
  IF NOT EMPTY(ALLTRIM(Indi.Deat_Date)) OR NOT EMPTY(ALLTRIM(Indi.Deat_Plac))
    Ligne='1 DEAT'
    DO EcrireFic
    IF NOT EMPTY(ALLTRIM(Indi.Deat_Date))
      Ligne='2 DATE '+ALLTRIM(Indi.Deat_date)
      DO EcrireFic
    ENDIF
    IF NOT EMPTY(ALLTRIM(Indi.Deat_Plac))
      Ligne='2 PLAC '+ALLTRIM(Indi.Deat_Plac)
      DO EcrireFic
    ENDIF
  ENDIF
  
  * L'enterrement...
  IF NOT EMPTY(ALLTRIM(Indi.Buri_Date)) OR NOT EMPTY(ALLTRIM(Indi.Buri_Plac))
    Ligne='1 BURI'
    DO EcrireFic
    IF NOT EMPTY(ALLTRIM(Indi.Buri_Date))
      Ligne='2 DATE '+ALLTRIM(Indi.Buri_date)
      DO EcrireFic
    ENDIF
    IF NOT EMPTY(ALLTRIM(Indi.Buri_Plac))
      Ligne='2 PLAC '+ALLTRIM(Indi.Buri_Plac)
      DO EcrireFic
    ENDIF
  ENDIF
  
  * Gestion des liens familiaux dans INDI.
  *   Ceci pour accrotre la compatibilit avec les programmes
  *   d'import GEDCOM qui en ont besoin!
  IF IndiFam
    Individu=ALLTRIM(Indi.Indi)
    SELECT FAM
    * L'individu est issu de la famille FAMC
    * RQ: il ne peut tre l'enfant que d'une famille!
    GO TOP
    * Cas de l'index de l'individu qui n'est pas le dernier
    IndivNonFin=Individu+'I'
    * Cas de l'index en Fin
    IndivFin=Individu+'@'
    * Au boulot!
    LOCATE FOR (IndivNonFin $ Fam.Chil) OR (IndivFin $ Fam.Chil)
    IF NOT EOF('FAM')
      * La famille des parents de l'individu a t trouve!
      Ligne='1 FAMC @'+ALLTRIM(Fam.Fam)+'@'
      DO EcrireFic
    ENDIF
    * Il a t le conjoint (HUSB/WIFE) dans les familles FAMS
    * RQ: l'galit stricte se fait par "=="
    GO TOP
    LOCATE FOR (Individu==ALLTRIM(Fam.Husb)) OR (Individu==ALLTRIM(Fam.Wife))
    IF NOT EOF('FAM')
      * Entre de la premire occurence
      Ligne='1 FAMS @'+ALLTRIM(Fam.Fam)+'@'
      DO EcrireFic
      * Existe-t-il d'autres occurences?
      DO WHILE NOT EOF('FAM')
        CONTINUE
        IF NOT EOF('FAM')
          * Une nouvelle famille!
          Ligne='1 FAMS @'+ALLTRIM(Fam.Fam)+'@'
          DO EcrireFic
        ENDIF      
      ENDDO
    ENDIF
    * Retour  INDI!
    SELECT INDI 
  ENDIF

  * Occupation
  IF NOT EMPTY(ALLTRIM(Indi.Occu))
    Ligne='1 OCCU '+ALLTRIM(Indi.Occu)
    DO EcrireFic
  ENDIF
  
  * Notes
  IF NOT EMPTY(Indi.Note)
    NbrLignes=MEMLINE(Indi.Note)
    * On crit la premire ligne
    Ligne='1 NOTE '+MLINE(Indi.Note,1)
    DO EcrireFic
    * On met les autres en "CONT"... Si elles existent!
    IF NbrLignes>1
      FOR LigneMemo=2 TO NbrLignes
        Ligne='2 CONT '+MLINE(Indi.Note,LigneMemo)
        DO EcrireFic
      ENDFOR
    ENDIF
  ENDIF
  
  * Enregistrement suivant
  SKIP

ENDDO
***********************************************
* 5) Ajout des familles
***********************************************
SELECT FAM
GO TOP
IF NOT EOF('FAM')
  DO WHILE NOT EOF('FAM')
    * En-tte de la famille
    Ligne='0 @'+ALLTRIM(Fam.Fam)+'@ FAM'
    DO EcrireFic
    
    * Le Mari...
    IF NOT EMPTY(Fam.Husb)
      Ligne='1 HUSB @'+ALLTRIM(Fam.Husb)+'@'
      DO EcrireFic
    ENDIF
    
    * L'Epouse...
    IF NOT EMPTY(Fam.Wife)
      Ligne='1 WIFE @'+ALLTRIM(Fam.Wife)+'@'
      DO EcrireFic
    ENDIF
    
    * Les Enfants...
    IndexEnfants=ALLTRIM(Fam.Chil)
    NbrEnfants=OCCURS("I",IndexEnfants)
    IF NbrEnfants>0
      DO WHILE NbrEnfants>0
        * Un Index commence toujours par un "I"
        Longueur=AT("I",SUBSTR(IndexEnfants,2))
        * Si AT renvoit "0", c'est qu'il n'y a plus d'index
        *  aprs l'index courant! => on met la longueur totale!
        IF Longueur=0
          * Un champ CHIL non vide se termine TOUJOURS par '@'
          Longueur=LEN(IndexEnfants)
        ELSE
          * Puisqu'on a commenc  partir du numro, et non du "I"...
          Longueur=Longueur+1
        ENDIF
        * Extraction!
        Ligne='1 CHIL @'+ALLTRIM(LEFT(IndexEnfants,Longueur-1))+'@'
        DO EcrireFic
        * Suppression!
        IF NbrEnfants>1
          IndexEnfants=SUBSTR(IndexEnfants,Longueur)
        ENDIF
        NbrEnfants=NbrEnfants-1
      ENDDO
    ENDIF
    
    * Le Mariage
    IF NOT EMPTY(ALLTRIM(Fam.Marr_Date)) OR NOT EMPTY(ALLTRIM(Fam.Marr_Plac))
      Ligne='1 MARR'
      DO EcrireFic
      IF NOT EMPTY(ALLTRIM(Fam.Marr_Date))
        Ligne='2 DATE '+ALLTRIM(Fam.Marr_date)
        DO EcrireFic
      ENDIF
      IF NOT EMPTY(ALLTRIM(Fam.Marr_Plac))
        Ligne='2 PLAC '+ALLTRIM(Fam.Marr_Plac)
        DO EcrireFic
      ENDIF
    ENDIF
    
    * Le divorce...
    IF Fam.Div=.T.
      Ligne='1 DIV Y'
      DO EcrireFic
    ENDIF
    
    * Les notes
    IF NOT EMPTY(Fam.Note)
      NbrLignes=MEMLINE(Fam.Note)
      * On crit la premire ligne
      Ligne='1 NOTE '+MLINE(Fam.Note,1)
      DO EcrireFic
      * On met les autres en "CONT"... Si elles existent!
      IF NbrLignes>1
        FOR LigneMemo=2 TO NbrLignes
          Ligne='2 CONT '+MLINE(Fam.Note,LigneMemo)
          DO EcrireFic
        ENDFOR
      ENDIF
    ENDIF

    * Famille suivante!
    SKIP
    
  ENDDO
ENDIF
***********************************************
* 6) Fin du fichier GEDCOM
***********************************************
=FPUT(NumFic,"0 TRLR")
***********************************************
* 7) Mnage avant de quitter
***********************************************
=FCLOSE(NumFic)
CLOSE ALL
RETURN
************************************************
* Ecriture du fichier GEDCOM avec ou sans conversions
************************************************
PROCEDURE EcrireFic
  IF ANS2ASC=.T.
    Ligne=ANSITOOEM(Ligne)
  ENDIF 
  =FPUT(NumFic,Ligne)
RETURN
************************************************