REM *********************************************
REM
REM      Test du code des cartes de crdit
REM
REM    Algorithme principal: J. GIL (Portugal)
REM
REM   Programme et ajout de nouvelles cartes
REM          par Franois CLAUSTRES
REM
REM                    V1.0
REM  (a fait bien de mettre un n de version!)
REM
REM *********************************************
REM
REM Cartes qui ne suivent pas cet algorithme:
REM
REM - Carte PASS (Carrefour)
REM - Carte TOTAL
REM
REM *********************************************
REM
REM Initialisations...
REM
REM Chiffres% : pas plus de 20 chiffres sur une carte!
DIM Chiffres%(20)
REM NbChiffres% : Nombre de chiffres
NbChiffres% = 0
REM TypeCarte$ : Type de la carte (VISA, DINER...)
TypeCarte$ = "<INCONNU>"
REM Code$ = Chiffres sous forme de chaine
Code$ = ""
REM
REM Petit affichage...
REM
PRINT
PRINT "******************************************"
PRINT "* Vrification des n de carte de crdit *"
PRINT "******************************************"
PRINT
PRINT "Attention  ne pas confondre la lettre 'O' et le zro (0)!"
INPUT "Entrez le numro de carte --> "; NumCarte$
PRINT
REM
REM Ici on ne conserve QUE les chiffres 0-9!
REM
FOR I = LEN(NumCarte$) TO 1 STEP -1
  REM On extrait car/car  partir de la droite
  A$ = MID$(NumCarte$, I, 1)
  IF A$ >= "0" AND A$ <= "9" THEN
    REM C'est un chiffre!
    NbChiffres% = NbChiffres% + 1
    Chiffres%(NbChiffres%) = VAL(A$)
    Code$ = A$ + Code$
  END IF
NEXT I
REM
REM On affiche le numro de carte aprs "filtrage"
REM
FOR I% = NbChiffres% TO 1 STEP -1
  PRINT Chiffres%(I%);
NEXT I%
PRINT
PRINT
INPUT "Est-ce bien le numro de votre carte? (Dfaut = Oui) "; A$
PRINT
IF A$ = "" THEN A$ = "O"
A$ = LEFT$(A$, 1)
IF A$ = "N" OR A$ = "n" THEN END
REM
REM ***************************************************
REM
REM          Dtermination du type de carte
REM
REM ***************************************************
REM
REM Au minimum 11 chiffres...
REM
IF NbChiffres% < 11 THEN
  PRINT "*** ERREUR: au moins 11 chiffres!"
REM  END
END IF
REM
REM 13 ou 16 chiffres et le plus  gauche est un "4"?
REM C'est une VISA!
IF (NbChiffres% = 13 OR NbChiffres% = 16) AND Chiffres%(NbChiffres%) = 4 THEN
  TestCase$ = LEFT$(Code$, 4)
  SELECT CASE TestCase$
    CASE "4972"
      TypeCarte$ = "CB ou VISA Crdit Lyonnais"
    CASE "4973"
      TypeCarte$ = "CB ou VISA Socit Gnrale"
    CASE "4978"
      TypeCarte$ = "CB ou VISA Caisse d'Epargne"
    CASE "4976"
      TypeCarte$ = "CB ou VISA Crdit du Nord"

    CASE ELSE
      TypeCarte$ = "CB ou VISA"

  END SELECT
  GOTO Test
END IF
REM
REM 15 chiffres et les deux premiers chiffres 34 ou 37 ?
REM C'est une American Express (AMEX)!
IF NbChiffres% = 15 AND Chiffres%(NbChiffres%) = 3 AND (Chiffres%(NbChiffres% - 1) = 4 OR Chiffres%(NbChiffres% - 1) = 7) THEN
  TypeCarte$ = "AMEX"
  GOTO Test
END IF
REM
REM 14 Chiffres et les deux premiers 30, 36 ou 38 ?
REM C'est une DINER!
IF NbChiffres% = 14 AND Chiffres%(NbChiffres%) = 3 AND (Chiffres%(NbChiffres% - 1) = 0 OR Chiffres%(NbChiffres% - 1) = 6 OR Chiffres%(NbChiffres% - 1) = 8) THEN
  TypeCarte$ = "DINER"
  GOTO Test
END IF
REM
REM 16 chiffres et les deux premiers 50 ou 56 ?
REM C'est une ACCESS!
IF NbChiffres% = 16 AND Chiffres%(NbChiffres%) = 5 AND (Chiffres%(NbChiffres% - 1) = 0 OR Chiffres%(NbChiffres% - 1) = 6) THEN
  TypeCarte$ = "AMEX"
  GOTO Test
END IF
REM
REM 16 Chiffres et les deux premiers 35 ?
REM C'est une JCB! (???)
IF NbChiffres% = 16 AND Chiffres%(NbChiffres%) = 3 AND Chiffres%(NbChiffres% - 1) = 5 THEN
  TypeCarte$ = "JCB"
  GOTO Test
END IF
REM
REM * Cartes franaises
REM
REM 17 chiffres et le premier est un 3 ?
REM C'est sans doute une COFINOGA!
IF NbChiffres% = 17 AND Chiffres%(NbChiffres%) = 3 THEN
  TypeCarte$ = "COFINOGA"
  GOTO Test
END IF
REM
REM 19 chiffres et le premier est un 6 ?
REM C'est sans doute une "Galeries Lafayette"!
IF NbChiffres% = 19 AND Chiffres%(NbChiffres%) = 6 THEN
  TypeCarte$ = "GALERIES LAFAYETTE"
  GOTO Test
END IF
REM 16 chiffres et le premier est un 1 ?
REM C'est sans doute une "Le Bon March"!
IF NbChiffres% = 16 AND Chiffres%(NbChiffres%) = 1 THEN
  TypeCarte$ = "LE BON MARCHE"
  GOTO Test
END IF
REM
REM ************************************************************
REM
REM               Test de la validit du numro
REM
REM ************************************************************
REM
Test:
UnSurDeux% = 0
Validite% = 0
Dble% = 0
FOR I% = 1 TO NbChiffres%

  IF UnSurDeux% = 1 THEN
    UnSurDeux% = 0
    REM Ici, on double!
    Dble% = Chiffres%(I%) * 2
    REM Si le rsultat > 9, il faut ajouter dizaine & units!
    IF Dble% > 9 THEN
      A$ = RTRIM$(LTRIM$(STR$(Dble%)))
      Dble% = VAL(LEFT$(A$, 1))
      Dble% = Dble% + VAL(RIGHT$(A$, 1))
    END IF
    Validite% = Validite% + Dble%
  ELSE
    UnSurDeux% = 1
    Validite% = Validite% + Chiffres%(I%)
  END IF
NEXT I%
REM
REM Il faut que Validite% soit un multiple de 10 ...
REM
IF RIGHT$(RTRIM$(STR$(Validite%)), 1) = "0" THEN
  ResultTest$ = "VALIDE"
ELSE
  ResultTest$ = "ERRONE"
END IF
REM
REM ************************************************************
REM
REM                    Affichage du rsultat!
REM
REM ************************************************************
REM
PRINT "Cette carte est une "; TypeCarte$; " dont le numro est "; ResultTest$; " ("; RTRIM$(LTRIM$(STR$(Validite%))); ")"
PRINT

