' Une alarme en QBasic !

CLS                                                        '** Efface l'cran
COLOR 14                                           '** Passe en couleur jaune
PRINT "Il est             : "; TIME$             '** Affiche l'heure courante
INPUT "Heure de l'alarme  : ", alarme$           '** Demande l'heure d'alarme
PRINT "Reste avant alarme : "                        '** Temps avant l'alarme

heure% = VAL(MID$(alarme$, 1, 2))             '** Extrait l'heure de l'alarme
min% = VAL(MID$(alarme$, 4, 2))                               '** ses minutes
sec% = VAL(MID$(alarme$, 7, 2))                   '** les secondes pour finir

COLOR 15                                              '** en blanc dornavant

DO WHILE INKEY$ = ""                '** Tant qu'aucune touche n'a t appuye

  '** Extrait les valeurs d'heure minute et seconde de l'heure courante
  heure2% = VAL(MID$(TIME$, 1, 2))
  min2% = VAL(MID$(TIME$, 4, 2))
  sec2% = VAL(MID$(TIME$, 7, 2))

  '** Recalcule integralement le nombre de seconde jusqu' l'heure d'alarme
  temps = (heure% - heure2%) * 3600 + (min% - min2%) * 60 + (sec% - sec2%)
 
  '** Si ngatif, alors on rajoute un jour complet, 24 heures, 86400 secondes
  IF temps < 0 THEN temps = temps + 86400
 
  '** Lance l'alarme si l'heure d'alarme est identique  l'heure courante
  IF temps = 0 THEN IsAlarme% = 1

  '** Retransforme le temps complet en CHAINES de seconde, minutes et heures
  sec$ = LTRIM$(STR$(temps MOD 60))                '** 60 secondes dans 1 min
  min$ = LTRIM$(STR$((temps MOD 3600) \ 60))      '** 60 minutes dans 1 heure
  heure$ = LTRIM$(STR$(temps \ 3600))             '** 1 heure = 3600 secondes

  IF LEN(sec$) = 1 THEN sec$ = "0" + sec$         '** Rajoute les zros si il
  IF LEN(min$) = 1 THEN min$ = "0" + min$        '** n'y a qu'un seul chiffre
  IF LEN(heure$) = 1 THEN heure$ = "0" + heure$             '** ex : 5 --> 05

  LOCATE 1, 22
  PRINT TIME$;                                   '** Affiche l'heure courante
  LOCATE 3, 22
  PRINT heure$ + ":" + min$ + ":" + sec$         '** Affiche le temps restant

  IF IsAlarme% > 0 THEN                         '** L'alarme a t dclanche
    FOR i% = 1 TO 4                                     '** 4 bips  la suite
      PALETTE 0, 36                      '** On fais flasher l'cran en rouge
      SOUND 2750, 1                    '** On emet le son pendant 1/18 de sec
      PALETTE 0, 0                                      '** On eteint l'cran
      SOUND 25000, 1                 '** On fais un pause pendant 1/18 de sec
    NEXT
    SOUND 25000, 4                           '** Pause pendant 1/4 de seconde
  
    '** Facultatif : arrete l'alarme au bout d'un certain temps..
    IF IsAlarme% = 50 THEN IsAlarme% = 0 ELSE IsAlarme% = IsAlarme% + 1
  END IF
LOOP

SYSTEM                                                      '** Quitte Qbasic

