;***************************************************************************
;*	Routine permettant de charger des images PCX 320*200 en 256 couleurs
;*
;* Programm par Sbastien Granjoux
;*
;* Commenc le 20/02/94
;* Dernire modif le 10/01/95

IDEAL
P286
MODEL	SMALL

DATASEG

VIDEO_SEG	EQU	0A000h  ; segment de l'ecran en mode graphique
PAL_REG		EQU	03C8h

FILEBUF		EQU	1024	;taille du buffer

Filename	DB	'C:\PROGRAM\USER\DEMO\BACK03.PCX',0

CODESEG

	mov	ax,13h		;passe en mode graphique 320*200*256
	int	10h

	mov	ax,VIDEO_SEG	;adresse du dbut de l'ecran
	mov	es,ax
	xor	di,di
	mov	ax,@DATA	; rcupre le segment des donnes
	mov	ds,ax
	mov	dx,OFFSET Filename
	call	loadpcx		; charge l'image

	mov	ah,07		; attend une touche au clavier
	int	21h

	mov	ax,3		; repasse en mode texte
	int	10h

	mov	ax,4c00h	; termine le programme
	int	21h

;***************************************************************************
;*	Cette fonction charge une image PCX  l'adresse ES:DI avec le nom
;*	du fichier en DS:DX
;*
;* Entre:
;*	DS:DX	nom du fichier
;*	ES:DI	adresse de chargement du fichier  l'ecran
;*
;* Sortie:
;*	AX=0 et C=0 si aucune erreur
;*
;* Attention:
;*	la taille du buffer interne FILEBUF doit au moins tre gale 
;*	768


PROC	LOADPCX
LOCAL	buffer:BYTE:FILEBUF,nbrep:BYTE=locvar

	mov	ax,3d00h	; ouvre le fichier
	int	21h
	jnc	@@no_error
	ret
@@no_error:
	mov	bx,ax

	enter	locvar,0	; reserve de la place pour un buffer
	push	ds
	mov	ax,ss
	mov	ds,ax

	lea	ax,[buffer+FILEBUF]         ;une touche de code automodifi
	mov	[cs:OFFSET @@fgetbyte+2],ax

	mov	ax,4200h	; saute le header
	mov	dx,128
	xor	cx,cx
	int	21h

	lea	si,[Buffer+FILEBUF]
@@boucle:
	cmp	di,320*200
	jae	@@load_palette	; si on a rempli l'ecran

	call	@@fgetbyte
	cmp	al,0c0h
	ja	@@repeat
	stosb			; couleur non compact
	jmp	@@boucle

@@repeat:
	sub	al,0c0h		; couleur compact
	mov	[nbrep],al
	call	@@fgetbyte
	mov	cl,[nbrep]
	xor	ch,ch
	rep	stosb
	jmp	@@boucle

@@load_palette:
	mov	dx,0fd00h	; se place sur la palette (on part de la fin)
	mov	cx,0ffffh
	mov	ax,4202h
	int	21h

	mov	ah,3fh		; charge la palette
	mov	cx,768
	lea	dx,[buffer]
	int	21h

	mov	ah,3eh		; ferme le fichier
	int	21h

	mov	dx,PAL_REG
	xor	al,al
	out	dx,al		; Premire couleur  modifier 0
	inc	dx
	lea	si,[Buffer]
	mov	cx,768
@@next_col:
	lodsb
	shr	al,2
	out	dx,al		; charge la palette de couleur
	dec	cx
	jne	@@next_col

	xor	ax,ax
	clc
	pop	ds
	leave
	ret

; Cette fonction renvoit les octets du fichier un par un en passant par
;  un buffer, SI doit contenir l'adresse courante dans le buffer
;  la valeur 1234h est modifi en dbut de programme pour contenir l'adresse
;  de fin du buffer

@@fgetbyte:
	cmp	si,1234h	; code automodifi,signale la fin du buffer
	jb	@@no_empty
	lea	dx,[buffer]
	mov	si,dx
	mov	cx,FILEBUF
	mov	ah,3fh
	int	21h
@@no_empty:
	lodsb

	ret

ENDP

STACK	600h

END