;***************************************************************************
;*	Routine permettant de charger des images PCX en mode 640*350*16
;*	 couleurs
;*
;* Programm par Sbastien Granjoux
;*
;* Commenc le 10/01/95
;* Dernire modif le 10/01/95

IDEAL
P8086			; Ca change de P386 !
MODEL	SMALL

DATASEG

VIDEO_SEG	EQU	0A000h  ; segment de l'ecran en mode graphique
PAL_REG		EQU	03C8h	; adresse du registre d'adresse de la palette
SC_INDEX	EQU	03C4h   ; adresse du sequenceur
MAP_MASK	EQU	2

FILEBUF		EQU	1024	;taille du buffer (ne dpasser pas la taille
				; de la pile)

NB_LINE		EQU	350 	; nombre de ligne de l'image
LEN_LINE	EQU	80	; longeur d'une ligne de l'image en octet

STRUC	PCXHD     		; C'est plus jolie avec une structure

	type	DB	?
	vers	DB	?
	compact	DB	?
	bitbypix DB	?
	x1	DW	?
	y1	DW	?
	x2	DW	?
	y2	DW	?
	xres	DW	?
	yres	DW	?
	pal	DB 16*3 DUP (?)
		DB	?
	nbplan	DB	?
	bytebyl DW	?
	palinf	DW	?
		DB 58 DUP (?)
ENDS

Filename	DB	'C:\PROGRAM\USER\REPORTER\TEST16.PCX',0

CODESEG
	mov	ax,10h		;passe en mode graphique 640*350*16
	int	10h

	mov	ax,@DATA	; rcupre le segment des donnes
	mov	ds,ax
	mov	dx,OFFSET Filename
	call	loadpcx		; charge l'image

	mov	ah,07		; attend une touche au clavier
	int	21h

	mov	ax,3		; repasse en mode texte
	int	10h

	mov	ax,4c00h	; termine le programme
	int	21h

;***************************************************************************
;*	Cette fonction charge une image PCX avec le nom du fichier en
;*	DS:DX
;*
;* Entre:
;*	DS:DX	nom du fichier
;*
;* Sortie:
;*	AX=0 et C=0 si aucune erreur
;*
;* Attention:
;*	la taille du buffer interne FILEBUF doit au moins tre gale 
;*	128


PROC	LOADPCX
LOCAL	buffer:BYTE:FILEBUF,plan:WORD,nextline:WORD,nbrep:BYTE=locvar

	mov	ax,3d00h	; ouvre le fichier
	int	21h
	jnc	@@no_error
	ret
@@no_error:
	mov	bx,ax

	push	bp	; reserve de la place pour le buffer
	mov	bp,sp
	sub	sp,locvar
	push	ds
	mov	ax,ss
	mov	ds,ax

	lea	ax,[buffer+FILEBUF]         ;une touche de code automodifi
	mov	[cs:OFFSET @@fgetbyte+2],ax


	mov	ah,3fh          ; lecture du header
	mov	cx,128
	lea	dx,[buffer]
	int	21h

	mov	dx,PAL_REG      ; D'abord la palette c'est plus simple
	xor	al,al
	out	dx,al		; Premire couleur  modifier 0
	inc	dx
	lea	si,[(PCXHD PTR buffer).pal]
	mov	cx,16*3
@@next_col:
	lodsb
	shr	al,2
	out	dx,al
	loop	@@next_col

	mov	ax,VIDEO_SEG
	mov	es,ax
	xor	di,di
	mov	[plan],8*256+MAP_MASK
	mov	[nextline],0         	; adresse de fin de ligne

	lea	si,[buffer+FILEBUF]
@@boucle:
	cmp	di,[nextline]
	jb	@@same_plan

	rol	[(byte ptr plan+1)],1
	and	[(byte ptr plan+1)],0Fh
	jnz	@@next_plan
	add	di,LEN_LINE
	cmp	di,LEN_LINE*NB_LINE
	jne	@@new_line

	mov	ah,3eh		; ferme le fichier
	int	21h

	xor	ax,ax
	clc
	pop	ds
	mov	sp,bp
	pop	bp
	ret

@@new_line:
	add	[nextline],LEN_LINE
	mov	[(byte ptr plan+1)],01h

@@next_plan:
	mov	dx,SC_INDEX
	mov	ax,[plan]
	out	dx,ax
	sub	di,LEN_LINE

@@same_plan:
	call	@@fgetbyte
	cmp	al,0c0h
	ja	@@repeat
	stosb			; couleur non compact
	jmp	@@boucle

@@repeat:
	sub	al,0c0h		; couleur compact
	xor	ah,ah
	mov	[nbrep],al
	call	@@fgetbyte
	mov	cl,[nbrep]
	xor	ch,ch
	mov	dx,[nextline]
	sub	dx,di
	cmp	dx,cx
	jae	@@decompact

	xchg	dx,cx          ; et en plus a cheval entre 2 plans !
	sub	dx,cx
	rep	stosb
	mov	ch,al
	mov	cl,dl

	rol	[(byte ptr plan+1)],1 ;change de plan
	mov	dx,SC_INDEX
	mov	ax,[plan]
	and	ah,0Fh
	out	dx,ax
	sub	di,LEN_LINE

	mov	al,ch
	xor	ch,ch
@@decompact:
	rep	stosb

	jmp	@@boucle

; Cette fonction renvoit les octets du fichier un par un en passant par
;  un buffer, SI doit contenir l'adresse courante dans le buffer
;  la valeur 1234h est modifi en dbut de programme pour contenir l'adresse
;  de fin du buffer

@@fgetbyte:
	cmp	si,1234h	; code automodifi,signale la fin du buffer
	jae	@@empty
	lodsb
	retn
@@empty:
	lea	dx,[buffer]
	mov	si,dx
	mov	cx,FILEBUF
	mov	ah,3fh
	int	21h
	lodsb
	retn

ENDP

STACK	600h

END