;***************************************************************************
;*      Routine permettant de jouer un sample sur un DAC mont sur le port
;*       parallle 2. Cette routine permet de jouer des sons de plus de
;*       64Ko.
;*
;* Programm par Sbastien Granjoux
;*
;* Commenc le 25/01/95
;* Modification le 25/01/95

IDEAL
P8086           ; C'est tout simple il n'y a pas vraimment besoin du 386 !
MODEL   SMALL

DATASEG

INT_SEG         EQU     00h     ; Segment des vecteurs d'interruptions
IRQ0ADR         EQU     20h     ; Adresse de l'interruption du timer
LPT2ADR         EQU     40Ah    ; Adresse du port parallle 2
SAMPFRQ         EQU     142     ; =1193180/Frquence de restitution en Hz
				; Ici 8.4Khz

Filename        DB      'C:\UTILS\PLAYER\ABSENCE.MOD',0
StartMsg        DB      'Playing sample.....',0ah,0dh,'$'
ErrorMsg        DB      'Can''t load sound file.',0ah,0dh,'$'
SampleSeg       DW      0
SampleLen       DD      0

CODESEG

SampleAdr       DD      0       ; C'est donne sont dans le segment de code
SampleEnd       DD      0       ; pour permettre  la routine sous
Compteur        DW      0       ; interruption de les rcuprer facilement
OldInt          DD      0
Stop            DB      1

start:
	mov     bx,ss  ; rend la mmoire inutilis au DOS
	mov     ax,es
	sub     bx,ax
	mov     ax,sp
	add     ax,15
	shr     ax,4
	add     bx,ax
	mov     ah,4ah
	int     21h

	mov     ax,@DATA        ; rcupre le segment des donnes
	mov     ds,ax

	mov     dx,OFFSET Filename ; charge le sample
	call    loadsmp    
	jnc     @@no_error

	push    ax              ; Erreur (pas assez de mmoire ou fichier
	mov     ah,09           ; inexistant en gnral)
	mov     dx,OFFSET ErrorMsg
	int     21h
	pop     ax
	mov     ah,4Ch
	int     21h
@@no_error:

	mov     ah,09h          ; Un petit message (tout va bien)
	mov     dx,OFFSET StartMsg
	int     21h

	call    startdac        ; commence le son

@@wait_end:                     ; attend la fin du son
	cmp     [cs:Stop],1
	jne     @@wait_end

	mov     ah,49h          ; Rend la mmoire utilis par le sample
	mov     es,[SampleSeg]
	int     21h

	mov     ax,4c00h        ; termine le programme
	int     21h

;***************************************************************************
;*      Charge le fichier contenant le sample
;*
;* Entre:
;*      DS:DX   nom du fichier son
;*
;* Sortie:
;*      AX      erreur

PROC    loadsmp

	mov     ax,3d00h        ; ouvre le fichier
	int     21h
	jnc     @@no_error
@@error:
	ret
@@no_error:
	mov     bx,ax

	mov     ax,4202h        ; cherche la taille du fichier
	xor     cx,cx
	xor     dx,dx
	int     21h

	mov     [word ptr ds:OFFSET SampleLen],ax       ; Stocke la taille
	mov     [word ptr ds:OFFSET SampleLen+2],dx     ; pour startdac

	add     ax,15   ; Reserve la place mmoire ncessaire
	adc     dx,0
	shr     ax,4
	mov     dh,dl
	shl     dh,4
	or      ah,dh
	push    bx
	mov     bx,ax
	mov     ah,48h
	int     21h
	pop     bx
	jc      @@error
	mov     [ds:SampleSeg],ax

	push    ds
	mov     ds,ax

	mov     ax,4200h        ; On revient au dbut du fichier
	xor     cx,cx
	xor     dx,dx
	int     21h

	xor     dx,dx
@@read_sample:
	mov     ah,3Fh          ; On lit le fichier par bout de 65520 octets
	mov     cx,0FFF0h
	int     21h

	add     dx,ax
	jnc     @@same_seg
	mov     cx,ds
	add     cx,1000h
	mov     ds,cx
@@same_seg:
	cmp     ax,0FFF0h
	je      @@read_sample

	pop     ds
	mov     ah,3eh          ; Finie, on ferme le fichier
	int     21h

	ret
ENDP

;***************************************************************************
;*      Commence la restitution du son sur le DAC
;*
;* Entre:
;*      Dans [ds:SampleSeg] l'adresse de dbut du sample
;*      Dans [ds:SampleLen] la longueur du sample

PROC    startdac

	xor     ax,ax   ; Calcule l'adresse de dbut et de fin du sample
	mov     [word ptr cs:OFFSET SampleAdr],ax
	mov     ax,[word ptr ds:SampleLen]
	mov     [word ptr cs:OFFSET SampleEnd],ax
	mov     ax,[ds:SampleSeg]
	mov     [word ptr cs:OFFSET SampleAdr+2],ax
	mov     [word ptr cs:OFFSET SampleEnd+2],ax
	mov     ax,[word ptr ds:SampleLen+2]
	shl     al,4
	add     [byte ptr cs:OFFSET SampleEnd+3],al

	push    ds
	mov     ax,INT_SEG              ; Recupre l'adresse du DAC
	mov     ds,ax
	mov     bx,LPT2ADR
	mov     ax,[ds:bx]
	mov     [cs:OFFSET portdac+1],ax

	cli
	mov     ax,INT_SEG
	mov     ds,ax
	mov     bx,IRQ0ADR
	mov     ax,[word ptr ds:bx]             ; Lit l'ancien vecteur
	mov     [word ptr cs:OFFSET OldInt],ax
	mov     ax,[word ptr ds:bx+2]
	mov     [word ptr cs:OFFSET OldInt+2],ax

	mov     ax,OFFSET sounddac              ; place le nouveau
	mov     [word ptr ds:bx],ax
	mov     ax,cs
	mov     [word ptr ds:bx+2],ax

	mov     al,00110110b    ; Place la frquence voulus
	out     43h,al
	mov     ax,SAMPFRQ
	mov     [cs:OFFSET frqcompt+5],ax
	out     40h,al
	mov     al,ah
	out     40h,al
	sti

	pop     ds

	mov     [cs:Stop],0     ; Indique au programme que l'on joue le son

	ret

ENDP

;****************************************************************************
;*      Cette fonction envoit un octet du son echantillon au DAC
;*

PROC    sounddac

	push    ax
	push    dx
	push    si
	push    ds

	lds     si,[cs:SampleAdr]       ; Rcupre l'octet et avance le
	mov     al,[ds:si]              ; pointeur (segment et offset)
	inc     si
	mov     [word ptr cs:OFFSET SampleAdr],si
	jnz     @@same_seg
	add     [word ptr cs:OFFSET SampleAdr+2],1000h
@@same_seg:

portdac:
	mov     dx,1234h        ; Code auto modifi

	add     al,128          ; envoit l'octet sign au DAC
	out     dx,al

	cmp     si,[word ptr cs:OFFSET SampleEnd]
	je      @@test_seg

@@not_the_end:
	pop     ds              ; On n'a pas fini le sample
	pop     bx
	pop     dx

frqcompt:
	add     [cs:Compteur],1234h     ; code automodifi
	jc      @@call_old_it

	mov     al,20h  ; Signale la fin de l'interruption au PIC
	out     20h,al
	pop     ax
	iret

@@call_old_it:   ; L'ancienne interruption est rappel en moyenne  18.2Hz
	pop     ax
	jmp     [dword ptr cs:OldInt]

@@test_seg:
	mov     ax,[word ptr cs:OFFSET SampleEnd+2]
	cmp     ax,[word ptr cs:OFFSET SampleAdr+2]
	jne     @@not_the_end

	call    stopdac
	jmp     @@not_the_end

ENDP

;***************************************************************************
;*      Procdure arrtant le son sur la DAC, remet l'ancienne routine
;*      d'interruption et replace la frquence du timer

PROC    stopdac

	push    ds                      ; Replace l'ancienne routine
	mov     ax,INT_SEG
	mov     ds,ax
	mov     bx,IRQ0ADR
	mov     ax,[word ptr cs:OFFSET OldInt]
	mov     [word ptr ds:bx],ax
	mov     ax,[word ptr cs:OFFSET OldInt+2]
	mov     [word ptr ds:bx+2],ax
	pop     ds

	mov     al,00110110b    ; Remet la frquence 18.2Hz normal du timer
	out     43h,al
	xor     al,al
	out     40h,al
	out     40h,al

	mov     [cs:Stop],1     ; Indique au programme la fin du son

	ret

ENDP

STACK   200h

END     start
