/*
  Programme d'exemple des routines de gestion de l'XMS

  Copyright (c) 1994 Jrme Stolfo "Ultiman"
  Pour le Reporter no 4
*/

#include <conio.h>
#include <stdlib.h>
#include <process.h>
#include "xms.h"

void Error();

void main()
{
   int vernum;
   unsigned largest, free,
            handle;
   struct XMSMoveStruct mStr;
   char string[50]="Ceci est un exemple de donnes...";
   char dString[50];
   void far *ptr=0;
   unsigned char lock,freeHandles;
   unsigned length;


   /* initialisation */
   if (!XMSInit())
   {
      printf("Erreur  l'initialisation de l'XMS.\n");
      exit(1);
   }

   /* Version */
   vernum=XMSGetVersion();
   printf("Numro de version : %d. %d\n",vernum>>8,vernum&255);

   /* Mmoire libre */
   XMSGetFreeMem( &largest, &free);
   printf("Plus grand bloc disponible : %u Ko.\n",largest);
   printf("Mmoire XMS libre : %u Ko.\n\n",free);

   /* Essaie d'allouer de la mmoire */
   handle=0;
   printf("Essaie d'allouer de la mmoire tendue...");
   if ( !XMSAllocate( 100, &handle) ) Error();

   /* Libre la mmoire */
   printf("OK. Handle no %u.\nEssaie de librer la mmoire...",handle);
   if ( !XMSFree( handle) ) Error();

   printf("OK.\n\n");

   /* Transfre RAM->XMS */
   XMSAllocate( 1, &handle);

   mStr.Length=50;
   mStr.SourceHandle=0; /* RAM conventionnelle */
   mStr.SourceOffset=(unsigned long)string; /* Adresse */
   mStr.DestHandle=handle; /* XMS */
   mStr.DestOffset=0;      /*  partir du dbut du bloc */
   printf("Texte : %s\n",string);
   printf("Transfert de bloc, RAM->XMS...");
   if ( !XMSMove( &mStr) ) Error();

   printf("OK.\nTransfert XMS->RAM..."); /* les transferts XMS->XMS sont aussi
                                            possibles */

   mStr.Length=50;
   mStr.SourceHandle=handle;
   mStr.SourceOffset=0;

   mStr.DestHandle=0;
   mStr.DestOffset=(unsigned long)dString;

   if ( !XMSMove( &mStr) ) Error();

   printf("OK.\nTexte : %s\n\n",dString);
   XMSFree( handle);

   /* Vrrouillage / Dverrouillage */
   XMSAllocate( 10, &handle);
   printf("Verrouille un bloc...");
   if( !XMSLock( handle, ptr)) Error();

   printf("OK.\nDemande des informations :");
   if( !XMSGetInfo( handle, &lock, &freeHandles, &length)) Error();

   printf("OK:\nLock count: %d. Handles libres : %d",(int)lock,
          (int)freeHandles);
   printf(". Taille : %u Ko.\n",length);

   printf("Maintenant dverrouille...");
   if( !XMSUnlock( handle)) Error();

   printf( "OK.\n");

   /* Rallocation */
   printf("Essaie de rallouer  20Ko...");
   if ( !XMSRealloc( 20, handle)) Error();

   XMSGetInfo( handle, &lock, &freeHandles, &length);
   printf("OK. Nouvelle taille : %u.\n",length);

   XMSFree( handle);

   getch();
}

void Error()
{
   printf("Impossible !\n");
   printf("Erreur : %d\n", XMSGetError());
   exit(1);
}
