/************************************************************************\
* File : XMS.h                                                           *
**************************************************************************
* Fonctions de gestion de la mmoire tendue en C et ASM.                *
*                                                                        *
* Ecrit pour le Reporter no4                                             *
*                                                                        *
* Copyright (c) 1994 Jrme Stolfo (UltimaN)                             *
*                                                                        *
* Bas sur le document :                                                 *
* "eXtended Memory Specification (XMS), ver 3.00", by Microsoft(r),      *
* Lotus(r), Intel(r), AST(r) Research.                                   *
\************************************************************************/

#ifndef _XMS_H_
#define _XMS_H_

/* Structure pour les transferts de blocs de mmoire */
struct XMSMoveStruct {
   unsigned long Length; /* longueur du bloc  transfrer */

   unsigned int  SourceHandle; /* no du handle  dplacer (0 : RAM) */
   unsigned long SourceOffset; /* offset dans le handle (ou pointeur sur la
                                  zone si on dplace  partir de la RAM */
   unsigned int  DestHandle; /* Comme pour la source, mais pour le bloc
                                destination */
   unsigned long DestOffset;
};


/********************************************/
/* Initialisation de la librairie et du     */
/* driver.                                  */
/*                                          */
/* Parametres : aucun                       */
/* Retour  : 1 succs                       */
/*           0 erreur (voir UXMSGetError()) */
/********************************************/
extern int   XMSInit();

/********************************************/
/* Retourne la dernire erreur              */
/*                                          */
/* Paramtres : aucun                       */
/* Retour  : numro de l'erreur (0: OK)     */
/********************************************/
extern int   XMSGetError();

/********************************************/
/* Remet  0 l'erreur aprs traitement      */
/*                                          */
/* Paramtres : aucun                       */
/* Retour  : aucun                          */
/********************************************/
extern void   XMSResetError();

/********************************************/
/* Retourne la version de driver XMS        */
/*                                          */
/* Paramtres : aucun                       */
/* Retour  : int (hi  byte : numro     :3) */
/*               (lo  byte : no de rv. :00)*/
/********************************************/
extern int   XMSGetVersion();

/********************************************/
/* Retourne des informations sur la mmoire */
/* libre.                                   */
/*                                          */
/* Paramtres : Retour : bloc le plus grand */
/*                       mmoire libre      */
/********************************************/
extern void   XMSGetFreeMem( unsigned far *largest, unsigned far *freemem);

/********************************************/
/* Alloue de la mmoire tendue             */
/*                                          */
/* Paramtres : taile du bloc en Ko         */
/*              retour : handle du bloc     */
/* Retour  : 1 succs                       */
/*           0 erreur                       */
/********************************************/
extern int   XMSAllocate( unsigned size, unsigned far *handle);

/********************************************/
/* Ralloue de la mmoire tendue           */
/*                                          */
/* Paramtres : taille du bloc en Ko        */
/*              out: handle du bloc         */
/* Retour  : 1 succs                       */
/*           0 erreur                       */
/********************************************/
extern int   XMSRealloc( unsigned size, unsigned handle);

/********************************************/
/* Libre un handle                         */
/*                                          */
/* Paramtres : handle du bloc  librer    */
/* Retour  : 1 succs                       */
/*           0 erreur                       */
/********************************************/
extern int   XMSFree( unsigned handle);

/********************************************/
/* Transfre un bloc (XMS<->XMS ou XMS<->RAM*/
/*                                          */
/* Paramtres : structure XMSMoveStruct     */
/* Retour  : 1 succs                       */
/*           0 erreur                       */
/********************************************/
extern int   XMSMove( struct XMSMoveStruct far *);

/********************************************/
/* Verrouille un bloc en XMS (pour qu'il    */
/* ne bouge pas)                            */
/*                                          */
/* Paramtres: handle  vrouiller          */
/*             out: adresse 32-bit du bloc  */
/* Retour  : 1 succs                       */
/*           0 erreur                       */
/********************************************/
extern int   XMSLock( unsigned handle, void far *address);

/********************************************/
/* Dverouille le bloc                      */
/*                                          */
/* Paramtres : handle ud bloc  dverrouil.*/
/* Retour  : 1 succs                       */
/*           0 erreur                       */
/********************************************/
extern int   XMSUnlock( unsigned handle);

/********************************************/
/* Retourne des infos sur un bloc           */
/*                                          */
/* Paramtres : handle  inspecter          */
/*              retour : verrouillage       */
/*                   Nb de handle libres    */
/*                   Taille du bloc en Ko   */
/* Retour  : 1 succs                       */
/*           0 erreur                       */
/********************************************/
extern int   XMSGetInfo( unsigned handle, unsigned char far *lock,
                         unsigned char far *freehandles,
                         unsigned far *freemem);

#endif