
Code         SEGMENT PARA
             ORG 100h
             ASSUME CS:Code,DS:Code


;============================================================================;
;                          ZONE RESIDENTE                                    ;
;============================================================================;


Start:       JMP   InstallPart

;
;            -=- Donnes -=-
;

AddOrgInt08h EQU   THIS DWORD             ; Ancien vecteur d'interruption 8h
OfsOrgInt08h DW    (?)           
SegOrgInt08h DW    (?)
AddOrgInt13h EQU   THIS DWORD             ; Ancien vecteur d'interruption 13h
OfsOrgInt13h DW    (?)
SegOrgInt13h DW    (?)
AddOrgInt28h EQU   THIS DWORD             ; Ancien vecteur d'interruption 28h
OfsOrgInt28h DW    (?)
SegOrgInt28h DW    (?)
InDos        EQU   THIS DWORD             ; Pointeur sur variable DOS InDos
OfsInDos     DW    (?)
SegInDos     DW    (?)

VideoSeg     EQU   ModifS+1
Int13hCalled DB    00h
LastSecond   DB    (?)
Mark         DB    'OP'

;
;            -=- Routine d'appel de l'horloge, mise sous interruption -=-
;

Clock        PROC  FAR
             PUSH  BX
             PUSH  DS

             LDS   BX,CS:InDos
             OR    BYTE PTR DS:[BX],0 ; DOS dj appel ?
             JNZ   DosCalled
             OR    BYTE PTR CS:[Int13hCalled],0 ; Int. accs disque ?
             JNZ   DosCalled

             CALL  AffClock           ; NON -> on peut l'appeler sans risques

DosCalled:   POP   DS
             POP   BX
             JMP   CS:[AddOrgInt08h]   ; Vers l'ancienne routine
Clock        ENDP

;
;            -=- Routine d'affichage de l'heure -=-
;

AffClock     PROC  NEAR               ; Modifie BX et DS
             PUSH  AX
             PUSH  CX
             PUSH  DX
             PUSH  DI
             PUSH  SI
             PUSH  ES
             PUSH  BP

             PUSH  CS                 ; Mieux vaut ne pas l'oublier
             POP   DS

             MOV   AH,2ch
             INT   21h

             CMP   DH,LastSecond      ; L'heure doit-elle raffiche ?
             JZ    NoAff2
             MOV   LastSecond,DH
             
             XOR   DI,DI
ModifS:      MOV   AX,0b800h
             MOV   ES,AX
             MOV   AL,CH
             CALL  AffByte
             MOV   AL,':'
             STOSB
             INC   DI
             MOV   AL,CL
             CALL  AffByte
             MOV   AL,':'
             STOSB
             INC   DI
             MOV   AL,DH
             CALL  AffByte

NoAff2:      POP   BP
             POP   ES
             POP   SI
             POP   DI
             POP   DX
             POP   CX
             POP   AX
             RET
AffClock     ENDP

;
;            -=- Sous programme de l'horloge -=-
;

AffByte      PROC  NEAR
             XOR   AH,AH               ; En entre : AL=Byte, ES:DI=Pos
             MOV   DL,10
             DIV   DL                  ; AL=dixaines, AH=units
             ADD   AL,30h              ; ASCII affichable
             STOSB                     ; Ecrit dixaines
             INC   DI
             MOV   AL,AH
             ADD   AL,30h
             STOSB                     ; Ecrit units
             INC   DI
             RET
AffByte      ENDP

;
;            -=- Flag install dans l'interruption 13h -=-
;
NewInt13h    PROC  FAR
             MOV   CS:[Int13hCalled],0ffh  ; Flag  1

             PUSHF                         ; Appel ancienne routine
             CALL  CS:[AddOrgInt13h]

             MOV   CS:[Int13hCalled],0ffh  ; Flag  0
             IRET
NewInt13h    ENDP

;
;            -=- Chanage de l'interruption 28h -=-
;

NewInt28h    PROC  FAR

             PUSHF                     ; Car IRET au retour et non RET
             CALL  CS:[AddOrgInt28h]   ; Appel de l'ancienne routine

             PUSH  BX
             PUSH  DS
             CALL  AffClock
             POP   DS
             POP   BX

             IRET
NewInt28h    ENDP

;
;

InstEnd      EQU     THIS BYTE               


;============================================================================;
;                ZONE EFFACEE APRES CHAQUE APPEL                             ;
;============================================================================;


Installm     DB "Programme activ",13,10,"$"
Elimine      DB "Programme dsactiv",13,10,"$"

;
;            -=- Initialisation -=-
;

InstallPart: MOV   AX,3508h            ; Horloge installe ?
             INT   21h
             CMP   WORD PTR ES:[BX-2],'PO'
             JNZ   Install             ; Non --> l'installe

;
;            -=- Elimination du rsident -=-
;

             MOV   DX,ES:OfsOrgInt08h  ; Rinstalle ancienne routine 08h
             MOV   AX,ES:SegOrgInt08h
             MOV   DS,AX
             MOV   AX,2508h
             INT   21h

             MOV   DX,ES:OfsOrgInt13h  ; Rinstalle ancienne routine 13h
             MOV   AX,ES:SegOrgInt13h
             MOV   DS,AX
             MOV   AX,2513h
             INT   21h

             MOV   DX,ES:OfsOrgInt28h  ; Rinstalle ancienne routine 28h
             MOV   AX,ES:SegOrgInt28h 
             MOV   DS,AX
             MOV   AX,2528h
             INT   21h

             PUSH  ES                  ; Libration de la mmoire
             MOV   ES,ES:[2ch]         ; occupe par l'environnement
             MOV   AH,49h              ; (adresse segment dans le PSP)
             INT   21h

             POP   ES                  ; Libration de la mmoire
             MOV   AH,49h              ; occupe par le rsident
             INT   21h

             PUSH  CS                  ; Affichage chane
             POP   DS
             MOV   DX,Offset Elimine
             MOV   AH,9
             INT   21h

             MOV   AX,4c00h
             INT   21h

;
;            -=- Mise en place du rsident
;

Install:     MOV   AX,3508h            ; Sauve ancien vecteur 08h
             INT   21h
             MOV   SegOrgInt08h,ES
             MOV   OfsOrgInt08h,BX

             MOV   DX,Offset Clock     ; Installe nouvelle routine 08h
             MOV   AX,2508h
             INT   21h

             MOV   AX,3513h            ; Sauve ancien vecteur 13h
             INT   21h
             MOV   SegOrgInt13h,ES
             MOV   OfsOrgInt13h,BX

             MOV   DX,Offset NewInt13h ; Installe nouvelle routine 13h
             MOV   AX,2513h
             INT   21h

             MOV   AX,3528h            ; Sauve ancien vecteur 28h
             INT   21h
             MOV   SegOrgInt28h,ES
             MOV   OfsOrgInt28h,BX

             MOV   DX,Offset NewInt28h ; Installe nouvelle routine 28h
             MOV   AX,2528h
             INT   21h

             MOV   AH,34h              ; Rcupre adresse InDos
             INT   21h
             MOV   SegInDos,ES
             MOV   OfsInDos,BX

             MOV   DX,Offset InstallM  ; Affiche chane
             MOV   AH,9
             INT   21h

             MOV   DX,Offset InstEnd   ; Calcul du nombre de paragraphes
             MOV   CL,4                ; utiliss par le PSP, les routines
             SHR   DX,CL               ; rsidentes et leurs donnes
             INC   DX
             MOV   AX,3100h
             INT   21h                 ; termine en restant rsidant

Code         ENDS
             END   Start

