
Code         SEGMENT PARA
             ORG     100h
             ASSUME  CS:Code,DS:Code

Start:       JMP   FlipCfg

;
;            -=- Procdure mise sous interruption -=-
;

NewInt17h    PROC  FAR
             OR    AH,AH               ; Est-ce la fonction d'impression ?
             JNZ   NoConvert           ; Non, on ne convertie pas
             PUSH  BX
             CALL  Eight2Seven         ; Oui, on appelle la sous-routine
             POP   BX
NoConvert:   JMP   CS:[AddOldInt17h]   ; Appel de l'ancienne routine
NewInt17h    ENDP

;
;            -=- Conversion Ascii 8bits -> 7bits (via AL) -=-
;

Eight2Seven  PROC  NEAR
             CMP   AL,80h              ; Est-ce de l'ASCII tendu ?
             JB    End827              ; Non -> pas de conversion

             SUB   AL,80h              ; Oui -> rcupre octet dans Table
             MOV   BX,Offset Table
             PUSH  DS
             PUSH  CS
             POP   DS
             XLATB
             POP   DS
End827:      RET
Eight2Seven  ENDP

;
;            -=- Table de conversion -=-
;

Table        DB    'Cueaaaac'
             DB    'eeeiiiAA'
             DB    'E  ooouu'
             DB    'yOUcLYPf'
             DB    'aiounNao'
             DB    '?--  !""'
             DB    '###|++++'
             DB    '+*|**+++'
             DB    '++++-+++'
             DB    '*****=*+'
             DB    '++++++++'
             DB    '+++#####'
             DB    'abgPSsmt'
             DB    'PTod 0e '
             DB    '=+><||-~'
             DB    'oo.V 2# '

;
;            -=- Donnes -=-
;

AddOldInt17h EQU   THIS DWORD
OffOldInt17h DW    (?)
SegOldInt17h DW    (?)
TSRCodeSize  EQU   Offset AddOldInt17h - Offset NewInt17h

;
;            -=- Fin de la partie rsidante -=-
;

EndResPart   EQU   THIS BYTE

;
;            -=- Routine d'installation / dsinstallation -=-
;

FlipCfg      PROC  NEAR
             MOV   AH,09h
             MOV   DX,Offset MComm
             INT   21h                     ; Message commun aux deux routines

             MOV   AX,3517h
             INT   21h                     ; Rcupre adresse du vecteur printer

             MOV   DI,BX                   ; ES:DI = routine d'interruption
             MOV   SI,Offset NewInt17h     ; DS:SI = notre rsident
             MOV   CX,TSRCodeSize
             REP   CMPSB                   ; Est-ce la mme chose ?

             JZ    Desinstall              ; Si oui, te le rsident
FlipCfg      ENDP

;
;            -=- Procdure d'installation -=-
;

Install      PROC  NEAR                ; Si non, excute ceci
             MOV   AX,ES
             MOV   SegOldInt17h,AX
             MOV   OffOldInt17h,BX     ; Sauvegarde de l'ancien vecteur

             MOV   DX,Offset NewInt17h
             MOV   AX,2517h
             INT   21h                 ; Installation de la nouvelle routine

             MOV   AH,09h
             MOV   DX,Offset Minst
             INT   21h                 ; Affiche message d'installation

             MOV   AX,3100h
             MOV   DX,Offset EndResPart
             MOV   CL,4
             SHR   DX,CL
             INC   DL                  ; Calcule taille partie rsidante
             INT   21h                 ; Termine en restant rsidant
Install      ENDP

;
;            -=- Procdure de dsinstallation -=-
;

Desinstall   PROC  NEAR
             MOV   DX,ES:OffOldInt17h
             MOV   AX,ES:SegOldInt17h
             MOV   DS,AX
             MOV   AX,2517h
             INT   21h                 ; Restaure l'ancienne adresse

             MOV   BX,ES
             MOV   ES,ES:[2ch]
             MOV   AH,49h
             INT   21h                 ; Libre mmoire d'environnement

             MOV   ES,BX
             MOV   AH,49h
             INT   21h                 ; Libre la mmoire du TSR

             PUSH  CS
             POP   DS                  ; DS modifi prcedemment

             MOV   AH,09h
             MOV   DX,Offset MDesinst
             INT   21h                 ; Affichage du message

             MOV   AX,4c00h
             INT   21h                 ; Fin de programme
Desinstall   ENDP

;
;            -=- Messages -=-
;

MComm        DB    'TSR d',27h,'impression 7 bits $'
MInst        DB    'install',0dh,0ah,'$'
MDesinst     DB    'dsinstall',0dh,0ah,'$'

;
;
;

Code         ENDS
             END Start

