program micro;
{****** 'MICRO' INTERPRETE D'EXPRESSIONS MATHEMATIQUES ***********}
uses crt;

type tident=string[6];
const maxPriorite=3;
      nbIdent=18;
      termine='%';
      chiffre:set of char=['0'..'9'];
      lettre:set of char=['A'..'Z'];
      symbolePermis:set of char=['+','-','/','*','^','(',')'];
      debutTerme:set of char=['(','N','F'];
      operateur:array[1..maxPriorite] of set of char=
           (['+','-','O'],['*','/','D','A','M'],['^']);
      { 'O':pour OR
        'A':pour AND
        'D':pour division entire
        'M':pour MOD }
      identificateur:array[1..nbIdent] of tident=(
       'PI','AND','OR','MOD','DIV','ABS','ARCTAN','COS','EXP','FRAC',
       'TRUNC','LOG','LN','ROUND','SIN','SQR','SQRT','TAN');

type float= {$IFDEF CPU87} extended {$ELSE} real {$ENDIF};
     numer= record case typ:char of
       {donne numrique, soit entire soit relle}
       'R': (xr:float);
       'I': (xi:longInt);
     end;

var erreur:boolean;
    LexCode:char;        {sorties de l'analyseur lexical}
    valeur:numer;        {valeur de sortie analyseur lexical}
    precedent,curseur:integer;  {curseurs de l'analyseur lexical}
    chaine:string;       {l'expression  analyser}

{*** Micro Gestionnaire d'erreurs ***}

procedure CasErreur(message:string);
begin
  writeln(copy(chaine,1,precedent-1)+' _ '+chaine[precedent]);
  writeln('ERREUR: ',message);
  erreur:=true;
end;

{*** Micro Analyseur lexical ***}

procedure lisConstante;  {constante entire ou relle}
var s:string; inutilise:integer; numerateur,denominateur,provisoire:longint;
begin
  s:='';
  while chaine[curseur] in chiffre do begin
    s:=s+chaine[curseur]; curseur:=succ(curseur);
  end; {while}
  val(s,provisoire,inutilise);
  if chaine[curseur]<>'.' then with valeur do begin {c'est un entier}
    typ:='I'; xi:=provisoire;
  end else begin  {c'est un rel!}
    curseur:=succ(curseur); {saute le point dcimal}
    denominateur:=1;
    s:='';
    while chaine[curseur] in chiffre do begin
       s:=s+chaine[curseur]; curseur:=succ(curseur);
       denominateur:=10*denominateur;
    end; {while}
    val(s,numerateur,inutilise);
    with valeur do begin
      typ:='R'; xr:=provisoire+numerateur/denominateur;
    end;
  end;
  LexCode:='N'; {numrique}
end;

procedure lisIdent;
{lis chaine de caractre de l'identificateur}
var s:string; i:integer;
begin
  s:='';
  while upcase(chaine[curseur]) in lettre do begin
    s:=s+upcase(chaine[curseur]); curseur:=succ(curseur);
  end; {while}
  i:=0;
  repeat i:=succ(i) until (s=identificateur[i]) or (i>nbIdent);
  if i>nbIdent then casErreur('Identificateur inconnu')
  else case i of {mot cl reconnu}
    1: begin   {valeur numrique PI}
         lexCode:='N'; valeur.typ:='R'; valeur.xr:=4*arctan(1);
       end;
    2: lexCode:='A';
    3: lexCode:='O';
    4: lexCode:='M';
    5: lexCode:='D';
    else begin lexCode:='F'; valeur.typ:='I'; valeur.xi:=i-5; end;
  end; {case}
end;

procedure suivant;   {le coeur de l'analyseur lexical}
begin
  while (chaine[curseur]=' ') do curseur:=succ(curseur);  {vite les blancs}
  precedent:=curseur;   {pour le gestionnaire d'erreur}
  if (chaine[curseur] in chiffre) then lisConstante
  else if (upcase(chaine[curseur]) in lettre) then lisIdent
  else begin
    LexCode:=chaine[curseur];
    if (LexCode in SymbolePermis) then curseur:=succ(curseur)
    else if LexCode<>termine then casErreur('Symbole Inconnu');
  end; {else}
end; {suivant}

procedure InitLex; {initialisation de l'analyseur lexical}
begin
  erreur:=false; curseur:=1; precedent:=1;
  chaine:=chaine+termine;
  suivant; {un premier passage initial}
end;


{*** Micro Interprete d'Expressions relles ***}

procedure compatible(var terme1,terme2:numer; code:char);
{effectue transtypage si ncessaire}
var prov:float;
begin
  case code of
    'A','O','D','M': if not((terme1.typ='I') and (terme2.typ='I')) then
       casErreur('Oprateur rserv aux entiers');
    '+','-','*','^': if (terme1.typ<>terme2.typ) then begin {transtypage}
       with terme1 do if typ='I' then begin prov:=xi; typ:='R'; xr:=prov; end;
       with terme2 do if typ='I' then begin prov:=xi; typ:='R'; xr:=prov; end;
     end; {transtypage}
    '/': begin {force les rels}
       with terme1 do if typ='I' then begin prov:=xi; typ:='R'; xr:=prov; end;
       with terme2 do if typ='I' then begin prov:=xi; typ:='R'; xr:=prov; end;
     end;
  end; {case}
end;

procedure operation(terme1,terme2:numer; code:char; var resultat:numer);
var prov,i:longInt;
begin
  {verification de compatibilit des types}
  compatible(terme1,terme2,code);
  if not(erreur) then with resultat do begin
    typ:=terme1.typ; {car transtypage dja fait}
    case code of
     'A':xi:=terme1.xi and terme2.xi;
     'O':xi:=terme1.xi or terme2.xi;
     'M':xi:=terme1.xi mod terme2.xi;
     'D':if terme2.xi<>0 then xi:=terme1.xi div terme2.xi else
           casErreur('Division (entire) par zro');
     '+':if typ='I' then xi:=terme1.xi+terme2.xi else xr:=terme1.xr+terme2.xr;
     '-':if typ='I' then xi:=terme1.xi-terme2.xi else xr:=terme1.xr-terme2.xr;
     '*':if typ='I' then xi:=terme1.xi*terme2.xi else xr:=terme1.xr*terme2.xr;
     '/':if terme2.xr<>0 then xr:=terme1.xr/terme2.xr else
             casErreur('Division par zro');
     '^':if typ='I' then begin
           if terme2.xi<0 then casErreur('Mise  une puissance ngative')
           else begin
             prov:=1;
             for i:=1 to terme2.xi do prov:=prov*terme1.xi;
             xi:=prov;
           end;
        end else {cas des rels}
          if terme1.xr<0 then casErreur('Premier terme ngatif')
          else xr:=exp(terme2.xr*ln(terme1.xr));
    end; {case code}
  end; {if not(erreur)}
end; {operation}

procedure fonction(numfonct:integer; var resultat:numer);
{effectue l'operation mathmatique de la fonction unaire}
var x:float;
begin
  with resultat do begin
    if typ='I' then x:=xi else x:=xr; {transtypage utilis que si ncessaire}
    case numfonct of
      1:{ABS} if typ='I' then xi:=abs(xi) else xr:=abs(xr);
      2:{ARCTAN} begin typ:='R'; xr:=arctan(x); end;
      3:{COS} begin typ:='R'; xr:=cos(x); end;
      4:{EXP} begin typ:='R'; xr:=exp(x); end;
      5:{FRAC} begin typ:='R'; xr:=frac(x); end;
      6:{TRUNC} if typ='R' then begin xi:=trunc(x); typ:='I';end;
      7:{LOG} begin typ:='R'; xr:=ln(x)/ln(10); end;
      8:{LN} begin typ:='R'; xr:=ln(x); end;
      9:{ROUND} if typ='R' then begin xi:=round(x); typ:='I'; end;
      10:{SIN} begin typ:='R'; xr:=sin(x); end;
      11:{SQR} if typ='I' then xi:=sqr(xi) else xr:=sqr(xr);
      12:{SQRT} if (x<0) then casErreur('SQRT(negatif)')
                else begin typ:='R'; xr:=sqrt(x); end;
      13:{TAN} begin typ:='R';
                     if cos(x)=0 then casErreur('tangente infinie')
                     else xr:=sin(x)/cos(x);
               end;
    end; {case}
  end; {with resultat}
end; {fonction}

procedure expression(var resultat:numer); forward; {rcursivit oblige!}

procedure termeFinal(var resultat:numer);
var numFonct,posErreur1,posErreur2:integer;
begin
  case LexCode of
    'N':begin resultat:=valeur; suivant; end;
    '(':begin    {gestion des parenthses}
          suivant;
          if not(erreur) then expression(resultat);
          if not(erreur) then if LexCode=')' then suivant
                              else casErreur('Symbole ) attendu');
        end;
    'F':begin    {fonctions mathmatiques}
          numFonct:=valeur.xi;  suivant;
          if not(erreur) then if (lexCode='(') then suivant
                             else casErreur('Symbole ( attendu');
          posErreur1:=precedent; {recupere position curseur}
          if not(erreur) then expression(resultat);
          if not(erreur) then if LexCode=')' then suivant
                              else casErreur('Symbole ) attendu');
          if not(erreur) then begin
            posErreur2:=precedent; {sauve position curseur}
            precedent:=posErreur1; {remet l'ancien}
            fonction(numFonct,resultat);
            precedent:=posErreur2; {remet le curseur correct..}
          end;
        end;
    else casErreur('(, fonction ou numrique attendu');
  end; {case}
end; {termeFinal}

procedure terme(priorite:integer; changeSigne:boolean; var resultat:numer);
var terme1,terme2:numer; code:char; posErreur1,posErreur2:integer;
begin
  if priorite>maxPriorite then termeFinal(resultat)
  else if (LexCode in debutTerme) then begin {non terminal}
    terme(priorite+1,false,resultat);
    if changeSigne then with resultat do
      if typ='I' then xi:=-xi else xr:=-xr;
    while (not(erreur)) and (LexCode in operateur[priorite]) do begin
      code:=LexCode; suivant;
      posErreur1:=precedent; {recupere position curseur}
      terme1:=resultat;
      if not(erreur) then begin
        terme(priorite+1,false,terme2);
        if not(erreur) then begin
          posErreur2:=precedent; {sauve position curseur actuel}
          precedent:=posErreur1; {remet ancien curseur}
          operation(terme1,terme2,code,resultat);
          precedent:=posErreur2; {remet curseur correct..}
        end;
      end; {if}
    end; {while}
  end else casErreur('Terme attendu');
end;  {terme}

procedure expression(var resultat:numer);
var negatif:boolean;
begin
  if LexCode='-' then negatif:=true else negatif:=false;
  if LexCode in ['+','-'] then suivant;
  if not(erreur) then
    if (LexCode in debutTerme) then terme(1,negatif,resultat)
    else casErreur('Terme attendu');
end;


{*** Micro programme de test ***}

var  resultat:numer;
begin
   repeat
     clrScr; writeln('Donnez une expression:');
     readln(chaine);
     InitLex;                      {initialisation analyseur lexical}
     if not(erreur) then expression(resultat);   {valuation}
     if not(erreur) then begin
       with resultat do if typ='I' then writeln('rsultat entier: ',xi)
                                   else writeln('rsultat rel: ',xr);
       if not(lexCode=termine) then
         casErreur('ATTENTION! Fin de chaine non value');
     end;
     writeln('Encore (O/N) ?');
  until upcase(readkey)='N';
end.