unit palette;
{$N+}
interface
uses global;

type
   pPalette=^PaletteGenerique;
   paletteGenerique=object
     nbCouleurs,NbCoulPalette:word; ratio:byte;
     correction:float;
     constructor initPalette(nbCoul,maxVal:integer);
     destructor finPalette; virtual;
     function choixPalette(coul:couleur):byte; virtual;
     procedure ecart(coul:couleur;color:byte;var erreur:tErreurCoul); virtual;
   end;

var paletteDeBase:tpalette;

procedure selectPaletteMode( var userPalette:pPalette;
          paletteChoix, nbCouleurs, maxValeurPalette:integer);

{--------------------------IMPLEMENTATION-----------------------------------}
implementation
uses modele;

type

  pHSVEGA=^HSVEGA;
  HSVEGA=object(paletteGenerique)
    constructor initPalette(nbCoul,maxVal:integer);
    function choixPalette(coul:couleur):byte; virtual;
    procedure setPaletteHSV(num:byte;hue,sat,val:float);
  end;

  pNoirBlanc=^NoirBlanc;
  NoirBlanc=object(paletteGenerique)
    constructor initPalette(nbCoul,maxVal:integer);
    function choixPalette(coul:couleur):byte; virtual;
    procedure ecart(coul:couleur;color:byte;var erreur:tErreurCoul); virtual;
  end;

  pNoirBlancExt=^NoirBlancExt;
  NoirBlancExt=object(NoirBlanc)
    constructor initPalette(nbCoul,maxVal:integer);
    {choixPalette et ecart herite de NoirBlanc}
  end;

  pRVB884=^RVB884;
  RVB884=object(paletteGenerique)
    constructor initPalette(nbCoul,maxVal:integer);
    function choixPalette(coul:couleur):byte; virtual;
  end;

  pRVB676=^RVB676;
  RVB676=object(paletteGenerique)
    constructor initPalette(nbCoul,maxVal:integer);
    function choixPalette(coul:couleur):byte; virtual;
  end;

  pHSV256=^HSV256;
  HSV256=object(HSVEGA)  {pour bnficier de setPaletteHSV}
    constructor initPalette(nbCoul,maxVal:integer);
    function choixPalette(coul:couleur):byte; virtual;
  end;


  pOptim=^Optim;
  Optim=object(paletteGenerique)
    constructor initPalette(nbCoul,maxVal:integer);
    function choixPalette(coul:couleur):byte; virtual;
  end;


{------------------------PALETTE GENERIQUE----------------------------------}
constructor paletteGenerique.initPalette(nbCoul,maxVal:integer);
begin {bidon} end;

function paletteGenerique.choixPalette(coul:couleur):byte;
begin {bidon} end;

destructor paletteGenerique.finPalette;
begin {bidon} end;

procedure PaletteGenerique.ecart(coul:couleur;color:byte;
                var erreur:tErreurCoul);
{traite le cas le plus courant
! pour acclrer NbCoulPalette vaut 64 cd un de plus que le
  maxPaletteValeur d'avant
  Correction vaut 0.5/256-0.5/nbCoulPalette}
begin
  with erreur do begin
    Rr:=coul.r/256-paletteDeBase[color].r/NbCoulPalette+correction;
    Vr:=coul.v/256-paletteDeBase[color].v/NbCoulPalette+correction;
    Br:=coul.b/256-paletteDeBase[color].b/NbCoulPalette+correction;
  end;
end;

{-------------------------HSV COULEURS EGA----------------------------------}
procedure HSVEGA.setPaletteHSV(num:byte;hue,sat,val:float);
var rouge,vert,bleu:float;
begin
  HSVtoRGB(hue,sat,val,rouge,vert,bleu);
  with paletteDeBase[num] do begin
    {on est pas sur que <1 }
    r:=round(rouge*NbCoulPalette-0.5);
    v:=round(vert*NbCoulPalette-0.5);
    b:=round(bleu*NbCoulPalette-0.5);
  end;
end;

constructor HSVEGA.initPalette(nbCoul,maxVal:integer);
var i:byte; hue:float;
begin
  nbCouleurs:=16; {forc mme si on peut mieux, c'est voulu!}
  NbCoulPalette:=maxVal+1;
  correction:=0.5/256-0.5/nbCoulPalette;
  ratio:=256 div (maxVal+1);
  for i:=0 to 3 do with paletteDeBase[i] do begin  {niveau de gris}
    r:=trunc(NbCoulPalette*(i+0.5)/4);
    v:=r; b:=r;
  end;
  for i:=0 to 5 do begin
    hue:=60*i;
    setPaletteHSV(4+i,hue,1,2/3);
    setPaletteHSV(10+i,hue,1,1);
  end;
end;

function HSVEGA.choixPalette(coul:couleur):byte;
var hue,sat,val:float; color:byte;
begin
  with coul do RGBtoHSV((r+0.5)/256,(v+0.5)/256,(b+0.5)/256,hue,sat,val);
  if sat<0.5 then  color:=trunc(val*4)
  else begin
    color:=4+round(hue/60); {4+de 0  6}
    if color=10 then color:=4;
    if val>0.815 then color:=color+6;
  end;
  choixPalette:=color;
end;

{--------------------------DEGRADE DE GRIS VRAIS----------------------------}
constructor NoirBlanc.initPalette(nbCoul,maxVal:integer);
var i:byte;
begin
  if nbCoul>(maxVal+1) then nbCouleurs:=maxVal+1 else nbCouleurs:=nbCoul;
  {16 ou 64,dpend des limites du driver en niveaux possibles}
  NbCoulPalette:=maxVal+1;
  correction:=0.5/256-0.5/nbCoulPalette;
  ratio:=256 div (maxVal+1);
  for i:=0 to nbCouleurs-1 do with paletteDeBase[i] do begin
    r:=trunc(i*NbCoulPalette/nbCouleurs);
    v:=r; b:=r;
  end;
end;

function NoirBlanc.choixPalette(coul:couleur):byte;
var luminosite:float;
begin
  with coul do luminosite:=0.001168*r+0.002293*v+0.000445*b;
    {0.299/256*r+ 0.587/256*v +0.114/256*b}
  choixPalette:=trunc(luminosite*nbCouleurs);
end;

procedure NoirBlanc.ecart(coul:couleur;color:byte; var erreur:tErreurCoul);
{traite le cas particulier pour palettes Noir et Blanc}
var errLuminosite:float;
begin
  with Coul do
    errLuminosite:=
      0.001168*r+0.002293*v+0.000445*b-color/nbCouleurs+correction;
  with erreur do begin
    Rr:=errLuminosite;
    Vr:=errLuminosite;
    Br:=errLuminosite;
  end;
end;

{--------------------------DEGRADE DE GRIS ETENDU---------------------------}
constructor NoirBlancExt.initPalette(nbCoul,maxVal:integer);
var i:byte;
begin
  nbCouleurs:=4*maxVal+1;
  {tentative d'extension de luminosit, pour cartes 256 couleurs,
   253 niveaux de gris, de 0  252}
  NbCoulPalette:=maxVal+1;
  correction:=0.5/256-0.5/nbCoulPalette;
  ratio:=256 div (maxVal+1);
  for i:=0 to NbCoulPalette-2 do begin
    with paletteDeBase[i*4] do begin r:=i; v:=i; b:=i; end;
    with paletteDeBase[i*4+1] do begin r:=i; v:=i; b:=i+1; end;
    with paletteDeBase[i*4+2] do begin r:=i; v:=i+1; b:=i; end;
    with paletteDeBase[i*4+3] do begin r:=i; v:=i+1; b:=i+1; end;
  end;
  {le dernier niveau  blanc}
  with paletteDeBase[4*NbCoulPalette-4] do begin
    r:=NbCoulPalette-1; v:=r; b:=r;
  end;
end;

{--------------------------CUBE RVB METHODE 884-----------------------------}
constructor RVB884.initPalette(nbCoul,maxVal:integer);
var num,ri,vi,bi:byte;
begin
  nbCouleurs:=nbCoul;
  NbCoulPalette:=maxVal+1;
  correction:=0.5/256-0.5/nbCoulPalette;
  ratio:=256 div (maxVal+1);
  for bi:=0 to 3 do for vi:=0 to 7 do for ri:=0 to 7 do begin
    num:=bi+vi shl 2+ri shl 5;
    with paletteDeBase[num] do begin
      r:=trunc(NbCoulPalette/8*(ri+0.5));
      v:=trunc(NbCoulPalette/8*(vi+0.5));
      b:=trunc(NbCoulPalette/4*(bi+0.5));
    end;
  end;
end;

function RVB884.choixPalette(coul:couleur):byte;
begin
  with coul do choixPalette:=
    (r and $E0)+(v and $E0) shr 3+(b and $C0) shr 6;
end;

{--------------------------CUBE RVB METHODE 676-----------------------------}
constructor RVB676.initPalette(nbCoul,maxVal:integer);
var num,ri,vi,bi:byte;
begin
  nbCouleurs:=nbCoul;
  NbCoulPalette:=maxVal+1;
  correction:=0.5/256-0.5/nbCoulPalette;
  ratio:=256 div (maxVal+1);
  for bi:=0 to 5 do for vi:=0 to 6 do for ri:=0 to 5 do begin
    num:=bi+vi*6+ri*42;
    with paletteDeBase[num] do begin
      r:=trunc(NbCoulPalette/6*(ri+0.5));
      v:=trunc(NbCoulPalette/7*(vi+0.5));
      b:=trunc(NbCoulPalette/6*(bi+0.5));
    end;
  end;
end;

function RVB676.choixPalette(coul:couleur):byte;
begin
  with coul do choixPalette:=
    42*trunc(r*0.023438)+6*trunc(v*0.027344)+trunc(b*0.023438);
    {0.023438=6/256, 0.027344=7/256}
end;

{------------------------------HSV 256--------------------------------------}
constructor HSV256.initPalette(nbCoul,maxVal:integer);
var i,j,k:byte; hue:float; compt:word;
begin
  nbCouleurs:=256;    {pour ce cas particulier}
  NbCoulPalette:=maxVal+1;
  correction:=0.5/256-0.5/nbCoulPalette;
  ratio:=256 div (maxVal+1);
  for i:=0 to 15 do with paletteDeBase[i] do begin
      {niveaux de gris}
    r:=trunc((i+0.5)*NbCoulPalette/16);
    v:=trunc((i+0.5)*NbCoulPalette/16);
    b:=trunc((i+0.5)*NbCoulPalette/16);
  end;
  compt:=16;
  for i:=0 to 11 do begin  {12 couleurs de base}
    hue:=30*i;
    for j:=1 to 5 do begin {5 niveaux d'intensit"+1"}
      for k:=1 to 4 do begin {4 niveaux de saturation"+1"}
        setPaletteHSV(compt,hue,0.125+0.875/4*(k-0.5),0.1+0.9/5*(j-0.5));
        inc(compt);
      end;
    end;
  end;
end;

function HSV256.choixPalette(coul:couleur):byte;
var hue,sat,val:float; color:byte;
begin
  with coul do RGBtoHSV((r+0.5)/256,(v+0.5)/256,(b+0.5)/256,hue,sat,val);
  if (sat<0.125) or (val<0.1) then  color:=trunc(val*16) {niveaux de gris}
  else begin
    color:=round(hue/30); {de 0  12}
    if color=12 then color:=0;  {de 0  11}
    color:=16+20*color+4*trunc((val-0.1)*5.555)+trunc((sat-0.125)*4.571);
    {5/0.9=5.555 4/0.875=4.571}
  end;
  choixPalette:=color;
end;


{--------------------------PALETTE OPTIMISEE -------------------------------}

constructor Optim.initPalette(nbCoul,maxVal:integer);
{attention paletteDeBase sense tre donne par le pilote graphique!}
var i,choix:byte; mini,prov:integer;  coul:couleur;
begin
  nbCouleurs:=nbCoul;
  NbCoulPalette:=maxVal+1;
  correction:=0.5/256-0.5/nbCoulPalette;
  ratio:=256 div (maxVal+1);
  {attention utilise tableau global maTable sens tre correct!}
end;

function cherchePalette(coul:couleur;nbCouleurs:byte):byte;
var i,choix:byte; tot,mini,prov:longint;
begin
  mini:=3000000;
  for i:=1 to nbCouleurs-1 do with palettedeBase[i] do begin
    prov:=r-coul.r; tot:=prov*prov;
    if tot<mini then begin
      prov:=v-coul.v; inc(tot,prov*prov);
      if tot<mini then begin
        prov:=b-coul.b; inc(tot,prov*prov);
        if tot<mini then begin choix:=i; mini:=tot; end;
      end;
    end;
  end;
  cherchePalette:=choix;
end;


function Optim.choixPalette(coul:couleur):byte;
var choix:byte; adresse:word;

begin
  with coul do begin
    adresse:=(r and $F8) shl 7 +(v and $F8) shl 2 +b shr 3;
  end;
  if maTable^[adresse]<>0 then choix:=maTable^[adresse]
  else begin
    with coul do begin
      {rduit la couleur typique de l'adresse considre
       au nombre de bits de la palette}
      r:=(r and $F8 +4) div ratio;
      v:=(v and $F8 +4) div ratio;
      b:=(b and $F8 +4) div ratio;
    end;
    choix:=cherchePalette(coul,nbCouleurs);
    maTable^[adresse]:=choix;
  end;
  choixPalette:=choix;
end;


{----------------------------SELECTPALETTEMODE------------------------------}
procedure selectPaletteMode(var userPalette:pPalette;
          paletteChoix, nbCouleurs, maxValeurPalette:integer);
begin
  case paletteChoix of
    palHSVEGA: userPalette:=new(pHSVEGA,
                     initPalette(nbCouleurs,maxValeurPalette));
    palNoirBlanc: userPalette:=new(pNoirBlanc,
                     initPalette(nbCouleurs,maxValeurPalette));
    palNBExt: userPalette:=new(pNoirBlancExt,
                     initPalette(nbCouleurs,maxValeurPalette));
    palRVB884: userPalette:=new(pRVB884,
                     initPalette(nbCouleurs,maxValeurPalette));
    palRVB676: userPalette:=new(pRVB676,
                     initPalette(nbCouleurs,maxValeurPalette));
    palHSV256: userPalette:=new(pHSV256,
                     initPalette(nbCouleurs,maxValeurPalette));
    palOptim: userPalette:=new(pOptim,
                     initPalette(nbCouleurs,maxValeurPalette));
  end;
end;

begin end.