unit image;
{$N+}
interface
uses crt,global;

procedure getCouleurImage(x,y:float; var coul:couleur);
{Trouve la couleur en fonction de la position x et y [0..1]}
procedure selectImage(imageVoulue:word);
{Slectionne l'image  afficher}
procedure finImage;
{pour fermer proprement en enlevant les variables dynamiques}

var pixelXIm,pixelYIm:integer;

{------------------------IMPLEMENTATION-------------------------------------}
implementation
uses modele;  {pour conversion HSVtoRGB}

const tailleBuf=60000;

type  dataDegrade=array[1..9] of integer;
      pBuf=^Buf;
      Buf=array[0..tailleBuf-1] of byte;

const nbCoupe=12;
      infoCoupe:array[1..nbCoupe] of string=(
      '   1) Vert    Rouge   Noir    Jaune',
      '   2) Bleu    Rouge   Noir    Magenta',
      '   3) Bleu    Vert    Noir    Cyan',
      '   4) Magenta Jaune   Rouge   Blanc',
      '   5) Magenta Cyan    Bleu    Blanc',
      '   6) Cyan    Jaune   Vert    Blanc',
      '   7) Cyan    Rouge   Noir    Blanc',
      '   8) Jaune   Bleu    Noir    Blanc',
      '   9) Magenta Vert    Noir    Blanc',
      '  10) Vert    Magenta Bleu    Jaune',
      '  11) Cyan    Rouge   Magenta Vert',
      '  12) Cyan    Rouge   Bleu    Jaune'
      );
      datacoupe:array[1..nbCoupe] of dataDegrade=(
      (0,1,1,0,0,0,0,0,0),(0,1,0,0,1,0,0,0,0),(0,0,0,1,1,0,0,0,0),
      (0,0,0,1,1,0,1,0,0),(0,1,1,0,0,0,0,0,1),(0,1,0,0,1,0,0,1,0),
      (0,1,1,0,1,0,0,0,0),(0,1,0,1,1,0,0,0,0),(1,0,0,1,1,0,0,0,0),
      (0,1,1,0,-1,0,0,0,1),(-1,0,1,0,0,-1,1,0,1),(0,1,1,0,0,-1,0,0,1)
      );

var imageChoisie:word;
    a:dataDegrade;
    buffer:pBuf;
    Xint,Yint,total,Xlong,Ylong:longint; xDep,yDep:float; oldPage:byte; first:boolean;
    f:file;   fichierTGA:string;
    inverse:boolean;

procedure FixeCouleur(rr,vr,br:float;var coul:couleur);
begin
  with coul do begin
    if (rr<0) or (vr<0) or (br<0) or (rr>1) or (vr>1) or (br>1) then begin
      r:=0; v:=0; b:=0;
    end else begin
      r:=round(255*rr); v:=round(255*vr); b:=round(255*br);
    end;
  end;
end;

procedure selectdegradeRVB;
var i,choix:integer;
begin
  repeat
    clrScr;
    textColor(white);
    writeln('                      *****  COUPE RVB  *****');
    textColor(lightGray);
    writeln;
    writeln('       Choisissez la coupe dans le cube RVB que vous souhaitez!');
    writeln; textColor(Yellow);
    for i:=1 to nbCoupe do writeln(infoCoupe[i]);
    textColor(lightGray);
    writeln; writeln;
    write('            votre choix:');
    readln(choix);
  until (choix>0) and (choix<=nbCoupe);
  a:=dataCoupe[choix];
end;

procedure selectImageTGA;
var i:integer;  extension:boolean;
begin
  clrScr;
  textColor(white);
  writeln('                      *****  IMAGE TGA  *****');
  textColor(yellow);
  writeln;
  writeln('      Nom de fichier de l''image TGA  afficher  (chemin complet)');
  writeln;
  writeln('        Format 24 bits non compress.. (pas de vrification)');
  writeln;
  writeln; writeln;
  textColor(lightGray);
  write('            votre choix:');
  readln(fichierTGA);
  extension:=false;
  for i:=1 to length(fichierTga) do
    if fichierTGA[i]='.' then extension:=true;
  if not(extension) then fichierTGA:=fichierTGA+'.TGA';
end;

procedure fintga;
begin
  dispose(buffer); close(f);
end;

procedure chargePage(page:byte);
var adrs:longint; taille,i:word;
begin
  adrs:=page; adrs:=adrs*tailleBuf;
  if (adrs+tailleBuf>total)
    then taille:=total-adrs else taille:=tailleBuf;
  seek(f,adrs);
  blockread(f,buffer^,taille);
  oldpage:=page;
end;

procedure initTga;
begin
  selectImageTGA;
  new(buffer);
  assign(f,fichierTGA); reset(f,1);
  blockread(f,buffer^,tailleBuf);
  Xlong:=256*buffer^[13]+buffer^[12];
  Ylong:=256*buffer^[15]+buffer^[14];
  pixelXIm:=Xlong; pixelYIm:=Ylong;
  total:=18+3*Xlong*Ylong;
  oldPage:=0;  first:=true;
  if ((buffer^[17] and $20)=0) then inverse:=true else inverse:=false;
end;

procedure getTgaCouleur(x,y:float; var coul:couleur);
var adrs:longint; page:byte;
begin
  if first then begin
    Xdep:=X+0.0001; Ydep:=Y-0.0001;
    Xint:=0; Yint:=0; first:=false;
  end else
    if (Y>Ydep) then begin Xint:=0; Yint:=0; {2eme passe}
    end else
       if (X<Xdep) then begin inc(Yint); Xint:=0; end else inc(Xint);
  if (Xint<Xlong) and (Yint<Ylong) then begin
    if not(inverse) then adrs:=20+3*(Yint*XLong+Xint)
    else adrs:=20+3*((Ylong-1-Yint)*Xlong+Xint);
    page:=adrs div tailleBuf;
    if page<>oldPage then chargePage(page);
    adrs:=adrs mod tailleBuf;
    with coul do begin
      b:=buffer^[adrs-2]; v:=buffer^[adrs-1]; r:=buffer^[adrs];
    end;
  end else with coul do begin r:=0; v:=0; b:=0; end;
end;

procedure getCouleurImage(x,y:float; var coul:couleur);
var rr,vr,br:float;
begin
  case ImageChoisie of
    ImCoupeLum: FixeCouleur(x,(0.5-0.299*x-0.114*y)/0.587,y,coul);
    ImDegradeRVB: FixeCouleur(a[1]*x+a[2]*y+a[7],
        a[3]*x+a[4]*y+a[8],a[5]*x+a[6]*y+a[9],coul);
    ImCoupeHSV: begin
       HSVtoRGB(360*x,y,1,rr,vr,br); FixeCouleur(rr,vr,br,coul); end;
    else getTgaCouleur(x,y,coul);
  end;
end;

procedure selectImage(imageVoulue:word);
begin
  ImageChoisie:=ImageVoulue;
  if ImageChoisie=imDegradeRVB then selectDegradeRVB
  else if ImageChoisie=imTga then initTga;
end;


procedure finImage;
begin
  if ImageChoisie=imTga then finTga;
end;

begin end.