unit driverG;
{contient les mini-drivers graphiques}
interface
uses global;

type
  PDriver=^DriverGenerique;
  DriverGenerique=object
    nbPixelX,nbPixelY,nbCouleurs:word;
    maxValeurPalette:byte;
    trueColor:boolean;
    constructor initDriver;
    destructor finDriver; virtual;
    procedure modeGraphique; virtual;
    procedure modeTexte;
    procedure pixel(x,y:word;couleur:byte); virtual;
    procedure truePixel(x,y:word;coul:couleur); virtual;
    procedure ValidePalette(var palette:tPalette); virtual;
  end;

procedure selectDriver(var userDriver:pDriver;driverVoulu:integer);
{cre l'objet userDriver de type correspondant  driverVoulu}

{------------------------IMPLEMENTATION-------------------------------------}
implementation
uses dos;

type
  PEga=^Ega;
  Ega=object(DriverGenerique)
    constructor initDriver;
    procedure modeGraphique; virtual;
    procedure pixel(x,y:word;couleur:byte); virtual;
    procedure ValidePalette(var palette:tPalette); virtual;
  end;

  PVga=^Vga;
  Vga=object(Ega)
    constructor initDriver;
    procedure modeGraphique; virtual;
    procedure ValidePalette(var palette:tPalette); virtual;
    {procedure pixel recuperee de EGA}
  end;

  Pmcga=^mcga;
  mcga=object(DriverGenerique)
    constructor initDriver;
    procedure modeGraphique; virtual;
    procedure pixel(x,y:word;couleur:byte); virtual;
    procedure ValidePalette(var palette:tPalette); virtual;
  end;

  Pm13X=^m13X;
  m13X=object(mcga)
    constructor initDriver;
    procedure modeGraphique; virtual;
    procedure pixel(x,y:word;couleur:byte); virtual;
  end;

  Pvga400=^vga400;
  vga400=object(mcga)
    constructor initDriver;
    procedure modeGraphique; virtual;
    procedure pixel(x,y:word;couleur:byte); virtual;
  end;

  Pvga480=^vga480;
  vga480=object(vga400)
    constructor initDriver;
    procedure modeGraphique; virtual;
    {procedure pixel heritee de vga400, ca semble marcher}
  end;

const long640:longint=640;

var adresse:longint;  dep:word;  ancBank,Bank:byte;
    {utilises par VGA400, VGA480: ne marche pas si incluses dans l'objet
     probleme de segment?}


{------------------------DRIVER GENERIQUE----------------------------------}

constructor DriverGenerique.initDriver;
begin {bidon} end;

procedure DriverGenerique.modeGraphique;
begin {bidon} end;

procedure DriverGenerique.pixel(x,y:word;couleur:byte);
begin {bidon} end;

procedure DriverGenerique.modeTexte;
var reg:registers;     {pour tous}
begin
  reg.ax:=3;
  intr($10,reg);
end;

procedure DriverGenerique.ValidePalette(var palette:tPalette);
begin {bidon} end;

destructor DriverGenerique.finDriver;
begin {enleve l'objet} end;

procedure DriverGenerique.truePixel(x,y:word;coul:couleur);
begin {bidon} end;

{------------------------DRIVER EGA-----------------------------------------}

constructor Ega.initDriver;
begin
  nbPixelX:=640;
  nbPixelY:=350;
  nbCouleurs:=16;
  maxValeurPalette:=3;
  trueColor:=false;
end;

procedure Ega.modeGraphique;
var reg:registers;  i:byte;
begin
   reg.ax:=$10;
   intr($10,reg);
end;

procedure Ega.pixel(x,y:word;couleur:byte);
{cf Bible PC, Michael Tischer}
begin
  asm
    mov ax,y;       mov dx,80;      mul dx;         mov bx,x;
    mov cl,bl;      shr bx,1;       shr bx,1;       shr bx,1;
    add bx,ax;      and cl,7;       xor cl,7;       mov ah,1;
    shl ah,cl;      mov dx,$3ce;    mov al,8;       out dx,ax;
    mov ax,$205;    out dx,ax;      mov ax,$a000;   mov es,ax;
    mov al,es:[bx]; mov al,couleur; mov es:[bx],al; mov ax,$ff08;
    out dx,ax;      mov ax,5;       out dx,ax
  end;
end;

procedure Ega.ValidePalette(var palette:tPalette);
var reg:registers;  i:byte;
begin
  for i:=0 to nbCouleurs-1 do with reg do with palette[i] do begin
    ax:=$1000;  bl:=i;
    bh:= (r and $1) shl 5 +(r and $2) shl 1 +(v and $1) shl 4+ (v and $2);
    bh:= bh +(b and $1) shl 3+ (b and $2) shr 1;
    intr($10,reg);
  end;
end;

{------------------------DRIVER VGA-----------------------------------------}

constructor Vga.initDriver;
begin
  nbPixelX:=640;
  nbPixelY:=480;
  nbCouleurs:=16;
  maxValeurPalette:=$3F;  {63}
  trueColor:=false;
end;

procedure Vga.modeGraphique;
var reg:registers;  i:byte;
begin
   reg.ax:=$12;
   intr($10,reg);
end;

procedure Vga.ValidePalette(var palette:tPalette);
var reg:registers;  i:byte;
begin
  {fait correspondre le numero de la couleur avec le registre DAC}
  for i:=0 to nbCouleurs-1 do with reg do begin
    ax:=$1000;  bl:=i; bh:=i;
    intr($10,reg);
  end;
  {met en place les couleurs dans la table DAC}
  with reg do begin
    ax:=$1012;  bx:=0;  cx:=nbCouleurs;
    es:=seg(palette);   dx:=ofs(palette);
  end;
  intr($10,reg);
end;

{------------------------DRIVER MCGA----------------------------------------}

constructor mcga.initDriver;
begin
  nbPixelX:=320;
  nbPixelY:=200;
  nbCouleurs:=256;
  maxValeurPalette:=$3F;  {63}
  trueColor:=false;
end;

procedure mcga.modeGraphique;
var reg:registers;
begin
   reg.ax:=$13;
   intr($10,reg);
end;

procedure mcga.pixel(x,y:word;couleur:byte);
begin mem[$a000:x+320*y]:=couleur; end;

procedure mcga.ValidePalette(var palette:tPalette);
var reg:registers;
begin
  with reg do begin
    ax:=$1012;  bx:=0;  cx:=nbCouleurs;
    es:=seg(palette);   dx:=ofs(palette);
  end;
  intr($10,reg);
end;

{------------------------DRIVER MODE X -------------------------------------}

constructor m13X.initDriver;
begin
  nbPixelX:=360;
  nbPixelY:=480;
  nbCouleurs:=256;
  maxValeurPalette:=$3F;  {63}
  trueColor:=false;
end;

procedure m13X.modeGraphique;
var reg:registers;
begin
   reg.ax:=$13;
   intr($10,reg);
   asm
     mov dx,$3C4;  mov ax,$604;  out dx,ax;  mov ax,$100;  out dx,ax;
     mov al,$E7;   mov dx,$3C2;  out dx,al;  mov dx,$3C4;  mov ax,$300;
     out dx,ax;    mov dx,$3D4;  mov al,$11; out dx,al;    inc dx;
     in al,dx;     and al,$7F;   out dx,al;  mov dx,$3D4 ;
     mov ax,$6B00; out dx,ax;    mov ax,$5901;   out dx,ax;
     mov ax,$5A02; out dx,ax;    mov ax,$8E03;   out dx,ax;
     mov ax,$5E04; out dx,ax;    mov ax,$8A05;   out dx,ax;
     mov ax,$0D06; out dx,ax;    mov ax,$3E07;   out dx,ax;
     mov ax,$4009; out dx,ax;    mov ax,$EA10;   out dx,ax;
     mov ax,$8C11; out dx,ax;    mov ax,$DF12;   out dx,ax;
     mov ax,$2D13; out dx,ax;    mov ax,$0014;   out dx,ax;
     mov ax,$E715; out dx,ax;    mov ax,$0616;   out dx,ax;
     mov ax,$E317; out dx,ax;
     mov dx,$3C4;  mov ax,$F02;  out dx,ax;
     mov ax,$A000; mov es,ax;    mov ax,0;   mov di,ax;    cld;
     mov cx,$6000; rep stosw;
   end;
end;

procedure m13X.pixel(x,y:word;couleur:byte);
begin
  asm
    mov ax,$A000; mov es,ax;   mov ax,y;     mov bx,90;    mul bx;
    mov bx,x;     mov cx,bx;   shr bx,1;     shr bx,1;     add bx,ax;
    mov ax,$102;  and cl,3;     shl ah,cl;   mov dx,$3c4;  out dx,ax;
    mov al,couleur;  mov es:[bx],al;
  end;
end;


{------------------------DRIVER VGA400--------------------------------------}

constructor vga400.initDriver;
begin
  nbPixelX:=640;
  nbPixelY:=400;
  nbCouleurs:=256;
  maxValeurPalette:=$3F;  {63}
  trueColor:=false;
end;

procedure vga400.modeGraphique;
var reg:registers;
begin
   reg.ax:=$5E;
   intr($10,reg);
   ancBank:=255;
end;

procedure vga400.pixel(x,y:word;couleur:byte);
begin
  adresse:=x+long640*y;
  Bank:=(adresse shr 16) shl 4;
  if Bank<>ancBank then begin {switch Bank mmoire}
    asm   {cf doc Amstrad 2386}
      mov dx,$3ce;  mov ax,$50f; out dx,ax
      mov al,9;     mov ah,Bank; out dx,ax
      mov ax,$f;    out dx,ax
    end;
    ancBank:=Bank;
  end;
  dep:=(adresse and $0FFFF);
  mem[$a000:dep]:=couleur;
end;

{------------------------DRIVER VGA480--------------------------------------}

constructor vga480.initDriver;
begin
  nbPixelX:=640;
  nbPixelY:=480;
  nbCouleurs:=256;
  maxValeurPalette:=$3F;  {63}
  trueColor:=false;
end;

procedure vga480.modeGraphique;
var reg:registers;
begin
   reg.ax:=$5F;
   intr($10,reg);
   ancBank:=255;
end;

{------------------------SELECTDRIVER---------------------------------------}

procedure selectDriver(var userDriver:pDriver;driverVoulu:integer);
begin
  case driverVoulu of
    modeEGA:    userDriver:=new(PEga,initDriver);
    modeVGA:    userDriver:=new(Pvga,initDriver);
    modeMCGA:   userDriver:=new(Pmcga,initDriver);
    mode13X:    userDriver:=new(Pm13X,initDriver);
    modeVGA400: userDriver:=new(Pvga400,initDriver);
    modeVGA480: userDriver:=new(Pvga480,initDriver);
  end;
end;

begin end.