unit dither;
{$N+}
{contient les diffrentes mthodes de 'dithering' ou tramage}
interface
uses global;
type  pDither=^ditherGenerique;
      ditherGenerique=object
        usedPixelX:word;  total:byte;
        constructor initDither(userPixelX:word);
        procedure initData; virtual;
        destructor finDither; virtual;
        procedure changeLigne; virtual;
        procedure corrige(position:word); virtual;
      end;
var avecDithering:boolean;
    ErrSuivante,ErrCoul:tErreurCoul;

procedure selectDither(var userDither:pDither;ditherVoulu,usedPixelX:word);
{cre l'objet userDither de type ditherVoulu}
procedure modifieCouleur(var coul:couleur; ErrCouleur:tErreurCoul);
{corrige couleur avec clipping ventuel}

{------------------------IMPLEMENTATION-------------------------------------}
implementation

type tErreur=array[0..0] of shortint;
     pErreur=^tErreur;
     matrice1LigFl=array[1..4] of integer;
     matrice1Ligne=array[1..7] of integer;
     matrice2Ligne=array[1..12] of integer;

      pFloydSteinberg=^FloydSteinberg;
      FloydSteinberg=object(ditherGenerique)
        matrice:matrice1ligFl;
        constructor initDither(userPixelX:word);
        destructor finDither; virtual;
        procedure corrige(position:word); virtual;
      end;

      pBurkes=^Burkes;
      Burkes=object(ditherGenerique)
        matrice:matrice1Ligne;
        constructor initDither(userPixelX:word);
        destructor finDither; virtual;
        procedure corrige(position:word); virtual;
      end;

      pStucki=^Stucki;
      Stucki=object(ditherGenerique)
        matrice:matrice2ligne;
        constructor initDither(userPixelX:word);
        procedure initData; virtual;
        destructor finDither; virtual;
        procedure changeLigne; virtual;
        procedure corrige(position:word); virtual;
      end;

      pSierra=^Sierra;
      Sierra=object(Stucki)
        constructor initDither(userPixelX:word);
      end;

      pJarkis=^Jarkis;
      Jarkis=object(Stucki)
        constructor initDither(userPixelX:word);
      end;

var  pErr1,pErr2: array[1..3] of pErreur;
     provis,errProv:array[1..3] of float;

const floydMatrice:matrice1LigFl= (7,3,5,1);
      BurkesMatrice:matrice1Ligne= (4,2,1,2,4,2,1);
      StuckiMatrice:matrice2Ligne= (8,4,2,4,8,4,2,1,2,4,2,1);
      SierraMatrice:matrice2Ligne= (5,3,2,4,5,4,2,0,2,3,2,0);
      JarkisMatrice:matrice2Ligne= (7,5,3,5,7,5,3,1,3,5,3,1);

{----------------------DITHER GENERIQUE-------------------------------------}
constructor ditherGenerique.initDither(userPixelX:word);
begin {bidon} end;

destructor ditherGenerique.finDither;
begin {bidon} end;

procedure ditherGenerique.changeLigne;
begin {bidon} end;

procedure ditherGenerique.corrige(position:word);
begin {bidon} end;

procedure ditherGenerique.initData;
{crit pour une ligne (Floyd, Burkes) surcharg pour 2 lignes}
var i,h:word;
begin
  {$R-}
  for h:=1 to 3 do begin {chacunes des 3 primitives RVB}
    getmem(pErr1[h],UsedPixelX+4);
    for i:=0 to usedPixelX+3 do pErr1[h]^[i]:=0;
  end;
  {$R+}
  With ErrSuivante do begin Rr:=0; Vr:=0; Br:=0; end;
  for i:=1 to 3 do errProv[i]:=0;
end;

{-----------------------FLOYD STEINBERG-------------------------------------}
constructor FloydSteinberg.initDither(userPixelX:word);
begin
  usedPixelX:=userPixelX;
  total:=16;
  matrice:=floydMatrice;
  initData;
end;

destructor FloydSteinberg.finDither;
var h:byte;
begin
  {$R-}  for h:=3 downto 1 do freemem(pErr1[h],UsedPixelX+4);  {$R+}
end;

procedure FloydSteinberg.corrige(position:word);
{procdure de dithering  une ligne et 1 colonne}
var compt,i,j:word;
begin
  {$R-}
  with errCoul do begin  {fraction d'erreur  distribuer}
    provis[1]:=Rr/total;
    provis[2]:=Vr/total;
    provis[3]:=Br/total;
  end;
  compt:=position+1;
  with errSuivante do begin   {pour point suivant}
    Rr:=pErr1[1]^[compt]/127+provis[1]*matrice[1];
    Vr:=pErr1[2]^[compt]/127+provis[2]*matrice[1];
    Br:=pErr1[3]^[compt]/127+provis[3]*matrice[1];
  end;
   {puis pour la ligne suivante}
  for i:=1 to 3 do pErr1[i]^[compt]:=trunc(127*provis[i]*matrice[4]);
  dec(compt);
  for i:=1 to 3 do inc(pErr1[i]^[compt],trunc(127*provis[i]*matrice[3]));
  dec(compt);
  for i:=1 to 3 do inc(pErr1[i]^[compt],trunc(127*provis[i]*matrice[2]));
  {$R+}
end;

{--------------------------------BURKES-------------------------------------}
constructor Burkes.initDither(userPixelX:word);
begin
  usedPixelX:=userPixelX;
  total:=16;
  matrice:=BurkesMatrice;
  initData;
end;

destructor Burkes.finDither;
var h:byte;
begin
  {$R-}  for h:=3 downto 1 do freemem(pErr1[h],UsedPixelX+4);  {$R+}
end;

procedure Burkes.corrige(position:word);
{procdure de dithering  une ligne}
var compt,i,j:word;
begin
  {$R-}
  with errCoul do begin  {fraction d'erreur  distribuer}
    provis[1]:=Rr/total;
    provis[2]:=Vr/total;
    provis[3]:=Br/total;
  end;
  with errSuivante do begin   {pour point suivant}
    Rr:=errProv[1]+provis[1]*matrice[1];
    Vr:=errProv[2]+provis[2]*matrice[1];
    Br:=errProv[3]+provis[3]*matrice[1];
  end;
  compt:=position+2;
  for i:=1 to 3 do errProv[i]:=pErr1[i]^[compt]/127+provis[i]*matrice[2];
   {puis pour la ligne suivante}
  for i:=1 to 3 do pErr1[i]^[compt]:=trunc(127*provis[i]*matrice[7]);
  for j:=6 downto 3 do begin
    dec(compt);
    for i:=1 to 3 do inc(pErr1[i]^[compt],trunc(127*provis[i]*matrice[j]));
  end;
  {$R+}
end;

{--------------------------------STUCKI-------------------------------------}
procedure Stucki.initData;
var i,h:word;
begin
  {$R-}
  for h:=1 to 3 do begin {chacunes des 3 primitives RVB}
    getmem(pErr1[h],UsedPixelX+4);
    for i:=0 to usedPixelX+3 do pErr1[h]^[i]:=0;
  end;
  for h:=1 to 3 do begin {chacunes des 3 primitives RVB}
    getmem(pErr2[h],UsedPixelX+4);
    for i:=0 to usedPixelX+3 do pErr2[h]^[i]:=0;
  end;
  {$R+}
  With ErrSuivante do begin Rr:=0; Vr:=0; Br:=0; end;
  for i:=1 to 3 do errProv[i]:=0;
end;

constructor Stucki.initDither(userPixelX:word);
begin
  usedPixelX:=userPixelX;
  total:=42;
  matrice:=StuckiMatrice;
  initData;
end;

destructor Stucki.finDither;
var h:byte;
begin
  {$R-}
  for h:=3 downto 1 do freemem(pErr2[h],UsedPixelX+4);
  for h:=3 downto 1 do freemem(pErr1[h],UsedPixelX+4);
  {$R+}
end;

procedure Stucki.corrige(position:word);
{procdure de dithering  deux lignes}
var compt,i,j:word;
begin
  {$R-}
   with errCoul do begin  {fraction d'erreur  distribuer}
    provis[1]:=Rr/total;
    provis[2]:=Vr/total;
    provis[3]:=Br/total;
  end;
  with errSuivante do begin   {pour point suivant}
    Rr:=errProv[1]+provis[1]*matrice[1];
    Vr:=errProv[2]+provis[2]*matrice[1];
    Br:=errProv[3]+provis[3]*matrice[1];
  end;
  compt:=position+2;
  for i:=1 to 3 do errProv[i]:=pErr1[i]^[compt]/127+provis[i]*matrice[2];
   {puis pour la deuxieme ligne suivante}
  for i:=1 to 3 do pErr1[i]^[compt]:=trunc(127*provis[i]*matrice[12]);
  for j:=11 downto 8 do begin
    dec(compt);
    for i:=1 to 3 do inc(pErr1[i]^[compt],trunc(127*provis[i]*matrice[j]));
  end;
   {puis pour la ligne suivante}
  compt:=position+3;
  for j:=7 downto 3 do begin
    dec(compt);
    for i:=1 to 3 do inc(pErr2[i]^[compt],trunc(127*provis[i]*matrice[j]));
  end;
  {$R+}
end;

procedure Stucki.ChangeLigne;
{change les deux lignes en changeant les pointeurs}
var pProv:pErreur; i:byte;
begin
  for i:=1 to 3 do begin
    pProv:=pErr1[i];
    pErr1[i]:=pErr2[i];
    pErr2[i]:=pProv;
  end;
end;

{--------------------------------SIERRA-------------------------------------}
constructor Sierra.initDither(userPixelX:word);
begin
  usedPixelX:=userPixelX;
  total:=32;
  matrice:=SierraMatrice;
  initdata;
end;

{-----------------------------JARKIS & Al-----------------------------------}
constructor Jarkis.initDither(userPixelX:word);
begin
  usedPixelX:=userPixelX;
  total:=48;
  matrice:=JarkisMatrice;
  initData;
end;

{-------------------------MODIFIE COULEUR-----------------------------------}
procedure modifieCouleur(var coul:couleur; ErrCouleur:tErreurCoul);
{corrige couleur avec clipping ventuel}
var prov:float; prov2:integer;
begin
  with coul do begin
    prov:=r+256*ErrCouleur.Rr-0.5; prov2:=trunc(prov);
    if prov2<0 then r:=0 else if prov2>255 then r:=255 else r:=prov2;
    prov:=v+256*ErrCouleur.Vr-0.5; prov2:=trunc(prov);
    if prov2<0 then v:=0 else if prov2>255 then v:=255 else v:=prov2;
    prov:=b+256*ErrCouleur.Br-0.5; prov2:=trunc(prov);
    if prov2<0 then b:=0 else if prov2>255 then b:=255 else b:=prov2;
 end;
end;
{---------------------------SELECTDITHER------------------------------------}
procedure selectDither (var userDither:pDither;ditherVoulu,usedPixelX:word);
{cre l'objet userDither de type ditherVoulu}
begin
  case ditherVoulu of
    ditAucun:  userDither:=new(pDither,initDither(usedPixelX));
    ditFloydSteinberg:
               userDither:=new(pFloydSteinberg,initDither(usedPixelX));
    ditBurkes: userDither:=new(pBurkes,initDither(usedPixelX));
    ditStucki: userDither:=new(pStucki,initDither(usedPixelX));
    ditSierra: userDither:=new(pSierra,initDither(usedPixelX));
    ditJarkis: userDither:=new(pJarkis,initDither(usedPixelX));
  end;
end;

begin end.

