program rendu;

{----------------------------------------------------------------------------

      Programme de test du rendu de couleurs en fonction
        -des possibilits de la carte graphique
        -du choix de la palette de couleur
        -des diffrentes mthodes de tramage (dithering)

 Ce programme est crit surtout pour la mise au point d'un pilote graphique
 gnral, ddi  l'affichage d'image (traitement d'image, lancer de rayons)

 Il utilise les possibilits actuelles du pilote graphique, se contentant
 de slectionner par divers menus 'texte' les diffrents paramtres du pilote.
 Les images de test sont cres dans l'unite image.


        (C)   Legolas    (Luc Rivire)     Mars 1994

----------------------------------------------------------------------------}

{$N+}
uses crt,global,pilotGen,image;

var  aspectRatio,tailleImage,decalX,decalY:float;
     avecCadre:boolean;

{----------------------- CHOIX DU DRIVER GRAPHIQUE -------------------------}
function ChoisisDriver:integer;
var i:integer;
begin
  with choixUser do repeat
    clrScr;
    textColor(white);
    writeln('                      *****  PILOTE GRAPHIQUE  *****');
    textColor(lightGray);
    writeln; writeln;
    writeln('       Choisissez le pilote graphique adapt  votre carte');
    writeln('        ATTENTION: pas de vrification de compatibilit !');
    writeln; writeln;
    for i:=1 to nbDriver do begin
      if compatible[paletteChoisie,i] then textColor(Yellow)
      else textColor(lightGray);
      writeln(infoDriver[i]);
    end;
    textColor(lightGray);
    writeln; writeln;
    write('            votre choix:');
    DriverChoisi:=ord(readkey)-ord('0');
  until (DriverChoisi>0) and (DriverChoisi<nbDriver+1)
        and compatible[paletteChoisie,DriverChoisi];
end;

{------------------------ CHOIX DE LA PALETTE ------------------------------}
procedure ChoisisPalette;
var i:integer;
begin
  with choixUser do repeat
    ClrScr;
    textColor(white);
    writeln('               *****  CHOIX DE LA PALETTE  *****');
    textColor(lightGray);
    writeln; writeln;
    writeln('          Choisissez la palette que vous souhaitez tester');
    writeln('   ATTENTION: seulement parmi celles compatibles avec le pilote');
    writeln; writeln;
    for i:=1 to nbPalette do begin
      if compatible[i,driverChoisi] then textColor(Yellow)
      else textColor(lightGray);
      writeln(infoPalette[i]);
    end;
    textColor(lightGray);
    writeln; writeln;
    write('                       votre choix:');
    PaletteChoisie:=ord(readkey)-ord('0');
  until (PaletteChoisie>0) and (PaletteChoisie<nbPalette+1)
        and compatible[paletteChoisie,DriverChoisi];
end;

{----------------------- CHOIX METHODE DE TRAMAGE --------------------------}
procedure ChoisisDither;
var i:integer;
begin
  with choixUser do repeat
    ClrScr;
    textColor(white);
    writeln('      *****  CHOIX DE LA METHODE DE TRAMAGE (DITHERING)  *****');
    textColor(lightGray);
    writeln; writeln;
    writeln('          Choisissez la mthode que vous souhaitez tester');
    writeln; writeln;
    textColor(Yellow);
    for i:=1 to nbDither do  writeln(infoDither[i]);
    textColor(lightGray);
    writeln; writeln;
    write('                       votre choix:');
    DitherChoisi:=ord(readkey)-ord('0');
  until (DitherChoisi>0) and (DitherChoisi<nbDither+1);
end;

{--------------------------- CHOIX DE L'IMAGE ------------------------------}
procedure ChoisisImage;
var i:integer;
begin
  with choixUser do repeat
    ClrScr;
    textColor(white);
    writeln('          *****  CHOIX DE L''IMAGE A AFFICHER  *****');
    textColor(lightGray);
    writeln; writeln;
    writeln('          Choisissez l''image que vous souhaitez visualiser');
    writeln; writeln;
    textColor(Yellow);
    for i:=1 to nbImage do  writeln(infoImage[i]);
    textColor(lightGray);
    writeln; writeln;
    write('                       votre choix:');
    ImageChoisie:=ord(readkey)-ord('0');
  until (ImageChoisie>0) and (ImageChoisie<nbImage+1);
end;

{-------------------------- AFFICHE MENU PRINCIPAL -------------------------}
function selectMenu:char;
var choix:char;
begin
  clrScr;
  textColor(white);
  writeln('(F)in  (M)ode Graphique  (P)alette  (T)ramage  (I)mage  (A)ffiche');
  writeln(' Taille de l''image : (+) augmente (-) diminue');
  textColor(lightGray); writeln; writeln;
  writeln(' Slection actuelle:'); writeln; writeln;
  textColor(yellow);
  with ChoixUser do begin
    writeln('Taille de l''image: ',tailleImage:3:1);
    write('Mode    '); writeln(infoDriver[DriverChoisi]);
    write('Palette '); writeln(infoPalette[PaletteChoisie]);
    write('Tramage '); writeln(infoDither[DitherChoisi]);
    write('Image   '); writeln(infoImage[ImageChoisie]);
  end;
  textColor(lightGray); writeln; writeln; writeln; writeln;
  write('                        votre choix:');
  repeat choix:=upcase(readkey) until
     choix in ['F','M','T','P','I','A','+','-'];
  selectMenu:=choix;
end;

{-------------------------- APPEL DU PILOTE --------------------------------}
procedure dessine;
var  x,y:float; coul:couleur; c:char;
begin
  selectImage(choixUser.imageChoisie);
  initGraphique(-decalX,-decalY,1+decalX,1+decalY);
  fixeLimite(0,0,1,1);
  while encoreXY(x,y) do begin
    if avecCadre and ( (x<0.999*TaillePixelX) or (x>1.001-taillePixelX)
                      or (y<0.999*TaillePixelY) or (y>1.001-taillePixelY))
    then with coul do begin r:=255; v:=255; b:=255;  {blanc}
    end else getCouleurImage(x,y,coul);
    couleurXY(coul);
  end;
  c:=readkey;
  finGraphique;
end;

{--------------------------- INITIALISATION --------------------------------}
procedure initAll;
begin
  AspectRatio:=4/3; {tient compte facteur de forme de l'ecran}
  {mettre 1 pour utiliser tout l'ecran}
  tailleImage:=0.6; {par rapport a la hauteur d'ecran}
  with ChoixUser do begin
    DriverChoisi:=modeEGA; {par dfaut le moins volu}
    PaletteChoisie:=palHSVEGA;
    DitherChoisi:=ditAucun;
    ImageChoisie:=ImCoupeLum;
  end;
  decalY:=(1/tailleImage-1)/2;
  decalX:=(aspectRatio/tailleImage-1)/2;
  avecCadre:=true;
end;

{------------------------ PROGRAMME PRINCIPAL ------------------------------}
var choix:char;
begin
  initAll;
  repeat
    choix:=selectMenu;
    case choix of
      'M': choisisDriver;
      'P': choisisPalette;
      'T': choisisDither;
      'I': choisisImage;
      'A': dessine;
      '+':if tailleImage<1 then tailleImage:=tailleimage+0.1;
      '-':if tailleimage>0.11 then tailleImage:=tailleImage-0.1;
   end;
   decalY:=(1/tailleImage-1)/2;
   decalX:=(aspectRatio/tailleImage-1)/2;
  until choix='F';
end.
