unit pilotGen;
{$N+}
{pilote graphique gnral}
interface
uses global;

type tChoixUser=record DriverChoisi:1..nbDriver;
                       PaletteChoisie:1..nbPalette;
                       DitherChoisi:1..nbDither;
                       ImageChoisie:1..nbImage;
               end;

var taillePixelX,taillePixelY:float; {peut etre utile au programme principal}
    ChoixUser:tChoixUser;

procedure finGraphique;
{retour au mode Texte et efface les variables dynamiques}
procedure initGraphique(minX,minY,maxX,maxY:float);
{passe en mode graphique tout en dfinissant les coordonnes utilisateur}
procedure FixeLimite(minX,minY,maxX,maxY:float);
{fixe les limites de l'image en coordonnes utilisateur apres initgraphique
 obligatoire meme en mode plein cran}
function encoreXY(var x,y:float):boolean;
{retourne FALSE si plus de point  calculer,
 sinon rajuste X et Y pour le calcul suivant}
procedure couleurXY(coul:couleur);
{fixe la couleur du point X,Y courant}


{-----------------------------IMPLEMENTATION--------------------------------}
implementation
uses driverG,palette,dither;

var usedPixelX,usedPixelY:word; {pixels utiliss dans fenetre}
    XCoord,YCoord:integer;  {coordonne courante en entier}
    decalX,decalY:integer;  {decalage en X et Y du premier point}
    Xfloat,Yfloat:float; {coordonne courante en reel}
    EcranMinX,EcranMaxX,EcranMinY,EcranMaxY:float; {coord ecran}
    FenMinX,FenMaxX,FenMinY,FenMaxY:float;  {coord fenetre}

    {les diffrents objets utiliss}
    usedDriver:pDriver;
    usedPalette:pPalette;
    usedDither:pDither;


{-------------------------------COULEUR XY----------------------------------}
function choisisPalette(coul:couleur):byte;
var color:byte;
begin
  if avecDithering then modifieCouleur(coul,errSuivante);
  color:=usedPalette^.choixPalette(coul);
  if avecDithering then begin
    usedPalette^.ecart(coul,color,errCoul);
    usedDither^.corrige(Xcoord-decalX+2);
      {Xcoord-decalX+2 pointe sur suivant}
  end;
  choisisPalette:=color;
end;

procedure couleurXY(coul:couleur);
begin
  with UsedDriver^ do
    if trueColor then truePixel(Xcoord,Ycoord,coul)
    else pixel(Xcoord,Ycoord,choisisPalette(coul));
end;

{------------------------INIT GRAPHIQUE-------------------------------------}
procedure initData;
begin
  UsedPixelX:=round(UsedDriver^.nbPixelX*(FenMaxX-fenMinX)/(EcranMaxX-EcranMinX));
  UsedPixelY:=round(UsedDriver^.nbPixelY*(FenMaxY-fenMinY)/(EcranMaxY-EcranMinY));
  decalX:=round((UsedDriver^.nbPixelX-1)*(FenMinX-EcranMinX)/(EcranMaxX-EcranMinX));
  decalY:=round((UsedDriver^.nbPixelY-1)*(FenMinY-EcranMinY)/(EcranMaxY-EcranMinY));
  XCoord:=decalX-1; YCoord:=decalY;
  taillePixelX:=(EcranMaxX-EcranMinX)/(UsedDriver^.nbPixelX-1);
  taillePixelY:=(EcranMaxY-EcranMinY)/(UsedDriver^.nbPixelY-1);
  Xfloat:=fenMinX-taillePixelX;  Yfloat:=fenMaxY;
end;

procedure InitGraphique(minX,minY,maxX,maxY:float);
begin
  with ChoixUser do begin
    {slectionne et cre l'objet driver}
    selectDriver(usedDriver,driverChoisi);
    {slectionne et cre l'objet palette}
    with usedDriver^ do
      selectPaletteMode(usedPalette,paletteChoisie,nbCouleurs,maxValeurPalette);
  end;
  EcranMinx:=MinX; EcranMaxX:=maxX; EcranMinY:=minY; EcranMaxY:=maxY;
  FenMinx:=MinX; FenMaxX:=maxX; FenMinY:=minY; FenMaxY:=maxY;
  initdata;
  usedDriver^.modeGraphique;
  usedDriver^.validePalette(paletteDeBase);
end;

{------------------------FIXE LIMITE----------------------------------------}
procedure FixeLimite(minX,minY,maxX,maxY:float);
begin
  if minX>EcranMinX then FenMinX:=minX else FenMinX:=EcranMinX;
  if maxX<EcranMaxX then FenMaxX:=maxX else FenMaxX:=EcranMaxX;
  if minY>EcranMinY then FenMinY:=minY else FenMinY:=EcranMinY;
  if maxY<EcranMaxY then FenMaxY:=maxY else FenMaxY:=EcranMaxY;
  initData;
  with ChoixUser do begin
    if usedDriver^.trueColor then DitherChoisi:=ditAucun;
      {idiot en mode trueColor et stockage par octet}
    selectDither(usedDither,ditherChoisi,usedPixelX);
    if ditherChoisi=ditAucun then avecDithering:=false
                             else avecDithering:=true;
  end;
end;

{----------------------------ENCORE XY--------------------------------------}
function encoreXY(var X,Y:float):boolean;
var fini:boolean;
begin
  fini:=false;
  inc(Xcoord);
  if (Xcoord>=decalX+usedPixelX) then begin
    Xcoord:=decalX; Xfloat:=FenMinX; usedDither^.changeLigne;
    inc(Ycoord);
    if Ycoord>=decalY+usedPixelY then fini:=true
      else YFloat:=YFloat-TaillePixelY;
  end else XFloat:=XFloat+taillePixelX;
  X:=Xfloat;
  Y:=Yfloat;
  encoreXY:=not(fini);
end;

{----------------------------FIN GRAPHIQUE----------------------------------}
procedure finGraphique;
begin
  usedDriver^.modeTexte;
  dispose(usedDither,finDither);
  dispose(usedPalette,finPalette);
  dispose(usedDriver,finDriver);
end;

begin end.