program pico;
{****** 'PICO' INTERPRETE D'EXPRESSIONS ***********}
uses crt;

const maxPriorite=3;
      chiffre:set of char=['0'..'9'];
      termine='%';
      operateur:array[1..maxPriorite] of char= ('+','*','^');

var LexCode:char;        {sortie de l'analyseur lexical}
    curseur:integer;     {curseur de l'analyseur lexical}
    chaine:string;       {l'expression  analyser}

{*** Pico Analyseur lexical ***}

procedure suivant;   {le coeur de l'analyseur lexical}
begin
  LexCode:=chaine[curseur];
  if (LexCode<>termine) then curseur:=succ(curseur);
end; {suivant}

procedure initLex;
begin
  curseur:=1;
  chaine:=chaine+termine;
  suivant; {un premier passage initial}
end;


{*** Pico Interprete d'expressions simples ***}

function operation(terme1,terme2:Integer; code:char):integer;
var prov,i:integer;
begin
  case code of
    '+':operation:=terme1+terme2;
    '*':operation:=terme1*terme2;
    '^':begin
          prov:=1;
          for i:=1 to terme2 do prov:=prov*terme1;
          operation:=prov;
        end; {cas '^'}
  end; {case}
end; {operation}

function terme(priorite:integer):Integer;
var terme1,terme2:integer;
begin
  if priorite>maxPriorite then begin                {terminal}
    if (LexCode in chiffre) then terme:=ord(LexCode)-ord('0')
    else terme:=0;        {normalement sans erreur ca n'arrive pas!}
    suivant;
  end else begin {non terminal}
    terme1:=terme(priorite+1);
    while (LexCode = operateur[priorite]) do begin
      suivant;
      terme2:=terme(priorite+1);
      terme1:=operation(terme1,terme2,operateur[priorite]);
    end; {while}
    terme:=terme1;
  end;  {else}
end;  {terme}


{*** Pico programme de test ***}

var resultat:integer;
begin
  repeat
     clrScr;
     writeln('*** Pico Interprte ***');
     writeln('limit aux chiffres (0  9) ');
     writeln('       aux oprations binaires +,* et ^');
     writeln('       sans gestion d''erreurs');
     writeln('Donnez une expression:');
     readln(chaine);
     InitLex;                      {initialisation analyseur lexical}
     resultat:=terme(1);           {valuation}
     writeln(resultat);
     writeln('Encore (O/N) ?');
  until upcase(readkey)='N';
end.