unit palette;
{$N+}
interface
uses global;

type
   pPalette=^PaletteGenerique;
   paletteGenerique=object
     nbCouleurs,maxPaletteValeur:word;
     constructor initPalette(nbCoul,maxVal:integer);
     destructor finPalette; virtual;
     function choixPalette(coul:couleur):byte; virtual;
     procedure ecart(coul:couleur;color:byte;var erreur:tErreurCoul); virtual;
   end;

var paletteDeBase:tpalette;

procedure selectPaletteMode( var userPalette:pPalette;
          paletteChoix, nbCouleurs, maxValeurPalette:integer);

{--------------------------IMPLEMENTATION-----------------------------------}
implementation
uses modele;

type

  pHSVEGA=^HSVEGA;
  HSVEGA=object(paletteGenerique)
    constructor initPalette(nbCoul,maxVal:integer);
    function choixPalette(coul:couleur):byte; virtual;
    procedure setPaletteHSV(num:byte;hue,sat,val:float);
  end;

  pNoirBlanc=^NoirBlanc;
  NoirBlanc=object(paletteGenerique)
    constructor initPalette(nbCoul,maxVal:integer);
    function choixPalette(coul:couleur):byte; virtual;
    procedure ecart(coul:couleur;color:byte;var erreur:tErreurCoul); virtual;
  end;

  pNoirBlancExt=^NoirBlancExt;
  NoirBlancExt=object(NoirBlanc)
    constructor initPalette(nbCoul,maxVal:integer);
    {choixPalette et ecart herite de NoirBlanc}
  end;

  pRVB884=^RVB884;
  RVB884=object(paletteGenerique)
    constructor initPalette(nbCoul,maxVal:integer);
    function choixPalette(coul:couleur):byte; virtual;
  end;

  pRVB676=^RVB676;
  RVB676=object(paletteGenerique)
    constructor initPalette(nbCoul,maxVal:integer);
    function choixPalette(coul:couleur):byte; virtual;
  end;

  pHSV256=^HSV256;
  HSV256=object(HSVEGA)  {pour bnficier de setPaletteHSV}
    constructor initPalette(nbCoul,maxVal:integer);
    function choixPalette(coul:couleur):byte; virtual;
  end;

{------------------------PALETTE GENERIQUE----------------------------------}
constructor paletteGenerique.initPalette(nbCoul,maxVal:integer);
begin {bidon} end;

function paletteGenerique.choixPalette(coul:couleur):byte;
begin {bidon} end;

destructor paletteGenerique.finPalette;
begin {bidon} end;

procedure PaletteGenerique.ecart(coul:couleur;color:byte;
                var erreur:tErreurCoul);
{traite le cas le plus courant}
begin
  with erreur do begin
    Rr:=coul.r/255-paletteDeBase[color].r/maxPaletteValeur;
    Vr:=coul.v/255-paletteDeBase[color].v/maxPaletteValeur;
    Br:=coul.b/255-paletteDeBase[color].b/maxPaletteValeur;
  end;
end;

{-------------------------HSV COULEURS EGA----------------------------------}
procedure HSVEGA.setPaletteHSV(num:byte;hue,sat,val:float);
var rouge,vert,bleu:float;
begin
  HSVtoRGB(hue,sat,val,rouge,vert,bleu);
  with paletteDeBase[num] do begin
    r:=trunc(rouge*maxPaletteValeur);
    v:=trunc(vert*maxPaletteValeur);
    b:=trunc(bleu*maxPaletteValeur);
  end;
end;

constructor HSVEGA.initPalette(nbCoul,maxVal:integer);
var i:byte; hue:float;
begin
  nbCouleurs:=16; {forc mme si on peut mieux, c'est voulu!}
  maxPaletteValeur:=maxVal;
  for i:=0 to 3 do with paletteDeBase[i] do begin  {niveau de gris}
    r:=(maxPaletteValeur*i) div 3;
    v:=(maxPaletteValeur*i) div 3;
    b:=(maxPaletteValeur*i) div 3;
  end;
  for i:=0 to 5 do begin
    hue:=60*i;
    setPaletteHSV(4+i,hue,1,0.667);
    setPaletteHSV(10+i,hue,1,1);
  end;
end;

function HSVEGA.choixPalette(coul:couleur):byte;
var hue,sat,val:float; color:byte;
begin
  with coul do RGBtoHSV(r/255,v/255,b/255,hue,sat,val);
  if sat<0.5 then  color:=trunc(val*3+0.5)
  else begin
    color:=4+round(hue/60); {4+de 0  6}
    if color=10 then color:=4;
    if val>0.82 then color:=color+6;
  end;
  choixPalette:=color;
end;

{--------------------------DEGRADE DE GRIS VRAIS----------------------------}
constructor NoirBlanc.initPalette(nbCoul,maxVal:integer);
var i:byte;
begin
  if nbCoul>(maxVal+1) then nbCouleurs:=maxVal else nbCouleurs:=nbCoul-1;
  {dpend des limites du driver en niveaux possibles
  attention nbCouleurs vaut nbCouleurs-1 pour un peu acclrer le choix}
  maxPaletteValeur:=maxVal;
  for i:=0 to nbCouleurs do with paletteDeBase[i] do begin
    r:=i*maxPaletteValeur div nbCouleurs;
    v:=i*maxPaletteValeur div nbCouleurs;
    b:=i*maxPaletteValeur div nbCouleurs;
  end;
end;

function NoirBlanc.choixPalette(coul:couleur):byte;
var luminosite:float;
begin
  with coul do luminosite:=0.001173*r+0.002302*v+0.000447*b;
    {0.299/255*r+ 0.587/255*v +0.114/255*b}
  choixPalette:=round(luminosite*nbCouleurs);
end;

procedure NoirBlanc.ecart(coul:couleur;color:byte; var erreur:tErreurCoul);
{traite le cas particulier pour palettes Noir et Blanc}
var errLuminosite:float;
begin
  with Coul do
    errLuminosite:=0.001173*r+0.002302*v+0.000447*b-color/nbCouleurs;
  with erreur do begin
    Rr:=errLuminosite; Vr:=errLuminosite; Br:=errLuminosite;
  end;
end;

{--------------------------DEGRADE DE GRIS ETENDU---------------------------}
constructor NoirBlancExt.initPalette(nbCoul,maxVal:integer);
var i:byte;
begin
  nbCouleurs:=nbCoul-1;
  {tentative d'extension de luminosite pour cartes 256 couleurs !
  attention nbCouleurs vaut nbCouleurs-1 pour un peu acclrer le choix}
  maxPaletteValeur:=maxVal;
  for i:=0 to maxPaletteValeur-1 do begin
    with paletteDeBase[i*4] do begin r:=i; v:=i; b:=i; end;
    with paletteDeBase[i*4+1] do begin r:=i; v:=i; b:=i+1; end;
    with paletteDeBase[i*4+2] do begin r:=i; v:=i+1; b:=i; end;
    with paletteDeBase[i*4+3] do begin r:=i; v:=i+1; b:=i+1; end;
  end;
  {les 4 derniers niveaux  blanc}
  for i:=nbCouleurs-3 to nbCouleurs do with PaletteDeBase[i] do begin
    r:=maxPaletteValeur; v:=maxPaletteValeur; b:=maxPaletteValeur;
  end;
end;

{--------------------------CUBE RVB METHODE 884-----------------------------}
constructor RVB884.initPalette(nbCoul,maxVal:integer);
var num,ri,vi,bi:byte;
begin
  nbCouleurs:=nbCoul;
  maxPaletteValeur:=maxVal;
  for bi:=0 to 3 do for vi:=0 to 7 do for ri:=0 to 7 do begin
    num:=bi+vi shl 2+ri shl 5;
    with paletteDeBase[num] do begin
      r:=maxPaletteValeur*ri div 7;
      v:=maxPaletteValeur*vi div 7;
      b:=maxPaletteValeur*bi div 3;
    end;
  end;
end;

function RVB884.choixPalette(coul:couleur):byte;
begin
  with coul do choixPalette:=
    round(0.027451*r) shl 5+round(0.027451*v) shl 2+round(0.011765*b);
      {7/255=0.027451; 3/255=0.011765}
end;

{--------------------------CUBE RVB METHODE 676-----------------------------}
constructor RVB676.initPalette(nbCoul,maxVal:integer);
var num,ri,vi,bi:byte;
begin
  nbCouleurs:=nbCoul;
  maxPaletteValeur:=maxVal;
  for bi:=0 to 5 do for vi:=0 to 6 do for ri:=0 to 5 do begin
    num:=bi+vi*6+ri*42;
    with paletteDeBase[num] do begin
      r:=maxPaletteValeur*ri div 5;
      v:=maxPaletteValeur*vi div 6;
      b:=maxPaletteValeur*bi div 5;
    end;
  end;
end;

function RVB676.choixPalette(coul:couleur):byte;
begin
  with coul do choixPalette:=
    42*round(0.019608*r)+6*round(0.023529*v)+round(0.019608*b);
       {5/255=0.019608  6/255=0.023529}
end;

{------------------------------HSV 256--------------------------------------}
constructor HSV256.initPalette(nbCoul,maxVal:integer);
var i,j,k:byte; hue:float; compt:word;
begin
  nbCouleurs:=256;    {pour ce cas particulier}
  maxPaletteValeur:=maxVal;
  for i:=0 to 15 do with paletteDeBase[i] do begin
      {niveaux de gris}
    r:=round(i*maxPaletteValeur/15);
    v:=round(i*maxPaletteValeur/15);
    b:=round(i*maxPaletteValeur/15);
  end;
  compt:=16;
  for i:=0 to 11 do begin  {12 couleurs de base}
    hue:=30*i;
    for j:=1 to 5 do begin {5 niveaux d'intensit}
      for k:=1 to 4 do begin {4 niveaux de saturation}
        setPaletteHSV(compt,hue,0.25*k,0.2*j);
        inc(compt);
      end;
    end;
  end;
end;

function HSV256.choixPalette(coul:couleur):byte;
var hue,sat,val:float; color:byte;
begin
  with coul do RGBtoHSV(r/255,v/255,b/255,hue,sat,val);
  if (sat<0.125) or (val<0.1) then  color:=round(val*15) {niveaux de gris}
  else begin
    color:=round(hue/30); {de 0  12}
    if color=12 then color:=0;  {de 0  11}
    color:=11+20*color+4*round(val*5)+round(sat*4);
  end;
  choixPalette:=color;
end;

{----------------------------SELECTPALETTEMODE------------------------------}
procedure selectPaletteMode(var userPalette:pPalette;
          paletteChoix, nbCouleurs, maxValeurPalette:integer);
begin
  case paletteChoix of
    palHSVEGA: userPalette:=new(pHSVEGA,
                     initPalette(nbCouleurs,maxValeurPalette));
    palNoirBlanc: userPalette:=new(pNoirBlanc,
                     initPalette(nbCouleurs,maxValeurPalette));
    palNBExt: userPalette:=new(pNoirBlancExt,
                     initPalette(nbCouleurs,maxValeurPalette));
    palRVB884: userPalette:=new(pRVB884,
                     initPalette(nbCouleurs,maxValeurPalette));
    palRVB676: userPalette:=new(pRVB676,
                     initPalette(nbCouleurs,maxValeurPalette));
    palHSV256: userPalette:=new(pHSV256,
                     initPalette(nbCouleurs,maxValeurPalette));
  end;
end;

begin end.