program nano;
{****** 'NANO' INTERPRETE D'EXPRESSIONS ENTIERES ***********}
uses crt;

const maxPriorite=3;
      termine='%';
      chiffre:set of char=['0'..'9'];
      symbolePermis:set of char=['+','-','/','*','^','(',')'];
      debutTerme:set of char=['(','I'];
      operateur:array[1..maxPriorite] of set of char=
           (['+','-'],['*','/'],['^']);

var erreur:boolean;
    LexCode:char;        {sorties de l'analyseur lexical}
    valeur:longInt;
    precedent,curseur:integer;  {curseurs de l'analyseur lexical}
    chaine:string;       {l'expression  analyser}

{*** Nano Gestionnaire d'erreurs ***}

procedure CasErreur(message:string);
begin
  writeln(copy(chaine,1,precedent-1)+' => '+chaine[precedent]);
  writeln('ERREUR: ',message);
  erreur:=true;
end;


{*** Nano Analyseur lexical ***}

procedure lisConstante;  {constante entire}
var s:string; inutilise:integer;
begin
  s:='';
  while chaine[curseur] in chiffre do begin
    s:=s+chaine[curseur]; curseur:=succ(curseur);
  end; {while}
  val(s,valeur,inutilise);  LexCode:='I';
end;

procedure suivant;   {le coeur de l'analyseur lexical}
begin
  while (chaine[curseur]=' ') do curseur:=succ(curseur);  {vite les blancs}
  precedent:=curseur;   {pour le gestionnaire d'erreur}
  if (chaine[curseur] in chiffre) then lisConstante
  else begin
    LexCode:=chaine[curseur];
    if (LexCode in SymbolePermis) then curseur:=succ(curseur)
    else if LexCode<>termine then casErreur('Symbole Inconnu');
  end; {else}
end; {suivant}

procedure InitLex; {initialisation de l'analyseur lexical}
begin
  erreur:=false; curseur:=1; precedent:=1;
  chaine:=chaine+termine;
  suivant; {un premier passage initial}
end;


{*** Nano Interprte d'Expressions entires ***}

function operation(terme1,terme2:longInt; code:char):longInt;
var prov,i:longInt;
begin
  case code of
    '+':operation:=terme1+terme2;
    '-':operation:=terme1-terme2;
    '*':operation:=terme1*terme2;
    '/':if terme2<>0 then operation:=terme1 div terme2
        else casErreur('division par 0');
    '^':if terme2<0 then casErreur('Mise  une puissance ngative')
        else begin
          prov:=1;
          for i:=1 to terme2 do prov:=prov*terme1;
          operation:=prov;
        end; {else}
  end; {case}
end; {operation}

function expression:longInt; forward; {rcursivit oblige!}

function termeFinal:longInt;
begin
  case LexCode of
    'I':begin termeFinal:=valeur; suivant; end;
    '(':begin    {gestion des parentheses}
          suivant;
          if not(erreur) then termeFinal:=expression;
          if not(erreur) then if LexCode=')' then suivant
                              else casErreur('Symbole ) attendu');
        end;
    else casErreur('Terme attendu');
  end; {case}
end; {termeFinal}

function terme(priorite:integer; changeSigne:boolean):longInt;
var terme1,terme2:longInt; code:char;
begin
  if priorite>maxPriorite then terme:=termeFinal
  else if (LexCode in debutTerme) then begin {non terminal}
    terme1:=terme(priorite+1,false);
    if changeSigne then terme1:=-terme1;
    while (not(erreur)) and (LexCode in operateur[priorite]) do begin
      code:=LexCode; suivant;
      if not(erreur) then begin
        terme2:=terme(priorite+1,false);
        if not(erreur) then terme1:=operation(terme1,terme2,code);
      end; {if}
    end; {while}
    terme:=terme1;
  end else casErreur('Terme attendu');
end;  {terme}

function expression:longInt;
var negatif:boolean;
begin
  if LexCode='-' then negatif:=true else negatif:=false;
  if LexCode in ['+','-'] then suivant;
  if not(erreur) then
    if (LexCode in debutTerme) then expression:=terme(1,negatif)
    else casErreur('Terme attendu');
end;


{*** Nano programme de test ***}

var  resultat:longint;
begin
   repeat
     clrScr;
     writeln('*** Nano interprte ***');
     writeln('Donnez une expression:');
     readln(chaine);
     InitLex;                      {initialisation analyseur lexical}
     if not(erreur) then resultat:=expression;   {valuation}
     if not(erreur) then begin
       writeln('rsultat: ',resultat);
       if not(lexCode=termine) then
         casErreur('ATTENTION! Fin de chaine non value');
     end;
     writeln('Encore (O/N) ?');
  until upcase(readkey)='N';
end.