unit modele;
{$N+}
interface
uses global;

procedure HSVtoRGB(h,s,v:float; var r,g,b:float);
procedure RGBtoHSV(r,g,b:float ; var h,s,v:float);
procedure YCrCbtoRGB(y,cr,cb:float; var r,g,b:float);
procedure RGBtoYCrCb(r,g,b:float; var y,cr,cb:float);

{--------------------------IMPLEMENTATION-----------------------------------}
implementation

procedure HSVtoRGB(h,s,v:float; var r,g,b:float);
{adapt du source de Persistence Of Vision (POV), eux-mmes se rfrant 
  "Computer Graphics", Donald Hearn & M. Pauline Baker, p. 304}
var zone:byte; f:float;
begin
  if h=360 then h:=0;
  zone:=trunc(h/60);
  f:=h/60-zone;
  case zone of
    0: begin r:=v; g:=v*(1-s*(1-f)); b:=v*(1-s); end;
    1: begin r:=v*(1-s*f); g:=v; b:=v*(1-s); end;
    2: begin r:=v*(1-s); g:=v; b:=v*(1-s*(1-f)); end;
    3: begin r:=v*(1-s); g:=v*(1-s*f); b:=v; end;
    4: begin r:=v*(1-s*(1-f)); g:=v*(1-s); b:=v; end;
    5: begin r:=v; g:=v*(1-s); b:=v*(1-s*f); end;
    else begin r:=0; g:=0; b:=0; end;
  end;
end;

procedure RGBtoHSV(r,g,b:float ; var h,s,v:float);
{adapt du source de Persistence Of Vision (POV), eux-mmes se rfrant 
  "Computer Graphics", Donald Hearn & M. Pauline Baker, p. 304}
var m:float;
begin
  if r>g then begin
    if r>b then v:=r else v:=b;
    if g<b then m:=g else m:=b;
  end else begin
    if g>b then v:=g else v:=b;
    if r<b then m:=r else m:=b
  end;
  {en fait v:=max(r,g,b) m:=min(r,g,b)}
  if v<>0 then s:=(v-m)/v else s:=0;  {calcul saturation}
  if s<>0 then begin {calcul de l'angle}
    if v=r then if m=g then h:=5+(v-b)/(v-m) else h:=1-(v-g)/(v-m)
    else if v=g then if m=b then h:=1+(v-r)/(v-m) else h:=3-(v-b)/(v-m)
    else if v=b then if m=r then h:=3+(v-g)/(v-m) else h:=5-(v-r)/(v-m);
    h:=h*60; if h=360 then h:=0;
  end else begin {noir}
    h:=0; s:=0;
  end;
end;

procedure YCrCbtoRGB(y,cr,cb:float; var r,g,b:float);
{luminance/chrominance comme sur la tl
 Y:luminance Cr:diffrence R-Y normalise Cb:diffrence B-Y normalise}
begin
  r:=y+1.402*Cr;
  b:=y+1.772*Cb;
  g:=(y-0.299*r-0.114*b)/0.587;
end;

procedure RGBtoYCrCb(r,g,b:float; var y,Cr,Cb:float);
begin
  y:=0.299*r+0.587*g+0.114*b;          {luminance de 0  1}
  cr:=(r-y)/1.402;  {chrominance rouge normalise de -0.5  0.5}
  cb:=(b-y)/1.772;  {chrominance bleue normalise de -0.5  0.5}
end;

begin end.