unit image;
{$N+}
interface
uses crt,global;

procedure getCouleurImage(x,y:float; var coul:couleur);
{Trouve la couleur en fonction de la position x et y [0..1]}
procedure selectImage(imageVoulue:word);
{Slectionne l'image  afficher}

{------------------------IMPLEMENTATION-------------------------------------}
implementation
uses modele;  {pour conversion HSVtoRGB}

type  dataDegrade=array[1..9] of integer;
const nbCoupe=12;
      infoCoupe:array[1..nbCoupe] of string=(
      '   1) Vert    Rouge   Noir    Jaune',
      '   2) Bleu    Rouge   Noir    Magenta',
      '   3) Bleu    Vert    Noir    Cyan',
      '   4) Magenta Jaune   Rouge   Blanc',
      '   5) Magenta Cyan    Bleu    Blanc',
      '   6) Cyan    Jaune   Vert    Blanc',
      '   7) Cyan    Rouge   Noir    Blanc',
      '   8) Jaune   Bleu    Noir    Blanc',
      '   9) Magenta Vert    Noir    Blanc',
      '  10) Vert    Magenta Bleu    Jaune',
      '  11) Cyan    Rouge   Magenta Vert',
      '  12) Cyan    Rouge   Bleu    Jaune'
      );
      datacoupe:array[1..nbCoupe] of dataDegrade=(
      (0,1,1,0,0,0,0,0,0),(0,1,0,0,1,0,0,0,0),(0,0,0,1,1,0,0,0,0),
      (0,0,0,1,1,0,1,0,0),(0,1,1,0,0,0,0,0,1),(0,1,0,0,1,0,0,1,0),
      (0,1,1,0,1,0,0,0,0),(0,1,0,1,1,0,0,0,0),(1,0,0,1,1,0,0,0,0),
      (0,1,1,0,-1,0,0,0,1),(-1,0,1,0,0,-1,1,0,1),(0,1,1,0,0,-1,0,0,1)
      );

var imageChoisie:word;
    a:dataDegrade;

procedure FixeCouleur(rr,vr,br:float;var coul:couleur);
begin
  with coul do begin
    if (rr<0) or (vr<0) or (br<0) or (rr>1) or (vr>1) or (br>1) then begin
      r:=0; v:=0; b:=0;
    end else begin
      r:=round(255*rr); v:=round(255*vr); b:=round(255*br);
    end;
  end;
end;

procedure selectdegradeRVB;
var i,choix:integer;
begin
  repeat
    clrScr;
    textColor(white);
    writeln('                      *****  COUPE RVB  *****');
    textColor(lightGray);
    writeln;
    writeln('       Choisissez la coupe dans le cube RVB que vous souhaitez!');
    writeln; textColor(Yellow);
    for i:=1 to nbCoupe do writeln(infoCoupe[i]);
    textColor(lightGray);
    writeln; writeln;
    write('            votre choix:');
    readln(choix);
  until (choix>0) and (choix<=nbCoupe);
  a:=dataCoupe[choix];
end;

procedure getCouleurImage(x,y:float; var coul:couleur);
var rr,vr,br:float;
begin
  case ImageChoisie of
    ImCoupeLum: FixeCouleur(x,(0.5-0.299*x-0.114*y)/0.587,y,coul);
    ImDegradeRVB: FixeCouleur(a[1]*x+a[2]*y+a[7],
        a[3]*x+a[4]*y+a[8],a[5]*x+a[6]*y+a[9],coul);
    ImCoupeHSV: begin
       HSVtoRGB(360*x,y,1,rr,vr,br); FixeCouleur(rr,vr,br,coul); end;
  end;
end;

procedure selectImage(imageVoulue:word);
begin
  ImageChoisie:=ImageVoulue;
  if imageVoulue=imDegradeRVB then selectDegradeRVB;
end;

begin end.