unit global;
{$N+}
interface

const
{------------------------ DRIVERS GRAPHIQUES -------------------------------}
      nbDriver=6;
      modeEGA=1;
      modeVGA=2;
      modeMCGA=3;
      mode13X=4;
      modeVGA400=5;
      modeVGA480=6;
      infoDriver:array[1..nbDriver] of string=(
     '  1) Rs 640 * 350,  16 couleurs (mode EGA)',
     '  2) Rs 640 * 480,  16 couleurs (mode VGA)',
     '  3) Rs 320 * 200, 256 couleurs (mode MCGA:   $13)',
     '  4) Rs 360 * 480, 256 couleurs (mode X !)',
     '  5) Rs 640 * 400, 256 couleurs (mode VGA400: $5E  PARADISE)',
     '  6) Rs 640 * 480, 256 couleurs (mode VGA480: $5F  PARADISE)');
{-------------------------- PALETTES ---------------------------------------}
     nbPalette=6;
     palHSVEGA=1;
     palNoirBlanc=2;
     palNBExt=3;
     palRVB884=4;
     palRVB676=5;
     palHSV256=6;
     infoPalette:array[1..nbPalette] of string=(
     '  1) Palette de couleurs EGA, mthode HSV',
     '  2) Palette Noir et Blanc',
     '  3) Palette Noir et Blanc tendue  256 niveaux',
     '  4) Palette cube RVB, mthode 884',
     '  5) Palette cube RVB, mthode 676',
     '  6) Palette de 256 couleurs, mthode HSV (12,4,5)');

     compatible:array[1..nbPalette,1..nbDriver] of boolean=(
      (true, true, true, true, true, true),        {HSV EGA}
      (false,true, true, true, true, true),        {Noir et blanc}
      (false,false,true, true, true, true),        {Noir et Blanc tendu}
      (false,false,true, true, true, true),        {RVB 884}
      (false,false,true, true, true, true),        {RVB 676}
      (false,false,true, true, true, true)         {HSV 256 couleurs}
      );
{----------------------------- TRAMAGE -------------------------------------}
      nbDither=6;
      ditAucun=1;
      ditFloydSteinberg=2;
      ditBurkes=3;
      ditStucki=4;
      ditSierra=5;
      ditJarkis=6;
      infoDither:array[1..nbDither] of string=(
      '  1) Pas de dithering',
      '  2) mthode Floyd Steinberg',
      '  3) mthode de Burkes',
      '  4) mthode de Stucki',
      '  5) mthode de Sierra',
      '  6) mthode de Jarkis, Judice et Ninke');
{---------------------------- IMAGES ---------------------------------------}
      nbImage=3;
      ImCoupeLum=1;
      ImDegradeRVB=2;
      ImCoupeHSV=3;
      infoImage:array[1..nbImage] of string=(
      '  1) Coupe de luminance 0.5',
      '  2) Coupes du cube RVB',
      '  3) Coupe HSV (V=1)'
      );

type float={$IFDEF CPU87} extended; {$ELSE} real; {$ENDIF}
     couleur=record r,v,b:byte end;
     tErreurCoul=record Rr,Vr,Br:float; end;
     tpalette=array[0..255] of couleur;

implementation

begin end.