.\" $Id: xtacacsd.man,v 4.3 1997/05/28 19:36:25 vikas Exp $
.TH XTACACSD 8 "May 31, 1997"
.SH NAME
xtacacsd \- v4.1 Extended TAC Access Control server for Cisco commServers
.SH SYNOPSIS
.B xtacacsd
.RB [ " \-bdhilnpqs " ]
[
.B -c
.IR configfile
]
[
.B -u
.IR utmpfile
]
[
.B -w
.IR wtmpfile
]
[
.IR password-filename \&. \|. \|.
]
.nf
.RS
\fB \-b \fI (permit Blank passwords fields, useful for anonymous users)
\fB \-d \fI (Debug, repeat for higher debug levels)
\fB \-h \fI (update Host wtmp files also, e.g. wtmp.mycisco)
\fB \-i \fI (Ignore case in usernames for password file matches)
\fB \-l \fI (Log info messages and normal actions via syslog)
\fB \-n \fI (disable use of Domain Nameserver)
\fB \-p \fI (search system Password file in addition to alternate files)
\fB \-q \fI (Quiet mode\-  DENY type responses never sent back)
\fB \-Q \fI (Quiet mode2\-  DENY type responses not sent if user not found)
\fB \-s \fI (Standalone mode\- default is via \fB inetd\fI)
.RE
.ft
.fi
.\" ******************************************************************
.SH DESCRIPTION
.LP
\fB COMPLETE & UP-TO-DATE DOCUMENTATION IS IN HTML FORMAT AT \fR
.I http://www.netplex-tech.com/software/xtacacsd
.LP
.B xtacacsd
is an 
.I extended
TACACS server (for Cisco network devices)
which authenticates users logging onto a terminal server
(or any host which cares to query the server). It uses the standard
password file 
.RI ( /etc/passwd
) by default, or an alternate list of password files.
.LP
This version of 
.B xtacacsd
has the following \fInew\fR features:
.IP \-
Can create and use DBM format database files for extracting users from
the Unix password files (use Getpw).
.IP \-
Support for the QI/PH name server database from ftp.cso.uiuc.edu
.IP \-
Support for DEC SIA routines and Solaris shadow passwords
.IP \-
Support for the OSF DCE authentication routines.
.LP
Most of the options are specified in the configuration file. This file
also allows extensive control of responses based on the username, group-id or 
geco string matches. It allows permitting or denying a request based on
its type, originating host and line numbers, and setting access control lists.
.LP
This server should be run under
.I inetd
in all cases except for debugging (use -s option for standalone mode).
.\"
.LP
Old features deleted in this version are:
.IP \-
Does not use the gid as the access list number. Now specify the access-list
using the config file.
.IP \-
Does not use the group gid to permit/deny access (defined during compile
time in earlier versions). Now control using the config file.
.IP \-
converting all query names to lowercase has been replaced with case
insensitive username matching.
.\"
.LP
This program can be used to authenticate users when they try to access
a terminal server (
.I cisco 
terminal servers support this option). The server can log information
about all queries coming to the server using 
.B syslog.
It is meant to be invoked by 
.B inetd
but can be run from a terminal in standalone mode if desired. In this mode,
it writes all errors to the controlling terminal.
.LP
The server always returns an authentication failure for any queries
that have a uid of 0 (
.I root uid
) or for any users that do not have a password (null password field) in
the password files.
It also verifies that the account is current and not expired if the
last password field (
.IR pw_shell )
or expiry field supports this feature. Finally, permissions are checked for
the request by matching the username, group-id and gecos field of
the user in the tacacs request (the groups listed in the /etc/groups
file are checked as well). The permissions are specified in the
configuration file as described in the CONFIG FILE section below.
.LP
To facilitate user login record keeping, the server writes formatted log
messages at the NOTICE level. The format of these messages is:
.RS
.sp .25
.ps-1
.nf
 STAT:Service:Username:UID:GID @ From-Host:line TTY:TransID:Action:Misc
 STAT:xlogin:vikas:913:10 @ cs500:line tty5:67:accepted:9
.fi
.ps+1
.sp .25
.RE
The TransID is the tacacs transaction ID (which is a unique number per
tacacs query-reply). It is useful for eliminating duplicate entries from
redundant tacacs server logs.
.LP
.\"
.SH SAMPLE CISCO CONFIGURATION
.LP
Configure the cisco using the commands:
.RS
.ps-1
.sp .25
.nf
tacacs-server extended
tacacs-server host 192.1.1.1
tacacs-server host 192.1.1.15
tacacs-server last-resort password
!
tacacs-server notify connect
tacacs-server notify slip
tacacs-server notify enable
tacacs-server notify logout
!
! In v11.0 of Cisco software, allow queries to a host using user@host
tacacs-server directed-request
!
tacacs authenticate enable
tacacs authenticate connect
tacacs-server authenticate slip [ always ] [ access-lists ]
!
! In v10.3 of Cisco software, set enable levels
enable use-tacacs
enable last-resort password
!
ppp auth chap
line 1
 login tacacs
 slip address dynamic 202.100.94.101
inter async 1
 ppp use-tacacs [single-line]
 arap use-tacacs [single-line]
 async mode interactive
!
.fi
.ps+1
.sp .25
.RE
.IP 4.
For SLIP/PPP support where you want the user to be able to ask for a
particular IP address, put an entry in your nameserver so that the user
can do a 
.I "slip myusername"
on the cisco and use the same password as he did when logging in. This
is preferred instead of using
.I "slip 192.1.3.4"
for convenience and simplicity in maintaining the password file.
.LP
For CHAP/ARAP support, you can create a separate password file with
the CHAP & ARAP secrets in clear text (yes, the secrets are in clear text if
you are not using the
.I single-line
keyword in the cisco configuration). Make sure that this file is set mode
0600 so that only root can read it.
.\" ******************************************************************
.SH OPTIONS
.TP
.B \-d
.I (debug)
Logs additional debugging information (to
.I syslog
or on the terminal in standalone mode). Extensive debugging information
is obtained by compiling the program with the
.B DEBUG
option.
.TP
.B \-s
.I (standalone)
When the server is run in the standalone mode, it sits in an
endless loop waiting for data to arrive on the TACACS port. If the
debug
.B (\-d)
option is not specified, the program forks and detaches itself from
the controlling terminal. All errors are logged to 
.IR stderr .
.\" ******************************************************************
.SH CONFIGURATION FILE
This version of
.B xtacacsd
supports a configuration file on the command line. The configuration
file can (optionally) list the WTMP, UTMP and the alternate PASSWORD files.
It also lists permissions and corresponding actions for each tacacs
request type.
.LP
The syntax of the config file is:
.RS
.ps-1
.sp .25
.nf
#
# Boolean options
BLANKPASSWORD
NONAMESERVER
IGNORECASE
HOSTWTMP
LOGGING
#QUIET
QUIETNOUSER
DEBUGLEVEL  2

## If processing a request takes longer than ABORTSECS, the process will
#  exit if this is set. A crude way to flush any pending requests in the
#  system queue. USE ONLY UNDER INETD.
#ABORTSECS  15

# Specify alternate UTMP and the WTMP files (strongly recommended)
WTMP	/var/xtacacs/wtmp
UTMP	/var/xtacacs/utmp

# Upto 5 password files. Command line arguments will precede this list.
# Specify DEFAULT if you are running NIS or shadow passwords and also want to
# search through those files.
PASSWD	DEFAULT
PASSWD	/etc/passwd.local
PASSWD	/usr/local/etc/passwd.xtacacs

##
# For authentication using an external stub program, use the 'AUTHTOKEN' 
# config lines. If the password field in the password file matches the keyword
# (i.e. password-string) specified in this config file, then the corresponding
# external program specified is run with the username and password on the
# command line. This external stub program should return 1 to permit access
# and 0 to deny access.
# Note that this can be any keyword (not limited to enigma or sdi).

#The password string is case sensitive and
# the external program must return 1 to permit access and 0 to deny access.
# 
#       AUTHTOKEN  <passwd-string>  <prog to exec for passwd auth>
AUTHTOKEN 	ENIGMA 	/usr/local/tacacs/bin/enigma 
AUTHTOKEN 	SDI 	/usr/local/tacacs/bin/sdi

## To put restrictions on the connections...
##
#
# While doing an 'exec', it adds on the username, host & line number
# at the end as an argument.
#
# [<list type>] <key> HOST {hostname} [<request type>] [<action>] <args>
#
#	where
#	<list type> is one of:
#		USER GROUP or GECO
#	<request type> is one of:
#		arap chap login connect enable slipaddr slipon all
#	<action> is one of:
#		permit deny norouting acl getok numlogin exec execdeny
#
.fi
.ps+1
.RE
.LP
The list can further be tailored using HOST to specify the terminal
server that is sending the tacacs request and LINE to specify the
tty line number (the LINE's are optional).

Note the syntax of the SLIP access-lists in the SLIP ACL configuration
line - it is
.I <acl in>
.B -
.I <acl out>
(separated by a hyphen). You need the new cisco software versions 
(above 9.21.5) for this functionality.

In following example, the user 'admin' will have an ACL of '0' (no
access-list) and a permit for *all* types of requests. SLIPaddr requests
will have the program 'mail_download' run on the server host.
Users in group 10 will be okay-ed against the program 'daytime_logins'
(which will be run with the username, gid, host & port as args).
This check is done AFTER the password has been verified.
Users in the group 10 will have an inbound slip ACL of 33 and outbound slip 
ACL of 44 applied when they go into slip mode.
Group 10 and users with 'slip' in the gecos field will be permitted 
to go into slip mode. They can also do an 'enable 5' in newer (>10.3) cisco
releases.
User 'bin' is denied all access.
Users with the keyword 'dialback' as the last string in the geco field
will be denied access (execdeny) and the program 'dialback.csh' will be run
(typically a routine to dialout to the remote user's home).
Users with 'slip' as the last string in the geco field will be
permitted access (subject to that fact that no previous line has denied
them access (order is important).
All remaining users will have an ACL of '8' on all connections, and
a limit of 5 on the number of logins.
The last entry is a catch-all so that all other users not listed will be
denied access.
.RS
.sp .25
.ps-1
.nf
##
#   <list> 	  <host [line]> 	 <req> 	 <action> 	<args>
#
USER admin	HOST all 	all	acl		0
USER admin	HOST all	all	permit

USER all 	HOST mycisco  LINE  13,14	login	deny
USER all	HOST all 	all	acl		8
USER all	HOST all  LINE all 	slipaddr execpermit /usr/bin/mail_download

GROUP 10 	HOST noontime 	login 	getok 		/bin/daytime_logins
GROUP 10 	HOST all  LINE 4,5,6,9 	slipon 	acl 		33-44
GROUP 10 	HOST 198.138.178.0 MASK 0.0.0.255 	slipon 	permit
GROUP 10	HOST all	enable level 5	permit

USER bin	HOST all  LINE 1,2,3,4	all	deny

GECO dialback	HOST cs500 	login	execdeny	/bin/dialback.csh
GECO slip	HOST all 	slipon	permit

USER  all	HOST all 	all	numlogin	5	

USER all	HOST all 	all	deny
.fi
.ps+1
.RE
.LP
There are three permission lists:
.IR user ,
.IR group ,
and
.IR gecos .
For the user-list, the 
.B key
is the 
.IR username ,
for the group-list it is the 
.IR gid ,
(NOT group-name, and the /etc/group file is also checked)
and for the geco-list it is a 
.I geco
string match (the last portion of the geco string if it has fields
separated by commas).
.LP
.LP
All configuration file entries are processed in the order they are read.
The first permit or deny match will stop any further searches.
Note that ACL entries do not set permit or deny, so put these entries
first in the config file. All other entries set permit or deny explicitly
on matching the key,
and will cause an immediate return without further searches.
.LP
If the 
.IR key ,
.IR hostname
and
.I request_type
match, the specified action is performed.
.\" ******************************************************************
.SH USEFUL TIDBITS (FAQs)
.LP
.IP \-
FOR LARGE NUMBER OF USERS, do the following:
.RS
.IP 1.
Use \fI Getpw \-c\fR to create DBM versions of the password file.
This will create two files with the extensions
.I .pag
and 
.I .dir
which are used automatically if they exist. Remember to re-create the DBM
files after making any changes to the passwd file.
.IP 2.
Increase the retry & timeout period on the Cisco (perhaps 4-7 seconds)
.IP 3.
Run a nameserver on the same machine on which you have xtacacsd (even
a cacheing server will help) or run with the \fI -n\fR option to not
use the nameserver at all.
.RE
.IP \-
On SysV based machines, the password age (expiry date) is stored in
the "age" field of the password file. In other systems, the password
expiry is stored in the "shell" field of the password file.
The format of this expiry date is:
.IR "Dec 22 1995" .
.IP \-
System V based machines expect 2 extra fields in their password files after
the GID field- the
.I age
and the
.I comment
field (followed by the gecos, dir and shell).
.RS
.ps-1
.nf
On non-SysV BSD-based machines:
    user : passwd : uid : gid : gecos : dir : shell
On sysV based machines:
    user : passwd : uid : gid : age : comment : gecos : dir : shell
.fi
.ps+1
.RE
If using shadow passwords, the expiry time is in the shadow password file
as a number which is the number of days since Jan 1, 1970.
xtacacsd first uses the value in the shadow password file, then the age
on SysV and finally checks in the shell field. (how even the Unix OS 
developers figure out which one to use is well beyond me).
.LP
.\" ******************************************************************
.SH XTACACS PROTOCOL LIMITATIONS 
The following are some of the limitations of the xtacacs protocol- these are
NOT a deficiency in the xtacacsd Unix software, but are simply not possible
using the current tacacs protocol.
.IP 1.
Cannot send back a separate IP address than the one that the user asked for.
.IP 2.
Cannot use the cisco
.I autocommand
configuration to specify a command to execute on the cisco when a user logs
into the commServer.
.IP 3.
Does NOT log packets or bytes transferred.
.IP 4.
Cannot use 'autoselect ppp' on the cisco and send queries to tacacs. These
are independent features.
.\" ******************************************************************
.SH BUGS
Please report new bugs and fixes to vikas@navya.com. Please look in the
.B TROUBLESHOOTING
section of the HTML document as well as the BUGS section in the HTML
documentation for a full and up-to-date list of bugs.
.IP 1.
During username searches in the system password files, the program converts
the username to all lowercase (if IGNORECASE is specified) and performs 
a search.
However, a true case insensitive  search is not possible since it uses the
getpwnam()  system call.
.IP 2
Due to vagaries in the utmp.h file on various platforms, your system's
.I last
or
.I ac
utilities might not be able to parse the wtmp and utmp files produced by
this daemon. Use the supplied
.I taclast
program instead, and process the times using awk/perl for accounting.
.IP 3.
The daemon tries to avoid duplicate entries in the UTMP and the WTMP
files, but duplicates/anomalies can show up if a terminal-server was
unreachable or crashed without sending out a 'xreload' message. Would
help to have a tool to periodically query all terminal servers and ensure
that the UTMP file is up to date.
.IP 4.
If there are multiple redundant servers and the primary goes down, the
wtmp & utmp files will get out of sync on the alternate and primary
xtacacs server hosts. In this case, you should use the accompanying
.I tacupd
program to extract the records and merge them into a single file.
.\" ******************************************************************
.SH FILES
.TP 20
.B /etc/xtacacsd
the main server
.TP 20
.B /etc/xtacacsd-conf
the xtacacsd config file.
.TP 20
.B /etc/passwd
default password file used for authentication
.TP 20
.B /var/adm/tacacs/utmp
file used to check number of allowed logins
.TP 20
.B /var/adm/tacacs/wtmp
file used to record all logins and logouts.
.TP 20
.BR wtmp. "<hostname>"
for host dependent wtmp records.
.\" ******************************************************************
.SH SEE ALSO
.BR taclast (1)
.BR tacupd (1)
.BR Getpw (1)
.BR inetd (8)
.BR inetd.conf (5),
.BR services (5),
.BR syslog (8)
.BR syslog.conf (5)
.LP
.IR "TACACS User Identification Telnet Option"
Brian A. Anderson,
.IR "RFC 927" ,
.IR "RFC 1492"
.\" ******************************************************************
.SH AUTHOR
This enhanced version of the software (with all the features described in this
man page) is written by
.B Vikas Aggarwal
.I (vikas@navya.com)
with contributions by many (See complete details in RELEASE).
Please send all bugs and suggestions to vikas@navya.com.
.LP
Greg Satz (satz@cisco.com), Cisco Systems. Original version from Cisco,
available from ftp.cisco.com.
.\" ******************************************************************
.SH SEE ALSO
.I tacplus
(available from ftp.cisco.com),
.IR radius ,
RFC1492
.\" ******************************************************************
.SH AVAILABILITY
.LP
Freely available from
.I http://www.netplex-tech.com/software
or from
.IR ftp://ftp.navya.com/pub/vikas/ .

