/*
 * $Header: /home/vikas/src/xtacacsd/RCS/tacutmp.h,v 1.3 1997/04/12 04:57:41 vikas Exp $
 *
 * Since the 10 lines of /usr/include/utmp.h  tend to be so unportable...
 *
 *	Vikas Aggarwal, vikas@navya.com, May 1995
 */

#ifndef _tacutmp_h
#define _tacutmp_h


#ifndef WTMP
# define WTMP	"/var/adm/tacacs/wtmp"
# define UTMP	"/var/adm/tacacs/utmp"
#endif

#define UT_LOGOUT_CHAR	'?'	/* first character of username in logout */

#define	UT_NAMESIZE	8
#define	UT_LINESIZE	8
#define	UT_HOSTSIZE	16
#define UT_COMMENTSIZE	16

#ifndef XTACUTMP	/* no comment field */

struct tacutmp {
	char	ut_line[UT_LINESIZE];
	char	ut_name[UT_NAMESIZE];
	char	ut_host[UT_HOSTSIZE];
	time_t	ut_time;
};

#else /* XTACUTMP */

/*
 * In xtacacsd-v4.0, the utmp and the wtmp file records have a comment
 * identifying each record. It can be the transaction-id or any other
 * string for identification.
 */
struct tacutmp {			/* new structure */
	char	ut_line[UT_LINESIZE];
	char	ut_name[UT_NAMESIZE];
	char	ut_host[UT_HOSTSIZE];
	time_t	ut_time;
	char 	ut_comment[UT_COMMENTSIZE];
};

#endif	/* XTACUTMP */

#endif /* _tacutmp_h */
