.\" $Id: tacupd.man,v 1.7 1997/07/16 06:25:22 vikas Exp $
.\"
.TH TACUPD 8  "April 1, 1996"
.SH NAME
tacupd \- Manipulate the WTMP and UTMP accounting files for xtacacsd
.SH SYNOPSIS
.B tacupd
[
.B  \-w
.I wtmp file
] [
.B  \-u
.I utmp file
]
.br
.RS
[\fB \-c \fI (clear entry) \fR]
.br
[\fB \-h \fI hostname \fR]
[\fB \-n \fI name-of-user \fR]
[\fB \-l \fI linename \fR]
.br
[\fB \-t \fI time-in-secs \fR]
.br
.RE
.LP
.B tacupd \-r
.I (convert text to wtmp)
[
.B \-f
.I text-file
]
.I > wtmp-file
.LP
.B tacupd \-a
.I (convert wtmp to text)
[
.B \-w
.I wtmp-file
] > text-file
.LP
.B tacupd \-R
(rollover wtmp files)
[
.B \-A
(ascii wtmp file)
] [
.B \-B
(binary wtmp file)
] [
.B \-w
.I wtmp-file
] [
.B \-u
.I utmp-file
] > new-wtmp-file
.\" ******************************************************************
.SH DESCRIPTION
.LP
.B tacupd
can manipulate the Unix style utmp and wtmp files created by xtacacsd v3.4
and later. It can be used to:
.IP \-
Clear an existing entry by specifying the name of user, line name, hostname.
Since there can be multiple entries, the program will prompt before deleting
an entry.
\fI Since no record locking is performed, this option should be used ONLY
on a file that is not being written to by xtacacsd.\fR
.IP \-
Add a new entry to the wtmp and utmp files. Specify the line, username,
host, and optionally, the time (in seconds) on the command line.
If the time is not specified, the current time is used.
To indicate a logout entry, either give no name on the command line or
in xtacacsd version v4.0 or after, specify the first character of the
name as a '?' character.
.IP \-
Dump an existing wtmp file format into ASCII by specifying the
.B \-a
option. This can be used to merge the contents of two wtmp files
together. It does not make sense to run this option on a UTMP file since
this file is not used for accounting records.
.IP \-
Recreate a wtmp file format from an ASCII dump. The wtmp file format is
used by accounting programs like
.B taclast
by using the
.B \-r
option.
.IP \-
Roll over wtmp files at end of month for accounting records. It writes
a logout entry in the old wtmp file for all users currently logged onto the
system and creates new login entries (writes them to stdout). It is advised
to use the following method for rolling over wtmp files:
.RS
.sp .25
.nf
   mv wtmp wtmp.old      # For binary wtmp files
   tacupd -B -R -w wtmp.old -u utmp > wtmp
   kill -HUP `cat /etc/xtacacsd.pid`
.fi
.RE
For ascii wtmp files, use the
.I \-A
option with tacupd (xtacacsd v4.1 can create ascii wtmp files). If you have
compiled with the \-DASCII_WTMP, then \-A is enabled by default, and you
should use the
.I \-B
option to work with binary wtmp files:
.RS
.sp .25
.nf
   mv wtmp.ascii wtmp.old      # For ASCII wtmp files
   kill -HUP `cat /etc/xtacacsd.pid` # flush out its file buffers
   tacupd -A -R -w wtmp.old -u utmp > wtmp.ascii
   kill -HUP `cat /etc/xtacacsd.pid` # close all file descriptors
.fi
.RE
.\" ****************
.LP
This program is meant to be a simple tool to allow administrators to
add or delete a user from the utmp or wtmp files created by
.I xtacacsd
in case the normal tacacs info packet gets lost on login/logout.
.LP
The 'time' value has to be specified in the number of secs since Jan 1970
(as in the output of the
.I time()
system call). If omitted, the current time is used.
All blank fields are replaced with a '*' character when converting to ascii.
Use the
.I taclast
program to display the contents of the wtmp or utmp files.
.SH XTACUTMP FORMAT
In xtacacsd v4.0 and above, the wtmp record structure has an extended
format (addition of a COMMENT field). Most of the programs have been
written to automatically detect older wtmp/utmp file formats and
write older format records, but it is advised to convert all existing
wtmp/utmp files to the new format using the syntax:
.IP
tacupd -a -w old-wtmp   > wtmp.ascii
.br
tacupd -r -f wtmp.ascii > wtmp.new
.LP
.SH INTERNALS
See the
.BR taclast (5)
man page for the internals.
.SH FILES
.I /var/adm/tacacs/wtmp
.I /var/adm/tacacs/utmp
.SH CAVEATS
No clean way to specify the time of entry (search for getdate.y in the
GNU archives to convert a time string into the number of secs).
.LP
No file locking is performed.
.SH AUTHOR
Vikas Aggarwal (vikas@navya.com)
.SH SEE ALSO
.I taclast (8)


