#!/usr/local/bin/perl

## THIS FILE IS HORRIBLY OUT OF DATE. RECOMMEND USE taclast
#  INSTEAD.
#
# @(#)tacstats	1.10 10/26/94

# COPYRIGHT, 1994, National Institues of Health.  This code may
# be freely used, modified, distributed, etc. provided this
# notice is included in all copies.  NO WARRANTY OF ANY KIND.
# Use at your own risk!
#
# AUTHOR:
#	 Jeffrey S. Posner -- jposner@web.nih.gov

# perl script to filter and format xtacacs records. Typical usage is:
#
#      sort syslog-1 syslog-2 | grep <MONTH> | tacstats
#
# NOTE: set tabstops=4
#
# usage:
#	tacstats -v -d -x -w window_size 
#		-v = verbose output - an extra log sent to stderr
#		-d = lots of useful debugging
#		-x = periodically dump the sliding window
#		-w = window size used for checking of duplicates
#		 HINT: The window size should be large enough to hold all
#		 the messages arriving in five minutes since this is how
#		 long a CS500 will resend until it gets a ack or gives up.
#
#  Reads from stdin, regular out to stdout, verbose out to stderr
#

# TBD
# I currently handle multiple logs by merge sorting in shell.  This is
# fine except that sorting logs re-arranges months of data according
# to the ascii sort order of the month name since this is the first
# thing in the log record.

# Process args
require "getopts.pl";
&Getopts('vxdw:');
# set the lines per page of STDERR to 50 for landscape
select((select(STDERR), $= = 50)[0]);
$stderr_sec=0;
# limit the default window size
$winsize = 25;
if ( $opt_w > 0 ) {
	$winsize=$opt_w;
}
foreach $op ('server_start', 'reload', 'login_accept', 'login_reject', 
	'xconnect', 'log_out', 'enable_accept', 'enable_reject', 'slip_on', 
	'slip_off', 'slip_reject', 'slip_accept', 'unknown', 'msg_repeats' ) {
	$opttl{$op} = 0;
}

# For every record in STDIN
while (<>) {
	chop;

	# filter records
	next if !/STAT:/ ;

	# save info from last message
	$lasttime=$time;
	$lastday=$day;
	$lastmon=$mon;

	# parse the record
    if( /^(...) (..) (..):(..):(..) ([a-zA-Z0-9]*) (.*STAT:)(.*)/ ) {
        $mon=$1;
        $day=$2;
        $hour=$3;
        $min=$4;
        $sec=$5;
		$time=$hour*3600 + $min*60 + $sec;
		$host=$6;
		$msg=$8;
    }
	($op,$user,$uid,$gid,$tty,$trans,$var1,$var2) = split(/:/,$msg);
	($gid,$from) = split (/ @/, $gid );
	$from=substr($from, 1);	
	$tty=substr($tty,5);
	$to="";
	$msg = $mon . $day . $hour . $op . $user . $tty . $var1 . $var2;
	
	#update the sliding window of messages and check for repeats.
	if( $window{$msg} && $op ne "Service" ) {
		$repeat=1;
	} else {
		delete $window{$keys[$counted % $winsize]};
		$keys[$counted % $winsize] = $msg;
		$window{$msg} = 1;
		$repeat=0;
	}
	# dump the window if needed
	if( $opt_x ) {
		&dumpwindow();
	}
	# increment overall record count do it here for mod arithmetic
	$counted += 1;

	if ( $day ne $lastday ) {
		if ( $lastday != 0 ) {
			&daily();
		}
		foreach $op ('server_start', 'reload', 'login_accept', 
			     'login_reject', 'xconnect', 'log_out',
			     'enable_accept', 'enable_reject', 'slip_on', 
			     'slip_off', 'slip_reject', 'slip_accept',
			     'unknown', 'msg_repeats' ) {
			$opcnt{$op} = 0;
		}
	}

	# increment individual host record counts
	if( $host ne $curhost ) {
		$lasthost=$curhost;
		$curhost=$host;
	}
	$hostcnt{$curhost} += 1;

	# increment individual and combined s/w start records
	if( $op eq "Service" ) {
		$start{$curhost} += 1;
		$op=server_start; 
		$user="";
		$tty="";
		$from="";
	}

	# increment individual and combined h/w reload records
	elsif( $op =~ /reload/ ) {
		$reload{$user} += 1;
		$op=reload; 
		$tty="";
		$from=$user;
		$user="";
	}


	# check other activitiy 
	elsif( $var1 eq "accepted" ) {
		if( $op =~ /login/ ) { $op=login_accept ; }
		elsif( $op =~ /enable/ ) { $op=enable_accept ; }
		elsif( $op =~ /slip/ ) { $op=slip_accept ; }
	}
	elsif( $var1 eq "rejected" ) {
		if( $op =~ /login/ ) { $op=login_reject ; }
		elsif( $op =~ /enable/ ) { $op=enable_reject ; }
		elsif( $op =~ /slip/ ) { $op=slip_reject ; }
	}
	elsif( $op =~ /xconnect/ ) { $op=xconnect; $to=$var1; }
	elsif( $op =~ /logout/ ) { $op=log_out ; }
	elsif( $op =~ /slipon/ ) { $op=slip_on ; }
	elsif( $op =~ /slipoff/ ) { $op=slip_off ; }
	else { $op=unknown ; }
	
	# If it's a duplicate countit as such.  If not, increment op counter.
	if( $op ne unknown && $repeat ) {
		$lastop = $op ;
		$op = msg_repeats;
		$opcnt{$op} += 1;
		$opttl{$op} += 1;
	} else {
		$opcnt{$op} += 1;
		$opttl{$op} += 1;
		$lastop = $op ;
	}

	# check for debugging
	if( $opt_d ) {
		print "$op	$opcnt{$op}	$_\n";
	}

	# Add a record to the verbose log
	if( $op ne unknown && $opt_v ) {
		if ( $stderr_sec == 0 ) {
    		select((select(STDERR), $^ = STDERR_SEC )[0]);
			$stderr_sec=1;
		} elsif ( $stderr_sec == 1 ) {
    		select((select(STDERR), $^ = STDERR_TOP )[0]);
			$stderr_sec=2;
		}
		write STDERR;
	}
}
# flush counts at the end of the log and do summary
$lastday=$day;
$lastmon=$mon;
&daily();
&summary();

sub summary {
	undef $total;
	undef $date;
	$a = "-----------";
	$b = "-----------";
	$c = "-----------";
	$d = "-----------";
	$e = "-----------";
	$f = "-----------";
	$g = "-----------";
	$h = "-----------";
	$i = "-----------";
	$j = "-----------";
	$k = "-----------";
	$l = "-----------";
	$m = "-----------";
	$n = "-----------";
	$o = "-----------";
	$total = "-----------";
	write;

    $date = "Total";
    $a = $opttl{server_start};
    $b = $opttl{reload};
    $d = $opttl{login_accept};
    $e = $opttl{login_reject};
    $f = $opttl{log_out};
    $g = $opttl{enable_accept};
    $h = $opttl{enable_reject};
    $i = $opttl{slip_accept};
    $j = $opttl{slip_reject};
    $k = $opttl{slip_on};
    $l = $opttl{slip_off};
    $m = $opttl{unknown};
    $n = $opttl{msg_repeats};
    $o = $opttl{xconnect};
    foreach $op (keys(%opttl)) {
        $total +=  $opttl{$op} ;
    }
    write;

	# print S/w restart counts by server
	undef $total;
	printf"\n\n";
	foreach $host (sort keys(%start)) {
		print "Xtacacsd daemon on $host started $start{$host} times\n";
		$total += $start{$host};
	}
	print "Total daemon restarts: $total\n";

	# print h/w reload counts by CS500 
	undef $total;
	printf"\n\n";
	foreach $cs500 (sort keys(%reload)) {
		print "CS500 $cs500 reloaded $reload{$cs500} times\n";
		$total += $reload{$cs500};
	}
	print "Total CS500 reloads: $total\n";

	# print operation counts per server
	undef $total;
	printf"\n\n";
	foreach $host (sort keys(%hostcnt)) {
		print "$host handled $hostcnt{$host} messages\n";
		$total += $hostcnt{$host};
	}
	print "Total messages: $total\n\n";
}

sub daily {
	undef $total;
	$date = "$lastmon-$lastday";
    $a = $opcnt{server_start};
    $b = $opcnt{reload};
    $d = $opcnt{login_accept};
    $e = $opcnt{login_reject};
    $f = $opcnt{log_out};
    $g = $opcnt{enable_accept};
    $h = $opcnt{enable_reject};
    $i = $opcnt{slip_accept};
    $j = $opcnt{slip_reject};
    $k = $opcnt{slip_on};
    $l = $opcnt{slip_off};
    $m = $opcnt{unknown};
    $n = $opcnt{msg_repeats};
    $o = $opcnt{xconnect};
    foreach $op (keys(%opcnt)) {
        $total +=  $opcnt{$op} ;
    }
    write;
}

sub abs {
	local($n1,$n2) = split;
	$n1-$n2 > 0 ? $n1-$n2 : $n2-$n1;
}

sub dumpwindow {
	foreach $i (0..$winsize-1) {
		print "$i	$keys[$i]\n";
	}
}

format STDOUT_TOP =
       S/W   H/W        Login                        Enable    SlipAdr    Slip Message   Total
Date   Start Reload Accept Reject Logout Connect Accept Reject Reject  On     Off    Unkown Repeats Operations

format STDOUT =
@<<<<< @||||| @|||| @||||| @||||| @||||| @|||||| @||||| @||||| @|||||  @||||| @||||| @||||| @|||||| @||||||
$date, $a,    $b,   $d,    $e,    $f,    $o,     $g,    $h,    $j,     $k,    $l,     $m,    $n,     $total
.

format STDERR_TOP = 
When             What          From                    To                    TTY    Who          
---------------  ------------  ----------------------  --------------------  -----  ------------------
.

format STDERR = 
@<</@< @<:@<:@< @<<<<<<<<<<<   @<<<<<<<<<<<<<<<<<<<<<  @<<<<<<<<<<<<<<<<<<<  @<<<<  @<<<<<<<<<<<<<<<<<
$mon,$day,$hour,$min,$sec,$lastop,$from,           	   $to,              $tty,  $user
.
 
format STDERR_SEC =
====================================== VERBOSE OUTPUT ================================================
When             What          From                    To                    TTY    Who          
---------------  ------------  ----------------------  --------------------  -----  ------------------
.
