.\" $Id: taclast.man,v 1.3 1997/04/14 04:37:32 vikas Exp $
.\"
.TH TACLAST 8  "April 1, 1996"
.SH NAME
taclast \- Extract current and old login data from Cisco
.I xtacacsd
wtmp and utmp files.
.SH SYNOPSIS
.B taclast
[
.B  \-f
.I wtmp or utmp file
]
[
.B \-a
.I (ASCII WTMP file)
]
[
.B \-b
.I (binary WTMP file)
]
[
.B \-d
.I (debug)
]
[
.B \-h
.I hostname
]
[
.B \-i
.I (ignore host name)
]
[
.B \-t
[
.B \-t
]
.I (total times)
]
[
.B \-w
.I (read UTMP file)
]
[
.I user ...
]
.\" ******************************************************************
.SH DESCRIPTION
.LP
.B taclast
can process the Unix style utmp and wtmp files created by xtacacsd v3.4 (and
above) and display the time that the users were connected on the terminal
server.
It can be given the names of the 
.IR users ,
and
.IR hosts ,
for which to extract the data.
Each line of output contains the user name, the tty line number on the
terminal server where the user was logged in, the terminal server name and
the times of login and logout on the terminal server. The output is in
reverse time order.
If the session is still continuing or was cut short by a crash or shutdown,
.B taclast
will so indicate.
.LP
.TP
.B \-f
.I <filename>
.B taclast
reads the file listed instead of the compiled default WTMP or UTMP file.
.TP 
.B \-a
xtacacsd v4.1 and above create ASCII wtmp files (for ease of manipulation).
If you are using taclast on an ASCII wtmp file, use this option. If you have
compiled with the ASCII_WTMP option, then this is enabled by default and you
have to use the
.I \-b
option to process any binary wtmp files.
.TP 
.B \-b
If the wtmp file is binary format (this is the default unless you have
compiled with ASCII_WTMP in which case -a is enabled).
.TP 
.B \-h
.I <hostname>
To list the records for a particular host only. Host names may be names or
internet numbers.
.IP \-i
taclast differs from typical Unix 'last' since it looks at the the hostname
in addition to the linename- while processing login times and records, it
makes sure that the hostname and the linename are the same for the
record. The
.I \-i
option tells taclast to ignore the hostname and just look at the line
numbers. If processing a host specific WTMP file, use this option.
.TP
.B \-t
This prints out the total times for the users and the hosts (all if nothing
is supplied on the command line).
\fI If you specify this option twice, then ONLY the totals will be 
printed out. \fR
.TP
.B \-w
If taclast is invoked as
.I tacwho
or the
.I \-w 
option is specified, it acts like the Unix
.I "w"
program and prints out the users
.I currently
on the various Cisco CommServers. It extracts the records from the compile
time default UTMP file (not the WTMP file) unless the 
.I \-f
option is used for an alternate UTMP file.
.\" *********************************************************
.LP
The output of this program shows the number of seconds that the user was
connected on the system. These delta times are independent of the timezone or
whether daylight savings time is in effect.
.LP
The pseudo-user
.I reboot
logs at reboots of the system, thus
.I taclast reboot
will show all the times that the Cisco terminal server was reloaded.
.LP
The output also includes the seconds that the user was connected. This is
to facilitate accounting.
.SH INACCURATE ENTRIES
While printing out the wtmp records, a number of entries and total times
may be flagged as 'inaccurate' by the program.
.LP
The program uses a simple algorithm to see if the login + logout pair
on a TTY are correct.
.IP
If the login is followed by a logout AND the usernames are the same, then
the record is accurate.
.IP
Else, the record is inaccurate (there is a missing login or logout record
which might be due to heavy system load, Unix system unreachability, etc.
.LP
.I taclast
flags all incorrect times and also prints out the incorrect seconds in the
totals.
.SH INTERNALS
The traditional Unix utmp entries have been the username, tty host and
timestamp are recorded in the utmp structure at login.
At logout, the entry made has a null username.
All accounting programs processing these files match the TTY field to 
correlate login with logout entries.
This method suffers from the fallacy that if a logout entry is lost, then the
time of the user on the system is erroneous.
.LP
In xtacacsd v4.0, the records stored in the wtmp and utmp files store
logouts in a slightly modified format. Instead of a NULL username, the
first character of the username is set to a
.B '?'
character, so that the accounting programs can compare the username in
logouts to verify the times.
.LP
In xtacacsd v4.1, the first character of the
.I comment
field has been changed to
.B '?'
instead of the first character in the username. This permits taclast from
accurately differentiating between user Asmith and Bsmith (a possible
coincidence ?). The GID is also stored in the comment field so that
accounting programs can possibly charge different rates for different
group ID's.
.SH AUTHOR
Vikas Aggarwal (vikas@navya.com)  for the xtacacsd software package.
xtacacsd can be obtained from http://www.netplex-tech.com/software.
.SH FILES
.I /var/adm/tacacs/wtmp
.I /var/adm/tacacs/utmp
login data base (/etc/passwd)
.SH SEE ALSO
.I tacupd (1)
.I xtacacsd


