/* $Header: /home/vikas/src/xtacacsd/RCS/tacacct.c,v 1.6 1997/06/05 18:15:25 vikas Exp $ */

/*+ taccact.c
 * 	This module is for doing billing of tacacs records. If taclast
 * is compiled with -DTACACCT, then the alternate structures and
 * functions that are in this file are used.
 *
 * This module calls the 'timerange' functions in order to convert the
 * login interval into the hours and days matrix. It extracts each
 * terminal server's timezone, and then multiplies the total times with
 * the rates.
 *
 * YOU MUST GET THE timerange.o CORRESPONDING TO YOUR HARDWARE PLATFORM
 * AND COPY IT INTO THIS DIRECTORY BEFORE DOING A 'make tacacct'
 * THE timerange.o MODULES ARE AVAILABLE FROM :
 *
 *	http://www.netplex-tech.com/software/xtacacs
 *
 * Copyright 1997 (c)  Vikas Aggarwal, vikas@navya.com
 * 	This code can NOT be used for ANY commercial purpose without 
 * 	prior written permission from the author.
 *	It is provided without any warranty (implied or otherwise).
 * 
 */

/*
 * $Log: tacacct.c,v $
 * Revision 1.6  1997/06/05 18:15:25  vikas
 * Major rewrite - mostly cleanup and optimization.
 *
 *
 * Revision 1.5  1997/01/14 06:21:59  vikas
 * Stripped away all the taclast code and added ifdefs so that this
 * can be an independent module separate from taclast.
 *
 * To be added:
 * 	- hashing for faster access to timezones
 *
 */

#ifdef TACACCT

#ifndef lint
static char rcsid[] = "$RCSfile: tacacct.c,v $ $Revision: 1.6 $ $Date: 1997/06/05 18:15:25 $" ;
#endif /* not lint */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>			/* password file definitions */
#include <sys/time.h>
/* #include <tzfile.h>			/* for SECSPERDAY, etc. */

#include "tacutmp.h"			/* our very own utmp.h file */
#include "tacacct.h"			/* common structure with taclast.c */

#ifndef MAX
# define MAX(A,B)      ((A) > (B) ? (A) : (B))
#endif

#ifndef WKDAY		/* should match the definitions in timerange.c */
# define WKDAY 0
# define WKEND 1
# define HOLID 2
#endif

extern ARG  *HOSTarglist, *USERarglist;		/* head of linked lists */

static char *
get_groupid(bp)
  struct tacutmp *bp;
{
  char  *grp = "DEFAULT";
  static char sgrp[8];
  char  name[16];
  struct passwd *pw;

#ifdef XTACUTMP
  if (strncmp(bp->ut_comment, "GID", 3) == 0)	/* extract from bp record */
    return ( (grp = bp->ut_comment + 3) );
#endif

  /* Probably can get the GROUP from the /etc/passwd file or something */
  strncpy(name, bp->ut_name, sizeof(bp->ut_name));
  setpwent();
  if ( (pw = getpwnam(name)) == NULL)   /* case sensitive */
  {
    char lname[128];
    register char *lp = lname, *np = name;
    while (*lp = tolower(*np++))        /* convert query to lower */
      lp++;
    *lp = '\0';                       /* just being extra careful */
    setpwent();
    pw = getpwnam(lname);             /* try lowercase username */
  }

  if (pw) {
    sprintf(sgrp, "%d", pw->pw_gid);	/* convert to string */
#ifdef DEBUG
    fprintf(stderr, "Extracted group %s for user %s from password file\n",
	    sgrp, name);
#endif
    return (sgrp);
  }
  else {
#ifdef DEBUG
    fprintf(stderr, "getpwnam() returned no such user %s\n", name);
#endif
  }
  fprintf(stderr,
	  "tacacct: WARNING, setting DEFAULT group for user '%s'\n", name);
  return(grp);
}	/* get_groupid() */

/*
 * Add the delta seconds to the total number of seconds. Add to the arglist
 * if this is a new host or name and nothing was supplied on the command line.
 */
addsecs(bp, delta, isaccurate)
  struct tacutmp *bp;
  time_t delta;
  int isaccurate;		/* whether delta is confirmed accurate */
{
  ARG	*steph, *stepu;
  int	numranges;
  long	*hrangeptr;			/* hourly ranges */
  long	(*sumptr)[3];			/* sum of WKDAY, WKEND, HOLIDAY */
  extern time_t tstzone, loctzone;	/* in taclast.c */
  extern int noargs;


  /* ** HOST list ** */
  for (steph = HOSTarglist; steph; steph = steph->next)
    if (!strncasecmp(steph->name, bp->ut_host, UT_HOSTSIZE))
      break ;
  if (!steph && noargs) {		/* new host, add to linked list */
    char *s = (char *)malloc(UT_HOSTSIZE + 1);
    strncpy (s, bp->ut_host, UT_HOSTSIZE);
    addarg(HOST_TYPE, s);
    steph = HOSTarglist;
  }
  /* ** USER list ** */
  for (stepu = USERarglist; stepu; stepu = stepu->next)
    if (!strncmp(stepu->name, bp->ut_name, UT_NAMESIZE))
      break ;
  if (!stepu && noargs)	/* new username, add to linked list */
  {
    char *s = (char *)malloc(UT_NAMESIZE + 1);
    strncpy (s, bp->ut_name, UT_NAMESIZE);
    addarg(USER_TYPE, s);
    stepu = USERarglist;
  }

  if (steph) {
    steph->maxsecs = MAX(steph->maxsecs, delta);	/* update max time */
    ++(steph->count);
  }
  if (stepu) {
    stepu->maxsecs = MAX(stepu->maxsecs, delta);	/* update max time */
    ++(stepu->count);
  }

  if (stepu && (stepu->groupid == NULL || *(stepu->groupid) == '\0'))
  {
    char *groupid = get_groupid(bp);

    stepu->groupid = (char *)malloc(strlen(groupid) + 1);
    strcpy(stepu->groupid, groupid);
  }

  numranges = get_group_timesum(stepu->groupid,
				  bp->ut_time, (bp->ut_time + delta),
				  tstzone,  &hrangeptr, &sumptr);

  if (stepu)
  {
    register int i;

    for (i = 0; i < numranges; ++i)
    {
      (stepu->ac)->totsecs[i][WKDAY] += sumptr[i][WKDAY];
      (stepu->ac)->totsecs[i][WKEND] += sumptr[i][WKEND];
      (stepu->ac)->totsecs[i][HOLID] += sumptr[i][HOLID];
    }

    if (isaccurate == 0)	/* inaccurate data */
    {
      for (i = 0; i < numranges; ++i)
      {
	(stepu->ac)->errsecs[i][WKDAY] += sumptr[i][WKDAY];
	(stepu->ac)->errsecs[i][WKEND] += sumptr[i][WKEND];
	(stepu->ac)->errsecs[i][HOLID] += sumptr[i][HOLID];
      }
    }	/* if (inaccurate data) */
  }	/* if stepu */

  if (steph) steph->totsecs += (long)delta;
  if (stepu) stepu->totsecs += (long)delta;

  if   (!isaccurate)
  {
    if (steph) steph->errsecs += (long)delta;
    if (stepu) stepu->errsecs += (long)delta;
  }

}	/* end: add_secs() */

/*+ pr_totaltimes()
 *
 * Print out the array of times and the total rate. For each user, get the
 * rate applicable to his/her 'groupid'.
 */
pr_totaltimes()
{
  register int i;
  int	numranges;
  unsigned long	avgsecs;
  long	*hrangeptr;	/* hourly range ptr scanned from config file */
  long	(*sumptr)[3];
  float	(*rateptr)[3];
  ARG	*step;
  extern time_t  tstzone;

  printf("\n============ USER REPORTS ============\n");

  /* USER stats */
  for (step = USERarglist; step; step = step->next)
  {
    struct acctstats *ac = step->ac;
    float totcost = 0, errcost = 0;

    numranges = get_group_timesum(step->groupid, 0, 0, tstzone,
			      &hrangeptr, &sumptr);
    get_group_rate(step->groupid, &rateptr);	/* rates for this group */

    printf("\nUSER %s (Group %s) USAGE (hh:mm:ss)\n",
	   step->name, step->groupid);
    printf(" range     (rates/hr)     weekday    weekend    holiday\n");

    for (i = 0; i < numranges; ++i)
    {
      printf(" %02ld-%02ld  %2.2f/%2.2f/%2.2f  %3ld:%02ld:%02ld  %3ld:%02ld:%02ld  %3ld:%02ld:%02ld\n",
	     hrangeptr[i],  hrangeptr[(i+1)%numranges],
	     rateptr[i][WKDAY], rateptr[i][WKEND], rateptr[i][HOLID],
	     ac->totsecs[i][WKDAY]/3600, (ac->totsecs[i][WKDAY]/60) % 60,
	     ac->totsecs[i][WKDAY] % 60,
	     ac->totsecs[i][WKEND]/3600, (ac->totsecs[i][WKEND]/60) % 60,
	     ac->totsecs[i][WKEND] % 60,
	     ac->totsecs[i][HOLID]/3600, (ac->totsecs[i][HOLID]/60) % 60,
	     ac->totsecs[i][HOLID] % 60);
	   
      totcost  = totcost +
	(ac->totsecs[i][WKDAY] * rateptr[i][WKDAY]) +
	(ac->totsecs[i][WKEND] * rateptr[i][WKEND]) +
	(ac->totsecs[i][HOLID] * rateptr[i][HOLID]);
      errcost = errcost +
	(ac->errsecs[i][WKDAY] * rateptr[i][WKDAY]) +
	(ac->errsecs[i][WKEND] * rateptr[i][WKEND]) +
	(ac->errsecs[i][HOLID] * rateptr[i][HOLID]);
    }	/* end for(i) */

    avgsecs = step->totsecs/step->count;
    printf("\n\tTOTAL ENTRIES = %d, Online max/avg(HH:MM)= %3ld:%02ld/%ld:%02ld",
	    step->count, step->maxsecs/3600, (step->maxsecs/60)%60,
	    avgsecs/3600, (avgsecs/60)%60);
    printf(", Error= %ld%%\n", step->errsecs * 100 /step->totsecs);
    if (totcost || errcost)
    {
      totcost /= 3600; errcost /= 3600;	/* convert into HOURLY rates */
      printf("\tTOTAL CHARGES = %.2f (possible error %.0f%% = %.2f)\n",
	     totcost, (errcost * 100)/totcost, errcost);
    }
  }	/* end for(step) */		  


  /* Print out HOST statistics */
  printf("\n============ HOST REPORTS ============\n");
  printf("      HOST       Usage(HH:MM)  Entries     Max     Avg\n");
  for (step = HOSTarglist; step; step = step->next)
  {
    avgsecs = step->totsecs/step->count;
    printf("%16.16s   %3ld:%02ld       %3d     %3ld:%02ld  %3ld:%02ld\n",
	   step->name, step->totsecs/3600, (step->totsecs/60)%60, step->count,
	   step->maxsecs/3600, (step->maxsecs/60)%60,
	   avgsecs/3600, (avgsecs/60)%60);
  }	/* end for(step) */		  

}	/* pr_tacacct_totals() */

#endif /* TACACCT */
