/*
 * Copyright, 1994, National Institutes of Health, Bethesda, MD
 *
 * Rights to re-use and reproduce provided the above copyright is included
 *
 * Program to be used as a driver for Security Dyanmics sd_check() for
 * use with xtacacs as the stub password verification program.
 *
 * You need the SecureID headers to build (they come standard with all
 * SecureID products) so anyone interested in using this program should 
 * already have any external files needed (headers and library).
 *
 * To build, use:
 *	cc -g sdcheck.o -o sdcheck sdiclient.a
 *
 * AUTHOR:
 *	Jeffrey S. Posner <jposner@saratoga.dcrt.nih.gov>, Aug 1994
 *
 * USAGE:
 *	sdcheck username password
 *
 * MODIFICATIONS:
 *
 *	10/26/94	jposner
 *		Filters duplicate retries from the cisco since these
 *		duplicates make the secureid server think the card is 
 *		under attack and disables the card.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/file.h>
#include <unistd.h>
#include <time.h>

#include "sdi_athd.h"
#include "sdi_size.h"
#include "sdi_type.h"
#include "sdacmvls.h"
#include "sdconf.h"

#define TRANSFILE "/usr/local/bin/transactions"
#define MAXTIME 360
#define MAXPRNLEN 16
#define TIMELEN 4

/* configure must be global */
union config_record configure;

main( argc, argv )
     int argc;
     char **argv;
{
    struct SD_CLIENT sd_dat, *sd;
    struct tm *tp;
    int fd;
	int minute;
	int found=0;
    char buf[MAXPRNLEN+1];
	char prn[MAXPRNLEN+1];
	int count=0;
	int first_idx=0;
	time_t when;
	time_t now;
	time_t first=0;
	time_t last=0;

    if( argc != 3 ) {
	fprintf(stderr, "usage: %s: name  passcode\n", argv[0] );
	exit(0);
    }

	now = time(NULL);
	sprintf(prn, "%*.*s", MAXPRNLEN, MAXPRNLEN, argv[2] );

	fd=open(TRANSFILE, O_RDWR|O_CREAT);
	flock(fd, LOCK_EX);
	while( read(fd, buf, MAXPRNLEN) == MAXPRNLEN ) {
		buf[MAXPRNLEN] = 0;
		read( fd, &when, TIMELEN );
		if( !first ) {  
			first=when;
			first_idx=count;
		}
		if ( when < first ) {
			first=when;
			first_idx=count;
		}
		else if ( when > last ) last = when;			
		count++;
		if( (now - when) < MAXTIME && strcmp( prn, buf ) == 0 ) {
			fprintf(stderr, "PRN %s was handled at %s", prn, 
ctime(&when) );
			found++;
			break;
		}
  	}
	if( !found ) {
		if( last-first > MAXTIME ) 
			lseek( fd, first_idx*(MAXPRNLEN+TIMELEN), SEEK_SET );
		else
			lseek( fd, 0, SEEK_END );

		sprintf(buf, "%*.*s", MAXPRNLEN, MAXPRNLEN, prn );
		write( fd, buf, MAXPRNLEN);
		write( fd, &now, TIMELEN);
		fprintf(stderr, "PRN added: %s at:%s", prn, ctime(&now) );
	}
	flock(fd, LOCK_UN );
	close(fd);
    if( found )
		exit(0);
			

    sd = &sd_dat;
    memset( sd, 0, sizeof(struct SD_CLIENT) );
    creadcfg();
    if( sd_init(sd)) {
	fprintf(stderr, "Can't Initialize ace client server communications\n");
	exit(0);
    }

    if( (sd_check( argv[2], argv[1],  sd )) == ACM_OK )
      exit(1);
    else
      exit(0);
}
