/*
 * $Header: /home/vikas/src/xtacacsd/RCS/ph.c,v 1.7 1997/07/16 06:28:36 vikas Exp $
 */

#ifdef QI

/*
 * ph.c --
 *
 * Interface ph (CSO, Qi) to the xtacacsd here. Basically, a replacement 
 * for pw_verify. Adapted from code found in the qtacacs distribution. 
 *
 *
 * Chap/Arap not supported yet.
 * Need to supply the various field-names from your database in config file.
 * Leave undefined if you dont have these in your database (uid, gid, gecos)
 * The group is set to the string "PH" if QI_GID is not set in config file.
 *
 *
 * Modified by Vikas Aggarwal, vikas@navya.com
 *
 * Original version by:
 *	David M. Meyer 503/346-1747
 *	meyer@phloem.uoregon.edu
 *	Thu Feb  2 07:25:21 1995
 *
 * $Log: ph.c,v $
 * Revision 1.7  1997/07/16 06:28:36  vikas
 * Compiler for AIX define's _AIX
 *
 * Revision 1.6  1997/04/14 06:12:34  vikas
 * Dont need to define EXTERN before including common.h due to changes
 * in common.h (looks for ifdef MAIN now).
 *
 * Revision 1.5  1996/05/19  17:28:22  vikas
 * Updated for use with the new authent() result codes. Also
 * implemented timeout read_qi()
 *
 * Revision 1.4  1996/03/13  21:25:14  vikas
 * Reads the field names from the xtacascd config file (perm.c) instead
 * of hardcoded defines. (pirard@vm1.ulg.ac.be)
 *
 * Revision 1.3  1996/03/13  20:30:28  vikas
 * Can extract more password fields from the QI database
 *
 * Revision 1.2  1996/02/12  09:51:55  vikas
 * Untested but stable version.
 *
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <syslog.h>
#include <fcntl.h>
#include <sys/time.h>		/* for timeval struct definition */
#include <unistd.h>
#include <sys/syslog.h>
#include <pwd.h>
#if defined(AIX) || defined(_AIX)
# include <sys/select.h>
#endif

#include "common.h"		/* tacacsd definitions */
#include "qiapi.h"		/* from the ph/unix/ distribution */

/*************  CUSTOMIZE THESE DEFINES  ************/

/*
 * Result if QI server dead: A_PASS, A_FAIL, A_NOUSER, A_ERROR
 * Use Quiet option with to not send a response if server down.
 */
#define	QI_DEFAULT_RESULT	A_ERROR

/*
 * The following is optional, and dependent on your database fields.
 * QI fields can be defined to be used by xtacacsd in the same way as those
 * from a password file. In particular, gid and gecos are passed to the
 * getok external routine. 
 * Write a line in xtacacsd config file to match each database field name.
 * The field name in the example is suggested for new QI fields definitions.
 */

/* Set QI_type  if you have defined a specific entry TYPE for these logins
 ** QI_type  dialup
 * Set QI_uid  to the field NAME (if defined) for extracting a UID for user
 ** QI_uid  dialup-uid
 * Set QI_gid  to the name of the field for extracting a GrpId for the user
 ** QI_gid   dialup-gid
 * Set QI_shell  to the name of the field for extracting shell or expire time
 ** QI_shell dialup-expire
 * Set QI_gecos  to the name of the field for extracting comments for user
 ** QI_gecos dialup-gecos
 */

/* following usually need not be customized */

#ifndef       QLOGIN_TYPE
# ifdef LQ_PASSWORD
#  define       QLOGIN_TYPE     LQ_PASSWORD	/* Normal, not Kerberos */
# endif
#endif        


/*************** END CUSTOMIZATIONS *************/

char  *QI_host1   = "127.0.0.1";	/* Primary QIServer hostname */
char  *QI_host2   = NULL;	/* secondary one */
char  *QI_timeoutstr = "10";	/* timeout in secs (string) */
char  *QI_type   = NULL;	/* QI records type name */
char  *QI_uid    = NULL;	/* QI uid field name */
char  *QI_gid    = NULL;	/* QI gid field name */
char  *QI_shell  = NULL;	/* QI expiration date name */
char  *QI_gecos  = NULL;	/* QI gecos field name */

static  int   ServerOpen = 0;		/* have a server? */
static  long  QI_timeout = 0;		/* timeout string converted */
static  char  *QI_host = NULL;		/* Current QiServer hostname */
static  char  *Alias = NULL;
static  FILE  *ToQi = NULL;		/* write to the Qi */
static  FILE  *FromQi = NULL;		/* read from the Qi */
static	QIR   *timeout_ReadQi() ;

struct passwd *fill_pwdstruct() ;

/*
 * authent_qi -- 
 *
 * Send the Username and Password from a TACACS query to a the CSO (Qi)  
 * name server.
 * NO CHAP support yet (dunno how to extract the CHAP username from the
 * database without logging in).
 *
 * Parameters:
 * 	Username -- pointer to Username string
 *	Password -- pointer to password string. If this is a null pointer,
 *		    then this is filled in with the CHAP/ARAP field (dont
 *		    do a login to the nameserver).
 *	ppw      -- pointer to a passwd structure that is filled in by this
 *			module. Important fields in this structure are:
 *		pw->name (recorded in the utmp and wtmp files)
 *		pw->passwd  (for CHAP/ARAP queries)
 *		pw->shell  (used in check_expiration, set to expiry date or /)
 *		pw->group  (set to a number to control permissions or NULL)
 *		pw->gecos  (any non-comma string used to control permissions)
 *
 *
 * Returns:
 *	A_PASS if valid password
 *	A_FAIL if invalid password
 *	A_NOUSER  if no-such-user
 *	A_ERROR  if any other error
 *
 */


authent_qi(Username, Password, ppw, checkpw)
     char    *Username;		/* supplied by user in tacacs pkt */
     char    *Password;
     struct  passwd **ppw;	/* to be filled in by this module */
     int checkpw;		/* whether check passwd or not, ignored */
{
  int 	i, j;
#ifdef QLOGIN_TYPE
  int	opts = QLOGIN_TYPE;	/* Login options */
#else
  int  opts  = 0x01;		/* auto login */
#endif
  QIR 	*qp, *qt;
  char	*cp;
  char	response[SOME_ARBITRARILY_LARGE_NUMBER];
  char	qtype[SOME_ARBITRARILY_LARGE_NUMBER];


  if (QI_type != NULL)
    sprintf(qtype, "type=%s", QI_type);
  else
    qtype[0] = '\0';

  if (!QI_timeout) {
      if (QI_timeoutstr)
	if ((QI_timeout = strtol(QI_timeoutstr, (char **)NULL, 10)) <= 0)
	  QI_timeout = 10;	/* take no chances */
  }

/*
 *    Get the server open if we don't already have it.
 */

  if (!ServerOpen)
    if (OpenQi(QI_host1, &ToQi, &FromQi) >= 0)
    {
	QI_host = QI_host1;
	ServerOpen = 1;
    }

  if ((!ServerOpen) && QI_host2 != NULL)
    if (OpenQi(QI_host2, &ToQi, &FromQi) >= 0)
    {
        QI_host = QI_host2;
        ServerOpen = 1;
        report(LOG_INFO, "Opened alternate QI server %s", QI_host);
    }

  if (!ServerOpen) {
      if (QI_DEFAULT_RESULT == A_PASS)
	report(LOG_WARNING,"Can't open QI server: validating %s by default",
	       Username);
      else
	report(LOG_WARNING,"Can't open QI server: returning %d for %s",
	       QI_DEFAULT_RESULT, Username);
      *ppw = fill_pwdstruct(Username, Password, /*uid*/ NULL, /*grp*/NULL,
			    /*shell*/ "/", /*gecos*/ "PH");
      return(QI_DEFAULT_RESULT);
  }

  bzero(response, SOME_ARBITRARILY_LARGE_NUMBER);

/*
 *    Truncate Username at first non alphanumeric and not '-' or '.'. 
 */

  for (cp = Username; *cp; cp++)
    if (!isalnum(*cp) && *cp != '-' && *cp != '.')
      *cp = '\0';
  if (strlen(Username) < 3) {
    report(LOG_WARNING, "authent_ph: Username too small %s", Username);
    return(A_FAIL);	/* not okay */
  }

#ifdef DEBUG
  if (debug)
    report(LOG_DEBUG, "PH querying for Username= %s", Username);
#endif

  if (debug > 1)
    QiDebug = debug - 1;

/*
 * For all practical purposes, the QI database treats the "alias" field
 * as unique in its database. Hence, we make all queries with the alias
 * set to Username.
 */

  fprintf(ToQi, "query alias=%s %s return alias\n", Username, qtype);
    
  (void) fflush (ToQi);

  /* Check if the server  is dead */
  if ((qp = timeout_ReadQi(FromQi, &i)) == QIR_NULL) {
      if (QI_DEFAULT_RESULT == A_PASS)
	report(LOG_ERR,
	       "authent_ph: could not read: validating %s by default", Username);
      else
	report(LOG_ERR,
	       "authent_ph: could not read: sending %d for %s",
	       QI_DEFAULT_RESULT, Username);
      ServerOpen = 0;
      fclose(FromQi);
      fclose(ToQi);
      *ppw = fill_pwdstruct(Username, Password, /*uid*/ NULL, /*grp*/NULL,
			    /*shell*/ "/", /*gecos*/ "PH");
      return(QI_DEFAULT_RESULT);
  }

#define Return_Qierror(F, P)  { FreeQIR(F);   *P = NULL;  return(A_FAIL); }

  if (i == 0) {
    report(LOG_INFO, "authent_ph: %s: no such %s entry", Username, qtype);
    Return_Qierror(qp, ppw);
  }

  /* Queries should only return a single match */
  if (i != 1) {
    report(LOG_ERR, "authent_ph: %s: multiple matches to %s query",
	   Username, qtype);
    Return_Qierror(qp, ppw);
  }


  /* check if returned alias matches the query */
  qt = PickField(qp, FieldValue("alias"));
  if (qt == QIR_NULL || abs(qt->code) != LR_OK) {
      report(LOG_ERR, "authent_ph: error in  alias field for %s", Username);
      Return_Qierror(qp, ppw);
  }
  if (strncasecmp(qt->message, Username, strlen(qt->message)) ) {
      report(LOG_ERR, "authent_ph: Returned Alias '%s' != Username '%s'",
	     qt->message, Username);
      Return_Qierror(qp, ppw);
  }
      
  if (Alias != NULL)	  /* Set global Alias to alias returned from qi */
    free(Alias);
  Alias = (char *) Strdup(qt->message);
  
  
  if (QI_type != NULL) 		/* Examine type field for validity */
  {
      qt = PickField(qp, FieldValue("type"));
      if (qt == QIR_NULL || abs(qt->code) != LR_OK) {
	  report(LOG_ERR, "authent_ph: Cannot get type field for %s",
		 Username);
	  Return_Qierror(qp, ppw);
      }

      if (strstr(qt->message, QI_type)) {
	  report(LOG_ERR, "authent_ph: type field %s .ne. %s",
		 qt->message, QI_type);
	  Return_Qierror(qp, ppw);
      }
  }

  fflush(ToQi);
  fflush(FromQi);

  if (checkpw)
  {
#ifdef DEBUG
      if (debug > 2)
	report(LOG_DEBUG,"authent_ph: issuing QI login command for %s", Alias);
#endif

      if ((LoginQi(QI_host, ToQi, FromQi, opts, Alias, Password)) == NULL) {
	  report(LOG_INFO, "authent_ph: %s: login failed", Alias);
	  *ppw = NULL;
	  return(A_FAIL);
      }
  }	/* end: if(checkpw) */

  /*
   * Here if successfully logged in OR we are not checking the password.
   * If we are not checking the password, make the relevant fields public
   * readable in the PH database.
   * Now query for all the fields for the entry.
   */
  fprintf(ToQi, "query alias=%s %s return all\n", Alias, qtype);
  (void) fflush (ToQi);
  /*    If the server is dead here, return error */
  if ((qp = timeout_ReadQi(FromQi, &i)) == QIR_NULL) {
      report(LOG_ERR, "authent_ph: could not read from server");
      *ppw = fill_pwdstruct(Username, Password, /*uid*/ NULL, /*grp*/NULL,
			    /*shell*/ "/", /*gecos*/ "PH");
      return(A_ERROR);
  }

  /* Now extract the various fields and fill in the password structure. */
  extract_fields(qp, qt, Username, Password, ppw);
  return(A_PASS);

#undef Return_Qierror		/* macro not required anymore  */

}	/* end: authent_ph() */


/*+
 * Extract the various fields from the database and fill in the
 * password structure.
 */

/* Macro function to avoid repetitious typing while extracting fields */
#define DoPickField(QVa, QSt) {  \
    if (QVa != NULL && *QVa != NULL) { \
	qt = PickField(qp, FieldValue(QVa)); \
	  if (qt == QIR_NULL || abs(qt->code) != LR_OK) \
	    report(LOG_WARNING,"authent_ph: error in extracting %s field for %s", \
		   QVa, Username); \
	  else \
	    strcpy(QSt, qt->message); \
    } }
			     
extract_fields(qp, qt, Username, Password, ppw)
     QIR *qp, *qt ;
     char *Username, *Password;
     struct passwd **ppw ;
{
    static char uidst[16], gidst[16], shellst[32], gecost[32];

    uidst[0] = gidst[0] = '\0';
    shellst[0] = '/';
    gecost[0] = '\0';

    DoPickField(QI_uid, uidst);
    DoPickField(QI_gid, gidst);
    DoPickField(QI_shell, shellst);
    DoPickField(QI_gecos, gecost);
    
    *ppw = fill_pwdstruct(Username, Password, /*uid*/ uidst, /*grp*/gidst,
			  /*shell*/ shellst, /*gecos*/ gecost);

}	/* end: extract_fields() */


struct passwd *
fill_pwdstruct(User, Pass, Uid, Gid, Shell, Gecos)
     char *User, *Pass, *Uid, *Gid, *Shell, *Gecos;
{
    static struct passwd pw;

    pw.pw_name = User;
    pw.pw_passwd = Pass;
    if (Uid && *Uid)
      pw.pw_uid = strtol(Uid, (char **)NULL, 10);
    else
      pw.pw_uid = NULL ;
    if (Gid && *Gid)
      pw.pw_gid = strtol(Gid, (char **)NULL, 10);
    else
      pw.pw_gid = NULL;
    pw.pw_shell = Shell;
    pw.pw_gecos = Gecos;

    return (&pw);

}	/* end: fill_pwdstruct() */


/*
 * ReadQi implemented using timeouts
 */
static QIR * 
timeout_ReadQi(f, pitems)
     FILE *f;
     int *pitems;
{
    int nfound;
    int fd;
    fd_set readfds;
    struct timeval timeout;

    timeout.tv_usec = 0L;
    timeout.tv_sec  = QI_timeout;	/* read timeout in seconds */

#ifdef DEBUG
    if (debug > 2)
      report(LOG_DEBUG, "(dbg) timeout_ReadQi: timeout set to %ld", QI_timeout);
#endif
    fd = fileno(f);
    FD_ZERO (&readfds); FD_SET(fd, &readfds);
    nfound = select(fd + 1, &readfds, NULL, NULL, &timeout);

    if (nfound < 0) {		/* some error */
	report(LOG_ERR, "timeout_ReadQi select ERROR: %s", sys_errlist[errno]);
	goto abort;
    }
    if (nfound == 0) {
	syslog(LOG_ERR, "timed out reading from QI server");
	goto abort;
    }
    if (!(FD_ISSET(fd, &readfds)) ) {	/* shouldn't happen */
	syslog(LOG_ERR, "timeout_ReadQi ERROR: Wrong FD_ISSET (wierd)");
	goto abort;
    }

    return(ReadQi(f, pitems));

 abort:
    return (NULL);

}	/* end timeout_ReadQi() */


#endif 	/* Qi server */
