/*
 * $Header: /home/vikas/src/xtacacsd/RCS/misc.c,v 1.5 1997/01/09 11:04:13 vikas Exp $
 */

/*
 * Miscellanous routines for xtacacsd.
 *
 * skip_spaces():
 *	Given a string pointer, returns a pointer after skipping the
 * 	leading spaces.
 *
 * Strdup():
 *	Duplicate a string (like strdup).
 *
 * report():
 *	Like syslog(), but prints to stderr, looks at logging, etc.
 *
 *
 *	-Vikas Aggarwal, vikas@navya.com, June 1995
 *
 * $Log: misc.c,v $
 * Revision 1.5  1997/01/09 11:04:13  vikas
 * Moved the uwtmp() related routines to a separate file.
 *
 *
 * Revision 1.1  1995/07/14  16:18:47  vikas
 * Initial revision
 *
 *
 */

#ifndef lint
 static char rcsid[] = "$RCSfile: misc.c,v $ $Revision: 1.5 $ $Date: 1997/01/09 11:04:13 $" ;
 static char sccsid[] = "$RCSfile: misc.c,v $ $Revision: 1.5 $ $Date: 1997/01/09 11:04:13 $" ;
#endif

#include <sys/types.h>
#include <stdio.h>
#ifdef __STDC__
# include <stdarg.h>		/* ANSI C, variable length args for report() */
#else
# include <varargs.h>		/* has 'vararg' definitions */
#endif
#include <string.h>
#include <errno.h>
#include <syslog.h>
/* #include <unistd.h>		/* for SEEK_ defintions */

#include "common.h"	/* all extern type definitions */

/*+ report:
 *
 * This routine reports errors and such via stderr and syslog() if
 * appopriate.  It just helps avoid a lot of if-else in the code.
 *
 * The syntax is identical to syslog(3), but %m is not considered special
 * for output to stderr (i.e. you'll see "%m" in the output. . .).  Also,
 * control strings should normally end with \n since newlines aren't
 * automatically generated for stderr output (whereas syslog strips out all
 * newlines and adds its own at the end).
 *
 * Print to stderr only in debug+standalone (otherwise the process closes
 * the stderr, etc. file descriptors on startup).
 */

#ifdef __STDC__
report (int priority, char *fmt, ...)
#else
report(priority, fmt, va_alist)
     int priority;
     char *fmt;
     va_dcl			/* no terminating semi-colon */
#endif
{
    char msg[256];		/* temporary string */
    va_list ap;

#ifdef __STDC__
    va_start(ap, fmt);
#else
    va_start(ap);
#endif
    vsprintf (msg, fmt, ap);
    va_end(ap);

    if (stand)
      fprintf (stderr, "(xtacacsd) ") ;

    /*
     * if compiled with DEBUG, log DEBUG messages at the INFO level
     */
       
    if (priority == LOG_DEBUG)
    {
#ifdef DEBUG
	if (debug && logging)
	  syslog(LOG_INFO, "%s", msg);
#endif
	if (debug && stand)
	  fprintf(stderr, "%s\n", msg);

    }

    else if (priority == LOG_INFO)	/* log only if logging */
    {
	if (logging)
	  syslog(LOG_INFO, "%s", msg);
	if (debug && stand)
	  fprintf(stderr,  "%s\n", msg);

    }
    else		/* more urgent */
    {
	syslog(priority, "%s", msg);
	if ( (priority == LOG_NOTICE && stand) || priority < LOG_NOTICE)
	  fprintf(stderr, "%s\n", msg);
    }

    return ;
}	/* end report() */



/*+ skip_spaces
 *
 * 	Skip leading spaces in the string passed to it and return back
 * a char pointer.
 */
char *skip_spaces(str)
     char *str ;
{
    if (str == NULL)
      return (str);
    while (*str == ' '  || *str == '\t')
      ++str ;                           /* skip leading spaces */
 
    return(str) ;
}

/*+ Strdup:
 *	Ultrix doesn't have a strdup(), so here's one...
 *
 */
char *Strdup(s)
     register char *s ;
{
    char *t ;
    
    if (s == NULL)
    {
        t = (char *)malloc(1);
        *t = '\0';
    }
    else
    {
        t = (char *)malloc(strlen(s) + 1);
        if (t != NULL)
          (char *)strcpy(t, s);
        else
	{
	    perror("Strdup: malloc()");
	    exit(1);
	}
    }
    
    return (t);
}	/* end: Strdup() */



