/*
 *      custpb1.c
 *
 *
 *      Main module for ID program using parameter block.
 *      This code is for demonstration.
 *
 */

#define ESC 0x1b

/* #define GUARDIAN */
/* #define WANG     */

#include <stdio.h>
#ifdef GUARDIAN
#   include <stdlib.h>
#endif
#include <string.h>
#include <ctype.h>

#include "custpb.h"
#include "custf.h"

/* declare internal routines for custpb.c */

#ifdef __STDC__
/* #ifdef GUARDIAN */
void    do_id (void);
void    do_slid (void);
void    execem (int);
void    gogo (int);
void    gonogo (void);
void    updlogs (void);
void    initpb (void);
void    savdata (void);
void    getfixed (void);
void    ppause (char *, int);
char   *fmtstr ();
void    print_msg (void);
#else
void    do_id ();
void    do_slid ();
void    execem ();
void    gogo ();
void    gonogo ();
void    updlogs ();
void    initpb ();
void    savdata ();
void    getfixed ();
void    ppause ();
char   *fmtstr ();
void    print_msg ();
#endif

#ifdef __STDC__
/* #ifdef GUARDIAN */
extern void pbmain (struct pblk *);
#else
extern void pbmain ();
#endif
#ifdef UNIX
extern void uninitenv ();
#endif

/*   misc defines   */

char   *ptitle = "\nSafeWord Security Check      PBLK Test V1.1     Enigma Logic Inc.\n";

struct pblk pblock;             /* parameter block for safeword check */
char    instrBuf[80];           /* general use buffer */
char    savdyn[24];             /* buffers to save entries for logs */
char    savcha[24];

int     sli_input;
int     sli;                    /* single line input mode flag */
short   slichal = SLI_CHAL_ACE_FP;      /* define single line input device
                                         * type */

/* ============================== main1 () =============================== */

int
main1 (argc, argv)
int     argc;
char   *argv[];
{
    int     i;
    char    c;
    char   *argmsg;

	if (argc > 1)
    {
        sli = 1;
    }
    else
    {
        sli = 0;
    }

    if (sli)
    {
        do_slid ();             /* single line input security ck */
    }
    else
    {
        do_id ();               /* normal security ck */
    }
}

/* ------------------------------ do_id () ------------------------------ */
/*
 *      Prompt user for ID verification.
 */

void
do_id ()
{
    struct pblk *pb;
    char    instr[80];
    int     i;
    int     index;
    pbint   lastchal;


    pb = &pblock;               /* pointer to parameter block */
    initpb ();
    *savdyn = *savcha = '\0';   /* init pwd save bufs */
    lastchal = pb->mode = CHALLENGE;    /* Set mode to challenge first */

    puts (ptitle);

tryagain:

/*
 *       Screen to input user name. Note that it is the responsiblity of the
 *       calling program to determine whether or not to echo the username.
 */

    puts ("\nUsername: ");
    fgets (instr, sizeof (pb->id), stdin);
    instr[strlen (instr) - 1] = '\0';

    if (strlen (instr) == 0)
    {
        if (pb->mode == CHALLENGE)
        {
            gonogo ();
            return;
        }
/*
 *  comment out the else if you want to redo the same id on the 2nd try
 *   when they only press return
 */
/*      else
        {
            goto failem;
        }
*/
    }
    else
    {
        strcpy (pb->id, instr);
    }

/*
 *       Call to ID program to get challenge information.
 *       pb->id and pb->mode must be set properly and the ID program
 *       must know where to find the pblk.
 */
    pbmain (pb);

/*
 *       We have returned here after the ID program has executed in the
 *       CHALLENGE or RECHALLENGE mode. It has left various information
 *       about the user in the pblk.
 */

    if (pb->status == PASS)     /* if they dont need passwords and all else
                                 * ok */
        goto passem;            /* then they get in here */

/*  Here we test to see if they failed because of time locks, hack(attack) lock
 *   etc. If they have we jump down to execute the failure. Note that
 *   we let the BAD_USER go on thru. We do this for two reasons.
 *   1. To give the user another chance in case he simply made an error.
 *   2. Disguise the bad id to hackers(attackers).
 *   Evaluation will always fail on bad user names.
 */
    if (pb->status != GOOD_USER && pb->status != BAD_USER &&
        pb->status != GOOD_NO_CHAL)
    {
        goto failem;
    }

/*
 *       Challenge screen. Any messages such as password size, and nearing
 *       password expiration are displayed. The dynamic password challege
 *       is displayed (if pb->dynpwdf is set and there is text in pb->chal).
 *       The user is prompted for the needed passwords.
 */

range:

    if (pb->msg1[0])
    {
        puts (fmtstr ("%s\n", pb->msg1));
    }

    if (pb->msg2[0])
    {
        puts (fmtstr ("%s\n", pb->msg2));
    }

    if (pb->dynpwdf == ENABLED && pb->status != GOOD_NO_CHAL)
    {
        if (pb->chal[0] != '\0')
        {
            puts (fmtstr ("Challenge: %s", pb->chal));
        }

        puts ("\nDynamic PassWord: ");
        fgets (instr, sizeof (pb->dynpwd), stdin);
        instr[strlen (instr) - 1] = '\0';
        strcpy (pb->dynpwd, instr);

        if (pb->dynpwd[0] == ESC)
        {
            pb->dynpwd[0] = '\0';
        }

        if (pb->fixpwdf == ENABLED && pb->dynpwd[0])
        {
            getfixed ();
        }
    }
    else
    {
        if (pb->fixpwdf == ENABLED)
        {
            getfixed ();
        }
    }

    savdata ();                 /* save data for logging */

/*
 *       Call to ID program to evaluate the entered passwords.
 *       pb->mode, pb->dynpwd, pb->fixpwd, and pb->nfixpwd must be set
 *       properly and the ID program must know where to find the pblk.
 */
    pb->mode = EVALUATE_ALL;
    pbmain (pb);

/*
 *       We have returned here after the ID program has executed in the
 *       EVALUATE_ALL mode. It has left the outcome of the evaluation
 *       in pb->status. In addition it there may be an execution cmd,
 *       and messages to the user.
 */

    if (pb->status == PASS_PIN)
    {
        puts ("\nDo you want to change your PIN? (Y/N): ");
        fgets (instr, sizeof (instr), stdin);
        instr[strlen (instr) - 1] = '\0';

        if (toupper (instr[0]) != 'Y')
        {
            goto passem;
        }

        pb->mode = CHANGE_PIN;
        pb->dynpwd[0] = 0;
        pbmain (pb);
        print_msg ();

        if (pb->chal[0] != 0)
        {
            puts (fmtstr ("\nChallenge: %s", pb->chal));
        }
        index = 0;
        puts ("\nDynamic PassWord: ");
        fgets (instr, sizeof (pb->dynpwd), stdin);
        instr[strlen (instr) - 1] = '\0';
        strcpy (pb->dynpwd, instr);

        if (pb->dynpwd[index] == ESC || pb->dynpwd[index] == 0)
        {
            goto passem;
        }

        index = strlen (pb->dynpwd);
        for (;;)
        {
            pbmain (pb);

            if (pb->status == PIN_VERIFIED || pb->status == PIN_NOT_VERIFIED)
            {
                goto passem;
            }

            if (pb->status == PIN_FOUND || pb->status == PIN_NOT_FOUND)
            {
                break;
            }

            print_msg ();
            puts ("\nDynamic PassWord: ");
            fgets (instr, sizeof (pb->dynpwd) - strlen (pb->dynpwd) - 1, stdin);
            instr[strlen (instr) - 1] = '\0';
            strcat (pb->dynpwd, instr);

            if (pb->dynpwd[index] == ESC || pb->dynpwd[index] == 0)
            {
                goto passem;
            }

            index = strlen (pb->dynpwd);
        }

        pb->mode = VERIFY_PIN;
        pbmain (pb);

        if (pb->status == FAIL)
        {
            goto passem;
        }

        print_msg ();
        puts (fmtstr ("\nChallenge: %s", pb->chal));
        puts ("\nDynamic PassWord: ");
        fgets (instr, sizeof (pb->dynpwd) - strlen (pb->dynpwd) - 1, stdin);
        instr[strlen (instr) - 1] = '\0';
        strcpy (pb->dynpwd, instr);

        if (pb->dynpwd[0] == ESC || pb->dynpwd[0] == 0)
        {
            goto passem;
        }

        pb->mode = VERIFY_PIN;
        pbmain (pb);
        goto passem;
    }

    if (pb->status == PASS || pb->status == PASS_MASTER)
    {
        goto passem;            /* if they passed */
    }

    if (pb->errcode == RANGE)   /* if out of range, get 2nd password */
    {
        goto range;
    }

    if (lastchal == RECHALLENGE)/* if this was their second try, fail */
    {
        goto failem;
    }

/*
 *   We are here if they failed the first time thru. We now use the
 *   RECHALLENGE mode which instructs the ID module to turn off APG
 *   thereby allowing resyncronization.
 */

    lastchal = pb->mode = RECHALLENGE;
    goto tryagain;

/*
 *       We are here if they passed the security check.
 */

passem:

    execem (1);
    return;
/*
 *       We are here if they failed the security check.
 */

failem:

    execem (0);
}







/* ------------------------------ DoID1 () ------------------------------ */
/*
 * Accept username, dynamic PassWord, and optional fixed password and
 * optional NewFixedPassword with its RptNewFixedPW from calling
 * function, then construct a parameter block and evaluate all.
 */

DoId1 (name, DynamicPassWord, FixedPW, NewFixedPassword, RptNewFixed)

#ifdef SYSV
char name[SOME_ARBITRARILY_LARGE_NUMBER];
char DynamicPassWord[SOME_ARBITRARILY_LARGE_NUMBER];
char FixedPW[SOME_ARBITRARILY_LARGE_NUMBER];
char NewFixedPassword[SOME_ARBITRARILY_LARGE_NUMBER];
char RptNewFixed[SOME_ARBITRARILY_LARGE_NUMBER];
#else
char *name, *DynamicPassWord, *FixedPW, *NewFixedPassword, *RptNewFixed;
#endif

{
struct pblk *pb;
char    instr[80];
int     try,i,j;
pbint   lastchal;

pb = &pblock;               /* pointer to parameter block */
/*
* Initialize the SafeWord Parameter Block
*/
initpb ();

/*
* Initialize important buffers, and fields within SafeWord
* Parameter Block
*/
*savdyn = *savcha = '\0';           /* init save bufs */
lastchal = pb->mode = slichal;      /* Set mode to challenge first */
try = 1;

/*
* Invoke the SafeWord API. (Although for the very simple token
* devices supported here this step may not be strictly necessary,
* we are doing it anyway to be consistent with past and future
* applications that must invoke the SafeWord API here to get
* challenge and ID prompt. The overhead for this is fairly
* low. At worst, this is harmless, and at best it initializes
* all relevant Parameter Block fields to familiar states.)
*/
pbmain (pb);


if (strlen (name) == 0)
	{               /* Inputs are all null. Terminate appropriately. */
	return(0);      /* Return 0 tells xtacacsd to deny access */
	}

/*
* Get here if user name is NOT null.
*
* Clear out Id, Dynamic Password fields and fixed password fields in 
* SafeWord Parameter Block
*/
pb->id[0] = pb->dynpwd[0] = pb->fixpwd[0] = '\0';

/* Insert name into Parameter Block */
for (i = 0; name[i] && i < sizeof (pb->id); i++)
	{
	pb->id[i] = name[i];
	}

/*
* Null terminate Id field in Parameter Block
*/
pb->id[i] = 0;

/*
* collect dynamic password and stuff into dynpwd field of
* SafeWord parameter block
*/
for (j = 0; DynamicPassWord[j] && j < sizeof (pb->dynpwd); j++)
	{
	pb->dynpwd[j] = DynamicPassWord[j];
	}
/*
* Null terminate dynpwd field of SafeWord Parameter Block
*/
pb->dynpwd[j] = 0;
/* remove trailing spaces from ID and replace with NULLs */
for (i = strlen (pb->id) - 1; pb->id[i] == ' '; i--)
	{
	pb->id[i] = 0;
	}
/*
* Copy fixed password field (FixedPW) into the SafeWord
* Parameter Block
*/
for (j=0; FixedPW[j] && j < sizeof(pb->fixpwd); j++)
	{
	pb->fixpwd[j]=FixedPW[j];
	}
/*
* Null terminate fixpwd field of SafeWord Parameter Block
*/
pb->fixpwd[j]=0;

/*
* Copy New fixed password field (NewFixedPassword) into the SafeWord
* Parameter Block
*/
for (j=0; NewFixedPassword[j] && j < sizeof(pb->nfixpwd); j++)
	{
	pb->nfixpwd[j]=NewFixedPassword[j];
	}

/*
* Null terminate NewFixedPassword field of SafeWord Parameter Block
*/
pb->nfixpwd[j]=0;

/*
 * Make sure that NewFixedPassword==RptNewFixed. If not, then DON'T
 * update NewFixedPassword and make sure access is denied!
 */
for(j=0; NewFixedPassword[j] && j < sizeof(pb->nfixpwd); j++)
	{
	if(NewFixedPassword[j] != RptNewFixed[j])
		{ /* No match null out everything to assure denial of access*/
		pb->nfixpwd[0]='\0';
		pb->fixpwd[0]= '\0';
		pb->dynpwd[0]= '\0';
		}
	}

/*
* Set up mode field of SafeWord Parameter Block to request
* Single-Line-Input Evaluate All
*/
pb->mode = SLI_EVAL;        /* go evaluate input */

/*
* Invoke the SafeWord API
*/
pbmain (pb);
savdata();
updlogs ();

if (pb->status == PASS)
	{
	return(1);      /* Tell xtacacsd to grant access */
	}
else
	{
	return(0);      /* Tell xtacacsd to deny access */
	}
}









/* ------------------------------ do_slid () ------------------------------ */
/*
 *      Prompt user for ID verification.
 *
 *      SINGLE LINE INPUT VERSION (for PFX or ACE)
 *      use SLI_CHAL_PFX for pfx, SLI_CHAL_ACE for ace in decl of slichal
 */

void
do_slid ()
{
    struct pblk *pb;
    char    instr[80];
    int     try,
            i,
            j;
    pbint   lastchal;


    pb = &pblock;               /* pointer to parameter block */
    initpb ();
    *savdyn = *savcha = '\0';   /* init save bufs */
    lastchal = pb->mode = slichal;      /* Set mode to challenge first */
    try = 1;
    puts (ptitle);

tryagain:

    pbmain (pb);                /* get challenge & ID prompt */

    if (pb->chal[0] != '\0')
    {
        puts ("\nChallenge: ");
        puts (fmtstr ("%s", pb->chal));
    }

    puts (fmtstr ("\n%s", pb->msg1));
    sli_input = 1;
    fgets (instr, sizeof (instr), stdin);
    instr[strlen (instr) - 1] = '\0';

    if (strlen (instr) == 0)
    {
        if (try == 1)
        {
            gonogo ();
            return;
        }
        else
        {
            pb->msg1[0] = '\0';
            pb->msg2[0] = '\0';
            goto failem;
        }
    }
    sli_input = 0;

    pb->id[0] = pb->dynpwd[0] = '\0';

    /* parse name up to comma */
    for (i = 0; instr[i] && instr[i] != ',' && i < sizeof (pb->id); i++)
    {
        pb->id[i] = instr[i];
    }

    pb->id[i] = 0;

    if (instr[i] == ',')
    {
        i++;
    }

    /* skip any spaces after comma */
    for (; instr[i] && isspace (instr[i]); i++)
    {
        continue;
    }

    /* collect password */
    for (j = 0; instr[i] && j < sizeof (pb->dynpwd); i++, j++)
    {
        pb->dynpwd[j] = instr[i];
    }
    pb->dynpwd[j] = 0;

    /* remove trailing spaces from ID */
    for (i = strlen (pb->id) - 1; pb->id[i] == ' '; i--)
    {
        pb->id[i] = 0;
    }

    savdata ();                 /* save data for logging */

    pb->mode = SLI_EVAL;        /* go evaluate input */
    pbmain (pb);

    if (pb->status == PASS)
    {
        goto passem;
    }

    /* if no pwd or out of range **chg** */
    if (pb->status == GOOD_USER || (pb->status == FAIL && pb->errcode == RANGE))
    {

        /*
         * we go to regular prompt mode; every thing should be
         * setup for us
         */
        if (pb->msg1[0])
        {
            puts (fmtstr ("\n%s\n", pb->msg1));
        }

        if (pb->msg2[0])
        {
            puts (fmtstr ("\n%s\n", pb->msg2));
        }

        if (pb->dynpwdf == ENABLED && pb->errcode == DPWD)
        {
            if (pb->chal[0] != 0)
            {
                puts (fmtstr ("\nChallenge: %s", pb->chal));
            }

            puts ("\nDynamic PassWord: ");
            fgets (instr, sizeof (pb->dynpwd), stdin);
            instr[strlen (instr) - 1] = '\0';
            strcpy (pb->dynpwd, instr);

            if (pb->dynpwd[0] == ESC)
            {
                pb->dynpwd[0] = '\0';
            }

            if (pb->fixpwdf == ENABLED && pb->dynpwd[0])
            {
                getfixed ();
            }
        }
        else
        {
            if (pb->fixpwdf == ENABLED)
            {
                getfixed ();
            }
        }

        savdata ();             /* save data for logging */

        /*
         * Call to ID program to evaluate the entered passwords.
         * pb->mode, pb->dynpwd, pb->fixpwd, and pb->nfixpwd must
         * be set properly and the ID program must know where to
         * find the pblk.
         */

        pb->mode = EVALUATE_ALL;
        pbmain (pb);

        if (pb->status == PASS || pb->status == PASS_MASTER)
        {
            goto passem;        /* if they passed */
        }

        if (try == 1)
        {
            if (pb->errcode == FPWD || pb->errcode == DPWD ||
                pb->status == BAD_USER)
            {
                pb->mode = slichal;
                try++;
                goto tryagain;
            }
        }
        goto failem;
    }                           /* else not good usr w/o pwd */
    else
    {
        if (try == 1)
        {
            if (pb->errcode == FPWD || pb->errcode == DPWD ||
                pb->errcode == BADID)
            {
                pb->mode = slichal;
                try++;
                goto tryagain;
            }
        }
        goto failem;
    }

/*
 *       We are here if they passed the security check.
 */

passem:

    execem (1);
    return;

/*
 *       We are here if they failed the security check.
 */

failem:

    execem (0);
}

/* --------------------------- execem () ---------------------------- */
/*
*   Execute pass or fail action as per passed flag
*/
void
execem (passed)
int     passed;
{
    struct pblk *pb;


    pb = &pblock;               /* pointer to parameter block */

    if (pb->msg1[0] || pb->msg2[0])     /* if messages, display them */
    {
        if (pb->msg1[0])
        {
            puts (fmtstr ("\n%s", pb->msg1));
        }

        if (pb->msg2[0])
        {
            puts (fmtstr ("\n%s", pb->msg2));
        }

        if (passed)
        {
            puts ("\n\nPress <RETURN> to continue");
            fgets (instrBuf, sizeof (instrBuf), stdin);
        }
        else
        {
            puts ("\n\n");
        }
    }

/*
 *       Any custom execution code should be installed here. This includes
 *       things like special actions taken for MASTER and BAD_IO.
 */

    updlogs ();

    if (passed && pb->status == PASS_MASTER)
    {
        gogo (PASS_MASTER);
    }
    else
    {
        if (passed)
        {
            gogo (PASS);
        }
        else
        {
            gonogo ();
        }
    }
}

/* ---------------------------- gogo () ------------------------------- */
/*
*   take action on authorized entry
*/

void
gogo (type)
int     type;
{
#ifdef UNIX
    /*
     * Under Unix uninitenv will close any open files associated with
     * the SafeWord (r) database and release all it's signal handlers.
     * also any record locks acquired will be released.
     */
    uninitenv ();
#endif
    if (type == PASS_MASTER)
    {
        printf ("\nPassed MASTER entry\n");
        exit (0);
    }

    printf ("\nPassed user entry\n");
    printf ("Application: %s   Parameter line: %s\n", pblock.appl, pblock.parm);
    exit (0);
}

/* ---------------------------- gonogo () ------------------------------- */
/*
*   take action on failed entry
*/

void
gonogo ()
{
#ifdef UNIX
    /*
     * Under Unix uninitenv will close any open files associated with
     * the SafeWord (r) database and release all it's signal handlers.
     * also any record locks acquired will be released.
     */
    uninitenv ();
#endif
    puts ("\nFailed entry\n");
    printf ("Application: %s   Parameter line: %s\n", pblock.appl, pblock.parm);
    exit (0);
}

/* ----------------------------- updlogs () --------------------------- */
/*
*       Update id server logs: usage(access) & fail, and access(database).
*/

void
updlogs ()
{
    if (pblock.dynpwd[0] == '\0')       /* use 1st pwd entered if none
                                         * entered */
    {                           /* on 2nd try */
        strcpy (pblock.dynpwd, savdyn);
        strcpy (pblock.chal, savcha);
    }

    pblock.mode = UPDATE_LOGS;  /* update access(database) rec and logs */
    pbmain (&pblock);
}

/* ---------------------------- initpb () ---------------------------- */

void
initpb ()
{                               /* initialize parameter block */
    char   *pbptr = (char *) &pblock;
    int     i;

    for (i = 0; i < sizeof (pblock); i++)
    {
        *pbptr++ = 0;
    }

    strcpy (pblock.uport, "custpb");
    pblock.status = NO_STATUS;
}

/* ---------------------------- savdata () ---------------------------- */
/*
*       Save dynamic password and challenge for logging in case user
*       enters null string on 2nd attempt.
*/
void
savdata ()
{
    if (pblock.dynpwd[0])       /* save for logging */
    {
        strcpy (savdyn, pblock.dynpwd);
        strcpy (savcha, pblock.chal);
    }
}

/* -------------------------- getfixed () ------------------------------ */
/*
*       Input fixed password from user and put in pblock
*/
void
getfixed ()
{
    char    fp[32],
            fpv[32];
    struct pblk *pb;

    pb = &pblock;               /* pointer to parameter block */

/*  Note that the MASTER fixed pw can not be changed here, it can only
 *   can only be changed in idutil. Therefore the following message could
 *   be omitted for master entry if so desired.
 */

    puts ("\n(Enter <Esc> if you wish to change your password)");
    puts ("\nFixed password: ");
    fgets (instrBuf, sizeof (pb->fixpwd), stdin);
    instrBuf[strlen (instrBuf) - 1] = '\0';
    strcpy (pb->fixpwd, instrBuf);

    if (pb->fixpwd[0] == ESC)
    {
        puts ("\nOld Fixed password: ");
        fgets (instrBuf, sizeof (pb->fixpwd), stdin);
        instrBuf[strlen (instrBuf) - 1] = '\0';
        strcpy (pb->fixpwd, instrBuf);
        puts ("\nNew Fixed password: ");
        fgets (instrBuf, sizeof (fp), stdin);
        instrBuf[strlen (instrBuf) - 1] = '\0';
        strcpy (fp, instrBuf);

        if (fp[0] != 0)
        {
            if (!pb->echofix)   /* if not echoing, ask for verify */
            {
                puts ("\nRepeat new Fixed password: ");
                fgets (instrBuf, sizeof (fpv), stdin);
                instrBuf[strlen (instrBuf) - 1] = '\0';
                strcpy (fpv, instrBuf);
            }
            else
            {
                strcpy (fpv, fp);
            }

            /*
             * Here we are looping thru the new fixed password
             * entry until the user gets the proper number of
             * characters, it is different from the old one and
             * and verifies it properly.
             */

            for (;;)
            {
                if (strcmp (fp, fpv) == 0 && strlen (fp) >= pb->fixmin
                    && strcmp (fp, pb->fixpwd) != 0)
                {
                    break;
                }

                if (strcmp (fp, pb->fixpwd) == 0)
                {
                    puts ("\n\nYour new password must be different from your old one.");
                }
                else
                {
                    if (strlen (fp) < pb->fixmin)
                    {
                        puts (fmtstr ("\n\nFixed passwords must have %d or more characters.",
                                      pb->fixmin));
                    }
                    else
                    {
                        puts ("\n\nVerify error.");
                    }
                }

                puts ("\n\nNew Fixed password: ");
                fgets (instrBuf, sizeof (fp), stdin);
                instrBuf[strlen (instrBuf) - 1] = '\0';
                strcpy (fp, instrBuf);

                if (strlen (fp) == 0)
                {
                    break;
                }

                puts ("\nRepeat new Fixed password: ");
                fgets (instrBuf, sizeof (fpv), stdin);
                instrBuf[strlen (instrBuf) - 1] = '\0';
                strcpy (fpv, instrBuf);
            }
            strcpy (pb->nfixpwd, fp);
        }
    }
}

/* -------------------------- ppause ------------------------------- */
void
ppause (s, l)
char    s[];
int     l;
{
    char    response[5];

    if (s[strlen (s) - 1] == '\n')
    {
        s[strlen (s) - 1] = 0;
    }

    puts ("\n");
    puts (s);

    if (l % 21 == 0)
    {
        puts ("\n\n--- Press RETURN to continue ---");
        fgets (response, sizeof (response), stdin);
        response[strlen (response) - 1] = '\0';
    }
}

/* -------------------------------- fmtstr () ------------------------------- */
/*
*       Format a string in the manner of sprintf and return a pointer to the
*       resultant string.
*/

char   *
fmtstr (a, b)
char   *a,
       *b;
{
    static char s[80];

    sprintf (s, a, b);
    return (s);
}

/* -------------------------------- print_msg () ----------------------------- */
void
print_msg ()
{
    struct pblk *pb;


    pb = &pblock;               /* pointer to parameter block */

    if (pb->msg1[0])
    {
        puts (fmtstr ("\n%s\n", pb->msg1));
        pb->msg1[0] = 0;
    }

    if (pb->msg2[0])
    {
        puts (fmtstr ("\n%s\n", pb->msg2));
        pb->msg2[0] = 0;
    }
}
